;
;  based on the kc basic source code
;
;  assemble with the asl macro assembler
;  (tested with version 1.41r8)
;

	CPU	z80

;************************************************
;EXTERNE SPRUNGZIELE
RAMST	equ	0c0bdh
NEW1	equ	0c641h
NEW2	equ	0c64fh
INITR	equ	0c669h
CPREG	equ	0c689h
RUNMOD	equ	0c854h
CLS	equ	0ddd0h

;************************************************
;VARIABLENVEREINBARUNG
        CICH:   EQU     00
        COCH:   EQU     01
        ICH_:   EQU     02
        OCH_:   EQU     03
;************************************************
	ROMBEG:	EQU	0C000H		;INTERPRETERANFANGSADR.
	RAMBEG:	EQU	300H		;RAMANFANGSADR.
	WSP:	EQU	RAMBEG
	PRAM:	EQU	WSP+257		;PROGRAMMSPEICHERANFADR.
	ZFT:	EQU	0		;WSP<PRAM
	BIN0IO:	EQU	1		;BINAERE NULLEN SIND
;ALS I/O-DATEN MOEGLICH
	EXTGO1:	EQU	0E003H
	EXTGO2:	EQU	0E006H
	EXTGO3:	EQU	0E009H
	EXTTAB:	EQU	0E00CH
	VERT:	EQU	0E00EH
;NOTIZSPEICHERVEREINBARUNG
	RSTLOC:	EQU	WSP
	USRLOC:	EQU	RSTLOC+3
	PORTAD:	EQU	USRLOC+3
	IOCHNL:	EQU	PORTAD+1
	OUTIND:	EQU	IOCHNL+1
	ININD:	EQU	OUTIND+1
	TRFLAG:	EQU	ININD+1
	DIVVAR:	EQU	TRFLAG+1
	DVAR1:	EQU	DIVVAR+1
	DVAR2:	EQU	DIVVAR+5
	DVAR3:	EQU	DIVVAR+9
	DVAR4:	EQU	DIVVAR+12
	RNDVR1:	EQU	DVAR4+2
	RNDVR2:	EQU	RNDVR1+1
	RNDVR3:	EQU	RNDVR2+1
	RNDVR4:	EQU	RNDVR3+33
	DUMMY:	EQU	RNDVR4+4
	LINLEN:	EQU	DUMMY+1
	PRLISI:	EQU	LINLEN+1
	OUTFLG:	EQU	PRLISI+1
	LINFLG:	EQU	OUTFLG+1
	LNFLGC:	EQU	LINFLG+2
	CHSUML:	EQU	LNFLGC+2
	INPLOC:	EQU	CHSUML+2
	AUTOFG:	EQU	INPLOC+3
	ANF:	EQU	AUTOFG+1
	ENDE:	EQU	ANF+2
	NANF:	EQU	ENDE+2
	DISTAN:	EQU	NANF+2
	STDPTR:	EQU	DISTAN+2
	CULINO:	EQU	STDPTR+2
	WINJP:	EQU	CULINO+2
	DATBYT:	EQU	WINJP+3
	DATFLG:	EQU	DATBYT+1
	PSTBEG:	EQU	DATFLG+1
	INPBUF:	EQU	PSTBEG+2		;EINGABEPUFFERANFANG
	EOINPB:	EQU	INPBUF+74		;EINGABEPUFFERENDE
	CURPOS:	EQU	EOINPB+1		;CURSORPOSITION
	LOCCRE:	EQU	CURPOS+1		;SUCHE VARIABLE (0)
						;ODER FUEGE SIE EIN (1)
	DATYPE:	EQU	LOCCRE+1		;DATENTYP
	DSTMNT:	EQU	DATYPE+1		;DATASTMNT.FLAG
	MEMSIZ:	EQU	DSTMNT+1		;MEMORY SIZE
	SPTPTR:	EQU	MEMSIZ+2		;ADRESSE DER NAECHSTEN
						;FREIEN STELLE IN LSPT
	LSPTBG:	EQU	SPTPTR+2		;SRINGADRESSTABELLE
	EOLSPT:	EQU	LSPTBG+11		;ENDE DER TABELLE
	STRDAT:	EQU	EOLSPT+1		;LAENGE UND ADRESSE DES
						;AKTUELLEN STRINGS
	SWAPTR:	EQU	STRDAT+4		;ZEIGER FUER STRINGBER.
	LBYTEX:	EQU	SWAPTR+2		;INDEX DES ZULETZT ABGE-
						;ARBEITETEN BYTES
	CSTFOR:	EQU	LBYTEX+2		;ADRESSE DES PROGRAMM-
						;ZEIGERS WAEHREND DER
						;SUCHE NACH EINER VOR-
						;HERIGEN FOR-ANWEISUNG
	DATPTR:	EQU	CSTFOR+2		;ZEILENNUMMER DES ZULETZT
						;GELESENEN DATASTATEMENTS
	FORFLG:	EQU	DATPTR+2		;FOR-FLAG
	IPHFLG:	EQU	FORFLG+1		;INPUTPHASE-FLAG
	RDFLAG:	EQU	IPHFLG+1		;RD/WR-FLAG
	CUSTMT:	EQU	RDFLAG+1		;ZEILENNUMMER/ADRESSE DES
						;AKTUELLEN STATEMENTS
	NTOKPT:	EQU	CUSTMT+2		;ADRESSE DES NAECHSTEN
						;ELEMENTS
	LLNOEX:	EQU	NTOKPT+2		;LETZTE ZEILENNUMMER
						;BEI END/STOP
	LBYTER:	EQU	LLNOEX+2		;ADRESSE DES LETZTEN
						;BYTES BEI ERROR
	SVARPT:	EQU	LBYTER+2		;ADRESSE DER LISTE DER
						;EINFACHEN- UND STRINGVAR.
	DVARPT:	EQU	SVARPT+2		;ADRESSE DER LISTE DER
						;FELDVARIABLEN
	FSLPTR:	EQU	DVARPT+2		;ERSTE FREIE ADRESSE
						;HINTER DEN LISTEN
	RDPTR:	EQU	FSLPTR+2		;AKT. ADRESSE IM DATA-
						;STATEMENT WAEHREND READ
	FNPTR:	EQU	RDPTR+2			;ADRESSE DES FN-STMNTS.
	WRA0:	EQU	FNPTR+2			;ARITHMETIKREGISTER 0
	WRA1:	EQU	WRA0+4			;ARITHMETIKREGISTER 1
	SGNORS:	EQU	WRA1+4			;VORZEICHEN DER OPERATION
	INTPRB:	EQU	SGNORS+1		;PRINT-PUFFER
	WRA2:	EQU	INTPRB+13		;ARITHMETIKREGISTER 2
	LSTFLG:	EQU	WRA2+4
	EXTFLG:	EQU	LSTFLG+1
	PRTFLG:	EQU	EXTFLG+1
	COLRET:	EQU	PRTFLG+1

;STEUERZEICHENVEREINBARUNG
	ASCBEL:	EQU	07H
	ASCCR:	EQU	0DH
	ASCSP:	EQU	20H
	CURLFT:	EQU	8
	CURRGT:	EQU	9
	CURDEL:	EQU	1FH
	CURSP:	EQU	1AH
	CURDWN:	EQU	0AH
	CURHIG:	EQU	0BH
	CURRE:	EQU	18H
	CURLI:	EQU	19H
	CLLN:	EQU	2
	LISTSW:	EQU	1CH		;LIST-Taste
	RUNSW:	EQU	1DH		;RUN-Taste
	PAUSSW:	EQU	13H		;PAUSE-Taste
	STOPSW:	EQU	03H		;STOP-Taste
	CONTSW:	EQU	1EH		;CONTINUE-Taste

;************************************************

	ORG	100h

	CALL	CLS

PRIST1:
;LADE DIE ERSTEN 98 SPEICHERPLAETZE DES
;NOTIZSPEICHERS MIT ERSTBELEGUNG
;RESERVIERE EIN STACKNIVEAU
LDWSP:
	LD	HL,RAMST
	LD	DE,WSP
	LD	BC,PSTBEG-RSTLOC+8
	LDIR
	EX	DE,HL
	LD	SP,HL

	; INITR benutzt temporr SP = (0356h) was
	; per default auf 465h zeigt und damit das
	; programm zermllt!
	LD	HL, 1c0h
	LD	(356h), HL
	CALL	INITR
	LD	(EOINPB),A
	LD	(PRAM-1),A

	LD	HL,RAMBEG
	DEC	HL
RAMSCH:	LD	DE,ROMBEG-1

	;SELBSTTAETIGE RAM-SUCHE BIS MAX. <DE>
RAMSH1:	INC	HL
	CALL	CPREG
	JR	Z,RAMTST
	LD	A,(HL)
	LD	B,A
	CPL
	LD	(HL),A
	CP	A, (HL)
	LD	(HL),B
	JR	Z,RAMSH1
	DEC	HL
RAMTST:	LD	DE,-256
	LD	(MEMSIZ),HL
	ADD	HL,DE
	LD	(STDPTR),HL

	;
	;  Verhindern, da der Anfang des
	;  BASIC-Speichers durch NEW1
	;  gelscht wird. Der Pointer SVARPT
	;  fr das Ende des Basic Programmes
	;  wird durch die Lade-Routine geschrieben.
	;	
	XOR     A
	LD      (DATFLG),A
	CALL	NEW2

	LD	HL,(STDPTR)
	LD	DE,65536-PRAM-16
	ADD	HL,DE
	LD	HL,(EXTGO1+1)
	LD	A,(HL)
	CP	A, 78H
	JR	NZ,RAMSH0
	DEFB	3EH
RAMSH0:	XOR	A
	LD	(EXTFLG),A
	LD	SP,INPBUF+6

;************************************************

	; BASIC Warmstart

	CALL	INITR
	CALL	NEW2
	;LD	A,1DH		; keycode fr RUN in...
	;LD	(25H),A		; ...Tastaturpuffer
	JP	RUNMOD
