# Contributing

```{toctree}
---
hidden:
---

the_basics
gauging_changes
issue_triage
release_process
reference/reference_summary
```

Welcome! Happy to see you willing to make the project better. Have you read the entire
[user documentation](https://black.readthedocs.io/en/latest/) yet?

```{rubric} Bird's eye view

```

In terms of inspiration, _Black_ is about as configurable as _gofmt_ (which is to say,
not very). This is deliberate. _Black_ aims to provide a consistent style and take away
opportunities for arguing about style.

Bug reports and fixes are always welcome! Please follow the
[issue template on GitHub](https://github.com/psf/black/issues/new) for best results.

Before you suggest a new feature or configuration knob, ask yourself why you want it. If
it enables better integration with some workflow, fixes an inconsistency, speeds things
up, and so on - go for it! On the other hand, if your answer is "because I don't like a
particular formatting" then you're not ready to embrace _Black_ yet. Such changes are
unlikely to get accepted. You can still try but prepare to be disappointed.

```{rubric} Contents

```

This section covers the following topics:

- {doc}`the_basics`
- {doc}`gauging_changes`
- {doc}`release_process`
- {doc}`reference/reference_summary`

For an overview on contributing to the _Black_, please checkout {doc}`the_basics`.

If you need a reference of the functions, classes, etc. available to you while
developing _Black_, there's the {doc}`reference/reference_summary` docs.
