/*

Boost Software License - Version 1.0 - August 17th, 2003

Permission is hereby granted, free of charge, to any person or organization
obtaining a copy of the software and accompanying documentation covered by
this license (the "Software") to use, reproduce, display, distribute,
execute, and transmit the Software, and to prepare derivative works of the
Software, and to permit third-parties to whom the Software is furnished to
do so, all subject to the following:

The copyright notices in the Software and this entire statement, including
the above license grant, this restriction and the following disclaimer,
must be included in all copies of the Software, in whole or in part, and
all derivative works of the Software, unless such copies or derivative
works are solely in the form of machine-executable object code generated by
a source language processor.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.

*/
module derelict.sdl.macinit.MacTypes;

version(DigitalMars) version(OSX) version = darwin;

version (darwin):
package:

/********************************************************************************

 Base integer types for all target OS's and CPU's

 UInt8            8-bit unsigned integer
 SInt8            8-bit signed integer
 UInt16          16-bit uinteger
 SInt16          16-bit signed integer
 UInt32          32-bit uinteger
 SInt32          32-bit signed integer
 UInt64          64-bit uinteger
 SInt64          64-bit integer

 *********************************************************************************/
alias ubyte UInt8;
alias byte SInt8;
alias ushort UInt16;
alias short SInt16;
alias uint UInt32;
alias int SInt32;
alias ulong UInt64;
alias long SInt64;

alias byte uint8_t;

/********************************************************************************

 Higher level basic types

 OSErr                   16-bit result error code
 OSStatus                32-bit result error code
 LogicalAddress          Address in the clients virtual address space
 ConstLogicalAddress     Address in the clients virtual address space that will only be read
 PhysicalAddress         Real address as used on the hardware bus
 BytePtr                 Pointer to an array of bytes
 ByteCount               The size of an array of bytes
 ByteOffset              An offset into an array of bytes
 ItemCount               32-bit iteration count
 OptionBits              Standard 32-bit set of bit flags
 PBVersion               ?
 Duration                32-bit millisecond timer for drivers
 AbsoluteTime            64-bit clock
 ScriptCode              A particular set of written characters (e.g. Roman vs Cyrillic) and their encoding
 LangCode                A particular language (e.g. English), as represented using a particular ScriptCode
 RegionCode              Designates a language as used in a particular region (e.g. British vs American
 English) together with other region-dependent characteristics (e.g. date format)
 FourCharCode            A 32-bit value made by packing four 1 byte characters together
 OSType                  A FourCharCode used in the OS and file system (e.g. creator)
 ResType                 A FourCharCode used to tag resources (e.g. 'DLOG')

 *********************************************************************************/
alias SInt16 OSErr;
alias SInt32 OSStatus;
alias void* LogicalAddress;
alias /*const*/void* ConstLogicalAddress;
alias void* PhysicalAddress;
alias UInt8* BytePtr;
alias uint ByteCount;
alias uint ByteOffset;
alias SInt32 Duration;
alias UnsignedWide AbsoluteTime;
alias UInt32 OptionBits;
alias uint ItemCount;
alias UInt32 PBVersion;
alias SInt16 ScriptCode;
alias SInt16 LangCode;
alias SInt16 RegionCode;
alias UInt32 FourCharCode;
alias FourCharCode OSType;
alias FourCharCode ResType;
alias OSType* OSTypePtr;
alias ResType* ResTypePtr;

struct UnsignedWide
{
    uint hi;
    uint lo;
}

struct ProcessSerialNumber
{
    uint highLongOfPSN;
    uint lowLongOfPSN;
}

alias ProcessSerialNumber * ProcessSerialNumberPtr;