# Copyright © The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""pytest fixtures and hooks for Debusine."""

import pytest

from debusine.django.django_utils import cleanup_temp_directory

try:
    from pytest_django.lazy_django import django_settings_is_configured
except ImportError:  # integration tests

    def django_settings_is_configured() -> None:
        """pytest_django has not configured Django."""
        return False


@pytest.hookimpl()
def pytest_sessionfinish() -> None:
    """Clean up any DEBUSINE_DATA_PATH that we created."""
    if django_settings_is_configured():
        cleanup_temp_directory()
