package events

import (
	"testing"
)

func TestReminderTypeUnmarshalText(t *testing.T) {
	tests := []struct {
		input string
		want  ReminderType
	}{
		{"same day", ReminderTypeSameDay},
		{"SAME DAY", ReminderTypeSameDay},
		{"  same day  ", ReminderTypeSameDay},
		{"days before", ReminderTypeDaysBefore},
		{"DAYS BEFORE", ReminderTypeDaysBefore},
		{"unknown", ReminderType("unknown")},
		{"", ReminderType("")},
	}

	for _, tt := range tests {
		t.Run(tt.input, func(t *testing.T) {
			var rt ReminderType
			err := rt.UnmarshalText([]byte(tt.input))
			if err != nil {
				t.Errorf("ReminderType.UnmarshalText(%q) unexpected error: %v", tt.input, err)
			}
			if rt != tt.want {
				t.Errorf("ReminderType.UnmarshalText(%q) = %q, want %q", tt.input, rt, tt.want)
			}
		})
	}
}
