# Check if a dependency exists and declare a target named Dep::$name.
# If USE_SYSTEM_LIBS variable is set, find dependency via pkg-config.

if (USE_SYSTEM_LIBS)
    find_package(PkgConfig REQUIRED)
endif()

macro(check_dependency target_var pkg_config_name vcpkg_name vcpkg_target_name)
    cmake_parse_arguments(_ARG "REQUIRED;CONFIG" "" "" ${ARGN})
    set(_REQUIRED "")
    if (_ARG_REQUIRED)
        set(_REQUIRED "REQUIRED")
    endif()
    set(_CONFIG "")
    if (_ARG_CONFIG)
        set(_CONFIG "CONFIG")
    endif()
    string(TOUPPER ${target_var} _TARGET_VAR_UPPER)
    set(HAVE_${_TARGET_VAR_UPPER} FALSE)
    if (USE_SYSTEM_LIBS)
        pkg_check_modules(${target_var} ${_REQUIRED} IMPORTED_TARGET ${pkg_config_name})
        if (${target_var}_FOUND)
            add_library(Dep::${target_var} ALIAS PkgConfig::${target_var})
            set(HAVE_${_TARGET_VAR_UPPER} TRUE)
        endif()
    else()
        find_package(${vcpkg_name} ${_CONFIG} ${_REQUIRED})
        if (TARGET ${vcpkg_target_name})
            set(actual_target ${vcpkg_target_name})
            get_target_property(aliased_target ${actual_target} ALIASED_TARGET)
            if (aliased_target AND NOT "${aliased_target}" MATCHES "NOTFOUND")
                set(actual_target ${aliased_target})
            endif()
            add_library(Dep::${target_var} ALIAS ${actual_target})
            set(HAVE_${_TARGET_VAR_UPPER} TRUE)
        endif()
    endif()
endmacro()
