static char *XALLOC_C="\n/*\n *	Copyright (c) 2004-2009 Smithsonian Astrophysical Observatory\n */\n\n/*\n *\n * xalloc -- safe memory allocation with error checking\n *\n */\n\n/* this module is compiled within a funtools filter and must not require\n   the header files */\n#ifdef FILTER_PTYPE\n#define ANSI_FUNC 1\n#else\n#include <xalloc.h>\n#endif\n\n#define XALLOC_ERROR \"ERROR: can't allocate memory (xalloc)\\n\"\n\n#if XALLOC_SETJMP\n\nstatic jmp_buf *xalloc_envptr=NULL;\n\n#ifdef ANSI_FUNC\nvoid xalloc_savejmp(jmp_buf *env)\n#else\nvoid xalloc_savejmp(env)\n     jmp_buf *env;\n#endif\n{\n  xalloc_envptr = env;\n}\n#endif\n\n\n#ifdef ANSI_FUNC\nstatic void _xalloc_error(void)\n#else\nstatic void _xalloc_error()\n#endif\n{\n  write(1, XALLOC_ERROR, strlen(XALLOC_ERROR));\n#if XALLOC_SETJMP\n  if( xalloc_envptr )\n    longjmp(*xalloc_envptr, XALLOC_SETJMP);\n  else\n#endif\n  exit(1);\n}\n\n#ifdef ANSI_FUNC\nvoid *xmalloc(size_t n)\n#else\nvoid *xmalloc(n)\n     size_t n;\n#endif\n{\n  void *p;\n  \n  if( !(p = (void *)malloc(n)) )\n    _xalloc_error();\n  return p;\n}\n\n#ifdef ANSI_FUNC\nvoid *xcalloc (size_t n, size_t s)\n#else\nvoid *xcalloc (n, s)\n     size_t n, s;\n#endif\n{\n  void *p;\n\n  if( !(p = (void *)calloc(n, s)) )\n    _xalloc_error();\n  return p;\n}\n\n#ifdef ANSI_FUNC\nvoid *xrealloc (void *p, size_t n)\n#else\nvoid *xrealloc (p, n)\n     void *p;\n     size_t n;\n#endif\n{\n  if( !p )\n    return xmalloc(n);\n  if( !(p = (void *)realloc(p, n)) )\n    _xalloc_error();\n  return p;\n}\n\n#ifdef ANSI_FUNC\nvoid xfree (void *p)\n#else\nvoid xfree (p)\n     void *p;\n#endif\n{\n  if( p )\n    free(p);\n}\n\n#ifdef ANSI_FUNC\nchar *xstrdup (char *s)\n#else\nchar *xstrdup (s)\n     char *s;\n#endif\n{\n  if( s )\n    return((char *)strcpy((char *)xmalloc((size_t)strlen(s)+1), s));\n  else\n    return NULL;\n}\n";
