<?xml version="1.0" encoding="UTF-8"?>

<!--  simple XSL transformation to create a docbook section  -->

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:dc="http://purl.org/dc/elements/1.1/"
                exclude-result-prefixes="dc">

  <!-- template "lang.split" -->
  <xsl:import href="authors_common.xsl" />

  <xsl:output method="xml" encoding="UTF-8" indent="yes"
              doctype-public="-//OASIS//DTD DocBook XML V4.3//EN"
              doctype-system="http://www.docbook.org/xml/4.3/docbookx.dtd"/>

  <xsl:param name="roles">documenter translator artist technican</xsl:param>
  <xsl:param name="print.roles.with.lang">translator</xsl:param>


  <!-- ============================================================= -->
  <xsl:template match="/dc:gimp-authors">
  <!-- ============================================================= -->
<xsl:comment>
    Do not edit this file directly. It was generated automatically
    from "stylesheets/authors.xml".
</xsl:comment>

    <sect1 id="gimp-team" lang="en">
      <title>
        <xsl:choose>
          <xsl:when test="dc:title">
            <xsl:value-of select="dc:title"/>
            <xsl:text> Authors and Contributors</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <acronym>GIMP</acronym> User Manual Authors and Contributors
          </xsl:otherwise>
        </xsl:choose>
      </title>

      <variablelist>
        <!-- create recursively "varlistentry" nodes -->
        <xsl:call-template name="print.listentry">
          <xsl:with-param name="roles">
            <xsl:value-of select="normalize-space($roles)"/>
          </xsl:with-param>
        </xsl:call-template>
      </variablelist>
    </sect1>
  </xsl:template>

  <!-- ============================================================= -->
  <xsl:template name="print.listentry">
  <!-- ============================================================= -->
    <!-- parameter: space-separated list of roles -->
    <xsl:param name="roles" select="''"/>
    <xsl:variable name="role">
      <xsl:choose>
        <xsl:when test="contains($roles,' ')">
          <xsl:value-of select="substring-before($roles,' ')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$roles"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:if test="$role != ''">
      <varlistentry>
        <term>
          <xsl:variable name="name" select="concat($role,'s')"/>
          <xsl:choose>
            <xsl:when test="$name = 'documenters'">
              <xsl:text>Documentation</xsl:text>
            </xsl:when>
            <xsl:when test="$name = 'translators'">
              <xsl:text>Translations</xsl:text>
            </xsl:when>
            <xsl:when test="$name = 'artists'">
              <xsl:text>Graphics, Stylesheets</xsl:text>
            </xsl:when>
            <xsl:when test="$name = 'technicans'">
              <xsl:text>Build System, Technical Contributions</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:message>
                <xsl:text>ERROR: Unknown role '</xsl:text>
                <xsl:value-of select="$name"/>
                <xsl:text>' in "authors_docbook.xml".</xsl:text>
              </xsl:message>
              <xsl:text>FIXME</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </term>
        <listitem>
          <simplelist type="inline">
            <!-- whether to print "John Doe (English)" or "John Doe" -->
            <xsl:variable name="with.language">
              <xsl:choose>
                <xsl:when test="contains($print.roles.with.lang, $role)">
                  <xsl:value-of select="1"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="0"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:variable>
            <!-- extract authors and contributors -->
            <xsl:choose>
              <!-- technicans may be creators or contributors -->
              <xsl:when test="$role = 'technican'">
                <xsl:for-each select="//dc:contributor[contains(@role, $role)] |
                                      //dc:creator[contains(@role, $role)]">
                  <xsl:call-template name="print.item">
                    <xsl:with-param name="print.language" select="$with.language"/>
                  </xsl:call-template>
                </xsl:for-each>
              </xsl:when>
              <!-- print contributors? -->
              <xsl:when test="$role != 'creator'">
                <xsl:for-each select="//dc:contributor[contains(@role, $role)]">
                  <xsl:call-template name="print.item">
                    <xsl:with-param name="print.language" select="$with.language"/>
                  </xsl:call-template>
                </xsl:for-each>
              </xsl:when>
              <!-- print creators -->
              <xsl:otherwise>
                <xsl:for-each select="//dc:creator">
                  <xsl:call-template name="print.item">
                    <xsl:with-param name="print.language" select="$with.language"/>
                  </xsl:call-template>
                </xsl:for-each>
              </xsl:otherwise>
            </xsl:choose>
          </simplelist>
        </listitem>
      </varlistentry>
      <!-- if necessary, print next list entry -->
      <xsl:if test="contains($roles,' ')">
        <xsl:call-template name="print.listentry">
          <xsl:with-param name="roles">
            <xsl:value-of select="substring-after($roles,' ')"/>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:if>
    </xsl:if>
  </xsl:template>

  <!-- ============================================================= -->
  <xsl:template name="print.item">
  <!-- ============================================================= -->
    <xsl:param name="print.language">1</xsl:param>
    <member>
      <author>
        <personname>
          <othername><xsl:apply-templates match="." /></othername>
        </personname>
      </author>
      <phrase>
        <xsl:if test="@lang != '' and $print.language != 0">
          <xsl:text>(</xsl:text>
          <xsl:call-template name="lang.split">
            <xsl:with-param name="lang" select="@lang" />
          </xsl:call-template>
          <xsl:text>)</xsl:text>
        </xsl:if>
      </phrase>
    </member>
  </xsl:template>
</xsl:stylesheet>
