=begin
#OpenBao API

#HTTP API that gives you full access to OpenBao. All API routes are prefixed with `/v1/`.

The version of the OpenAPI document: 2.0.0

Generated by: https://openapi-generator.tech
Generator version: 7.7.0

=end

require 'date'
require 'time'

module OpenbaoClient
  class KubernetesConfigureAuthRequest
    # Disable JWT issuer validation (Deprecated, will be removed in a future release)
    attr_accessor :disable_iss_validation

    # Disable defaulting to the local CA cert and service account JWT when running in a Kubernetes pod
    attr_accessor :disable_local_ca_jwt

    # Optional JWT issuer. If no issuer is specified, then this plugin will use kubernetes.io/serviceaccount as the default issuer. (Deprecated, will be removed in a future release)
    attr_accessor :issuer

    # PEM encoded CA cert for use by the TLS client used to talk with the API.
    attr_accessor :kubernetes_ca_cert

    # Host must be a host string, a host:port pair, or a URL to the base of the Kubernetes API server.
    attr_accessor :kubernetes_host

    # Optional list of PEM-formated public keys or certificates used to verify the signatures of kubernetes service account JWTs. If a certificate is given, its public key will be extracted. Not every installation of Kubernetes exposes these keys.
    attr_accessor :pem_keys

    # A service account JWT (or other token) used as a bearer token to access the TokenReview API to validate other JWTs during login. If not set the JWT used for login will be used to access the API.
    attr_accessor :token_reviewer_jwt

    # Attribute mapping from ruby-style variable name to JSON key.
    def self.attribute_map
      {
        :'disable_iss_validation' => :'disable_iss_validation',
        :'disable_local_ca_jwt' => :'disable_local_ca_jwt',
        :'issuer' => :'issuer',
        :'kubernetes_ca_cert' => :'kubernetes_ca_cert',
        :'kubernetes_host' => :'kubernetes_host',
        :'pem_keys' => :'pem_keys',
        :'token_reviewer_jwt' => :'token_reviewer_jwt'
      }
    end

    # Returns all the JSON keys this model knows about
    def self.acceptable_attributes
      attribute_map.values
    end

    # Attribute type mapping.
    def self.openapi_types
      {
        :'disable_iss_validation' => :'Boolean',
        :'disable_local_ca_jwt' => :'Boolean',
        :'issuer' => :'String',
        :'kubernetes_ca_cert' => :'String',
        :'kubernetes_host' => :'String',
        :'pem_keys' => :'Array<String>',
        :'token_reviewer_jwt' => :'String'
      }
    end

    # List of attributes with nullable: true
    def self.openapi_nullable
      Set.new([
      ])
    end

    # Initializes the object
    # @param [Hash] attributes Model attributes in the form of hash
    def initialize(attributes = {})
      if (!attributes.is_a?(Hash))
        fail ArgumentError, "The input argument (attributes) must be a hash in `OpenbaoClient::KubernetesConfigureAuthRequest` initialize method"
      end

      # check to see if the attribute exists and convert string to symbol for hash key
      attributes = attributes.each_with_object({}) { |(k, v), h|
        if (!self.class.attribute_map.key?(k.to_sym))
          fail ArgumentError, "`#{k}` is not a valid attribute in `OpenbaoClient::KubernetesConfigureAuthRequest`. Please check the name to make sure it's valid. List of attributes: " + self.class.attribute_map.keys.inspect
        end
        h[k.to_sym] = v
      }

      if attributes.key?(:'disable_iss_validation')
        self.disable_iss_validation = attributes[:'disable_iss_validation']
      else
        self.disable_iss_validation = true
      end

      if attributes.key?(:'disable_local_ca_jwt')
        self.disable_local_ca_jwt = attributes[:'disable_local_ca_jwt']
      else
        self.disable_local_ca_jwt = false
      end

      if attributes.key?(:'issuer')
        self.issuer = attributes[:'issuer']
      end

      if attributes.key?(:'kubernetes_ca_cert')
        self.kubernetes_ca_cert = attributes[:'kubernetes_ca_cert']
      end

      if attributes.key?(:'kubernetes_host')
        self.kubernetes_host = attributes[:'kubernetes_host']
      end

      if attributes.key?(:'pem_keys')
        if (value = attributes[:'pem_keys']).is_a?(Array)
          self.pem_keys = value
        end
      end

      if attributes.key?(:'token_reviewer_jwt')
        self.token_reviewer_jwt = attributes[:'token_reviewer_jwt']
      end
    end

    # Show invalid properties with the reasons. Usually used together with valid?
    # @return Array for valid properties with the reasons
    def list_invalid_properties
      warn '[DEPRECATED] the `list_invalid_properties` method is obsolete'
      invalid_properties = Array.new
      invalid_properties
    end

    # Check to see if the all the properties in the model are valid
    # @return true if the model is valid
    def valid?
      warn '[DEPRECATED] the `valid?` method is obsolete'
      true
    end

    # Checks equality by comparing each attribute.
    # @param [Object] Object to be compared
    def ==(o)
      return true if self.equal?(o)
      self.class == o.class &&
          disable_iss_validation == o.disable_iss_validation &&
          disable_local_ca_jwt == o.disable_local_ca_jwt &&
          issuer == o.issuer &&
          kubernetes_ca_cert == o.kubernetes_ca_cert &&
          kubernetes_host == o.kubernetes_host &&
          pem_keys == o.pem_keys &&
          token_reviewer_jwt == o.token_reviewer_jwt
    end

    # @see the `==` method
    # @param [Object] Object to be compared
    def eql?(o)
      self == o
    end

    # Calculates hash code according to all attributes.
    # @return [Integer] Hash code
    def hash
      [disable_iss_validation, disable_local_ca_jwt, issuer, kubernetes_ca_cert, kubernetes_host, pem_keys, token_reviewer_jwt].hash
    end

    # Builds the object from hash
    # @param [Hash] attributes Model attributes in the form of hash
    # @return [Object] Returns the model itself
    def self.build_from_hash(attributes)
      return nil unless attributes.is_a?(Hash)
      attributes = attributes.transform_keys(&:to_sym)
      transformed_hash = {}
      openapi_types.each_pair do |key, type|
        if attributes.key?(attribute_map[key]) && attributes[attribute_map[key]].nil?
          transformed_hash["#{key}"] = nil
        elsif type =~ /\AArray<(.*)>/i
          # check to ensure the input is an array given that the attribute
          # is documented as an array but the input is not
          if attributes[attribute_map[key]].is_a?(Array)
            transformed_hash["#{key}"] = attributes[attribute_map[key]].map { |v| _deserialize($1, v) }
          end
        elsif !attributes[attribute_map[key]].nil?
          transformed_hash["#{key}"] = _deserialize(type, attributes[attribute_map[key]])
        end
      end
      new(transformed_hash)
    end

    # Deserializes the data based on type
    # @param string type Data type
    # @param string value Value to be deserialized
    # @return [Object] Deserialized data
    def self._deserialize(type, value)
      case type.to_sym
      when :Time
        Time.parse(value)
      when :Date
        Date.parse(value)
      when :String
        value.to_s
      when :Integer
        value.to_i
      when :Float
        value.to_f
      when :Boolean
        if value.to_s =~ /\A(true|t|yes|y|1)\z/i
          true
        else
          false
        end
      when :Object
        # generic object (usually a Hash), return directly
        value
      when /\AArray<(?<inner_type>.+)>\z/
        inner_type = Regexp.last_match[:inner_type]
        value.map { |v| _deserialize(inner_type, v) }
      when /\AHash<(?<k_type>.+?), (?<v_type>.+)>\z/
        k_type = Regexp.last_match[:k_type]
        v_type = Regexp.last_match[:v_type]
        {}.tap do |hash|
          value.each do |k, v|
            hash[_deserialize(k_type, k)] = _deserialize(v_type, v)
          end
        end
      else # model
        # models (e.g. Pet) or oneOf
        klass = OpenbaoClient.const_get(type)
        klass.respond_to?(:openapi_any_of) || klass.respond_to?(:openapi_one_of) ? klass.build(value) : klass.build_from_hash(value)
      end
    end

    # Returns the string representation of the object
    # @return [String] String presentation of the object
    def to_s
      to_hash.to_s
    end

    # to_body is an alias to to_hash (backward compatibility)
    # @return [Hash] Returns the object in the form of hash
    def to_body
      to_hash
    end

    # Returns the object in the form of hash
    # @return [Hash] Returns the object in the form of hash
    def to_hash
      hash = {}
      self.class.attribute_map.each_pair do |attr, param|
        value = self.send(attr)
        if value.nil?
          is_nullable = self.class.openapi_nullable.include?(attr)
          next if !is_nullable || (is_nullable && !instance_variable_defined?(:"@#{attr}"))
        end

        hash[param] = _to_hash(value)
      end
      hash
    end

    # Outputs non-array value in the form of hash
    # For object, use to_hash. Otherwise, just return the value
    # @param [Object] value Any valid value
    # @return [Hash] Returns the value in the form of hash
    def _to_hash(value)
      if value.is_a?(Array)
        value.compact.map { |v| _to_hash(v) }
      elsif value.is_a?(Hash)
        {}.tap do |hash|
          value.each { |k, v| hash[k] = _to_hash(v) }
        end
      elsif value.respond_to? :to_hash
        value.to_hash
      else
        value
      end
    end

  end

end
