//*
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//*
// These .proto interfaces are private and stable.
// Please see http://wiki.apache.org/hadoop/Compatibility
// for what changes are allowed for a *stable* .proto interface.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.19.4
// source: inotify.proto

package hadoop_hdfs

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type EventType int32

const (
	EventType_EVENT_CREATE   EventType = 0
	EventType_EVENT_CLOSE    EventType = 1
	EventType_EVENT_APPEND   EventType = 2
	EventType_EVENT_RENAME   EventType = 3
	EventType_EVENT_METADATA EventType = 4
	EventType_EVENT_UNLINK   EventType = 5
	EventType_EVENT_TRUNCATE EventType = 6
)

// Enum value maps for EventType.
var (
	EventType_name = map[int32]string{
		0: "EVENT_CREATE",
		1: "EVENT_CLOSE",
		2: "EVENT_APPEND",
		3: "EVENT_RENAME",
		4: "EVENT_METADATA",
		5: "EVENT_UNLINK",
		6: "EVENT_TRUNCATE",
	}
	EventType_value = map[string]int32{
		"EVENT_CREATE":   0,
		"EVENT_CLOSE":    1,
		"EVENT_APPEND":   2,
		"EVENT_RENAME":   3,
		"EVENT_METADATA": 4,
		"EVENT_UNLINK":   5,
		"EVENT_TRUNCATE": 6,
	}
)

func (x EventType) Enum() *EventType {
	p := new(EventType)
	*p = x
	return p
}

func (x EventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EventType) Descriptor() protoreflect.EnumDescriptor {
	return file_inotify_proto_enumTypes[0].Descriptor()
}

func (EventType) Type() protoreflect.EnumType {
	return &file_inotify_proto_enumTypes[0]
}

func (x EventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *EventType) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = EventType(num)
	return nil
}

// Deprecated: Use EventType.Descriptor instead.
func (EventType) EnumDescriptor() ([]byte, []int) {
	return file_inotify_proto_rawDescGZIP(), []int{0}
}

type INodeType int32

const (
	INodeType_I_TYPE_FILE      INodeType = 0
	INodeType_I_TYPE_DIRECTORY INodeType = 1
	INodeType_I_TYPE_SYMLINK   INodeType = 2
)

// Enum value maps for INodeType.
var (
	INodeType_name = map[int32]string{
		0: "I_TYPE_FILE",
		1: "I_TYPE_DIRECTORY",
		2: "I_TYPE_SYMLINK",
	}
	INodeType_value = map[string]int32{
		"I_TYPE_FILE":      0,
		"I_TYPE_DIRECTORY": 1,
		"I_TYPE_SYMLINK":   2,
	}
)

func (x INodeType) Enum() *INodeType {
	p := new(INodeType)
	*p = x
	return p
}

func (x INodeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (INodeType) Descriptor() protoreflect.EnumDescriptor {
	return file_inotify_proto_enumTypes[1].Descriptor()
}

func (INodeType) Type() protoreflect.EnumType {
	return &file_inotify_proto_enumTypes[1]
}

func (x INodeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *INodeType) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = INodeType(num)
	return nil
}

// Deprecated: Use INodeType.Descriptor instead.
func (INodeType) EnumDescriptor() ([]byte, []int) {
	return file_inotify_proto_rawDescGZIP(), []int{1}
}

type MetadataUpdateType int32

const (
	MetadataUpdateType_META_TYPE_TIMES       MetadataUpdateType = 0
	MetadataUpdateType_META_TYPE_REPLICATION MetadataUpdateType = 1
	MetadataUpdateType_META_TYPE_OWNER       MetadataUpdateType = 2
	MetadataUpdateType_META_TYPE_PERMS       MetadataUpdateType = 3
	MetadataUpdateType_META_TYPE_ACLS        MetadataUpdateType = 4
	MetadataUpdateType_META_TYPE_XATTRS      MetadataUpdateType = 5
)

// Enum value maps for MetadataUpdateType.
var (
	MetadataUpdateType_name = map[int32]string{
		0: "META_TYPE_TIMES",
		1: "META_TYPE_REPLICATION",
		2: "META_TYPE_OWNER",
		3: "META_TYPE_PERMS",
		4: "META_TYPE_ACLS",
		5: "META_TYPE_XATTRS",
	}
	MetadataUpdateType_value = map[string]int32{
		"META_TYPE_TIMES":       0,
		"META_TYPE_REPLICATION": 1,
		"META_TYPE_OWNER":       2,
		"META_TYPE_PERMS":       3,
		"META_TYPE_ACLS":        4,
		"META_TYPE_XATTRS":      5,
	}
)

func (x MetadataUpdateType) Enum() *MetadataUpdateType {
	p := new(MetadataUpdateType)
	*p = x
	return p
}

func (x MetadataUpdateType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetadataUpdateType) Descriptor() protoreflect.EnumDescriptor {
	return file_inotify_proto_enumTypes[2].Descriptor()
}

func (MetadataUpdateType) Type() protoreflect.EnumType {
	return &file_inotify_proto_enumTypes[2]
}

func (x MetadataUpdateType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *MetadataUpdateType) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = MetadataUpdateType(num)
	return nil
}

// Deprecated: Use MetadataUpdateType.Descriptor instead.
func (MetadataUpdateType) EnumDescriptor() ([]byte, []int) {
	return file_inotify_proto_rawDescGZIP(), []int{2}
}

type EventProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type     *EventType `protobuf:"varint,1,req,name=type,enum=hadoop.hdfs.EventType" json:"type,omitempty"`
	Contents []byte     `protobuf:"bytes,2,req,name=contents" json:"contents,omitempty"`
}

func (x *EventProto) Reset() {
	*x = EventProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_inotify_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventProto) ProtoMessage() {}

func (x *EventProto) ProtoReflect() protoreflect.Message {
	mi := &file_inotify_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventProto.ProtoReflect.Descriptor instead.
func (*EventProto) Descriptor() ([]byte, []int) {
	return file_inotify_proto_rawDescGZIP(), []int{0}
}

func (x *EventProto) GetType() EventType {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return EventType_EVENT_CREATE
}

func (x *EventProto) GetContents() []byte {
	if x != nil {
		return x.Contents
	}
	return nil
}

type EventBatchProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Txid   *int64        `protobuf:"varint,1,req,name=txid" json:"txid,omitempty"`
	Events []*EventProto `protobuf:"bytes,2,rep,name=events" json:"events,omitempty"`
}

func (x *EventBatchProto) Reset() {
	*x = EventBatchProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_inotify_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventBatchProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventBatchProto) ProtoMessage() {}

func (x *EventBatchProto) ProtoReflect() protoreflect.Message {
	mi := &file_inotify_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventBatchProto.ProtoReflect.Descriptor instead.
func (*EventBatchProto) Descriptor() ([]byte, []int) {
	return file_inotify_proto_rawDescGZIP(), []int{1}
}

func (x *EventBatchProto) GetTxid() int64 {
	if x != nil && x.Txid != nil {
		return *x.Txid
	}
	return 0
}

func (x *EventBatchProto) GetEvents() []*EventProto {
	if x != nil {
		return x.Events
	}
	return nil
}

type CreateEventProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type             *INodeType         `protobuf:"varint,1,req,name=type,enum=hadoop.hdfs.INodeType" json:"type,omitempty"`
	Path             *string            `protobuf:"bytes,2,req,name=path" json:"path,omitempty"`
	Ctime            *int64             `protobuf:"varint,3,req,name=ctime" json:"ctime,omitempty"`
	OwnerName        *string            `protobuf:"bytes,4,req,name=ownerName" json:"ownerName,omitempty"`
	GroupName        *string            `protobuf:"bytes,5,req,name=groupName" json:"groupName,omitempty"`
	Perms            *FsPermissionProto `protobuf:"bytes,6,req,name=perms" json:"perms,omitempty"`
	Replication      *int32             `protobuf:"varint,7,opt,name=replication" json:"replication,omitempty"`
	SymlinkTarget    *string            `protobuf:"bytes,8,opt,name=symlinkTarget" json:"symlinkTarget,omitempty"`
	Overwrite        *bool              `protobuf:"varint,9,opt,name=overwrite" json:"overwrite,omitempty"`
	DefaultBlockSize *int64             `protobuf:"varint,10,opt,name=defaultBlockSize,def=0" json:"defaultBlockSize,omitempty"`
	ErasureCoded     *bool              `protobuf:"varint,11,opt,name=erasureCoded" json:"erasureCoded,omitempty"`
}

// Default values for CreateEventProto fields.
const (
	Default_CreateEventProto_DefaultBlockSize = int64(0)
)

func (x *CreateEventProto) Reset() {
	*x = CreateEventProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_inotify_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateEventProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEventProto) ProtoMessage() {}

func (x *CreateEventProto) ProtoReflect() protoreflect.Message {
	mi := &file_inotify_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEventProto.ProtoReflect.Descriptor instead.
func (*CreateEventProto) Descriptor() ([]byte, []int) {
	return file_inotify_proto_rawDescGZIP(), []int{2}
}

func (x *CreateEventProto) GetType() INodeType {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return INodeType_I_TYPE_FILE
}

func (x *CreateEventProto) GetPath() string {
	if x != nil && x.Path != nil {
		return *x.Path
	}
	return ""
}

func (x *CreateEventProto) GetCtime() int64 {
	if x != nil && x.Ctime != nil {
		return *x.Ctime
	}
	return 0
}

func (x *CreateEventProto) GetOwnerName() string {
	if x != nil && x.OwnerName != nil {
		return *x.OwnerName
	}
	return ""
}

func (x *CreateEventProto) GetGroupName() string {
	if x != nil && x.GroupName != nil {
		return *x.GroupName
	}
	return ""
}

func (x *CreateEventProto) GetPerms() *FsPermissionProto {
	if x != nil {
		return x.Perms
	}
	return nil
}

func (x *CreateEventProto) GetReplication() int32 {
	if x != nil && x.Replication != nil {
		return *x.Replication
	}
	return 0
}

func (x *CreateEventProto) GetSymlinkTarget() string {
	if x != nil && x.SymlinkTarget != nil {
		return *x.SymlinkTarget
	}
	return ""
}

func (x *CreateEventProto) GetOverwrite() bool {
	if x != nil && x.Overwrite != nil {
		return *x.Overwrite
	}
	return false
}

func (x *CreateEventProto) GetDefaultBlockSize() int64 {
	if x != nil && x.DefaultBlockSize != nil {
		return *x.DefaultBlockSize
	}
	return Default_CreateEventProto_DefaultBlockSize
}

func (x *CreateEventProto) GetErasureCoded() bool {
	if x != nil && x.ErasureCoded != nil {
		return *x.ErasureCoded
	}
	return false
}

type CloseEventProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Path      *string `protobuf:"bytes,1,req,name=path" json:"path,omitempty"`
	FileSize  *int64  `protobuf:"varint,2,req,name=fileSize" json:"fileSize,omitempty"`
	Timestamp *int64  `protobuf:"varint,3,req,name=timestamp" json:"timestamp,omitempty"`
}

func (x *CloseEventProto) Reset() {
	*x = CloseEventProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_inotify_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloseEventProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseEventProto) ProtoMessage() {}

func (x *CloseEventProto) ProtoReflect() protoreflect.Message {
	mi := &file_inotify_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseEventProto.ProtoReflect.Descriptor instead.
func (*CloseEventProto) Descriptor() ([]byte, []int) {
	return file_inotify_proto_rawDescGZIP(), []int{3}
}

func (x *CloseEventProto) GetPath() string {
	if x != nil && x.Path != nil {
		return *x.Path
	}
	return ""
}

func (x *CloseEventProto) GetFileSize() int64 {
	if x != nil && x.FileSize != nil {
		return *x.FileSize
	}
	return 0
}

func (x *CloseEventProto) GetTimestamp() int64 {
	if x != nil && x.Timestamp != nil {
		return *x.Timestamp
	}
	return 0
}

type TruncateEventProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Path      *string `protobuf:"bytes,1,req,name=path" json:"path,omitempty"`
	FileSize  *int64  `protobuf:"varint,2,req,name=fileSize" json:"fileSize,omitempty"`
	Timestamp *int64  `protobuf:"varint,3,req,name=timestamp" json:"timestamp,omitempty"`
}

func (x *TruncateEventProto) Reset() {
	*x = TruncateEventProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_inotify_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TruncateEventProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TruncateEventProto) ProtoMessage() {}

func (x *TruncateEventProto) ProtoReflect() protoreflect.Message {
	mi := &file_inotify_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TruncateEventProto.ProtoReflect.Descriptor instead.
func (*TruncateEventProto) Descriptor() ([]byte, []int) {
	return file_inotify_proto_rawDescGZIP(), []int{4}
}

func (x *TruncateEventProto) GetPath() string {
	if x != nil && x.Path != nil {
		return *x.Path
	}
	return ""
}

func (x *TruncateEventProto) GetFileSize() int64 {
	if x != nil && x.FileSize != nil {
		return *x.FileSize
	}
	return 0
}

func (x *TruncateEventProto) GetTimestamp() int64 {
	if x != nil && x.Timestamp != nil {
		return *x.Timestamp
	}
	return 0
}

type AppendEventProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Path     *string `protobuf:"bytes,1,req,name=path" json:"path,omitempty"`
	NewBlock *bool   `protobuf:"varint,2,opt,name=newBlock,def=0" json:"newBlock,omitempty"`
}

// Default values for AppendEventProto fields.
const (
	Default_AppendEventProto_NewBlock = bool(false)
)

func (x *AppendEventProto) Reset() {
	*x = AppendEventProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_inotify_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppendEventProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppendEventProto) ProtoMessage() {}

func (x *AppendEventProto) ProtoReflect() protoreflect.Message {
	mi := &file_inotify_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppendEventProto.ProtoReflect.Descriptor instead.
func (*AppendEventProto) Descriptor() ([]byte, []int) {
	return file_inotify_proto_rawDescGZIP(), []int{5}
}

func (x *AppendEventProto) GetPath() string {
	if x != nil && x.Path != nil {
		return *x.Path
	}
	return ""
}

func (x *AppendEventProto) GetNewBlock() bool {
	if x != nil && x.NewBlock != nil {
		return *x.NewBlock
	}
	return Default_AppendEventProto_NewBlock
}

type RenameEventProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SrcPath   *string `protobuf:"bytes,1,req,name=srcPath" json:"srcPath,omitempty"`
	DestPath  *string `protobuf:"bytes,2,req,name=destPath" json:"destPath,omitempty"`
	Timestamp *int64  `protobuf:"varint,3,req,name=timestamp" json:"timestamp,omitempty"`
}

func (x *RenameEventProto) Reset() {
	*x = RenameEventProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_inotify_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RenameEventProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenameEventProto) ProtoMessage() {}

func (x *RenameEventProto) ProtoReflect() protoreflect.Message {
	mi := &file_inotify_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RenameEventProto.ProtoReflect.Descriptor instead.
func (*RenameEventProto) Descriptor() ([]byte, []int) {
	return file_inotify_proto_rawDescGZIP(), []int{6}
}

func (x *RenameEventProto) GetSrcPath() string {
	if x != nil && x.SrcPath != nil {
		return *x.SrcPath
	}
	return ""
}

func (x *RenameEventProto) GetDestPath() string {
	if x != nil && x.DestPath != nil {
		return *x.DestPath
	}
	return ""
}

func (x *RenameEventProto) GetTimestamp() int64 {
	if x != nil && x.Timestamp != nil {
		return *x.Timestamp
	}
	return 0
}

type MetadataUpdateEventProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Path          *string             `protobuf:"bytes,1,req,name=path" json:"path,omitempty"`
	Type          *MetadataUpdateType `protobuf:"varint,2,req,name=type,enum=hadoop.hdfs.MetadataUpdateType" json:"type,omitempty"`
	Mtime         *int64              `protobuf:"varint,3,opt,name=mtime" json:"mtime,omitempty"`
	Atime         *int64              `protobuf:"varint,4,opt,name=atime" json:"atime,omitempty"`
	Replication   *int32              `protobuf:"varint,5,opt,name=replication" json:"replication,omitempty"`
	OwnerName     *string             `protobuf:"bytes,6,opt,name=ownerName" json:"ownerName,omitempty"`
	GroupName     *string             `protobuf:"bytes,7,opt,name=groupName" json:"groupName,omitempty"`
	Perms         *FsPermissionProto  `protobuf:"bytes,8,opt,name=perms" json:"perms,omitempty"`
	Acls          []*AclEntryProto    `protobuf:"bytes,9,rep,name=acls" json:"acls,omitempty"`
	XAttrs        []*XAttrProto       `protobuf:"bytes,10,rep,name=xAttrs" json:"xAttrs,omitempty"`
	XAttrsRemoved *bool               `protobuf:"varint,11,opt,name=xAttrsRemoved" json:"xAttrsRemoved,omitempty"`
}

func (x *MetadataUpdateEventProto) Reset() {
	*x = MetadataUpdateEventProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_inotify_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetadataUpdateEventProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetadataUpdateEventProto) ProtoMessage() {}

func (x *MetadataUpdateEventProto) ProtoReflect() protoreflect.Message {
	mi := &file_inotify_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetadataUpdateEventProto.ProtoReflect.Descriptor instead.
func (*MetadataUpdateEventProto) Descriptor() ([]byte, []int) {
	return file_inotify_proto_rawDescGZIP(), []int{7}
}

func (x *MetadataUpdateEventProto) GetPath() string {
	if x != nil && x.Path != nil {
		return *x.Path
	}
	return ""
}

func (x *MetadataUpdateEventProto) GetType() MetadataUpdateType {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return MetadataUpdateType_META_TYPE_TIMES
}

func (x *MetadataUpdateEventProto) GetMtime() int64 {
	if x != nil && x.Mtime != nil {
		return *x.Mtime
	}
	return 0
}

func (x *MetadataUpdateEventProto) GetAtime() int64 {
	if x != nil && x.Atime != nil {
		return *x.Atime
	}
	return 0
}

func (x *MetadataUpdateEventProto) GetReplication() int32 {
	if x != nil && x.Replication != nil {
		return *x.Replication
	}
	return 0
}

func (x *MetadataUpdateEventProto) GetOwnerName() string {
	if x != nil && x.OwnerName != nil {
		return *x.OwnerName
	}
	return ""
}

func (x *MetadataUpdateEventProto) GetGroupName() string {
	if x != nil && x.GroupName != nil {
		return *x.GroupName
	}
	return ""
}

func (x *MetadataUpdateEventProto) GetPerms() *FsPermissionProto {
	if x != nil {
		return x.Perms
	}
	return nil
}

func (x *MetadataUpdateEventProto) GetAcls() []*AclEntryProto {
	if x != nil {
		return x.Acls
	}
	return nil
}

func (x *MetadataUpdateEventProto) GetXAttrs() []*XAttrProto {
	if x != nil {
		return x.XAttrs
	}
	return nil
}

func (x *MetadataUpdateEventProto) GetXAttrsRemoved() bool {
	if x != nil && x.XAttrsRemoved != nil {
		return *x.XAttrsRemoved
	}
	return false
}

type UnlinkEventProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Path      *string `protobuf:"bytes,1,req,name=path" json:"path,omitempty"`
	Timestamp *int64  `protobuf:"varint,2,req,name=timestamp" json:"timestamp,omitempty"`
}

func (x *UnlinkEventProto) Reset() {
	*x = UnlinkEventProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_inotify_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UnlinkEventProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnlinkEventProto) ProtoMessage() {}

func (x *UnlinkEventProto) ProtoReflect() protoreflect.Message {
	mi := &file_inotify_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnlinkEventProto.ProtoReflect.Descriptor instead.
func (*UnlinkEventProto) Descriptor() ([]byte, []int) {
	return file_inotify_proto_rawDescGZIP(), []int{8}
}

func (x *UnlinkEventProto) GetPath() string {
	if x != nil && x.Path != nil {
		return *x.Path
	}
	return ""
}

func (x *UnlinkEventProto) GetTimestamp() int64 {
	if x != nil && x.Timestamp != nil {
		return *x.Timestamp
	}
	return 0
}

type EventsListProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Events    []*EventProto      `protobuf:"bytes,1,rep,name=events" json:"events,omitempty"` // deprecated
	FirstTxid *int64             `protobuf:"varint,2,req,name=firstTxid" json:"firstTxid,omitempty"`
	LastTxid  *int64             `protobuf:"varint,3,req,name=lastTxid" json:"lastTxid,omitempty"`
	SyncTxid  *int64             `protobuf:"varint,4,req,name=syncTxid" json:"syncTxid,omitempty"`
	Batch     []*EventBatchProto `protobuf:"bytes,5,rep,name=batch" json:"batch,omitempty"`
}

func (x *EventsListProto) Reset() {
	*x = EventsListProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_inotify_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventsListProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventsListProto) ProtoMessage() {}

func (x *EventsListProto) ProtoReflect() protoreflect.Message {
	mi := &file_inotify_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventsListProto.ProtoReflect.Descriptor instead.
func (*EventsListProto) Descriptor() ([]byte, []int) {
	return file_inotify_proto_rawDescGZIP(), []int{9}
}

func (x *EventsListProto) GetEvents() []*EventProto {
	if x != nil {
		return x.Events
	}
	return nil
}

func (x *EventsListProto) GetFirstTxid() int64 {
	if x != nil && x.FirstTxid != nil {
		return *x.FirstTxid
	}
	return 0
}

func (x *EventsListProto) GetLastTxid() int64 {
	if x != nil && x.LastTxid != nil {
		return *x.LastTxid
	}
	return 0
}

func (x *EventsListProto) GetSyncTxid() int64 {
	if x != nil && x.SyncTxid != nil {
		return *x.SyncTxid
	}
	return 0
}

func (x *EventsListProto) GetBatch() []*EventBatchProto {
	if x != nil {
		return x.Batch
	}
	return nil
}

var File_inotify_proto protoreflect.FileDescriptor

var file_inotify_proto_rawDesc = []byte{
	0x0a, 0x0d, 0x69, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x0b, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x1a, 0x09, 0x61, 0x63,
	0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x0b, 0x78, 0x61, 0x74, 0x74, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x54, 0x0a, 0x0a, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x2a, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0e,
	0x32, 0x16, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1a,
	0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0c,
	0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x22, 0x56, 0x0a, 0x0f, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x0a,
	0x04, 0x74, 0x78, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x03, 0x52, 0x04, 0x74, 0x78, 0x69,
	0x64, 0x12, 0x2f, 0x0a, 0x06, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x06, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x73, 0x22, 0x93, 0x03, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2a, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x02, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x49, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x02, 0x28,
	0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x02, 0x28, 0x03, 0x52, 0x05, 0x63, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x1c, 0x0a,
	0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x02, 0x28, 0x09,
	0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x02, 0x28, 0x09, 0x52, 0x09,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x34, 0x0a, 0x05, 0x70, 0x65, 0x72,
	0x6d, 0x73, 0x18, 0x06, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f,
	0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x46, 0x73, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x05, 0x70, 0x65, 0x72, 0x6d, 0x73, 0x12,
	0x20, 0x0a, 0x0b, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x24, 0x0a, 0x0d, 0x73, 0x79, 0x6d, 0x6c, 0x69, 0x6e, 0x6b, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x79, 0x6d, 0x6c, 0x69, 0x6e,
	0x6b, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x1c, 0x0a, 0x09, 0x6f, 0x76, 0x65, 0x72, 0x77,
	0x72, 0x69, 0x74, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x6f, 0x76, 0x65, 0x72,
	0x77, 0x72, 0x69, 0x74, 0x65, 0x12, 0x2d, 0x0a, 0x10, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x03, 0x3a,
	0x01, 0x30, 0x52, 0x10, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x42, 0x6c, 0x6f, 0x63, 0x6b,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x65, 0x72, 0x61, 0x73, 0x75, 0x72, 0x65, 0x43,
	0x6f, 0x64, 0x65, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x65, 0x72, 0x61, 0x73,
	0x75, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x64, 0x22, 0x5f, 0x0a, 0x0f, 0x43, 0x6c, 0x6f, 0x73,
	0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x70,
	0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12,
	0x1a, 0x0a, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28,
	0x03, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x03, 0x20, 0x02, 0x28, 0x03, 0x52, 0x09,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x22, 0x62, 0x0a, 0x12, 0x54, 0x72, 0x75,
	0x6e, 0x63, 0x61, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x04, 0x70,
	0x61, 0x74, 0x68, 0x12, 0x1a, 0x0a, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x02, 0x28, 0x03, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x03, 0x20, 0x02,
	0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x22, 0x49, 0x0a,
	0x10, 0x41, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52,
	0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x21, 0x0a, 0x08, 0x6e, 0x65, 0x77, 0x42, 0x6c, 0x6f, 0x63,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x52, 0x08,
	0x6e, 0x65, 0x77, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x22, 0x66, 0x0a, 0x10, 0x52, 0x65, 0x6e, 0x61,
	0x6d, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x0a, 0x07,
	0x73, 0x72, 0x63, 0x50, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x07, 0x73,
	0x72, 0x63, 0x50, 0x61, 0x74, 0x68, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x65, 0x73, 0x74, 0x50, 0x61,
	0x74, 0x68, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x08, 0x64, 0x65, 0x73, 0x74, 0x50, 0x61,
	0x74, 0x68, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18,
	0x03, 0x20, 0x02, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x22, 0xaa, 0x03, 0x0a, 0x18, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x0a,
	0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74,
	0x68, 0x12, 0x33, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0e, 0x32,
	0x1f, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6d, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05,
	0x61, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x61, 0x74, 0x69,
	0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x34, 0x0a, 0x05, 0x70, 0x65, 0x72, 0x6d, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x46, 0x73,
	0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52,
	0x05, 0x70, 0x65, 0x72, 0x6d, 0x73, 0x12, 0x2e, 0x0a, 0x04, 0x61, 0x63, 0x6c, 0x73, 0x18, 0x09,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64,
	0x66, 0x73, 0x2e, 0x41, 0x63, 0x6c, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x52, 0x04, 0x61, 0x63, 0x6c, 0x73, 0x12, 0x2f, 0x0a, 0x06, 0x78, 0x41, 0x74, 0x74, 0x72, 0x73,
	0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e,
	0x68, 0x64, 0x66, 0x73, 0x2e, 0x58, 0x41, 0x74, 0x74, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52,
	0x06, 0x78, 0x41, 0x74, 0x74, 0x72, 0x73, 0x12, 0x24, 0x0a, 0x0d, 0x78, 0x41, 0x74, 0x74, 0x72,
	0x73, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d,
	0x78, 0x41, 0x74, 0x74, 0x72, 0x73, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x22, 0x44, 0x0a,
	0x10, 0x55, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52,
	0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x18, 0x02, 0x20, 0x02, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x22, 0xcc, 0x01, 0x0a, 0x0f, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x4c, 0x69,
	0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2f, 0x0a, 0x06, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x52, 0x06, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x66, 0x69, 0x72, 0x73,
	0x74, 0x54, 0x78, 0x69, 0x64, 0x18, 0x02, 0x20, 0x02, 0x28, 0x03, 0x52, 0x09, 0x66, 0x69, 0x72,
	0x73, 0x74, 0x54, 0x78, 0x69, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x61, 0x73, 0x74, 0x54, 0x78,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x02, 0x28, 0x03, 0x52, 0x08, 0x6c, 0x61, 0x73, 0x74, 0x54, 0x78,
	0x69, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x79, 0x6e, 0x63, 0x54, 0x78, 0x69, 0x64, 0x18, 0x04,
	0x20, 0x02, 0x28, 0x03, 0x52, 0x08, 0x73, 0x79, 0x6e, 0x63, 0x54, 0x78, 0x69, 0x64, 0x12, 0x32,
	0x0a, 0x05, 0x62, 0x61, 0x74, 0x63, 0x68, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x05, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x2a, 0x8c, 0x01, 0x0a, 0x09, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x10, 0x0a, 0x0c, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45,
	0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x43, 0x4c, 0x4f, 0x53,
	0x45, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x41, 0x50, 0x50,
	0x45, 0x4e, 0x44, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x52,
	0x45, 0x4e, 0x41, 0x4d, 0x45, 0x10, 0x03, 0x12, 0x12, 0x0a, 0x0e, 0x45, 0x56, 0x45, 0x4e, 0x54,
	0x5f, 0x4d, 0x45, 0x54, 0x41, 0x44, 0x41, 0x54, 0x41, 0x10, 0x04, 0x12, 0x10, 0x0a, 0x0c, 0x45,
	0x56, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x4c, 0x49, 0x4e, 0x4b, 0x10, 0x05, 0x12, 0x12, 0x0a,
	0x0e, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x52, 0x55, 0x4e, 0x43, 0x41, 0x54, 0x45, 0x10,
	0x06, 0x2a, 0x46, 0x0a, 0x09, 0x49, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0f,
	0x0a, 0x0b, 0x49, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x10, 0x00, 0x12,
	0x14, 0x0a, 0x10, 0x49, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54,
	0x4f, 0x52, 0x59, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x49, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x53, 0x59, 0x4d, 0x4c, 0x49, 0x4e, 0x4b, 0x10, 0x02, 0x2a, 0x98, 0x01, 0x0a, 0x12, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x13, 0x0a, 0x0f, 0x4d, 0x45, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x54, 0x49,
	0x4d, 0x45, 0x53, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x15, 0x4d, 0x45, 0x54, 0x41, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01,
	0x12, 0x13, 0x0a, 0x0f, 0x4d, 0x45, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4f, 0x57,
	0x4e, 0x45, 0x52, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x4d, 0x45, 0x54, 0x41, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x50, 0x45, 0x52, 0x4d, 0x53, 0x10, 0x03, 0x12, 0x12, 0x0a, 0x0e, 0x4d, 0x45,
	0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x41, 0x43, 0x4c, 0x53, 0x10, 0x04, 0x12, 0x14,
	0x0a, 0x10, 0x4d, 0x45, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x58, 0x41, 0x54, 0x54,
	0x52, 0x53, 0x10, 0x05, 0x42, 0x75, 0x0a, 0x25, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x42, 0x0d, 0x49,
	0x6e, 0x6f, 0x74, 0x69, 0x66, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x5a, 0x3a, 0x67, 0x69,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x63, 0x6f, 0x6c, 0x69, 0x6e, 0x6d, 0x61,
	0x72, 0x63, 0x2f, 0x68, 0x64, 0x66, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2f, 0x68, 0x61, 0x64,
	0x6f, 0x6f, 0x70, 0x5f, 0x68, 0x64, 0x66, 0x73, 0xa0, 0x01, 0x01,
}

var (
	file_inotify_proto_rawDescOnce sync.Once
	file_inotify_proto_rawDescData = file_inotify_proto_rawDesc
)

func file_inotify_proto_rawDescGZIP() []byte {
	file_inotify_proto_rawDescOnce.Do(func() {
		file_inotify_proto_rawDescData = protoimpl.X.CompressGZIP(file_inotify_proto_rawDescData)
	})
	return file_inotify_proto_rawDescData
}

var file_inotify_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_inotify_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_inotify_proto_goTypes = []interface{}{
	(EventType)(0),                   // 0: hadoop.hdfs.EventType
	(INodeType)(0),                   // 1: hadoop.hdfs.INodeType
	(MetadataUpdateType)(0),          // 2: hadoop.hdfs.MetadataUpdateType
	(*EventProto)(nil),               // 3: hadoop.hdfs.EventProto
	(*EventBatchProto)(nil),          // 4: hadoop.hdfs.EventBatchProto
	(*CreateEventProto)(nil),         // 5: hadoop.hdfs.CreateEventProto
	(*CloseEventProto)(nil),          // 6: hadoop.hdfs.CloseEventProto
	(*TruncateEventProto)(nil),       // 7: hadoop.hdfs.TruncateEventProto
	(*AppendEventProto)(nil),         // 8: hadoop.hdfs.AppendEventProto
	(*RenameEventProto)(nil),         // 9: hadoop.hdfs.RenameEventProto
	(*MetadataUpdateEventProto)(nil), // 10: hadoop.hdfs.MetadataUpdateEventProto
	(*UnlinkEventProto)(nil),         // 11: hadoop.hdfs.UnlinkEventProto
	(*EventsListProto)(nil),          // 12: hadoop.hdfs.EventsListProto
	(*FsPermissionProto)(nil),        // 13: hadoop.hdfs.FsPermissionProto
	(*AclEntryProto)(nil),            // 14: hadoop.hdfs.AclEntryProto
	(*XAttrProto)(nil),               // 15: hadoop.hdfs.XAttrProto
}
var file_inotify_proto_depIdxs = []int32{
	0,  // 0: hadoop.hdfs.EventProto.type:type_name -> hadoop.hdfs.EventType
	3,  // 1: hadoop.hdfs.EventBatchProto.events:type_name -> hadoop.hdfs.EventProto
	1,  // 2: hadoop.hdfs.CreateEventProto.type:type_name -> hadoop.hdfs.INodeType
	13, // 3: hadoop.hdfs.CreateEventProto.perms:type_name -> hadoop.hdfs.FsPermissionProto
	2,  // 4: hadoop.hdfs.MetadataUpdateEventProto.type:type_name -> hadoop.hdfs.MetadataUpdateType
	13, // 5: hadoop.hdfs.MetadataUpdateEventProto.perms:type_name -> hadoop.hdfs.FsPermissionProto
	14, // 6: hadoop.hdfs.MetadataUpdateEventProto.acls:type_name -> hadoop.hdfs.AclEntryProto
	15, // 7: hadoop.hdfs.MetadataUpdateEventProto.xAttrs:type_name -> hadoop.hdfs.XAttrProto
	3,  // 8: hadoop.hdfs.EventsListProto.events:type_name -> hadoop.hdfs.EventProto
	4,  // 9: hadoop.hdfs.EventsListProto.batch:type_name -> hadoop.hdfs.EventBatchProto
	10, // [10:10] is the sub-list for method output_type
	10, // [10:10] is the sub-list for method input_type
	10, // [10:10] is the sub-list for extension type_name
	10, // [10:10] is the sub-list for extension extendee
	0,  // [0:10] is the sub-list for field type_name
}

func init() { file_inotify_proto_init() }
func file_inotify_proto_init() {
	if File_inotify_proto != nil {
		return
	}
	file_acl_proto_init()
	file_xattr_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_inotify_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_inotify_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventBatchProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_inotify_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateEventProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_inotify_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloseEventProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_inotify_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TruncateEventProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_inotify_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppendEventProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_inotify_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RenameEventProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_inotify_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetadataUpdateEventProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_inotify_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UnlinkEventProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_inotify_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventsListProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_inotify_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_inotify_proto_goTypes,
		DependencyIndexes: file_inotify_proto_depIdxs,
		EnumInfos:         file_inotify_proto_enumTypes,
		MessageInfos:      file_inotify_proto_msgTypes,
	}.Build()
	File_inotify_proto = out.File
	file_inotify_proto_rawDesc = nil
	file_inotify_proto_goTypes = nil
	file_inotify_proto_depIdxs = nil
}
