#pragma once
/*
 *  $Id: rgba.h 28777 2025-11-04 16:46:05Z yeti-dn $
 *  Copyright (C) 2004-2024 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_RGBA_H__
#define __GWY_RGBA_H__

#include <glib-object.h>
#include <libgwyddion/gwycontainer.h>

G_BEGIN_DECLS

#define GWY_TYPE_RGBA                         (gwy_rgba_get_type())

/* FIXME GTK3: GwyRGBA is byte for byte indentical to GdkRGBA, which also has some parsing and conversion
 * functions. They call the fields differently (complete words), but that should not be such a hassle to adapt.
 *
 * We still need to keep some utility functions, which is OK.
 *
 * I do not like having GTK+ types ("GdkRGBA") in our files directly though because they like to do some clever shit
 * which is almost compatible, but not really. */

typedef struct {
    gdouble r;
    gdouble g;
    gdouble b;
    gdouble a;
} GwyRGBA;

GType    gwy_rgba_get_type             (void)                    G_GNUC_CONST;
GwyRGBA* gwy_rgba_new                  (gdouble r,
                                        gdouble g,
                                        gdouble b,
                                        gdouble a)               G_GNUC_MALLOC;
GwyRGBA* gwy_rgba_copy                 (const GwyRGBA *rgba)     G_GNUC_MALLOC;
void     gwy_rgba_free                 (GwyRGBA *rgba);
gboolean gwy_rgba_equal                (const GwyRGBA *rgba,
                                        const GwyRGBA *other);
void     gwy_rgba_interpolate          (const GwyRGBA *src1,
                                        const GwyRGBA *src2,
                                        gdouble x,
                                        GwyRGBA *rgba);
gboolean gwy_rgba_get_from_container   (GwyRGBA *rgba,
                                        GwyContainer *container,
                                        const gchar *prefix);
void     gwy_rgba_store_to_container   (const GwyRGBA *rgba,
                                        GwyContainer *container,
                                        const gchar *prefix);
gboolean gwy_rgba_remove_from_container(GwyContainer *container,
                                        const gchar *prefix);
void     gwy_rgba_to_hex6              (const GwyRGBA *rgba,
                                        gchar *hexout);
void     gwy_rgba_to_hex8              (const GwyRGBA *rgba,
                                        gchar *hexout);
guint32  gwy_rgba_to_pixbuf_pixel      (const GwyRGBA *rgba);
void     gwy_rgba_from_pixbuf_pixel    (GwyRGBA *rgba,
                                        guint32 pixel);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
