module Test.Data.List.Reverse.StrictElement where

import qualified Data.List.Reverse.StrictElement as Rev
import qualified Data.List as List
import Data.Tuple.HT (mapPair, swap, )

import Test.QuickCheck (Testable, quickCheck, )

import Prelude hiding (takeWhile, dropWhile, span, )


takeWhile :: (Ord a) => (a -> Bool) -> [a] -> Bool
takeWhile p xs =
   Rev.takeWhile p xs == reverse (List.takeWhile p (reverse xs))

dropWhile :: (Ord a) => (a -> Bool) -> [a] -> Bool
dropWhile p xs =
   Rev.dropWhile p xs == reverse (List.dropWhile p (reverse xs))

span :: (Ord a) => (a -> Bool) -> [a] -> Bool
span p xs =
   Rev.span p xs == swap (mapPair (reverse, reverse) (List.span p (reverse xs)))

spanTakeDrop :: (Ord a) => (a -> Bool) -> [a] -> Bool
spanTakeDrop p xs =
   Rev.span p xs == (Rev.dropWhile p xs, Rev.takeWhile p xs)

dropWhileInf :: (Ord a) => a -> [a] -> Bool
dropWhileInf x xs =
   let ys = List.take 1000 $ Rev.dropWhile (x/=) $ cycle $ x:xs
   in  ys==ys

spanInf :: (Ord a) => a -> [a] -> Bool
spanInf x xs =
   let ys = List.take 1000 $ fst $ Rev.span (x/=) $ cycle $ x:xs
   in  ys==ys


simple ::
   (Testable test) =>
   (Float -> [Float] -> test) -> IO ()
simple = quickCheck


tests :: [(String, IO ())]
tests =
   ("takeWhile",     simple (\a -> takeWhile (a>=))) :
   ("dropWhile",     simple (\a -> dropWhile (a>=))) :
   ("span",          simple (\a -> span (a>=))) :
   ("spanTakeDrop",  simple (\a -> spanTakeDrop (a>=))) :
   ("dropWhileInf",  simple dropWhileInf) :
   ("spanInf",       simple spanInf) :
   []
