#!/bin/sh

. "`dirname \"$0\"`/common.sh"

USER="mailto:resource-room-confroom@example.com"

mkdir -p "$PREFS/$USER"
echo 'Europe/Oslo' > "$PREFS/$USER/TZID"
echo 'share' > "$PREFS/$USER/freebusy_sharing"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out0.tmp

   grep -q 'METHOD:REPLY' out0.tmp \
&& ! grep -q '^FREEBUSY' out0.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out1.tmp

   grep -q 'METHOD:REPLY' out1.tmp \
&& ! grep -q '^FREEBUSY' out1.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out2.tmp

   grep -q 'METHOD:REPLY' out2.tmp \
&& grep -q 'ATTENDEE;PARTSTAT=ACCEPTED' out2.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out3.tmp

   grep -q 'METHOD:REPLY' out3.tmp \
&& grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T150000Z/20141126T160000Z' out3.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-conflict.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out4.tmp

   grep -q 'METHOD:REPLY' out4.tmp \
&& grep -q 'ATTENDEE;PARTSTAT=DECLINED' out4.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-conflict-utc.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out5.tmp

   grep -q 'METHOD:REPLY' out5.tmp \
&& grep -q 'ATTENDEE;PARTSTAT=DECLINED' out5.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out6.tmp

   grep -q 'METHOD:REPLY' out6.tmp \
&& grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T150000Z/20141126T160000Z' out6.tmp \
&& [ `grep 'FREEBUSY;FBTYPE=BUSY' out6.tmp | wc -l` = '1' ] \
&& echo "Success" \
|| echo "Failed"

"$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-cancel.txt" 2>> $ERROR
echo "Cancel..."

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out7.tmp

   grep -q 'METHOD:REPLY' out7.tmp \
&& ! grep -q '^FREEBUSY' out7.tmp \
&& echo "Success" \
|| echo "Failed"

"$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-spoofed.txt" 2>> $ERROR
echo "Spoof..."

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out8.tmp

   grep -q 'METHOD:REPLY' out8.tmp \
&& ! grep -q '^FREEBUSY' out8.tmp \
&& echo "Success" \
|| echo "Failed"
