(function() {
  var LessPlugin;

  module.exports = LessPlugin = (function() {
    LessPlugin.identifier = 'less';

    LessPlugin.version = '1.0';

    function LessPlugin(window, host) {
      this.window = window;
      this.host = host;
    }

    LessPlugin.prototype.reload = function(path, options) {
      if (this.window.less && this.window.less.refresh) {
        if (path.match(/\.less$/i)) {
          return this.reloadLess(path);
        }
        if (options.originalPath.match(/\.less$/i)) {
          return this.reloadLess(options.originalPath);
        }
      }
      return false;
    };

    LessPlugin.prototype.reloadLess = function(path) {
      var link, links, _i, _len;
      links = (function() {
        var _i, _len, _ref, _results;
        _ref = document.getElementsByTagName('link');
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          link = _ref[_i];
          if (link.href && link.rel.match(/^stylesheet\/less$/i) || (link.rel.match(/stylesheet/i) && link.type.match(/^text\/(x-)?less$/i))) {
            _results.push(link);
          }
        }
        return _results;
      })();
      if (links.length === 0) {
        return false;
      }
      for (_i = 0, _len = links.length; _i < _len; _i++) {
        link = links[_i];
        link.href = this.host.generateCacheBustUrl(link.href);
      }
      this.host.console.log("LiveReload is asking LESS to recompile all stylesheets");
      this.window.less.refresh(true);
      return true;
    };

    LessPlugin.prototype.analyze = function() {
      return {
        disable: !!(this.window.less && this.window.less.refresh)
      };
    };

    return LessPlugin;

  })();

}).call(this);
