#!/usr/bin/env python3

from selenium import webdriver
from selenium.webdriver.webkitgtk.options import Options
import time
import os

# other includes
from selenium.webdriver.webkitgtk.service import Service as WebKitService

# potential other existing python code in your application
# to prepare your setup

# set the to used driver, here as example for the chrome-driver
service = WebKitService(executable_path="/usr/bin/WebKitWebDriver")
# give the chosen driver as option to the intatioation of Chrome()
driver = webdriver.WebKitGTK(service = service)

html_path = "test-pie-page.html"
js_file_jquery_path = '/usr/share/javascript/jquery/jquery.js'
js_file_sparkline_path = '/usr/share/javascript/jquery.sparkline/jquery.sparkline.js'

current_dir = os.path.dirname(os.path.abspath(__file__))
file_path = f"file://{os.path.join(current_dir, html_path)}"

try:
    # Load test html
    driver.get(file_path)
    print(f"Title: {driver.title}")
    
    # Load JavaScript - JQuery
    with open(js_file_jquery_path, 'r', encoding='utf-8') as file:
        js_code = file.read()
    result = driver.execute_script(js_code)

    # Load JavaScript - Sparkline
    with open(js_file_sparkline_path, 'r', encoding='utf-8') as file:
        js_code = file.read()
    result = driver.execute_script(js_code)

    # Run Sparkline to generate a pie chart
    js_code="$('#pie').sparkline([1,2,3,4,5,4,3,2,1], { type:'pie' });"
    result = driver.execute_script(js_code)
    
    # pause 10 sec
    time.sleep(10)

finally:
    # close driver
    driver.quit()
