/**
 * PKCS11Constants.java - part of the JSS project
 * Copyright (C) 2018 Red Hat, Inc.
 *
 * This file is automatically generated (tools/build_pkcs11_constants.py)
 * from the contents of NSS's pkcs11t.h and pkcs11n.h headers. This
 * replaces the sun.security.pkcs11.wrapper.PKCS11Constants interface
 * which was removed from public visibility in JDK 9 due to the
 * introduction of modules.
 *
 * For more information, please see the documentation under
 * jss/docs/pkcs11_constants.md.
 *
 * Below are the copyright statements for the sourced files:
 */
/* Copyright statements from /usr/include/nss3/pkcs11t.h */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */
/* License to copy and use this software is granted provided that it is
 * identified as "RSA Security Inc. PKCS #11 Cryptographic Token Interface
 * (Cryptoki)" in all material mentioning or referencing this software.

 * License is also granted to make and use derivative works provided that
 * such works are identified as "derived from the RSA Security Inc. PKCS #11
 * Cryptographic Token Interface (Cryptoki)" in all material mentioning or
 * referencing the derived work.

 * RSA Security Inc. makes no representations concerning either the
 * merchantability of this software or the suitability of this software for
 * any particular purpose. It is provided "as is" without express or implied
 * warranty of any kind.
 */

/* Copyright statements from /usr/include/nss3/pkcs11n.h */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

package org.mozilla.jss.pkcs11;

public interface PKCS11Constants {

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_TRUE = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_FALSE = 0x00000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_NULL_PTR = 0x00000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_EFFECTIVELY_INFINITE = 0x00000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_INVALID_HANDLE = 0x00000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKN_SURRENDER = 0x00000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_TOKEN_PRESENT = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_REMOVABLE_DEVICE = 0x00000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_HW_SLOT = 0x00000004L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_RNG = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_WRITE_PROTECTED = 0x00000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_LOGIN_REQUIRED = 0x00000004L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_USER_PIN_INITIALIZED = 0x00000008L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_RESTORE_KEY_NOT_NEEDED = 0x00000020L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_CLOCK_ON_TOKEN = 0x00000040L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_PROTECTED_AUTHENTICATION_PATH = 0x00000100L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_DUAL_CRYPTO_OPERATIONS = 0x00000200L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_TOKEN_INITIALIZED = 0x00000400L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_SECONDARY_AUTHENTICATION = 0x00000800L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_USER_PIN_COUNT_LOW = 0x00010000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_USER_PIN_FINAL_TRY = 0x00020000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_USER_PIN_LOCKED = 0x00040000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_USER_PIN_TO_BE_CHANGED = 0x00080000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_SO_PIN_COUNT_LOW = 0x00100000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_SO_PIN_FINAL_TRY = 0x00200000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_SO_PIN_LOCKED = 0x00400000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_SO_PIN_TO_BE_CHANGED = 0x00800000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_ERROR_STATE = 0x01000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKU_SO = 0x00000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKU_USER = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKU_CONTEXT_SPECIFIC = 0x00000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKS_RO_PUBLIC_SESSION = 0x00000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKS_RO_USER_FUNCTIONS = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKS_RW_PUBLIC_SESSION = 0x00000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKS_RW_USER_FUNCTIONS = 0x00000003L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKS_RW_SO_FUNCTIONS = 0x00000004L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_RW_SESSION = 0x00000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_SERIAL_SESSION = 0x00000004L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKO_DATA = 0x00000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKO_CERTIFICATE = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKO_PUBLIC_KEY = 0x00000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKO_PRIVATE_KEY = 0x00000003L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKO_SECRET_KEY = 0x00000004L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKO_HW_FEATURE = 0x00000005L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKO_DOMAIN_PARAMETERS = 0x00000006L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKO_MECHANISM = 0x00000007L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKO_PROFILE = 0x00000009L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKO_VENDOR_DEFINED = 0x80000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKP_INVALID_ID = 0x00000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKP_BASELINE_PROVIDER = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKP_EXTENDED_PROVIDER = 0x00000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKP_AUTHENTICATION_TOKEN = 0x00000003L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKP_PUBLIC_CERTIFICATES_TOKEN = 0x00000004L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKP_VENDOR_DEFINED = 0x80000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKH_MONOTONIC_COUNTER = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKH_CLOCK = 0x00000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKH_USER_INTERFACE = 0x00000003L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKH_VENDOR_DEFINED = 0x80000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_RSA = 0x00000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_DSA = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_DH = 0x00000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_ECDSA = 0x00000003L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_EC = 0x00000003L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_X9_42_DH = 0x00000004L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_KEA = 0x00000005L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_GENERIC_SECRET = 0x00000010L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_RC2 = 0x00000011L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_RC4 = 0x00000012L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_DES = 0x00000013L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_DES2 = 0x00000014L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_DES3 = 0x00000015L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_CAST = 0x00000016L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_CAST3 = 0x00000017L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_CAST5 = 0x00000018L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_CAST128 = 0x00000018L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_RC5 = 0x00000019L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_IDEA = 0x0000001AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_SKIPJACK = 0x0000001BL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_BATON = 0x0000001CL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_JUNIPER = 0x0000001DL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_CDMF = 0x0000001EL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_AES = 0x0000001FL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_BLOWFISH = 0x00000020L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_TWOFISH = 0x00000021L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_CAMELLIA = 0x00000025L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_SEED = 0x0000002FL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_ARIA = 0x00000026L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_MD5_HMAC = 0x00000027L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_SHA_1_HMAC = 0x00000028L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_RIPEMD128_HMAC = 0x00000029L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_RIPEMD160_HMAC = 0x0000002AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_SHA256_HMAC = 0x0000002BL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_SHA384_HMAC = 0x0000002CL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_SHA512_HMAC = 0x0000002DL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_SHA224_HMAC = 0x0000002EL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_GOSTR3410 = 0x00000030L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_GOSTR3411 = 0x00000031L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_GOST28147 = 0x00000032L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_CHACHA20 = 0x00000033L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_POLY1305 = 0x00000034L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_AES_XTS = 0x00000035L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_SHA3_224_HMAC = 0x00000036L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_SHA3_256_HMAC = 0x00000037L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_SHA3_384_HMAC = 0x00000038L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_SHA3_512_HMAC = 0x00000039L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_BLAKE2B_160_HMAC = 0x0000003AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_BLAKE2B_256_HMAC = 0x0000003BL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_BLAKE2B_384_HMAC = 0x0000003CL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_BLAKE2B_512_HMAC = 0x0000003DL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_SALSA20 = 0x0000003EL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_X2RATCHET = 0x0000003FL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_EC_EDWARDS = 0x00000040L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_EC_MONTGOMERY = 0x00000041L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_HKDF = 0x00000042L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_SHA512_224_HMAC = 0x00000043L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_SHA512_256_HMAC = 0x00000044L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_SHA512_T_HMAC = 0x00000045L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_VENDOR_DEFINED = 0x80000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKC_X_509 = 0x00000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKC_X_509_ATTR_CERT = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKC_WTLS = 0x00000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKC_VENDOR_DEFINED = 0x80000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_CERTIFICATE_CATEGORY_UNSPECIFIED = 0x00000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_CERTIFICATE_CATEGORY_TOKEN_USER = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_CERTIFICATE_CATEGORY_AUTHORITY = 0x00000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_CERTIFICATE_CATEGORY_OTHER_ENTITY = 0x00000003L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_SECURITY_DOMAIN_UNSPECIFIED = 0x00000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_SECURITY_DOMAIN_MANUFACTURER = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_SECURITY_DOMAIN_OPERATOR = 0x00000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_SECURITY_DOMAIN_THIRD_PARTY = 0x00000003L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_OTP_FORMAT_DECIMAL = 0x00000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_OTP_FORMAT_HEXADECIMAL = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_OTP_FORMAT_ALPHANUMERIC = 0x00000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_OTP_FORMAT_BINARY = 0x00000003L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_OTP_PARAM_IGNORED = 0x00000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_OTP_PARAM_OPTIONAL = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_OTP_PARAM_MANDATORY = 0x00000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_ARRAY_ATTRIBUTE = 0x40000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_CLASS = 0x00000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_TOKEN = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_PRIVATE = 0x00000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_LABEL = 0x00000003L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_APPLICATION = 0x00000010L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_VALUE = 0x00000011L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_OBJECT_ID = 0x00000012L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_CERTIFICATE_TYPE = 0x00000080L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_ISSUER = 0x00000081L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_SERIAL_NUMBER = 0x00000082L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_AC_ISSUER = 0x00000083L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_OWNER = 0x00000084L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_ATTR_TYPES = 0x00000085L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_TRUSTED = 0x00000086L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_CERTIFICATE_CATEGORY = 0x00000087L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_JAVA_MIDP_SECURITY_DOMAIN = 0x00000088L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_URL = 0x00000089L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_HASH_OF_SUBJECT_PUBLIC_KEY = 0x0000008AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_HASH_OF_ISSUER_PUBLIC_KEY = 0x0000008BL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_CHECK_VALUE = 0x00000090L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_KEY_TYPE = 0x00000100L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_SUBJECT = 0x00000101L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_ID = 0x00000102L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_SENSITIVE = 0x00000103L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_ENCRYPT = 0x00000104L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_DECRYPT = 0x00000105L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_WRAP = 0x00000106L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_UNWRAP = 0x00000107L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_SIGN = 0x00000108L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_SIGN_RECOVER = 0x00000109L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_VERIFY = 0x0000010AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_VERIFY_RECOVER = 0x0000010BL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_DERIVE = 0x0000010CL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_START_DATE = 0x00000110L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_END_DATE = 0x00000111L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_MODULUS = 0x00000120L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_MODULUS_BITS = 0x00000121L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_PUBLIC_EXPONENT = 0x00000122L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_PRIVATE_EXPONENT = 0x00000123L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_PRIME_1 = 0x00000124L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_PRIME_2 = 0x00000125L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_EXPONENT_1 = 0x00000126L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_EXPONENT_2 = 0x00000127L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_COEFFICIENT = 0x00000128L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_PUBLIC_KEY_INFO = 0x00000129L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_PRIME = 0x00000130L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_SUBPRIME = 0x00000131L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_BASE = 0x00000132L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_PRIME_BITS = 0x00000133L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_SUBPRIME_BITS = 0x00000134L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_SUB_PRIME_BITS = 0x00000134L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_VALUE_BITS = 0x00000160L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_VALUE_LEN = 0x00000161L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_EXTRACTABLE = 0x00000162L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_LOCAL = 0x00000163L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_NEVER_EXTRACTABLE = 0x00000164L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_ALWAYS_SENSITIVE = 0x00000165L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_KEY_GEN_MECHANISM = 0x00000166L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_MODIFIABLE = 0x00000170L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_COPYABLE = 0x00000171L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_DESTROYABLE = 0x00000172L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_ECDSA_PARAMS = 0x00000180L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_EC_PARAMS = 0x00000180L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_EC_POINT = 0x00000181L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_SECONDARY_AUTH = 0x00000200L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_AUTH_PIN_FLAGS = 0x00000201L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_ALWAYS_AUTHENTICATE = 0x00000202L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_WRAP_WITH_TRUSTED = 0x00000210L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_WRAP_TEMPLATE = 0x40000211L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_UNWRAP_TEMPLATE = 0x40000212L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_DERIVE_TEMPLATE = 0x40000213L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_OTP_FORMAT = 0x00000220L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_OTP_LENGTH = 0x00000221L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_OTP_TIME_INTERVAL = 0x00000222L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_OTP_USER_FRIENDLY_MODE = 0x00000223L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_OTP_CHALLENGE_REQUIREMENT = 0x00000224L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_OTP_TIME_REQUIREMENT = 0x00000225L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_OTP_COUNTER_REQUIREMENT = 0x00000226L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_OTP_PIN_REQUIREMENT = 0x00000227L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_OTP_COUNTER = 0x0000022EL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_OTP_TIME = 0x0000022FL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_OTP_USER_IDENTIFIER = 0x0000022AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_OTP_SERVICE_IDENTIFIER = 0x0000022BL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_OTP_SERVICE_LOGO = 0x0000022CL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_OTP_SERVICE_LOGO_TYPE = 0x0000022DL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_GOSTR3410_PARAMS = 0x00000250L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_GOSTR3411_PARAMS = 0x00000251L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_GOST28147_PARAMS = 0x00000252L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_HW_FEATURE_TYPE = 0x00000300L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_RESET_ON_INIT = 0x00000301L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_HAS_RESET = 0x00000302L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_PIXEL_X = 0x00000400L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_PIXEL_Y = 0x00000401L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_RESOLUTION = 0x00000402L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_CHAR_ROWS = 0x00000403L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_CHAR_COLUMNS = 0x00000404L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_COLOR = 0x00000405L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_BITS_PER_PIXEL = 0x00000406L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_CHAR_SETS = 0x00000480L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_ENCODING_METHODS = 0x00000481L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_MIME_TYPES = 0x00000482L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_MECHANISM_TYPE = 0x00000500L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_REQUIRED_CMS_ATTRIBUTES = 0x00000501L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_DEFAULT_CMS_ATTRIBUTES = 0x00000502L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_SUPPORTED_CMS_ATTRIBUTES = 0x00000503L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_ALLOWED_MECHANISMS = 0x40000600L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_PROFILE_ID = 0x00000601L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_X2RATCHET_BAG = 0x00000602L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_X2RATCHET_BAGSIZE = 0x00000603L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_X2RATCHET_BOBS1STMSG = 0x00000604L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_X2RATCHET_CKR = 0x00000605L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_X2RATCHET_CKS = 0x00000606L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_X2RATCHET_DHP = 0x00000607L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_X2RATCHET_DHR = 0x00000608L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_X2RATCHET_DHS = 0x00000609L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_X2RATCHET_HKR = 0x0000060AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_X2RATCHET_HKS = 0x0000060BL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_X2RATCHET_ISALICE = 0x0000060CL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_X2RATCHET_NHKR = 0x0000060DL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_X2RATCHET_NHKS = 0x0000060EL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_X2RATCHET_NR = 0x0000060FL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_X2RATCHET_NS = 0x00000610L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_X2RATCHET_PNS = 0x00000611L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_X2RATCHET_RK = 0x00000612L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKA_VENDOR_DEFINED = 0x80000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RSA_PKCS_KEY_PAIR_GEN = 0x00000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RSA_PKCS = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RSA_9796 = 0x00000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RSA_X_509 = 0x00000003L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_MD2_RSA_PKCS = 0x00000004L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_MD5_RSA_PKCS = 0x00000005L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA1_RSA_PKCS = 0x00000006L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RIPEMD128_RSA_PKCS = 0x00000007L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RIPEMD160_RSA_PKCS = 0x00000008L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RSA_PKCS_OAEP = 0x00000009L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RSA_X9_31_KEY_PAIR_GEN = 0x0000000AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RSA_X9_31 = 0x0000000BL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA1_RSA_X9_31 = 0x0000000CL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RSA_PKCS_PSS = 0x0000000DL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA1_RSA_PKCS_PSS = 0x0000000EL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DSA_KEY_PAIR_GEN = 0x00000010L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DSA = 0x00000011L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DSA_SHA1 = 0x00000012L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DSA_SHA224 = 0x00000013L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DSA_SHA256 = 0x00000014L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DSA_SHA384 = 0x00000015L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DSA_SHA512 = 0x00000016L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DSA_SHA3_224 = 0x00000018L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DSA_SHA3_256 = 0x00000019L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DSA_SHA3_384 = 0x0000001AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DSA_SHA3_512 = 0x0000001BL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DH_PKCS_KEY_PAIR_GEN = 0x00000020L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DH_PKCS_DERIVE = 0x00000021L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_X9_42_DH_KEY_PAIR_GEN = 0x00000030L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_X9_42_DH_DERIVE = 0x00000031L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_X9_42_DH_HYBRID_DERIVE = 0x00000032L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_X9_42_MQV_DERIVE = 0x00000033L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA256_RSA_PKCS = 0x00000040L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA384_RSA_PKCS = 0x00000041L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA512_RSA_PKCS = 0x00000042L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA256_RSA_PKCS_PSS = 0x00000043L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA384_RSA_PKCS_PSS = 0x00000044L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA512_RSA_PKCS_PSS = 0x00000045L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA224_RSA_PKCS = 0x00000046L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA224_RSA_PKCS_PSS = 0x00000047L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA512_224 = 0x00000048L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA512_224_HMAC = 0x00000049L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA512_224_HMAC_GENERAL = 0x0000004AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA512_224_KEY_DERIVATION = 0x0000004BL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA512_256 = 0x0000004CL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA512_256_HMAC = 0x0000004DL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA512_256_HMAC_GENERAL = 0x0000004EL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA512_256_KEY_DERIVATION = 0x0000004FL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA512_T = 0x00000050L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA512_T_HMAC = 0x00000051L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA512_T_HMAC_GENERAL = 0x00000052L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA512_T_KEY_DERIVATION = 0x00000053L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA3_256_RSA_PKCS = 0x00000060L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA3_384_RSA_PKCS = 0x00000061L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA3_512_RSA_PKCS = 0x00000062L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA3_256_RSA_PKCS_PSS = 0x00000063L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA3_384_RSA_PKCS_PSS = 0x00000064L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA3_512_RSA_PKCS_PSS = 0x00000065L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA3_224_RSA_PKCS = 0x00000066L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA3_224_RSA_PKCS_PSS = 0x00000067L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RC2_KEY_GEN = 0x00000100L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RC2_ECB = 0x00000101L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RC2_CBC = 0x00000102L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RC2_MAC = 0x00000103L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RC2_MAC_GENERAL = 0x00000104L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RC2_CBC_PAD = 0x00000105L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RC4_KEY_GEN = 0x00000110L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RC4 = 0x00000111L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DES_KEY_GEN = 0x00000120L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DES_ECB = 0x00000121L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DES_CBC = 0x00000122L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DES_MAC = 0x00000123L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DES_MAC_GENERAL = 0x00000124L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DES_CBC_PAD = 0x00000125L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DES2_KEY_GEN = 0x00000130L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DES3_KEY_GEN = 0x00000131L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DES3_ECB = 0x00000132L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DES3_CBC = 0x00000133L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DES3_MAC = 0x00000134L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DES3_MAC_GENERAL = 0x00000135L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DES3_CBC_PAD = 0x00000136L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CDMF_KEY_GEN = 0x00000140L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CDMF_ECB = 0x00000141L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CDMF_CBC = 0x00000142L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CDMF_MAC = 0x00000143L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CDMF_MAC_GENERAL = 0x00000144L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CDMF_CBC_PAD = 0x00000145L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DES_OFB64 = 0x00000150L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DES_OFB8 = 0x00000151L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DES_CFB64 = 0x00000152L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DES_CFB8 = 0x00000153L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_MD2 = 0x00000200L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_MD2_HMAC = 0x00000201L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_MD2_HMAC_GENERAL = 0x00000202L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_MD5 = 0x00000210L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_MD5_HMAC = 0x00000211L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_MD5_HMAC_GENERAL = 0x00000212L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA_1 = 0x00000220L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA_1_HMAC = 0x00000221L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA_1_HMAC_GENERAL = 0x00000222L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RIPEMD128 = 0x00000230L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RIPEMD128_HMAC = 0x00000231L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RIPEMD128_HMAC_GENERAL = 0x00000232L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RIPEMD160 = 0x00000240L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RIPEMD160_HMAC = 0x00000241L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RIPEMD160_HMAC_GENERAL = 0x00000242L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA256 = 0x00000250L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA256_HMAC = 0x00000251L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA256_HMAC_GENERAL = 0x00000252L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA384 = 0x00000260L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA384_HMAC = 0x00000261L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA384_HMAC_GENERAL = 0x00000262L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA512 = 0x00000270L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA512_HMAC = 0x00000271L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA512_HMAC_GENERAL = 0x00000272L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA224 = 0x00000255L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA224_HMAC = 0x00000256L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA224_HMAC_GENERAL = 0x00000257L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SECURID_KEY_GEN = 0x00000280L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SECURID = 0x00000282L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_HOTP_KEY_GEN = 0x00000290L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_HOTP = 0x00000291L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_ACTI = 0x000002A0L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_ACTI_KEY_GEN = 0x000002A1L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA3_256 = 0x000002B0L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA3_256_HMAC = 0x000002B1L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA3_256_HMAC_GENERAL = 0x000002B2L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA3_256_KEY_GEN = 0x000002B3L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA3_224 = 0x000002B5L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA3_224_HMAC = 0x000002B6L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA3_224_HMAC_GENERAL = 0x000002B7L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA3_224_KEY_GEN = 0x000002B8L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA3_384 = 0x000002C0L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA3_384_HMAC = 0x000002C1L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA3_384_HMAC_GENERAL = 0x000002C2L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA3_384_KEY_GEN = 0x000002C3L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA3_512 = 0x000002D0L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA3_512_HMAC = 0x000002D1L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA3_512_HMAC_GENERAL = 0x000002D2L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA3_512_KEY_GEN = 0x000002D3L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAST_KEY_GEN = 0x00000300L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAST_ECB = 0x00000301L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAST_CBC = 0x00000302L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAST_MAC = 0x00000303L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAST_MAC_GENERAL = 0x00000304L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAST_CBC_PAD = 0x00000305L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAST3_KEY_GEN = 0x00000310L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAST3_ECB = 0x00000311L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAST3_CBC = 0x00000312L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAST3_MAC = 0x00000313L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAST3_MAC_GENERAL = 0x00000314L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAST3_CBC_PAD = 0x00000315L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAST5_KEY_GEN = 0x00000320L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAST128_KEY_GEN = 0x00000320L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAST5_ECB = 0x00000321L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAST128_ECB = 0x00000321L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAST5_CBC = 0x00000322L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAST128_CBC = 0x00000322L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAST5_MAC = 0x00000323L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAST128_MAC = 0x00000323L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAST5_MAC_GENERAL = 0x00000324L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAST128_MAC_GENERAL = 0x00000324L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAST5_CBC_PAD = 0x00000325L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAST128_CBC_PAD = 0x00000325L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RC5_KEY_GEN = 0x00000330L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RC5_ECB = 0x00000331L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RC5_CBC = 0x00000332L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RC5_MAC = 0x00000333L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RC5_MAC_GENERAL = 0x00000334L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RC5_CBC_PAD = 0x00000335L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_IDEA_KEY_GEN = 0x00000340L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_IDEA_ECB = 0x00000341L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_IDEA_CBC = 0x00000342L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_IDEA_MAC = 0x00000343L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_IDEA_MAC_GENERAL = 0x00000344L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_IDEA_CBC_PAD = 0x00000345L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_GENERIC_SECRET_KEY_GEN = 0x00000350L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CONCATENATE_BASE_AND_KEY = 0x00000360L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CONCATENATE_BASE_AND_DATA = 0x00000362L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CONCATENATE_DATA_AND_BASE = 0x00000363L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_XOR_BASE_AND_DATA = 0x00000364L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_EXTRACT_KEY_FROM_KEY = 0x00000365L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SSL3_PRE_MASTER_KEY_GEN = 0x00000370L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SSL3_MASTER_KEY_DERIVE = 0x00000371L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SSL3_KEY_AND_MAC_DERIVE = 0x00000372L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SSL3_MASTER_KEY_DERIVE_DH = 0x00000373L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_TLS_PRE_MASTER_KEY_GEN = 0x00000374L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_TLS_MASTER_KEY_DERIVE = 0x00000375L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_TLS_KEY_AND_MAC_DERIVE = 0x00000376L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_TLS_MASTER_KEY_DERIVE_DH = 0x00000377L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_TLS_PRF = 0x00000378L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SSL3_MD5_MAC = 0x00000380L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SSL3_SHA1_MAC = 0x00000381L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_MD5_KEY_DERIVATION = 0x00000390L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_MD2_KEY_DERIVATION = 0x00000391L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA1_KEY_DERIVATION = 0x00000392L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA256_KEY_DERIVATION = 0x00000393L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA384_KEY_DERIVATION = 0x00000394L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA512_KEY_DERIVATION = 0x00000395L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA224_KEY_DERIVATION = 0x00000396L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA3_256_KEY_DERIVATION = 0x00000397L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA3_224_KEY_DERIVATION = 0x00000398L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA3_384_KEY_DERIVATION = 0x00000399L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA3_512_KEY_DERIVATION = 0x0000039AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHAKE_128_KEY_DERIVATION = 0x0000039BL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHAKE_256_KEY_DERIVATION = 0x0000039CL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_PBE_MD2_DES_CBC = 0x000003A0L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_PBE_MD5_DES_CBC = 0x000003A1L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_PBE_MD5_CAST_CBC = 0x000003A2L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_PBE_MD5_CAST3_CBC = 0x000003A3L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_PBE_MD5_CAST5_CBC = 0x000003A4L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_PBE_MD5_CAST128_CBC = 0x000003A4L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_PBE_SHA1_CAST5_CBC = 0x000003A5L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_PBE_SHA1_CAST128_CBC = 0x000003A5L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_PBE_SHA1_RC4_128 = 0x000003A6L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_PBE_SHA1_RC4_40 = 0x000003A7L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_PBE_SHA1_DES3_EDE_CBC = 0x000003A8L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_PBE_SHA1_DES2_EDE_CBC = 0x000003A9L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_PBE_SHA1_RC2_128_CBC = 0x000003AAL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_PBE_SHA1_RC2_40_CBC = 0x000003ABL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_PKCS5_PBKD2 = 0x000003B0L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_PBA_SHA1_WITH_SHA1_HMAC = 0x000003C0L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_WTLS_PRE_MASTER_KEY_GEN = 0x000003D0L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_WTLS_MASTER_KEY_DERIVE = 0x000003D1L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_WTLS_MASTER_KEY_DERIVE_DH_ECC = 0x000003D2L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_WTLS_PRF = 0x000003D3L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_WTLS_SERVER_KEY_AND_MAC_DERIVE = 0x000003D4L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_WTLS_CLIENT_KEY_AND_MAC_DERIVE = 0x000003D5L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_TLS12_MASTER_KEY_DERIVE = 0x000003E0L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_TLS12_KEY_AND_MAC_DERIVE = 0x000003E1L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_TLS12_MASTER_KEY_DERIVE_DH = 0x000003E2L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_TLS12_KEY_SAFE_DERIVE = 0x000003E3L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_TLS12_MAC = 0x000003D8L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_TLS12_KDF = 0x000003D9L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_TLS_MAC = 0x000003E4L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_TLS_KDF = 0x000003E5L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_KEY_WRAP_LYNKS = 0x00000400L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_KEY_WRAP_SET_OAEP = 0x00000401L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CMS_SIG = 0x00000500L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_KIP_DERIVE = 0x00000510L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_KIP_WRAP = 0x00000511L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_KIP_MAC = 0x00000512L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SKIPJACK_KEY_GEN = 0x00001000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SKIPJACK_ECB64 = 0x00001001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SKIPJACK_CBC64 = 0x00001002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SKIPJACK_OFB64 = 0x00001003L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SKIPJACK_CFB64 = 0x00001004L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SKIPJACK_CFB32 = 0x00001005L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SKIPJACK_CFB16 = 0x00001006L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SKIPJACK_CFB8 = 0x00001007L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SKIPJACK_WRAP = 0x00001008L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SKIPJACK_PRIVATE_WRAP = 0x00001009L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SKIPJACK_RELAYX = 0x0000100AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_KEA_KEY_PAIR_GEN = 0x00001010L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_KEA_KEY_DERIVE = 0x00001011L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_FORTEZZA_TIMESTAMP = 0x00001020L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_BATON_KEY_GEN = 0x00001030L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_BATON_ECB128 = 0x00001031L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_BATON_ECB96 = 0x00001032L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_BATON_CBC128 = 0x00001033L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_BATON_COUNTER = 0x00001034L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_BATON_SHUFFLE = 0x00001035L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_BATON_WRAP = 0x00001036L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_ECDSA_KEY_PAIR_GEN = 0x00001040L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_EC_KEY_PAIR_GEN = 0x00001040L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_ECDSA = 0x00001041L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_ECDSA_SHA1 = 0x00001042L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_ECDSA_SHA224 = 0x00001043L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_ECDSA_SHA256 = 0x00001044L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_ECDSA_SHA384 = 0x00001045L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_ECDSA_SHA512 = 0x00001046L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_EC_KEY_PAIR_GEN_W_EXTRA_BITS = 0x0000140BL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_ECDH1_DERIVE = 0x00001050L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_ECDH1_COFACTOR_DERIVE = 0x00001051L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_ECMQV_DERIVE = 0x00001052L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_ECDH_AES_KEY_WRAP = 0x00001053L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RSA_AES_KEY_WRAP = 0x00001054L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_JUNIPER_KEY_GEN = 0x00001060L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_JUNIPER_ECB128 = 0x00001061L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_JUNIPER_CBC128 = 0x00001062L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_JUNIPER_COUNTER = 0x00001063L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_JUNIPER_SHUFFLE = 0x00001064L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_JUNIPER_WRAP = 0x00001065L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_FASTHASH = 0x00001070L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_AES_KEY_GEN = 0x00001080L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_AES_ECB = 0x00001081L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_AES_CBC = 0x00001082L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_AES_MAC = 0x00001083L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_AES_MAC_GENERAL = 0x00001084L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_AES_CBC_PAD = 0x00001085L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_AES_CTR = 0x00001086L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_AES_GCM = 0x00001087L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_AES_CCM = 0x00001088L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_AES_CTS = 0x00001089L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_AES_CMAC = 0x0000108AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_AES_CMAC_GENERAL = 0x0000108BL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_AES_XCBC_MAC = 0x0000108CL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_AES_XCBC_MAC_96 = 0x0000108DL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_BLOWFISH_KEY_GEN = 0x00001090L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_BLOWFISH_CBC = 0x00001091L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_TWOFISH_KEY_GEN = 0x00001092L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_TWOFISH_CBC = 0x00001093L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_BLOWFISH_CBC_PAD = 0x00001094L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_TWOFISH_CBC_PAD = 0x00001095L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAMELLIA_KEY_GEN = 0x00000550L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAMELLIA_ECB = 0x00000551L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAMELLIA_CBC = 0x00000552L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAMELLIA_MAC = 0x00000553L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAMELLIA_MAC_GENERAL = 0x00000554L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAMELLIA_CBC_PAD = 0x00000555L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAMELLIA_ECB_ENCRYPT_DATA = 0x00000556L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CAMELLIA_CBC_ENCRYPT_DATA = 0x00000557L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_ARIA_KEY_GEN = 0x00000560L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_ARIA_ECB = 0x00000561L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_ARIA_CBC = 0x00000562L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_ARIA_MAC = 0x00000563L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_ARIA_MAC_GENERAL = 0x00000564L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_ARIA_CBC_PAD = 0x00000565L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_ARIA_ECB_ENCRYPT_DATA = 0x00000566L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_ARIA_CBC_ENCRYPT_DATA = 0x00000567L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SEED_KEY_GEN = 0x00000650L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SEED_ECB = 0x00000651L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SEED_CBC = 0x00000652L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SEED_MAC = 0x00000653L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SEED_MAC_GENERAL = 0x00000654L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SEED_CBC_PAD = 0x00000655L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SEED_ECB_ENCRYPT_DATA = 0x00000656L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SEED_CBC_ENCRYPT_DATA = 0x00000657L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_ECDSA_SHA3_224 = 0x00001047L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_ECDSA_SHA3_256 = 0x00001048L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_ECDSA_SHA3_384 = 0x00001049L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_ECDSA_SHA3_512 = 0x0000104AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_EC_EDWARDS_KEY_PAIR_GEN = 0x00001055L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_EC_MONTGOMERY_KEY_PAIR_GEN = 0x00001056L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_EDDSA = 0x00001057L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DES_ECB_ENCRYPT_DATA = 0x00001100L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DES_CBC_ENCRYPT_DATA = 0x00001101L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DES3_ECB_ENCRYPT_DATA = 0x00001102L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DES3_CBC_ENCRYPT_DATA = 0x00001103L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_AES_ECB_ENCRYPT_DATA = 0x00001104L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_AES_CBC_ENCRYPT_DATA = 0x00001105L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_GOSTR3410_KEY_PAIR_GEN = 0x00001200L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_GOSTR3410 = 0x00001201L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_GOSTR3410_WITH_GOSTR3411 = 0x00001202L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_GOSTR3410_KEY_WRAP = 0x00001203L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_GOSTR3410_DERIVE = 0x00001204L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_GOSTR3411 = 0x00001210L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_GOSTR3411_HMAC = 0x00001211L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_GOST28147_KEY_GEN = 0x00001220L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_GOST28147_ECB = 0x00001221L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_GOST28147 = 0x00001222L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_GOST28147_MAC = 0x00001223L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_GOST28147_KEY_WRAP = 0x00001224L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CHACHA20_KEY_GEN = 0x00001225L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CHACHA20 = 0x00001226L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_POLY1305_KEY_GEN = 0x00001227L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_POLY1305 = 0x00001228L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DSA_PARAMETER_GEN = 0x00002000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DH_PKCS_PARAMETER_GEN = 0x00002001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_X9_42_DH_PARAMETER_GEN = 0x00002002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DSA_PROBABILISTIC_PARAMETER_GEN = 0x00002003L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DSA_SHAWE_TAYLOR_PARAMETER_GEN = 0x00002004L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_DSA_FIPS_G_GEN = 0x00002005L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_AES_CFB1 = 0x00002108L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_AES_KEY_WRAP = 0x00002109L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_AES_KEY_WRAP_PAD = 0x0000210AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_AES_KEY_WRAP_KWP = 0x0000210BL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SP800_108_COUNTER_KDF = 0x000003ACL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SP800_108_FEEDBACK_KDF = 0x000003ADL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SP800_108_DOUBLE_PIPELINE_KDF = 0x000003AEL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RSA_PKCS_TPM_1_1 = 0x00004001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_RSA_PKCS_OAEP_TPM_1_1 = 0x00004002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA_1_KEY_GEN = 0x00004003L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA224_KEY_GEN = 0x00004004L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA256_KEY_GEN = 0x00004005L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA384_KEY_GEN = 0x00004006L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA512_KEY_GEN = 0x00004007L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA512_224_KEY_GEN = 0x00004008L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA512_256_KEY_GEN = 0x00004009L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SHA512_T_KEY_GEN = 0x0000400AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_NULL = 0x0000400BL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_BLAKE2B_160 = 0x0000400CL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_BLAKE2B_160_HMAC = 0x0000400DL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_BLAKE2B_160_HMAC_GENERAL = 0x0000400EL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_BLAKE2B_160_KEY_DERIVE = 0x0000400FL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_BLAKE2B_160_KEY_GEN = 0x00004010L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_BLAKE2B_256 = 0x00004011L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_BLAKE2B_256_HMAC = 0x00004012L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_BLAKE2B_256_HMAC_GENERAL = 0x00004013L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_BLAKE2B_256_KEY_DERIVE = 0x00004014L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_BLAKE2B_256_KEY_GEN = 0x00004015L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_BLAKE2B_384 = 0x00004016L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_BLAKE2B_384_HMAC = 0x00004017L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_BLAKE2B_384_HMAC_GENERAL = 0x00004018L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_BLAKE2B_384_KEY_DERIVE = 0x00004019L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_BLAKE2B_384_KEY_GEN = 0x0000401AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_BLAKE2B_512 = 0x0000401BL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_BLAKE2B_512_HMAC = 0x0000401CL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_BLAKE2B_512_HMAC_GENERAL = 0x0000401DL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_BLAKE2B_512_KEY_DERIVE = 0x0000401EL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_BLAKE2B_512_KEY_GEN = 0x0000401FL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SALSA20 = 0x00004020L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_CHACHA20_POLY1305 = 0x00004021L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SALSA20_POLY1305 = 0x00004022L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_X3DH_INITIALIZE = 0x00004023L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_X3DH_RESPOND = 0x00004024L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_X2RATCHET_INITIALIZE = 0x00004025L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_X2RATCHET_RESPOND = 0x00004026L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_X2RATCHET_ENCRYPT = 0x00004027L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_X2RATCHET_DECRYPT = 0x00004028L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_XEDDSA = 0x00004029L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_HKDF_DERIVE = 0x0000402AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_HKDF_DATA = 0x0000402BL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_HKDF_KEY_GEN = 0x0000402CL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_SALSA20_KEY_GEN = 0x0000402DL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKM_VENDOR_DEFINED = 0x80000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_HW = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_MESSAGE_ENCRYPT = 0x00000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_MESSAGE_DECRYPT = 0x00000004L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_MESSAGE_SIGN = 0x00000008L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_MESSAGE_VERIFY = 0x00000010L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_MULTI_MESSAGE = 0x00000020L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_FIND_OBJECTS = 0x00000040L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_ENCRYPT = 0x00000100L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_DECRYPT = 0x00000200L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_DIGEST = 0x00000400L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_SIGN = 0x00000800L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_SIGN_RECOVER = 0x00001000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_VERIFY = 0x00002000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_VERIFY_RECOVER = 0x00004000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_GENERATE = 0x00008000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_GENERATE_KEY_PAIR = 0x00010000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_WRAP = 0x00020000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_UNWRAP = 0x00040000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_DERIVE = 0x00080000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_EC_F_P = 0x00100000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_EC_F_2M = 0x00200000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_EC_ECPARAMETERS = 0x00400000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_EC_OID = 0x00800000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_EC_NAMEDCURVE = 0x00800000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_EC_UNCOMPRESS = 0x01000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_EC_COMPRESS = 0x02000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_EXTENSION = 0x80000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_OK = 0x00000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_CANCEL = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_HOST_MEMORY = 0x00000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_SLOT_ID_INVALID = 0x00000003L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_GENERAL_ERROR = 0x00000005L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_FUNCTION_FAILED = 0x00000006L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_ARGUMENTS_BAD = 0x00000007L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_NO_EVENT = 0x00000008L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_NEED_TO_CREATE_THREADS = 0x00000009L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_CANT_LOCK = 0x0000000AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_ATTRIBUTE_READ_ONLY = 0x00000010L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_ATTRIBUTE_SENSITIVE = 0x00000011L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_ATTRIBUTE_TYPE_INVALID = 0x00000012L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_ATTRIBUTE_VALUE_INVALID = 0x00000013L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_ACTION_PROHIBITED = 0x0000001BL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_DATA_INVALID = 0x00000020L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_DATA_LEN_RANGE = 0x00000021L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_DEVICE_ERROR = 0x00000030L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_DEVICE_MEMORY = 0x00000031L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_DEVICE_REMOVED = 0x00000032L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_ENCRYPTED_DATA_INVALID = 0x00000040L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_ENCRYPTED_DATA_LEN_RANGE = 0x00000041L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_FUNCTION_CANCELED = 0x00000050L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_FUNCTION_NOT_PARALLEL = 0x00000051L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_FUNCTION_NOT_SUPPORTED = 0x00000054L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_KEY_HANDLE_INVALID = 0x00000060L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_KEY_SIZE_RANGE = 0x00000062L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_KEY_TYPE_INCONSISTENT = 0x00000063L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_KEY_NOT_NEEDED = 0x00000064L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_KEY_CHANGED = 0x00000065L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_KEY_NEEDED = 0x00000066L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_KEY_INDIGESTIBLE = 0x00000067L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_KEY_FUNCTION_NOT_PERMITTED = 0x00000068L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_KEY_NOT_WRAPPABLE = 0x00000069L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_KEY_UNEXTRACTABLE = 0x0000006AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_MECHANISM_INVALID = 0x00000070L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_MECHANISM_PARAM_INVALID = 0x00000071L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_OBJECT_HANDLE_INVALID = 0x00000082L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_OPERATION_ACTIVE = 0x00000090L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_OPERATION_NOT_INITIALIZED = 0x00000091L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_PIN_INCORRECT = 0x000000A0L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_PIN_INVALID = 0x000000A1L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_PIN_LEN_RANGE = 0x000000A2L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_PIN_EXPIRED = 0x000000A3L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_PIN_LOCKED = 0x000000A4L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_SESSION_CLOSED = 0x000000B0L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_SESSION_COUNT = 0x000000B1L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_SESSION_HANDLE_INVALID = 0x000000B3L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_SESSION_PARALLEL_NOT_SUPPORTED = 0x000000B4L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_SESSION_READ_ONLY = 0x000000B5L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_SESSION_EXISTS = 0x000000B6L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_SESSION_READ_ONLY_EXISTS = 0x000000B7L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_SESSION_READ_WRITE_SO_EXISTS = 0x000000B8L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_SIGNATURE_INVALID = 0x000000C0L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_SIGNATURE_LEN_RANGE = 0x000000C1L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_TEMPLATE_INCOMPLETE = 0x000000D0L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_TEMPLATE_INCONSISTENT = 0x000000D1L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_TOKEN_NOT_PRESENT = 0x000000E0L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_TOKEN_NOT_RECOGNIZED = 0x000000E1L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_TOKEN_WRITE_PROTECTED = 0x000000E2L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_UNWRAPPING_KEY_HANDLE_INVALID = 0x000000F0L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_UNWRAPPING_KEY_SIZE_RANGE = 0x000000F1L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_UNWRAPPING_KEY_TYPE_INCONSISTENT = 0x000000F2L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_USER_ALREADY_LOGGED_IN = 0x00000100L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_USER_NOT_LOGGED_IN = 0x00000101L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_USER_PIN_NOT_INITIALIZED = 0x00000102L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_USER_TYPE_INVALID = 0x00000103L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_USER_ANOTHER_ALREADY_LOGGED_IN = 0x00000104L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_USER_TOO_MANY_TYPES = 0x00000105L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_WRAPPED_KEY_INVALID = 0x00000110L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_WRAPPED_KEY_LEN_RANGE = 0x00000112L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_WRAPPING_KEY_HANDLE_INVALID = 0x00000113L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_WRAPPING_KEY_SIZE_RANGE = 0x00000114L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_WRAPPING_KEY_TYPE_INCONSISTENT = 0x00000115L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_RANDOM_SEED_NOT_SUPPORTED = 0x00000120L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_RANDOM_NO_RNG = 0x00000121L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_DOMAIN_PARAMS_INVALID = 0x00000130L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_CURVE_NOT_SUPPORTED = 0x00000140L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_BUFFER_TOO_SMALL = 0x00000150L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_SAVED_STATE_INVALID = 0x00000160L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_INFORMATION_SENSITIVE = 0x00000170L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_STATE_UNSAVEABLE = 0x00000180L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_CRYPTOKI_NOT_INITIALIZED = 0x00000190L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_CRYPTOKI_ALREADY_INITIALIZED = 0x00000191L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_MUTEX_BAD = 0x000001A0L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_MUTEX_NOT_LOCKED = 0x000001A1L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_NEW_PIN_MODE = 0x000001B0L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_NEXT_OTP = 0x000001B1L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_EXCEEDED_MAX_ITERATIONS = 0x000001B5L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_FIPS_SELF_TEST_FAILED = 0x000001B6L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_LIBRARY_LOAD_FAILED = 0x000001B7L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_PIN_TOO_WEAK = 0x000001B8L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_PUBLIC_KEY_INVALID = 0x000001B9L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_FUNCTION_REJECTED = 0x00000200L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_TOKEN_RESOURCE_EXCEEDED = 0x00000201L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_OPERATION_CANCEL_FAILED = 0x00000202L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKR_VENDOR_DEFINED = 0x80000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_END_OF_MESSAGE = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_INTERFACE_FORK_SAFE = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_LIBRARY_CANT_CREATE_OS_THREADS = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_OS_LOCKING_OK = 0x00000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_DONT_BLOCK = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKG_MGF1_SHA1 = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKG_MGF1_SHA256 = 0x00000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKG_MGF1_SHA384 = 0x00000003L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKG_MGF1_SHA512 = 0x00000004L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKG_MGF1_SHA224 = 0x00000005L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKG_MGF1_SHA3_224 = 0x00000006L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKG_MGF1_SHA3_256 = 0x00000007L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKG_MGF1_SHA3_384 = 0x00000008L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKG_MGF1_SHA3_512 = 0x00000009L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKZ_DATA_SPECIFIED = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKD_NULL = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKD_SHA1_KDF = 0x00000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKD_SHA224_KDF = 0x00000005L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKD_SHA256_KDF = 0x00000006L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKD_SHA384_KDF = 0x00000007L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKD_SHA512_KDF = 0x00000008L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKD_CPDIVERSIFY_KDF = 0x00000009L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKD_SHA3_224_KDF = 0x0000000AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKD_SHA3_256_KDF = 0x0000000BL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKD_SHA3_384_KDF = 0x0000000CL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKD_SHA3_512_KDF = 0x0000000DL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKD_SHA1_KDF_SP800 = 0x0000000EL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKD_SHA224_KDF_SP800 = 0x0000000FL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKD_SHA256_KDF_SP800 = 0x00000010L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKD_SHA384_KDF_SP800 = 0x00000011L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKD_SHA512_KDF_SP800 = 0x00000012L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKD_SHA3_224_KDF_SP800 = 0x00000013L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKD_SHA3_256_KDF_SP800 = 0x00000014L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKD_SHA3_384_KDF_SP800 = 0x00000015L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKD_SHA3_512_KDF_SP800 = 0x00000016L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKD_BLAKE2B_160_KDF = 0x00000017L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKD_BLAKE2B_256_KDF = 0x00000018L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKD_BLAKE2B_384_KDF = 0x00000019L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKD_BLAKE2B_512_KDF = 0x0000001AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKD_SHA1_KDF_ASN1 = 0x00000003L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKD_SHA1_KDF_CONCATENATE = 0x00000004L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKG_NO_GENERATE = 0x00000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKG_GENERATE = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKG_GENERATE_COUNTER = 0x00000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKG_GENERATE_RANDOM = 0x00000003L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKG_GENERATE_COUNTER_XOR = 0x00000004L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_HKDF_SALT_NULL = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_HKDF_SALT_DATA = 0x00000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_HKDF_SALT_KEY = 0x00000004L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_SP800_108_ITERATION_VARIABLE = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_SP800_108_OPTIONAL_COUNTER = 0x00000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_SP800_108_DKM_LENGTH = 0x00000003L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_SP800_108_BYTE_ARRAY = 0x00000004L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_SP800_108_COUNTER = 0x00000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_SP800_108_DKM_LENGTH_SUM_OF_KEYS = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_SP800_108_DKM_LENGTH_SUM_OF_SEGMENTS = 0x00000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKP_PKCS5_PBKD2_HMAC_SHA1 = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKP_PKCS5_PBKD2_HMAC_GOSTR3411 = 0x00000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKP_PKCS5_PBKD2_HMAC_SHA224 = 0x00000003L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKP_PKCS5_PBKD2_HMAC_SHA256 = 0x00000004L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKP_PKCS5_PBKD2_HMAC_SHA384 = 0x00000005L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKP_PKCS5_PBKD2_HMAC_SHA512 = 0x00000006L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKP_PKCS5_PBKD2_HMAC_SHA512_224 = 0x00000007L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKP_PKCS5_PBKD2_HMAC_SHA512_256 = 0x00000008L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKZ_SALT_SPECIFIED = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_OTP_VALUE = 0x00000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_OTP_PIN = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_OTP_CHALLENGE = 0x00000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_OTP_TIME = 0x00000003L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_OTP_COUNTER = 0x00000004L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_OTP_FLAGS = 0x00000005L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_OTP_OUTPUT_LENGTH = 0x00000006L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CK_OTP_OUTPUT_FORMAT = 0x00000007L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_NEXT_OTP = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_EXCLUDE_TIME = 0x00000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_EXCLUDE_COUNTER = 0x00000004L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_EXCLUDE_CHALLENGE = 0x00000008L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_EXCLUDE_PIN = 0x00000010L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKF_USER_FRIENDLY_OTP = 0x00000020L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11t.h
     */
    public static final long CKK_INVALID_KEY_TYPE = 0xFFFFFFFFL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long NSSCK_VENDOR_NSS = 0x4E534350L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKO_NSS = 0xCE534350L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKO_NSS_CRL = 0xCE534351L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKO_NSS_SMIME = 0xCE534352L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKO_NSS_TRUST = 0xCE534353L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKO_NSS_BUILTIN_ROOT_LIST = 0xCE534354L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKO_NSS_NEWSLOT = 0xCE534355L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKO_NSS_DELSLOT = 0xCE534356L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKO_NSS_VALIDATION = 0xCE534357L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKK_NSS = 0xCE534350L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKK_NSS_PKCS8 = 0xCE534351L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKK_NSS_JPAKE_ROUND1 = 0xCE534352L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKK_NSS_JPAKE_ROUND2 = 0xCE534353L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKK_NSS_CHACHA20 = 0xCE534354L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKC_NSS = 0xCE534350L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_DIGEST = 0x81000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_MESSAGE = 0x82000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_MESSAGE_MASK = 0xFF000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_FLAGS_ONLY = 0x00000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS = 0xCE534350L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_URL = 0xCE534351L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_EMAIL = 0xCE534352L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_SMIME_INFO = 0xCE534353L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_SMIME_TIMESTAMP = 0xCE534354L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_PKCS8_SALT = 0xCE534355L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_PASSWORD_CHECK = 0xCE534356L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_EXPIRES = 0xCE534357L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_KRL = 0xCE534358L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_PQG_COUNTER = 0xCE534364L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_PQG_SEED = 0xCE534365L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_PQG_H = 0xCE534366L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_PQG_SEED_BITS = 0xCE534367L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_MODULE_SPEC = 0xCE534368L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_OVERRIDE_EXTENSIONS = 0xCE534369L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_JPAKE_SIGNERID = 0xCE53436AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_JPAKE_PEERID = 0xCE53436BL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_JPAKE_GX1 = 0xCE53436CL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_JPAKE_GX2 = 0xCE53436DL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_JPAKE_GX3 = 0xCE53436EL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_JPAKE_GX4 = 0xCE53436FL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_JPAKE_X2 = 0xCE534370L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_JPAKE_X2S = 0xCE534371L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_MOZILLA_CA_POLICY = 0xCE534372L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_SERVER_DISTRUST_AFTER = 0xCE534373L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_EMAIL_DISTRUST_AFTER = 0xCE534374L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_VALIDATION_TYPE = 0xCE534374L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_VALIDATION_VERSION = 0xCE534375L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_VALIDATION_LEVEL = 0xCE534376L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_VALIDATION_MODULE_ID = 0xCE534377L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_TRUST = 0xCE536350L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_TRUST_DIGITAL_SIGNATURE = 0xCE536351L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_TRUST_NON_REPUDIATION = 0xCE536352L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_TRUST_KEY_ENCIPHERMENT = 0xCE536353L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_TRUST_DATA_ENCIPHERMENT = 0xCE536354L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_TRUST_KEY_AGREEMENT = 0xCE536355L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_TRUST_KEY_CERT_SIGN = 0xCE536356L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_TRUST_CRL_SIGN = 0xCE536357L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_TRUST_SERVER_AUTH = 0xCE536358L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_TRUST_CLIENT_AUTH = 0xCE536359L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_TRUST_CODE_SIGNING = 0xCE53635AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_TRUST_EMAIL_PROTECTION = 0xCE53635BL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_TRUST_IPSEC_END_SYSTEM = 0xCE53635CL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_TRUST_IPSEC_TUNNEL = 0xCE53635DL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_TRUST_IPSEC_USER = 0xCE53635EL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_TRUST_TIME_STAMPING = 0xCE53635FL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_TRUST_STEP_UP_APPROVED = 0xCE536360L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_CERT_SHA1_HASH = 0xCE5363B4L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_CERT_MD5_HASH = 0xCE5363B5L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_DB = 0xD5A0DB00L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NSS_TRUST = 0x80000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_FAKE_RANDOM = 0x80000EFEL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_INVALID_MECHANISM = 0xFFFFFFFFL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKT_INVALID_TYPE = 0xFFFFFFFFL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS = 0xCE534350L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_AES_KEY_WRAP = 0xCE534351L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_AES_KEY_WRAP_PAD = 0xCE534352L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_HKDF_SHA1 = 0xCE534353L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_HKDF_SHA256 = 0xCE534354L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_HKDF_SHA384 = 0xCE534355L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_HKDF_SHA512 = 0xCE534356L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_JPAKE_ROUND1_SHA1 = 0xCE534357L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_JPAKE_ROUND1_SHA256 = 0xCE534358L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_JPAKE_ROUND1_SHA384 = 0xCE534359L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_JPAKE_ROUND1_SHA512 = 0xCE53435AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_JPAKE_ROUND2_SHA1 = 0xCE53435BL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_JPAKE_ROUND2_SHA256 = 0xCE53435CL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_JPAKE_ROUND2_SHA384 = 0xCE53435DL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_JPAKE_ROUND2_SHA512 = 0xCE53435EL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_JPAKE_FINAL_SHA1 = 0xCE53435FL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_JPAKE_FINAL_SHA256 = 0xCE534360L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_JPAKE_FINAL_SHA384 = 0xCE534361L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_JPAKE_FINAL_SHA512 = 0xCE534362L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_HMAC_CONSTANT_TIME = 0xCE534363L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_SSL3_MAC_CONSTANT_TIME = 0xCE534364L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_TLS_PRF_GENERAL_SHA256 = 0xCE534365L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_TLS_MASTER_KEY_DERIVE_SHA256 = 0xCE534366L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_TLS_KEY_AND_MAC_DERIVE_SHA256 = 0xCE534367L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_TLS_MASTER_KEY_DERIVE_DH_SHA256 = 0xCE534368L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_TLS_EXTENDED_MASTER_KEY_DERIVE = 0xCE534369L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_TLS_EXTENDED_MASTER_KEY_DERIVE_DH = 0xCE53436AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_CHACHA20_KEY_GEN = 0xCE53436BL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_CHACHA20_POLY1305 = 0xCE53436CL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_PKCS12_PBE_SHA224_HMAC_KEY_GEN = 0xCE53436DL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_PKCS12_PBE_SHA256_HMAC_KEY_GEN = 0xCE53436EL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_PKCS12_PBE_SHA384_HMAC_KEY_GEN = 0xCE53436FL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_PKCS12_PBE_SHA512_HMAC_KEY_GEN = 0xCE534370L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_CHACHA20_CTR = 0xCE534371L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_IKE_PRF_PLUS_DERIVE = 0xCE534372L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_IKE_PRF_DERIVE = 0xCE534373L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_IKE1_PRF_DERIVE = 0xCE534374L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_IKE1_APP_B_PRF_DERIVE = 0xCE534375L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_PUB_FROM_PRIV = 0xCE534378L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_SP800_108_COUNTER_KDF_DERIVE_DATA = 0xCE53437AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_SP800_108_FEEDBACK_KDF_DERIVE_DATA = 0xCE53437BL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_SP800_108_DOUBLE_PIPELINE_KDF_DERIVE_DATA = 0xCE53437CL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_PBE_SHA1_DES_CBC = 0x80000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_PBE_SHA1_TRIPLE_DES_CBC = 0x80000003L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_PBE_SHA1_40_BIT_RC2_CBC = 0x80000004L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_PBE_SHA1_128_BIT_RC2_CBC = 0x80000005L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_PBE_SHA1_40_BIT_RC4 = 0x80000006L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_PBE_SHA1_128_BIT_RC4 = 0x80000007L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_PBE_SHA1_FAULTY_3DES_CBC = 0x80000008L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_PBE_SHA1_HMAC_KEY_GEN = 0x80000009L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_PBE_MD5_HMAC_KEY_GEN = 0x8000000AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NSS_PBE_MD2_HMAC_KEY_GEN = 0x8000000BL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_TLS_PRF_GENERAL = 0x80000373L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKS_NSS_UNINITIALIZED = 0xFFFFFFFFL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKS_NSS_FIPS_NOT_OK = 0x00000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKS_NSS_FIPS_OK = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKT_NSS_SESSION_CHECK = 0x00000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKT_NSS_OBJECT_CHECK = 0x00000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKT_NSS_BOTH_CHECK = 0x00000003L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKT_NSS_SESSION_LAST_CHECK = 0x00000004L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKR_NSS = 0xCE534350L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKR_NSS_CERTDB_FAILED = 0xCE534351L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKR_NSS_KEYDB_FAILED = 0xCE534352L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKT_VENDOR_DEFINED = 0x80000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKT_NSS = 0xCE534350L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKT_NSS_TRUSTED = 0xCE534351L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKT_NSS_TRUSTED_DELEGATOR = 0xCE534352L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKT_NSS_MUST_VERIFY_TRUST = 0xCE534353L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKT_NSS_NOT_TRUSTED = 0xCE53435AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKT_NSS_TRUST_UNKNOWN = 0xCE534355L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKT_NSS_VALID_DELEGATOR = 0xCE53435BL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKT_NSS_UNTRUSTED = 0xCE534353L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKT_NSS_VALID = 0xCE53435AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKT_NSS_MUST_VERIFY = 0xCE534354L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long SFTK_MIN_USER_SLOT_ID = 0x00000004L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long SFTK_MAX_USER_SLOT_ID = 0x00000064L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long SFTK_MIN_FIPS_USER_SLOT_ID = 0x00000065L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long SFTK_MAX_FIPS_USER_SLOT_ID = 0x0000007FL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKF_EC_FP = 0x00100000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKO_KG_PARAMETERS = 0x00000006L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CK_INVALID_SESSION = 0x00000000L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKR_KEY_PARAMS_INVALID = 0x0000006BL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKO_NETSCAPE_CRL = 0xCE534351L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKO_NETSCAPE_SMIME = 0xCE534352L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKO_NETSCAPE_TRUST = 0xCE534353L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKO_NETSCAPE_BUILTIN_ROOT_LIST = 0xCE534354L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKO_NETSCAPE_NEWSLOT = 0xCE534355L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKO_NETSCAPE_DELSLOT = 0xCE534356L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKK_NETSCAPE_PKCS8 = 0xCE534351L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NETSCAPE_URL = 0xCE534351L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NETSCAPE_EMAIL = 0xCE534352L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NETSCAPE_SMIME_INFO = 0xCE534353L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NETSCAPE_SMIME_TIMESTAMP = 0xCE534354L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NETSCAPE_PKCS8_SALT = 0xCE534355L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NETSCAPE_PASSWORD_CHECK = 0xCE534356L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NETSCAPE_EXPIRES = 0xCE534357L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NETSCAPE_KRL = 0xCE534358L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NETSCAPE_PQG_COUNTER = 0xCE534364L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NETSCAPE_PQG_SEED = 0xCE534365L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NETSCAPE_PQG_H = 0xCE534366L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NETSCAPE_PQG_SEED_BITS = 0xCE534367L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NETSCAPE_MODULE_SPEC = 0xCE534368L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NETSCAPE_DB = 0xD5A0DB00L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKA_NETSCAPE_TRUST = 0x80000001L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NETSCAPE_AES_KEY_WRAP = 0xCE534351L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NETSCAPE_AES_KEY_WRAP_PAD = 0xCE534352L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NETSCAPE_PBE_SHA1_DES_CBC = 0x80000002L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NETSCAPE_PBE_SHA1_TRIPLE_DES_CBC = 0x80000003L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NETSCAPE_PBE_SHA1_40_BIT_RC2_CBC = 0x80000004L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NETSCAPE_PBE_SHA1_128_BIT_RC2_CBC = 0x80000005L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NETSCAPE_PBE_SHA1_40_BIT_RC4 = 0x80000006L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NETSCAPE_PBE_SHA1_128_BIT_RC4 = 0x80000007L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NETSCAPE_PBE_SHA1_FAULTY_3DES_CBC = 0x80000008L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NETSCAPE_PBE_SHA1_HMAC_KEY_GEN = 0x80000009L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NETSCAPE_PBE_MD5_HMAC_KEY_GEN = 0x8000000AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKM_NETSCAPE_PBE_MD2_HMAC_KEY_GEN = 0x8000000BL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKR_NETSCAPE_CERTDB_FAILED = 0xCE534351L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKR_NETSCAPE_KEYDB_FAILED = 0xCE534352L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKT_NETSCAPE_TRUSTED = 0xCE534351L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKT_NETSCAPE_TRUSTED_DELEGATOR = 0xCE534352L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKT_NETSCAPE_UNTRUSTED = 0xCE534353L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKT_NETSCAPE_MUST_VERIFY = 0xCE534354L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKT_NETSCAPE_TRUST_UNKNOWN = 0xCE534355L;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKT_NETSCAPE_VALID = 0xCE53435AL;

    /**
     * Content automatically generated; see NSS documentation for more information.
     *
     * Source file: /usr/include/nss3/pkcs11n.h
     */
    public static final long CKT_NETSCAPE_VALID_DELEGATOR = 0xCE53435BL;
}
