/*
 * J784S4 Clocks Info
 *
 * Copyright (C) 2022 Texas Instruments Incorporated - https://www.ti.com/
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <tisci.h>
#include <socinfo.h>

struct ti_sci_clocks_info j784s4_clocks_info[] = {
	{198, 0, "DEV_A72SS0_ARM0_CLK_CLK", "Input clock"},
	{198, 2, "DEV_A72SS0_ARM0_DIVH_CLK8_OBSCLK_OUT_CLK", "Output clock"},
	{198, 3, "DEV_A72SS0_ARM0_MSMC_CLK_CLK", "Input clock"},
	{198, 4, "DEV_A72SS0_ARM0_PLL_CTRL_CLK_CLK", "Input clock"},
	{202, 0, "DEV_A72SS0_CORE0_ARM0_CLK_CLK", "Input clock"},
	{203, 0, "DEV_A72SS0_CORE1_ARM0_CLK_CLK", "Input clock"},
	{204, 0, "DEV_A72SS0_CORE2_ARM0_CLK_CLK", "Input clock"},
	{205, 0, "DEV_A72SS0_CORE3_ARM0_CLK_CLK", "Input clock"},
	{200, 0, "DEV_A72SS1_ARM1_CLK_CLK", "Input clock"},
	{200, 2, "DEV_A72SS1_ARM1_DIVH_CLK8_OBSCLK_OUT_CLK", "Output clock"},
	{200, 6, "DEV_A72SS1_ARM1_PLL_CTRL_CLK_CLK", "Input clock"},
	{206, 0, "DEV_A72SS1_CORE0_ARM1_CLK_CLK", "Input clock"},
	{207, 0, "DEV_A72SS1_CORE1_ARM1_CLK_CLK", "Input clock"},
	{208, 0, "DEV_A72SS1_CORE2_ARM1_CLK_CLK", "Input clock"},
	{209, 0, "DEV_A72SS1_CORE3_ARM1_CLK_CLK", "Input clock"},
	{186, 0, "DEV_AGGR_ATB0_DBG_CLK", "Input clock"},
	{2, 0, "DEV_ATL0_ATL_CLK", "Input muxed clock"},
	{2, 1, "DEV_ATL0_ATL_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT1_CLK", "Parent input clock option to DEV_ATL0_ATL_CLK"},
	{2, 2, "DEV_ATL0_ATL_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_ATL0_ATL_CLK"},
	{2, 5, "DEV_ATL0_ATL_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT7_CLK", "Parent input clock option to DEV_ATL0_ATL_CLK"},
	{2, 6, "DEV_ATL0_ATL_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_ATL0_ATL_CLK"},
	{2, 7, "DEV_ATL0_ATL_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_ATL0_ATL_CLK"},
	{2, 9, "DEV_ATL0_ATL_IO_PORT_ATCLK_OUT", "Output clock"},
	{2, 10, "DEV_ATL0_ATL_IO_PORT_ATCLK_OUT_1", "Output clock"},
	{2, 11, "DEV_ATL0_ATL_IO_PORT_ATCLK_OUT_2", "Output clock"},
	{2, 12, "DEV_ATL0_ATL_IO_PORT_ATCLK_OUT_3", "Output clock"},
	{2, 13, "DEV_ATL0_ATL_IO_PORT_AWS", "Input muxed clock"},
	{2, 14, "DEV_ATL0_ATL_IO_PORT_AWS_PARENT_MCASP_MAIN_0_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS"},
	{2, 15, "DEV_ATL0_ATL_IO_PORT_AWS_PARENT_MCASP_MAIN_1_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS"},
	{2, 16, "DEV_ATL0_ATL_IO_PORT_AWS_PARENT_MCASP_MAIN_2_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS"},
	{2, 17, "DEV_ATL0_ATL_IO_PORT_AWS_PARENT_MCASP_MAIN_3_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS"},
	{2, 18, "DEV_ATL0_ATL_IO_PORT_AWS_PARENT_MCASP_MAIN_4_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS"},
	{2, 26, "DEV_ATL0_ATL_IO_PORT_AWS_PARENT_MCASP_MAIN_0_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS"},
	{2, 27, "DEV_ATL0_ATL_IO_PORT_AWS_PARENT_MCASP_MAIN_1_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS"},
	{2, 28, "DEV_ATL0_ATL_IO_PORT_AWS_PARENT_MCASP_MAIN_2_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS"},
	{2, 29, "DEV_ATL0_ATL_IO_PORT_AWS_PARENT_MCASP_MAIN_3_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS"},
	{2, 30, "DEV_ATL0_ATL_IO_PORT_AWS_PARENT_MCASP_MAIN_4_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS"},
	{2, 38, "DEV_ATL0_ATL_IO_PORT_AWS_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS"},
	{2, 39, "DEV_ATL0_ATL_IO_PORT_AWS_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS"},
	{2, 46, "DEV_ATL0_ATL_IO_PORT_AWS_1", "Input muxed clock"},
	{2, 47, "DEV_ATL0_ATL_IO_PORT_AWS_1_PARENT_MCASP_MAIN_0_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_1"},
	{2, 48, "DEV_ATL0_ATL_IO_PORT_AWS_1_PARENT_MCASP_MAIN_1_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_1"},
	{2, 49, "DEV_ATL0_ATL_IO_PORT_AWS_1_PARENT_MCASP_MAIN_2_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_1"},
	{2, 50, "DEV_ATL0_ATL_IO_PORT_AWS_1_PARENT_MCASP_MAIN_3_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_1"},
	{2, 51, "DEV_ATL0_ATL_IO_PORT_AWS_1_PARENT_MCASP_MAIN_4_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_1"},
	{2, 59, "DEV_ATL0_ATL_IO_PORT_AWS_1_PARENT_MCASP_MAIN_0_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_1"},
	{2, 60, "DEV_ATL0_ATL_IO_PORT_AWS_1_PARENT_MCASP_MAIN_1_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_1"},
	{2, 61, "DEV_ATL0_ATL_IO_PORT_AWS_1_PARENT_MCASP_MAIN_2_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_1"},
	{2, 62, "DEV_ATL0_ATL_IO_PORT_AWS_1_PARENT_MCASP_MAIN_3_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_1"},
	{2, 63, "DEV_ATL0_ATL_IO_PORT_AWS_1_PARENT_MCASP_MAIN_4_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_1"},
	{2, 71, "DEV_ATL0_ATL_IO_PORT_AWS_1_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_1"},
	{2, 72, "DEV_ATL0_ATL_IO_PORT_AWS_1_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_1"},
	{2, 85, "DEV_ATL0_ATL_IO_PORT_AWS_2", "Input muxed clock"},
	{2, 86, "DEV_ATL0_ATL_IO_PORT_AWS_2_PARENT_MCASP_MAIN_0_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_2"},
	{2, 87, "DEV_ATL0_ATL_IO_PORT_AWS_2_PARENT_MCASP_MAIN_1_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_2"},
	{2, 88, "DEV_ATL0_ATL_IO_PORT_AWS_2_PARENT_MCASP_MAIN_2_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_2"},
	{2, 89, "DEV_ATL0_ATL_IO_PORT_AWS_2_PARENT_MCASP_MAIN_3_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_2"},
	{2, 90, "DEV_ATL0_ATL_IO_PORT_AWS_2_PARENT_MCASP_MAIN_4_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_2"},
	{2, 98, "DEV_ATL0_ATL_IO_PORT_AWS_2_PARENT_MCASP_MAIN_0_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_2"},
	{2, 99, "DEV_ATL0_ATL_IO_PORT_AWS_2_PARENT_MCASP_MAIN_1_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_2"},
	{2, 100, "DEV_ATL0_ATL_IO_PORT_AWS_2_PARENT_MCASP_MAIN_2_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_2"},
	{2, 101, "DEV_ATL0_ATL_IO_PORT_AWS_2_PARENT_MCASP_MAIN_3_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_2"},
	{2, 102, "DEV_ATL0_ATL_IO_PORT_AWS_2_PARENT_MCASP_MAIN_4_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_2"},
	{2, 110, "DEV_ATL0_ATL_IO_PORT_AWS_2_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_2"},
	{2, 111, "DEV_ATL0_ATL_IO_PORT_AWS_2_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_2"},
	{2, 118, "DEV_ATL0_ATL_IO_PORT_AWS_3", "Input muxed clock"},
	{2, 119, "DEV_ATL0_ATL_IO_PORT_AWS_3_PARENT_MCASP_MAIN_0_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_3"},
	{2, 120, "DEV_ATL0_ATL_IO_PORT_AWS_3_PARENT_MCASP_MAIN_1_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_3"},
	{2, 121, "DEV_ATL0_ATL_IO_PORT_AWS_3_PARENT_MCASP_MAIN_2_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_3"},
	{2, 122, "DEV_ATL0_ATL_IO_PORT_AWS_3_PARENT_MCASP_MAIN_3_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_3"},
	{2, 123, "DEV_ATL0_ATL_IO_PORT_AWS_3_PARENT_MCASP_MAIN_4_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_3"},
	{2, 131, "DEV_ATL0_ATL_IO_PORT_AWS_3_PARENT_MCASP_MAIN_0_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_3"},
	{2, 132, "DEV_ATL0_ATL_IO_PORT_AWS_3_PARENT_MCASP_MAIN_1_MCASP_AFSX_POUT_DUP0", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_3"},
	{2, 133, "DEV_ATL0_ATL_IO_PORT_AWS_3_PARENT_MCASP_MAIN_2_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_3"},
	{2, 134, "DEV_ATL0_ATL_IO_PORT_AWS_3_PARENT_MCASP_MAIN_3_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_3"},
	{2, 135, "DEV_ATL0_ATL_IO_PORT_AWS_3_PARENT_MCASP_MAIN_4_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_3"},
	{2, 143, "DEV_ATL0_ATL_IO_PORT_AWS_3_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_3"},
	{2, 144, "DEV_ATL0_ATL_IO_PORT_AWS_3_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_AWS_3"},
	{2, 157, "DEV_ATL0_ATL_IO_PORT_BWS", "Input muxed clock"},
	{2, 158, "DEV_ATL0_ATL_IO_PORT_BWS_PARENT_MCASP_MAIN_0_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS"},
	{2, 159, "DEV_ATL0_ATL_IO_PORT_BWS_PARENT_MCASP_MAIN_1_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS"},
	{2, 160, "DEV_ATL0_ATL_IO_PORT_BWS_PARENT_MCASP_MAIN_2_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS"},
	{2, 161, "DEV_ATL0_ATL_IO_PORT_BWS_PARENT_MCASP_MAIN_3_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS"},
	{2, 162, "DEV_ATL0_ATL_IO_PORT_BWS_PARENT_MCASP_MAIN_4_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS"},
	{2, 170, "DEV_ATL0_ATL_IO_PORT_BWS_PARENT_MCASP_MAIN_0_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS"},
	{2, 171, "DEV_ATL0_ATL_IO_PORT_BWS_PARENT_MCASP_MAIN_1_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS"},
	{2, 172, "DEV_ATL0_ATL_IO_PORT_BWS_PARENT_MCASP_MAIN_2_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS"},
	{2, 173, "DEV_ATL0_ATL_IO_PORT_BWS_PARENT_MCASP_MAIN_3_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS"},
	{2, 174, "DEV_ATL0_ATL_IO_PORT_BWS_PARENT_MCASP_MAIN_4_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS"},
	{2, 182, "DEV_ATL0_ATL_IO_PORT_BWS_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS"},
	{2, 183, "DEV_ATL0_ATL_IO_PORT_BWS_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS"},
	{2, 190, "DEV_ATL0_ATL_IO_PORT_BWS_1", "Input muxed clock"},
	{2, 191, "DEV_ATL0_ATL_IO_PORT_BWS_1_PARENT_MCASP_MAIN_0_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_1"},
	{2, 192, "DEV_ATL0_ATL_IO_PORT_BWS_1_PARENT_MCASP_MAIN_1_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_1"},
	{2, 193, "DEV_ATL0_ATL_IO_PORT_BWS_1_PARENT_MCASP_MAIN_2_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_1"},
	{2, 194, "DEV_ATL0_ATL_IO_PORT_BWS_1_PARENT_MCASP_MAIN_3_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_1"},
	{2, 195, "DEV_ATL0_ATL_IO_PORT_BWS_1_PARENT_MCASP_MAIN_4_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_1"},
	{2, 203, "DEV_ATL0_ATL_IO_PORT_BWS_1_PARENT_MCASP_MAIN_0_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_1"},
	{2, 204, "DEV_ATL0_ATL_IO_PORT_BWS_1_PARENT_MCASP_MAIN_1_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_1"},
	{2, 205, "DEV_ATL0_ATL_IO_PORT_BWS_1_PARENT_MCASP_MAIN_2_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_1"},
	{2, 206, "DEV_ATL0_ATL_IO_PORT_BWS_1_PARENT_MCASP_MAIN_3_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_1"},
	{2, 207, "DEV_ATL0_ATL_IO_PORT_BWS_1_PARENT_MCASP_MAIN_4_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_1"},
	{2, 215, "DEV_ATL0_ATL_IO_PORT_BWS_1_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_1"},
	{2, 216, "DEV_ATL0_ATL_IO_PORT_BWS_1_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_1"},
	{2, 229, "DEV_ATL0_ATL_IO_PORT_BWS_2", "Input muxed clock"},
	{2, 230, "DEV_ATL0_ATL_IO_PORT_BWS_2_PARENT_MCASP_MAIN_0_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_2"},
	{2, 231, "DEV_ATL0_ATL_IO_PORT_BWS_2_PARENT_MCASP_MAIN_1_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_2"},
	{2, 232, "DEV_ATL0_ATL_IO_PORT_BWS_2_PARENT_MCASP_MAIN_2_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_2"},
	{2, 233, "DEV_ATL0_ATL_IO_PORT_BWS_2_PARENT_MCASP_MAIN_3_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_2"},
	{2, 234, "DEV_ATL0_ATL_IO_PORT_BWS_2_PARENT_MCASP_MAIN_4_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_2"},
	{2, 242, "DEV_ATL0_ATL_IO_PORT_BWS_2_PARENT_MCASP_MAIN_0_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_2"},
	{2, 243, "DEV_ATL0_ATL_IO_PORT_BWS_2_PARENT_MCASP_MAIN_1_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_2"},
	{2, 244, "DEV_ATL0_ATL_IO_PORT_BWS_2_PARENT_MCASP_MAIN_2_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_2"},
	{2, 245, "DEV_ATL0_ATL_IO_PORT_BWS_2_PARENT_MCASP_MAIN_3_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_2"},
	{2, 246, "DEV_ATL0_ATL_IO_PORT_BWS_2_PARENT_MCASP_MAIN_4_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_2"},
	{2, 254, "DEV_ATL0_ATL_IO_PORT_BWS_2_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_2"},
	{2, 255, "DEV_ATL0_ATL_IO_PORT_BWS_2_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_2"},
	{2, 262, "DEV_ATL0_ATL_IO_PORT_BWS_3", "Input muxed clock"},
	{2, 263, "DEV_ATL0_ATL_IO_PORT_BWS_3_PARENT_MCASP_MAIN_0_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_3"},
	{2, 264, "DEV_ATL0_ATL_IO_PORT_BWS_3_PARENT_MCASP_MAIN_1_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_3"},
	{2, 265, "DEV_ATL0_ATL_IO_PORT_BWS_3_PARENT_MCASP_MAIN_2_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_3"},
	{2, 266, "DEV_ATL0_ATL_IO_PORT_BWS_3_PARENT_MCASP_MAIN_3_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_3"},
	{2, 267, "DEV_ATL0_ATL_IO_PORT_BWS_3_PARENT_MCASP_MAIN_4_MCASP_AFSR_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_3"},
	{2, 275, "DEV_ATL0_ATL_IO_PORT_BWS_3_PARENT_MCASP_MAIN_0_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_3"},
	{2, 276, "DEV_ATL0_ATL_IO_PORT_BWS_3_PARENT_MCASP_MAIN_1_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_3"},
	{2, 277, "DEV_ATL0_ATL_IO_PORT_BWS_3_PARENT_MCASP_MAIN_2_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_3"},
	{2, 278, "DEV_ATL0_ATL_IO_PORT_BWS_3_PARENT_MCASP_MAIN_3_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_3"},
	{2, 279, "DEV_ATL0_ATL_IO_PORT_BWS_3_PARENT_MCASP_MAIN_4_MCASP_AFSX_POUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_3"},
	{2, 287, "DEV_ATL0_ATL_IO_PORT_BWS_3_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_3"},
	{2, 288, "DEV_ATL0_ATL_IO_PORT_BWS_3_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_ATL0_ATL_IO_PORT_BWS_3"},
	{2, 301, "DEV_ATL0_VBUS_CLK", "Input clock"},
	{157, 0, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN", "Input muxed clock"},
	{157, 1, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_0_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 2, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_1_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 3, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_2_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 4, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_3_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 5, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_4_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 13, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_0_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 14, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_1_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 15, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_2_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 16, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_3_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 17, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_4_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 25, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 26, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 27, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 28, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 29, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 33, "DEV_BOARD0_AUDIO_EXT_REFCLK0_OUT", "Output clock"},
	{157, 34, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN", "Input muxed clock"},
	{157, 35, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_0_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 36, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_1_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 37, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_2_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 38, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_3_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 39, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_4_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 47, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_0_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 48, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_1_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 49, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_2_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 50, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_3_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 51, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_4_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 59, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 60, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 61, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 62, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 63, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 67, "DEV_BOARD0_AUDIO_EXT_REFCLK1_OUT", "Output clock"},
	{157, 68, "DEV_BOARD0_CPTS0_RFT_CLK_OUT", "Output clock"},
	{157, 69, "DEV_BOARD0_CSI0_RXCLKN_OUT", "Output clock"},
	{157, 70, "DEV_BOARD0_CSI0_RXCLKP_OUT", "Output clock"},
	{157, 71, "DEV_BOARD0_CSI0_TXCLKN_IN", "Input clock"},
	{157, 72, "DEV_BOARD0_CSI0_TXCLKP_IN", "Input clock"},
	{157, 73, "DEV_BOARD0_CSI1_RXCLKN_OUT", "Output clock"},
	{157, 74, "DEV_BOARD0_CSI1_RXCLKP_OUT", "Output clock"},
	{157, 75, "DEV_BOARD0_CSI1_TXCLKN_IN", "Input clock"},
	{157, 76, "DEV_BOARD0_CSI1_TXCLKP_IN", "Input clock"},
	{157, 77, "DEV_BOARD0_CSI2_RXCLKN_OUT", "Output clock"},
	{157, 78, "DEV_BOARD0_CSI2_RXCLKP_OUT", "Output clock"},
	{157, 95, "DEV_BOARD0_DSI0_TXCLKN_IN", "Input clock"},
	{157, 96, "DEV_BOARD0_DSI0_TXCLKP_IN", "Input clock"},
	{157, 97, "DEV_BOARD0_DSI1_TXCLKN_IN", "Input clock"},
	{157, 98, "DEV_BOARD0_DSI1_TXCLKP_IN", "Input clock"},
	{157, 99, "DEV_BOARD0_EXT_REFCLK1_OUT", "Output clock"},
	{157, 100, "DEV_BOARD0_GPMC0_CLKOUT_IN", "Input clock"},
	{157, 101, "DEV_BOARD0_GPMC0_CLK_OUT", "Output clock"},
	{157, 102, "DEV_BOARD0_GPMC0_FCLK_MUX_IN", "Input clock"},
	{157, 103, "DEV_BOARD0_HYP0_RXFLCLK_IN", "Input clock"},
	{157, 104, "DEV_BOARD0_HYP0_RXPMCLK_OUT", "Output clock"},
	{157, 105, "DEV_BOARD0_HYP0_TXFLCLK_OUT", "Output clock"},
	{157, 106, "DEV_BOARD0_HYP0_TXPMCLK_IN", "Input clock"},
	{157, 107, "DEV_BOARD0_HYP1_RXFLCLK_IN", "Input clock"},
	{157, 108, "DEV_BOARD0_HYP1_RXPMCLK_OUT", "Output clock"},
	{157, 109, "DEV_BOARD0_HYP1_TXFLCLK_OUT", "Output clock"},
	{157, 110, "DEV_BOARD0_HYP1_TXPMCLK_IN", "Input clock"},
	{157, 111, "DEV_BOARD0_I2C0_SCL_IN", "Input clock"},
	{157, 112, "DEV_BOARD0_I2C0_SCL_OUT", "Output clock"},
	{157, 113, "DEV_BOARD0_I2C1_SCL_IN", "Input clock"},
	{157, 114, "DEV_BOARD0_I2C1_SCL_OUT", "Output clock"},
	{157, 115, "DEV_BOARD0_I2C2_SCL_IN", "Input clock"},
	{157, 116, "DEV_BOARD0_I2C2_SCL_OUT", "Output clock"},
	{157, 117, "DEV_BOARD0_I2C3_SCL_IN", "Input clock"},
	{157, 118, "DEV_BOARD0_I2C3_SCL_OUT", "Output clock"},
	{157, 119, "DEV_BOARD0_I2C4_SCL_IN", "Input clock"},
	{157, 120, "DEV_BOARD0_I2C4_SCL_OUT", "Output clock"},
	{157, 121, "DEV_BOARD0_I2C5_SCL_IN", "Input clock"},
	{157, 122, "DEV_BOARD0_I2C5_SCL_OUT", "Output clock"},
	{157, 123, "DEV_BOARD0_I2C6_SCL_IN", "Input clock"},
	{157, 124, "DEV_BOARD0_I2C6_SCL_OUT", "Output clock"},
	{157, 125, "DEV_BOARD0_LED_CLK_OUT", "Output clock"},
	{157, 126, "DEV_BOARD0_MCAN0_RX_OUT", "Output clock"},
	{157, 127, "DEV_BOARD0_MCAN10_RX_OUT", "Output clock"},
	{157, 128, "DEV_BOARD0_MCAN11_RX_OUT", "Output clock"},
	{157, 129, "DEV_BOARD0_MCAN12_RX_OUT", "Output clock"},
	{157, 130, "DEV_BOARD0_MCAN13_RX_OUT", "Output clock"},
	{157, 131, "DEV_BOARD0_MCAN14_RX_OUT", "Output clock"},
	{157, 132, "DEV_BOARD0_MCAN15_RX_OUT", "Output clock"},
	{157, 133, "DEV_BOARD0_MCAN16_RX_OUT", "Output clock"},
	{157, 134, "DEV_BOARD0_MCAN17_RX_OUT", "Output clock"},
	{157, 135, "DEV_BOARD0_MCAN1_RX_OUT", "Output clock"},
	{157, 136, "DEV_BOARD0_MCAN2_RX_OUT", "Output clock"},
	{157, 137, "DEV_BOARD0_MCAN3_RX_OUT", "Output clock"},
	{157, 138, "DEV_BOARD0_MCAN4_RX_OUT", "Output clock"},
	{157, 139, "DEV_BOARD0_MCAN5_RX_OUT", "Output clock"},
	{157, 140, "DEV_BOARD0_MCAN6_RX_OUT", "Output clock"},
	{157, 141, "DEV_BOARD0_MCAN7_RX_OUT", "Output clock"},
	{157, 142, "DEV_BOARD0_MCAN8_RX_OUT", "Output clock"},
	{157, 143, "DEV_BOARD0_MCAN9_RX_OUT", "Output clock"},
	{157, 144, "DEV_BOARD0_MCASP0_ACLKR_IN", "Input clock"},
	{157, 145, "DEV_BOARD0_MCASP0_ACLKR_OUT", "Output clock"},
	{157, 146, "DEV_BOARD0_MCASP0_ACLKX_IN", "Input clock"},
	{157, 147, "DEV_BOARD0_MCASP0_ACLKX_OUT", "Output clock"},
	{157, 148, "DEV_BOARD0_MCASP0_AFSR_OUT", "Output clock"},
	{157, 149, "DEV_BOARD0_MCASP0_AFSX_OUT", "Output clock"},
	{157, 150, "DEV_BOARD0_MCASP1_ACLKR_IN", "Input clock"},
	{157, 151, "DEV_BOARD0_MCASP1_ACLKR_OUT", "Output clock"},
	{157, 152, "DEV_BOARD0_MCASP1_ACLKX_IN", "Input clock"},
	{157, 153, "DEV_BOARD0_MCASP1_ACLKX_OUT", "Output clock"},
	{157, 154, "DEV_BOARD0_MCASP1_AFSR_OUT", "Output clock"},
	{157, 155, "DEV_BOARD0_MCASP1_AFSX_OUT", "Output clock"},
	{157, 156, "DEV_BOARD0_MCASP2_ACLKR_IN", "Input clock"},
	{157, 157, "DEV_BOARD0_MCASP2_ACLKR_OUT", "Output clock"},
	{157, 158, "DEV_BOARD0_MCASP2_ACLKX_IN", "Input clock"},
	{157, 159, "DEV_BOARD0_MCASP2_ACLKX_OUT", "Output clock"},
	{157, 160, "DEV_BOARD0_MCASP2_AFSR_OUT", "Output clock"},
	{157, 161, "DEV_BOARD0_MCASP2_AFSX_OUT", "Output clock"},
	{157, 162, "DEV_BOARD0_MCASP3_ACLKR_IN", "Input clock"},
	{157, 163, "DEV_BOARD0_MCASP3_ACLKR_OUT", "Output clock"},
	{157, 164, "DEV_BOARD0_MCASP3_ACLKX_IN", "Input clock"},
	{157, 165, "DEV_BOARD0_MCASP3_ACLKX_OUT", "Output clock"},
	{157, 166, "DEV_BOARD0_MCASP3_AFSR_OUT", "Output clock"},
	{157, 167, "DEV_BOARD0_MCASP3_AFSX_OUT", "Output clock"},
	{157, 168, "DEV_BOARD0_MCASP4_ACLKR_IN", "Input clock"},
	{157, 169, "DEV_BOARD0_MCASP4_ACLKR_OUT", "Output clock"},
	{157, 170, "DEV_BOARD0_MCASP4_ACLKX_IN", "Input clock"},
	{157, 171, "DEV_BOARD0_MCASP4_ACLKX_OUT", "Output clock"},
	{157, 172, "DEV_BOARD0_MCASP4_AFSR_OUT", "Output clock"},
	{157, 173, "DEV_BOARD0_MCASP4_AFSX_OUT", "Output clock"},
	{157, 174, "DEV_BOARD0_MCU_CLKOUT0_IN", "Input muxed clock"},
	{157, 175, "DEV_BOARD0_MCU_CLKOUT0_IN_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT0_CLK5", "Parent input clock option to DEV_BOARD0_MCU_CLKOUT0_IN"},
	{157, 176, "DEV_BOARD0_MCU_CLKOUT0_IN_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT0_CLK10", "Parent input clock option to DEV_BOARD0_MCU_CLKOUT0_IN"},
	{157, 177, "DEV_BOARD0_MCU_CPTS0_RFT_CLK_OUT", "Output clock"},
	{157, 178, "DEV_BOARD0_MCU_EXT_REFCLK0_OUT", "Output clock"},
	{157, 179, "DEV_BOARD0_MCU_HYPERBUS0_CK_IN", "Input clock"},
	{157, 180, "DEV_BOARD0_MCU_HYPERBUS0_CKN_IN", "Input clock"},
	{157, 181, "DEV_BOARD0_MCU_I2C0_SCL_IN", "Input clock"},
	{157, 182, "DEV_BOARD0_MCU_I2C0_SCL_OUT", "Output clock"},
	{157, 183, "DEV_BOARD0_MCU_I2C1_SCL_IN", "Input clock"},
	{157, 184, "DEV_BOARD0_MCU_I2C1_SCL_OUT", "Output clock"},
	{157, 185, "DEV_BOARD0_MCU_I3C0_SCL_IN", "Input clock"},
	{157, 186, "DEV_BOARD0_MCU_I3C0_SCL_OUT", "Output clock"},
	{157, 187, "DEV_BOARD0_MCU_I3C0_SDA_OUT", "Output clock"},
	{157, 188, "DEV_BOARD0_MCU_MCAN0_RX_OUT", "Output clock"},
	{157, 189, "DEV_BOARD0_MCU_MCAN1_RX_OUT", "Output clock"},
	{157, 190, "DEV_BOARD0_MCU_MDIO0_MDC_IN", "Input clock"},
	{157, 191, "DEV_BOARD0_MCU_OBSCLK0_IN", "Input muxed clock"},
	{157, 192, "DEV_BOARD0_MCU_OBSCLK0_IN_PARENT_MCU_OBSCLK_DIV_OUT0", "Parent input clock option to DEV_BOARD0_MCU_OBSCLK0_IN"},
	{157, 193, "DEV_BOARD0_MCU_OBSCLK0_IN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_BOARD0_MCU_OBSCLK0_IN"},
	{157, 224, "DEV_BOARD0_MCU_OSPI0_CLK_IN", "Input clock"},
	{157, 225, "DEV_BOARD0_MCU_OSPI0_DQS_OUT", "Output clock"},
	{157, 226, "DEV_BOARD0_MCU_OSPI0_LBCLKO_IN", "Input clock"},
	{157, 227, "DEV_BOARD0_MCU_OSPI0_LBCLKO_OUT", "Output clock"},
	{157, 228, "DEV_BOARD0_MCU_OSPI1_CLK_IN", "Input clock"},
	{157, 229, "DEV_BOARD0_MCU_OSPI1_DQS_OUT", "Output clock"},
	{157, 230, "DEV_BOARD0_MCU_OSPI1_LBCLKO_IN", "Input clock"},
	{157, 231, "DEV_BOARD0_MCU_OSPI1_LBCLKO_OUT", "Output clock"},
	{157, 232, "DEV_BOARD0_MCU_RGMII1_RXC_OUT", "Output clock"},
	{157, 233, "DEV_BOARD0_MCU_RGMII1_TXC_IN", "Input clock"},
	{157, 234, "DEV_BOARD0_MCU_RMII1_REF_CLK_OUT", "Output clock"},
	{157, 235, "DEV_BOARD0_MCU_SPI0_CLK_IN", "Input clock"},
	{157, 236, "DEV_BOARD0_MCU_SPI0_CLK_OUT", "Output clock"},
	{157, 237, "DEV_BOARD0_MCU_SPI1_CLK_IN", "Input clock"},
	{157, 238, "DEV_BOARD0_MCU_SPI1_CLK_OUT", "Output clock"},
	{157, 239, "DEV_BOARD0_MCU_SYSCLKOUT0_IN", "Input clock"},
	{157, 240, "DEV_BOARD0_MDIO0_MDC_IN", "Input clock"},
	{157, 241, "DEV_BOARD0_MDIO1_MDC_IN", "Input clock"},
	{157, 243, "DEV_BOARD0_MMC1_CLKLB_IN", "Input clock"},
	{157, 244, "DEV_BOARD0_MMC1_CLKLB_OUT", "Output clock"},
	{157, 245, "DEV_BOARD0_MMC1_CLK_IN", "Input clock"},
	{157, 246, "DEV_BOARD0_MMC1_CLK_OUT", "Output clock"},
	{157, 247, "DEV_BOARD0_OBSCLK0_IN", "Input clock"},
	{157, 248, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 249, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 250, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 251, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 252, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 253, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV1_16FFT_MAIN_5_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 254, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV0_16FFT_MAIN_6_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 255, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV0_16FFT_MAIN_26_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 256, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV0_16FFT_MAIN_27_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 257, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV0_16FFT_MAIN_28_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 260, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV0_16FFT_MAIN_12_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 261, "DEV_BOARD0_OBSCLK0_IN_PARENT_OBSCLK1_MUX_OUT0", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 262, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV2_16FFT_MAIN_14_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 264, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV1_16FFT_MAIN_16_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 265, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV1_16FFT_MAIN_17_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 267, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV1_16FFT_MAIN_19_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 268, "DEV_BOARD0_OBSCLK0_IN_PARENT_UFSHCI2P1SS_16FFC_MAIN_0_UFSHCI_MPHY_TX_REF_SYMBOLCLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 269, "DEV_BOARD0_OBSCLK0_IN_PARENT_UFSHCI2P1SS_16FFC_MAIN_0_UFSHCI_MPHY_M31_VCO_19P2M_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 270, "DEV_BOARD0_OBSCLK0_IN_PARENT_UFSHCI2P1SS_16FFC_MAIN_0_UFSHCI_MPHY_M31_VCO_26M_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 273, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV1_16FFT_MAIN_25_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 274, "DEV_BOARD0_OBSCLK0_IN_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 275, "DEV_BOARD0_OBSCLK0_IN_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 276, "DEV_BOARD0_OBSCLK0_IN_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 277, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT0_CLK_DUP0", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 278, "DEV_BOARD0_OBSCLK0_IN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 279, "DEV_BOARD0_OBSCLK0_IN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 280, "DEV_BOARD0_OBSCLK1_IN", "Input clock"},
	{157, 281, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 282, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 283, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 284, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 285, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 286, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV1_16FFT_MAIN_5_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 287, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV0_16FFT_MAIN_6_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 288, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV0_16FFT_MAIN_26_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 289, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV0_16FFT_MAIN_27_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 290, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV0_16FFT_MAIN_28_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 293, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV0_16FFT_MAIN_12_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 294, "DEV_BOARD0_OBSCLK1_IN_PARENT_OBSCLK1_MUX_OUT0", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 295, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV2_16FFT_MAIN_14_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 297, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV1_16FFT_MAIN_16_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 298, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV1_16FFT_MAIN_17_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 300, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV1_16FFT_MAIN_19_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 301, "DEV_BOARD0_OBSCLK1_IN_PARENT_UFSHCI2P1SS_16FFC_MAIN_0_UFSHCI_MPHY_TX_REF_SYMBOLCLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 302, "DEV_BOARD0_OBSCLK1_IN_PARENT_UFSHCI2P1SS_16FFC_MAIN_0_UFSHCI_MPHY_M31_VCO_19P2M_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 303, "DEV_BOARD0_OBSCLK1_IN_PARENT_UFSHCI2P1SS_16FFC_MAIN_0_UFSHCI_MPHY_M31_VCO_26M_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 306, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV1_16FFT_MAIN_25_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 307, "DEV_BOARD0_OBSCLK1_IN_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 308, "DEV_BOARD0_OBSCLK1_IN_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 309, "DEV_BOARD0_OBSCLK1_IN_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 310, "DEV_BOARD0_OBSCLK1_IN_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT0_CLK_DUP0", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 311, "DEV_BOARD0_OBSCLK1_IN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 312, "DEV_BOARD0_OBSCLK1_IN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_BOARD0_OBSCLK1_IN"},
	{157, 313, "DEV_BOARD0_PCIE_REFCLK0_N_OUT_IN", "Input clock"},
	{157, 314, "DEV_BOARD0_PCIE_REFCLK0_P_OUT_IN", "Input clock"},
	{157, 315, "DEV_BOARD0_PCIE_REFCLK1_N_OUT_IN", "Input clock"},
	{157, 316, "DEV_BOARD0_PCIE_REFCLK1_P_OUT_IN", "Input clock"},
	{157, 317, "DEV_BOARD0_PCIE_REFCLK2_N_OUT_IN", "Input clock"},
	{157, 318, "DEV_BOARD0_PCIE_REFCLK2_P_OUT_IN", "Input clock"},
	{157, 319, "DEV_BOARD0_PCIE_REFCLK3_N_OUT_IN", "Input clock"},
	{157, 320, "DEV_BOARD0_PCIE_REFCLK3_P_OUT_IN", "Input clock"},
	{157, 321, "DEV_BOARD0_RGMII1_RXC_OUT", "Output clock"},
	{157, 322, "DEV_BOARD0_RGMII1_TXC_IN", "Input clock"},
	{157, 323, "DEV_BOARD0_RMII_REF_CLK_OUT", "Output clock"},
	{157, 324, "DEV_BOARD0_SERDES0_REFCLK_N_IN", "Input clock"},
	{157, 325, "DEV_BOARD0_SERDES0_REFCLK_N_OUT", "Output clock"},
	{157, 326, "DEV_BOARD0_SERDES0_REFCLK_P_IN", "Input clock"},
	{157, 327, "DEV_BOARD0_SERDES0_REFCLK_P_OUT", "Output clock"},
	{157, 328, "DEV_BOARD0_SERDES1_REFCLK_N_IN", "Input clock"},
	{157, 329, "DEV_BOARD0_SERDES1_REFCLK_N_OUT", "Output clock"},
	{157, 330, "DEV_BOARD0_SERDES1_REFCLK_P_IN", "Input clock"},
	{157, 331, "DEV_BOARD0_SERDES1_REFCLK_P_OUT", "Output clock"},
	{157, 332, "DEV_BOARD0_SERDES2_REFCLK_N_IN", "Input clock"},
	{157, 333, "DEV_BOARD0_SERDES2_REFCLK_N_OUT", "Output clock"},
	{157, 334, "DEV_BOARD0_SERDES2_REFCLK_P_IN", "Input clock"},
	{157, 335, "DEV_BOARD0_SERDES2_REFCLK_P_OUT", "Output clock"},
	{157, 336, "DEV_BOARD0_SERDES4_REFCLK_N_IN", "Input clock"},
	{157, 337, "DEV_BOARD0_SERDES4_REFCLK_N_OUT", "Output clock"},
	{157, 338, "DEV_BOARD0_SERDES4_REFCLK_P_IN", "Input clock"},
	{157, 339, "DEV_BOARD0_SERDES4_REFCLK_P_OUT", "Output clock"},
	{157, 340, "DEV_BOARD0_SPI0_CLK_IN", "Input clock"},
	{157, 341, "DEV_BOARD0_SPI0_CLK_OUT", "Output clock"},
	{157, 342, "DEV_BOARD0_SPI1_CLK_IN", "Input clock"},
	{157, 343, "DEV_BOARD0_SPI1_CLK_OUT", "Output clock"},
	{157, 344, "DEV_BOARD0_SPI2_CLK_IN", "Input clock"},
	{157, 345, "DEV_BOARD0_SPI2_CLK_OUT", "Output clock"},
	{157, 346, "DEV_BOARD0_SPI3_CLK_IN", "Input clock"},
	{157, 347, "DEV_BOARD0_SPI3_CLK_OUT", "Output clock"},
	{157, 348, "DEV_BOARD0_SPI5_CLK_IN", "Input clock"},
	{157, 349, "DEV_BOARD0_SPI5_CLK_OUT", "Output clock"},
	{157, 350, "DEV_BOARD0_SPI6_CLK_IN", "Input clock"},
	{157, 351, "DEV_BOARD0_SPI6_CLK_OUT", "Output clock"},
	{157, 352, "DEV_BOARD0_SPI7_CLK_IN", "Input clock"},
	{157, 353, "DEV_BOARD0_SPI7_CLK_OUT", "Output clock"},
	{157, 354, "DEV_BOARD0_SYSCLKOUT0_IN", "Input clock"},
	{157, 355, "DEV_BOARD0_TCK_OUT", "Output clock"},
	{157, 356, "DEV_BOARD0_TRC_CLK_IN", "Input clock"},
	{157, 357, "DEV_BOARD0_UFS0_REF_CLK_IN", "Input clock"},
	{157, 358, "DEV_BOARD0_VOUT0_EXTPCLKIN_OUT", "Output clock"},
	{157, 359, "DEV_BOARD0_VOUT0_PCLK_IN", "Input clock"},
	{157, 360, "DEV_BOARD0_WKUP_I2C0_SCL_IN", "Input clock"},
	{157, 361, "DEV_BOARD0_WKUP_I2C0_SCL_OUT", "Output clock"},
	{157, 363, "DEV_BOARD0_HFOSC1_CLK_OUT", "Output clock"},
	{11, 0, "DEV_CMPEVENT_INTRTR0_INTR_CLK", "Input clock"},
	{241, 0, "DEV_CODEC0_VPU_ACLK_CLK", "Input clock"},
	{241, 1, "DEV_CODEC0_VPU_BCLK_CLK", "Input clock"},
	{241, 2, "DEV_CODEC0_VPU_CCLK_CLK", "Input clock"},
	{241, 3, "DEV_CODEC0_VPU_PCLK_CLK", "Input clock"},
	{242, 0, "DEV_CODEC1_VPU_ACLK_CLK", "Input clock"},
	{242, 1, "DEV_CODEC1_VPU_BCLK_CLK", "Input clock"},
	{242, 2, "DEV_CODEC1_VPU_CCLK_CLK", "Input clock"},
	{242, 3, "DEV_CODEC1_VPU_PCLK_CLK", "Input clock"},
	{30, 3, "DEV_COMPUTE_CLUSTER0_C71SS0_C7X_CLK", "Input clock"},
	{30, 4, "DEV_COMPUTE_CLUSTER0_C71SS0_C7X_DIVH_CLK4_OBSCLK_OUT_CLK", "Output clock"},
	{31, 0, "DEV_COMPUTE_CLUSTER0_C71SS0_CORE0_C7X_CLK", "Input clock"},
	{31, 2, "DEV_COMPUTE_CLUSTER0_C71SS0_CORE0_PLL_CTRL_CLK_CLK", "Input clock"},
	{33, 3, "DEV_COMPUTE_CLUSTER0_C71SS1_C7X_CLK", "Input clock"},
	{34, 0, "DEV_COMPUTE_CLUSTER0_C71SS1_CORE0_C7X_CLK", "Input clock"},
	{34, 2, "DEV_COMPUTE_CLUSTER0_C71SS1_CORE0_PLL_CTRL_CLK_CLK", "Input clock"},
	{37, 3, "DEV_COMPUTE_CLUSTER0_C71SS2_C7X_CLK", "Input clock"},
	{38, 0, "DEV_COMPUTE_CLUSTER0_C71SS2_CORE0_C7X_CLK", "Input clock"},
	{40, 3, "DEV_COMPUTE_CLUSTER0_C71SS3_C7X_CLK", "Input clock"},
	{41, 0, "DEV_COMPUTE_CLUSTER0_C71SS3_CORE0_C7X_CLK", "Input clock"},
	{45, 1, "DEV_COMPUTE_CLUSTER0_CORE_CORE_PSIL_LEAF_CLK", "Input clock"},
	{50, 0, "DEV_COMPUTE_CLUSTER0_DEBUG_WRAP_0_CLK1_CLK_CLK", "Input clock"},
	{50, 1, "DEV_COMPUTE_CLUSTER0_DEBUG_WRAP_0_CLK2_CLK_CLK", "Input clock"},
	{58, 0, "DEV_COMPUTE_CLUSTER0_GIC500SS_VCLK_CLK", "Input clock"},
	{62, 0, "DEV_CPSW1_CPPI_CLK_CLK", "Input clock"},
	{62, 1, "DEV_CPSW1_CPTS_GENF0", "Output clock"},
	{62, 3, "DEV_CPSW1_CPTS_RFT_CLK", "Input muxed clock"},
	{62, 4, "DEV_CPSW1_CPTS_RFT_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_CPSW1_CPTS_RFT_CLK"},
	{62, 5, "DEV_CPSW1_CPTS_RFT_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_CPSW1_CPTS_RFT_CLK"},
	{62, 6, "DEV_CPSW1_CPTS_RFT_CLK_PARENT_BOARD_0_MCU_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_CPSW1_CPTS_RFT_CLK"},
	{62, 7, "DEV_CPSW1_CPTS_RFT_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_CPSW1_CPTS_RFT_CLK"},
	{62, 8, "DEV_CPSW1_CPTS_RFT_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_CPSW1_CPTS_RFT_CLK"},
	{62, 9, "DEV_CPSW1_CPTS_RFT_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_CPSW1_CPTS_RFT_CLK"},
	{62, 10, "DEV_CPSW1_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN0_TXMCLK", "Parent input clock option to DEV_CPSW1_CPTS_RFT_CLK"},
	{62, 11, "DEV_CPSW1_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN1_TXMCLK", "Parent input clock option to DEV_CPSW1_CPTS_RFT_CLK"},
	{62, 12, "DEV_CPSW1_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN2_TXMCLK", "Parent input clock option to DEV_CPSW1_CPTS_RFT_CLK"},
	{62, 13, "DEV_CPSW1_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN3_TXMCLK", "Parent input clock option to DEV_CPSW1_CPTS_RFT_CLK"},
	{62, 14, "DEV_CPSW1_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT3_MAIN_1_IP2_LN0_TXMCLK", "Parent input clock option to DEV_CPSW1_CPTS_RFT_CLK"},
	{62, 15, "DEV_CPSW1_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT3_MAIN_1_IP2_LN1_TXMCLK", "Parent input clock option to DEV_CPSW1_CPTS_RFT_CLK"},
	{62, 16, "DEV_CPSW1_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP1_LN2_TXMCLK", "Parent input clock option to DEV_CPSW1_CPTS_RFT_CLK"},
	{62, 17, "DEV_CPSW1_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT3_MAIN_1_IP3_LN2_TXMCLK", "Parent input clock option to DEV_CPSW1_CPTS_RFT_CLK"},
	{62, 18, "DEV_CPSW1_CPTS_RFT_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_CPSW1_CPTS_RFT_CLK"},
	{62, 19, "DEV_CPSW1_CPTS_RFT_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_CPSW1_CPTS_RFT_CLK"},
	{62, 20, "DEV_CPSW1_GMII1_MR_CLK", "Input clock"},
	{62, 21, "DEV_CPSW1_GMII1_MT_CLK", "Input clock"},
	{62, 22, "DEV_CPSW1_GMII_RFT_CLK", "Input clock"},
	{62, 23, "DEV_CPSW1_MDIO_MDCLK_O", "Output clock"},
	{62, 24, "DEV_CPSW1_RGMII1_RXC_I", "Input clock"},
	{62, 26, "DEV_CPSW1_RGMII1_TXC_O", "Output clock"},
	{62, 27, "DEV_CPSW1_RGMII_MHZ_250_CLK", "Input clock"},
	{62, 28, "DEV_CPSW1_RGMII_MHZ_50_CLK", "Input clock"},
	{62, 29, "DEV_CPSW1_RGMII_MHZ_5_CLK", "Input clock"},
	{62, 30, "DEV_CPSW1_RMII_MHZ_50_CLK", "Input clock"},
	{64, 0, "DEV_CPSW_9XUSS_J7AM0_CPPI_CLK_CLK", "Input clock"},
	{64, 1, "DEV_CPSW_9XUSS_J7AM0_CPTS_GENF0", "Output clock"},
	{64, 3, "DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK", "Input muxed clock"},
	{64, 4, "DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK"},
	{64, 5, "DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK"},
	{64, 6, "DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK_PARENT_BOARD_0_MCU_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK"},
	{64, 7, "DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK"},
	{64, 8, "DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK"},
	{64, 9, "DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK"},
	{64, 10, "DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN0_TXMCLK", "Parent input clock option to DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK"},
	{64, 11, "DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN1_TXMCLK", "Parent input clock option to DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK"},
	{64, 12, "DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN2_TXMCLK", "Parent input clock option to DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK"},
	{64, 13, "DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN3_TXMCLK", "Parent input clock option to DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK"},
	{64, 14, "DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT3_MAIN_1_IP2_LN0_TXMCLK", "Parent input clock option to DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK"},
	{64, 15, "DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT3_MAIN_1_IP2_LN1_TXMCLK", "Parent input clock option to DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK"},
	{64, 16, "DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP1_LN2_TXMCLK", "Parent input clock option to DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK"},
	{64, 17, "DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT3_MAIN_1_IP3_LN2_TXMCLK", "Parent input clock option to DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK"},
	{64, 18, "DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK"},
	{64, 19, "DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_CPSW_9XUSS_J7AM0_CPTS_RFT_CLK"},
	{64, 22, "DEV_CPSW_9XUSS_J7AM0_GMII1_MR_CLK", "Input clock"},
	{64, 23, "DEV_CPSW_9XUSS_J7AM0_GMII1_MT_CLK", "Input clock"},
	{64, 24, "DEV_CPSW_9XUSS_J7AM0_GMII2_MR_CLK", "Input clock"},
	{64, 25, "DEV_CPSW_9XUSS_J7AM0_GMII2_MT_CLK", "Input clock"},
	{64, 26, "DEV_CPSW_9XUSS_J7AM0_GMII3_MR_CLK", "Input clock"},
	{64, 27, "DEV_CPSW_9XUSS_J7AM0_GMII3_MT_CLK", "Input clock"},
	{64, 28, "DEV_CPSW_9XUSS_J7AM0_GMII4_MR_CLK", "Input clock"},
	{64, 29, "DEV_CPSW_9XUSS_J7AM0_GMII4_MT_CLK", "Input clock"},
	{64, 30, "DEV_CPSW_9XUSS_J7AM0_GMII5_MR_CLK", "Input clock"},
	{64, 31, "DEV_CPSW_9XUSS_J7AM0_GMII5_MT_CLK", "Input clock"},
	{64, 32, "DEV_CPSW_9XUSS_J7AM0_GMII6_MR_CLK", "Input clock"},
	{64, 33, "DEV_CPSW_9XUSS_J7AM0_GMII6_MT_CLK", "Input clock"},
	{64, 34, "DEV_CPSW_9XUSS_J7AM0_GMII7_MR_CLK", "Input clock"},
	{64, 35, "DEV_CPSW_9XUSS_J7AM0_GMII7_MT_CLK", "Input clock"},
	{64, 36, "DEV_CPSW_9XUSS_J7AM0_GMII8_MR_CLK", "Input clock"},
	{64, 37, "DEV_CPSW_9XUSS_J7AM0_GMII8_MT_CLK", "Input clock"},
	{64, 38, "DEV_CPSW_9XUSS_J7AM0_GMII_RFT_CLK", "Input clock"},
	{64, 39, "DEV_CPSW_9XUSS_J7AM0_MDIO_MDCLK_O", "Output clock"},
	{64, 56, "DEV_CPSW_9XUSS_J7AM0_RGMII_MHZ_250_CLK", "Input clock"},
	{64, 57, "DEV_CPSW_9XUSS_J7AM0_RGMII_MHZ_50_CLK", "Input clock"},
	{64, 58, "DEV_CPSW_9XUSS_J7AM0_RGMII_MHZ_5_CLK", "Input clock"},
	{64, 59, "DEV_CPSW_9XUSS_J7AM0_RMII_MHZ_50_CLK", "Input clock"},
	{64, 60, "DEV_CPSW_9XUSS_J7AM0_SERDES1_REFCLK", "Input clock"},
	{64, 61, "DEV_CPSW_9XUSS_J7AM0_SERDES1_RXCLK", "Input clock"},
	{64, 62, "DEV_CPSW_9XUSS_J7AM0_SERDES1_RXFCLK", "Input clock"},
	{64, 63, "DEV_CPSW_9XUSS_J7AM0_SERDES1_TXCLK", "Output clock"},
	{64, 64, "DEV_CPSW_9XUSS_J7AM0_SERDES1_TXFCLK", "Input clock"},
	{64, 65, "DEV_CPSW_9XUSS_J7AM0_SERDES1_TXMCLK", "Input clock"},
	{64, 66, "DEV_CPSW_9XUSS_J7AM0_SERDES2_REFCLK", "Input clock"},
	{64, 67, "DEV_CPSW_9XUSS_J7AM0_SERDES2_RXCLK", "Input clock"},
	{64, 68, "DEV_CPSW_9XUSS_J7AM0_SERDES2_RXFCLK", "Input clock"},
	{64, 69, "DEV_CPSW_9XUSS_J7AM0_SERDES2_TXCLK", "Output clock"},
	{64, 70, "DEV_CPSW_9XUSS_J7AM0_SERDES2_TXFCLK", "Input clock"},
	{64, 71, "DEV_CPSW_9XUSS_J7AM0_SERDES2_TXMCLK", "Input clock"},
	{64, 72, "DEV_CPSW_9XUSS_J7AM0_SERDES3_REFCLK", "Input clock"},
	{64, 73, "DEV_CPSW_9XUSS_J7AM0_SERDES3_RXCLK", "Input clock"},
	{64, 74, "DEV_CPSW_9XUSS_J7AM0_SERDES3_RXFCLK", "Input clock"},
	{64, 75, "DEV_CPSW_9XUSS_J7AM0_SERDES3_TXCLK", "Output clock"},
	{64, 76, "DEV_CPSW_9XUSS_J7AM0_SERDES3_TXFCLK", "Input clock"},
	{64, 77, "DEV_CPSW_9XUSS_J7AM0_SERDES3_TXMCLK", "Input clock"},
	{64, 78, "DEV_CPSW_9XUSS_J7AM0_SERDES4_REFCLK", "Input clock"},
	{64, 79, "DEV_CPSW_9XUSS_J7AM0_SERDES4_RXCLK", "Input clock"},
	{64, 80, "DEV_CPSW_9XUSS_J7AM0_SERDES4_RXFCLK", "Input clock"},
	{64, 81, "DEV_CPSW_9XUSS_J7AM0_SERDES4_TXCLK", "Output clock"},
	{64, 82, "DEV_CPSW_9XUSS_J7AM0_SERDES4_TXFCLK", "Input clock"},
	{64, 83, "DEV_CPSW_9XUSS_J7AM0_SERDES4_TXMCLK", "Input clock"},
	{64, 84, "DEV_CPSW_9XUSS_J7AM0_SERDES5_REFCLK", "Input clock"},
	{64, 85, "DEV_CPSW_9XUSS_J7AM0_SERDES5_RXCLK", "Input clock"},
	{64, 86, "DEV_CPSW_9XUSS_J7AM0_SERDES5_RXFCLK", "Input clock"},
	{64, 87, "DEV_CPSW_9XUSS_J7AM0_SERDES5_TXCLK", "Output clock"},
	{64, 88, "DEV_CPSW_9XUSS_J7AM0_SERDES5_TXFCLK", "Input clock"},
	{64, 89, "DEV_CPSW_9XUSS_J7AM0_SERDES5_TXMCLK", "Input clock"},
	{64, 90, "DEV_CPSW_9XUSS_J7AM0_SERDES6_REFCLK", "Input clock"},
	{64, 91, "DEV_CPSW_9XUSS_J7AM0_SERDES6_RXCLK", "Input clock"},
	{64, 92, "DEV_CPSW_9XUSS_J7AM0_SERDES6_RXFCLK", "Input clock"},
	{64, 93, "DEV_CPSW_9XUSS_J7AM0_SERDES6_TXCLK", "Output clock"},
	{64, 94, "DEV_CPSW_9XUSS_J7AM0_SERDES6_TXFCLK", "Input clock"},
	{64, 95, "DEV_CPSW_9XUSS_J7AM0_SERDES6_TXMCLK", "Input clock"},
	{64, 96, "DEV_CPSW_9XUSS_J7AM0_SERDES7_REFCLK", "Input clock"},
	{64, 97, "DEV_CPSW_9XUSS_J7AM0_SERDES7_RXCLK", "Input clock"},
	{64, 98, "DEV_CPSW_9XUSS_J7AM0_SERDES7_RXFCLK", "Input clock"},
	{64, 99, "DEV_CPSW_9XUSS_J7AM0_SERDES7_TXCLK", "Output clock"},
	{64, 100, "DEV_CPSW_9XUSS_J7AM0_SERDES7_TXFCLK", "Input clock"},
	{64, 101, "DEV_CPSW_9XUSS_J7AM0_SERDES7_TXMCLK", "Input clock"},
	{64, 102, "DEV_CPSW_9XUSS_J7AM0_SERDES8_REFCLK", "Input clock"},
	{64, 103, "DEV_CPSW_9XUSS_J7AM0_SERDES8_RXCLK", "Input clock"},
	{64, 104, "DEV_CPSW_9XUSS_J7AM0_SERDES8_RXFCLK", "Input clock"},
	{64, 105, "DEV_CPSW_9XUSS_J7AM0_SERDES8_TXCLK", "Output clock"},
	{64, 106, "DEV_CPSW_9XUSS_J7AM0_SERDES8_TXFCLK", "Input clock"},
	{64, 107, "DEV_CPSW_9XUSS_J7AM0_SERDES8_TXMCLK", "Input clock"},
	{70, 0, "DEV_CPT2_AGGR0_VCLK_CLK", "Input clock"},
	{65, 0, "DEV_CPT2_AGGR1_VCLK_CLK", "Input clock"},
	{67, 0, "DEV_CPT2_AGGR2_VCLK_CLK", "Input clock"},
	{69, 0, "DEV_CPT2_AGGR3_VCLK_CLK", "Input clock"},
	{68, 0, "DEV_CPT2_AGGR4_VCLK_CLK", "Input clock"},
	{66, 0, "DEV_CPT2_AGGR5_VCLK_CLK", "Input clock"},
	{189, 0, "DEV_CSI_PSILSS0_MAIN_CLK", "Input clock"},
	{72, 0, "DEV_CSI_RX_IF0_MAIN_CLK_CLK", "Input clock"},
	{72, 1, "DEV_CSI_RX_IF0_PPI_D_RX_ULPS_ESC", "Input clock"},
	{72, 2, "DEV_CSI_RX_IF0_PPI_RX_BYTE_CLK", "Input clock"},
	{72, 3, "DEV_CSI_RX_IF0_VBUS_CLK_CLK", "Input clock"},
	{72, 4, "DEV_CSI_RX_IF0_VP_CLK_CLK", "Input clock"},
	{73, 0, "DEV_CSI_RX_IF1_MAIN_CLK_CLK", "Input clock"},
	{73, 1, "DEV_CSI_RX_IF1_PPI_D_RX_ULPS_ESC", "Input clock"},
	{73, 2, "DEV_CSI_RX_IF1_PPI_RX_BYTE_CLK", "Input clock"},
	{73, 3, "DEV_CSI_RX_IF1_VBUS_CLK_CLK", "Input clock"},
	{73, 4, "DEV_CSI_RX_IF1_VP_CLK_CLK", "Input clock"},
	{74, 0, "DEV_CSI_RX_IF2_MAIN_CLK_CLK", "Input clock"},
	{74, 1, "DEV_CSI_RX_IF2_PPI_D_RX_ULPS_ESC", "Input clock"},
	{74, 2, "DEV_CSI_RX_IF2_PPI_RX_BYTE_CLK", "Input clock"},
	{74, 3, "DEV_CSI_RX_IF2_VBUS_CLK_CLK", "Input clock"},
	{74, 4, "DEV_CSI_RX_IF2_VP_CLK_CLK", "Input clock"},
	{75, 2, "DEV_CSI_TX_IF_V2_0_DPHY_TXBYTECLKHS_CL_CLK", "Input clock"},
	{75, 3, "DEV_CSI_TX_IF_V2_0_ESC_CLK_CLK", "Input clock"},
	{75, 4, "DEV_CSI_TX_IF_V2_0_MAIN_CLK_CLK", "Input clock"},
	{75, 5, "DEV_CSI_TX_IF_V2_0_VBUS_CLK_CLK", "Input clock"},
	{76, 2, "DEV_CSI_TX_IF_V2_1_DPHY_TXBYTECLKHS_CL_CLK", "Input clock"},
	{76, 3, "DEV_CSI_TX_IF_V2_1_ESC_CLK_CLK", "Input clock"},
	{76, 4, "DEV_CSI_TX_IF_V2_1_MAIN_CLK_CLK", "Input clock"},
	{76, 5, "DEV_CSI_TX_IF_V2_1_VBUS_CLK_CLK", "Input clock"},
	{78, 0, "DEV_DCC0_DCC_CLKSRC0_CLK", "Input clock"},
	{78, 1, "DEV_DCC0_DCC_CLKSRC1_CLK", "Input clock"},
	{78, 2, "DEV_DCC0_DCC_CLKSRC2_CLK", "Input clock"},
	{78, 3, "DEV_DCC0_DCC_CLKSRC3_CLK", "Input clock"},
	{78, 4, "DEV_DCC0_DCC_CLKSRC4_CLK", "Input clock"},
	{78, 5, "DEV_DCC0_DCC_CLKSRC5_CLK", "Input clock"},
	{78, 6, "DEV_DCC0_DCC_CLKSRC6_CLK", "Input clock"},
	{78, 7, "DEV_DCC0_DCC_CLKSRC7_CLK", "Input clock"},
	{78, 8, "DEV_DCC0_DCC_INPUT00_CLK", "Input clock"},
	{78, 9, "DEV_DCC0_DCC_INPUT01_CLK", "Input clock"},
	{78, 10, "DEV_DCC0_DCC_INPUT02_CLK", "Input clock"},
	{78, 11, "DEV_DCC0_DCC_INPUT10_CLK", "Input clock"},
	{78, 12, "DEV_DCC0_VBUS_CLK", "Input clock"},
	{79, 0, "DEV_DCC1_DCC_CLKSRC0_CLK", "Input clock"},
	{79, 1, "DEV_DCC1_DCC_CLKSRC1_CLK", "Input clock"},
	{79, 2, "DEV_DCC1_DCC_CLKSRC2_CLK", "Input clock"},
	{79, 3, "DEV_DCC1_DCC_CLKSRC3_CLK", "Input clock"},
	{79, 4, "DEV_DCC1_DCC_CLKSRC4_CLK", "Input clock"},
	{79, 5, "DEV_DCC1_DCC_CLKSRC5_CLK", "Input clock"},
	{79, 6, "DEV_DCC1_DCC_CLKSRC6_CLK", "Input clock"},
	{79, 7, "DEV_DCC1_DCC_CLKSRC7_CLK", "Input clock"},
	{79, 8, "DEV_DCC1_DCC_INPUT00_CLK", "Input clock"},
	{79, 9, "DEV_DCC1_DCC_INPUT01_CLK", "Input clock"},
	{79, 10, "DEV_DCC1_DCC_INPUT02_CLK", "Input clock"},
	{79, 11, "DEV_DCC1_DCC_INPUT10_CLK", "Input clock"},
	{79, 12, "DEV_DCC1_VBUS_CLK", "Input clock"},
	{80, 0, "DEV_DCC2_DCC_CLKSRC0_CLK", "Input clock"},
	{80, 1, "DEV_DCC2_DCC_CLKSRC1_CLK", "Input clock"},
	{80, 3, "DEV_DCC2_DCC_CLKSRC3_CLK", "Input clock"},
	{80, 4, "DEV_DCC2_DCC_CLKSRC4_CLK", "Input clock"},
	{80, 5, "DEV_DCC2_DCC_CLKSRC5_CLK", "Input clock"},
	{80, 6, "DEV_DCC2_DCC_CLKSRC6_CLK", "Input clock"},
	{80, 7, "DEV_DCC2_DCC_CLKSRC7_CLK", "Input clock"},
	{80, 8, "DEV_DCC2_DCC_INPUT00_CLK", "Input clock"},
	{80, 9, "DEV_DCC2_DCC_INPUT01_CLK", "Input clock"},
	{80, 10, "DEV_DCC2_DCC_INPUT02_CLK", "Input clock"},
	{80, 11, "DEV_DCC2_DCC_INPUT10_CLK", "Input clock"},
	{80, 12, "DEV_DCC2_VBUS_CLK", "Input clock"},
	{81, 0, "DEV_DCC3_DCC_CLKSRC0_CLK", "Input clock"},
	{81, 1, "DEV_DCC3_DCC_CLKSRC1_CLK", "Input clock"},
	{81, 2, "DEV_DCC3_DCC_CLKSRC2_CLK", "Input clock"},
	{81, 3, "DEV_DCC3_DCC_CLKSRC3_CLK", "Input clock"},
	{81, 5, "DEV_DCC3_DCC_CLKSRC5_CLK", "Input clock"},
	{81, 6, "DEV_DCC3_DCC_CLKSRC6_CLK", "Input clock"},
	{81, 7, "DEV_DCC3_DCC_CLKSRC7_CLK", "Input clock"},
	{81, 8, "DEV_DCC3_DCC_INPUT00_CLK", "Input clock"},
	{81, 9, "DEV_DCC3_DCC_INPUT01_CLK", "Input clock"},
	{81, 10, "DEV_DCC3_DCC_INPUT02_CLK", "Input clock"},
	{81, 11, "DEV_DCC3_DCC_INPUT10_CLK", "Input clock"},
	{81, 12, "DEV_DCC3_VBUS_CLK", "Input clock"},
	{82, 0, "DEV_DCC4_DCC_CLKSRC0_CLK", "Input clock"},
	{82, 1, "DEV_DCC4_DCC_CLKSRC1_CLK", "Input clock"},
	{82, 2, "DEV_DCC4_DCC_CLKSRC2_CLK", "Input clock"},
	{82, 3, "DEV_DCC4_DCC_CLKSRC3_CLK", "Input clock"},
	{82, 4, "DEV_DCC4_DCC_CLKSRC4_CLK", "Input clock"},
	{82, 5, "DEV_DCC4_DCC_CLKSRC5_CLK", "Input clock"},
	{82, 6, "DEV_DCC4_DCC_CLKSRC6_CLK", "Input clock"},
	{82, 7, "DEV_DCC4_DCC_CLKSRC7_CLK", "Input clock"},
	{82, 8, "DEV_DCC4_DCC_INPUT00_CLK", "Input clock"},
	{82, 9, "DEV_DCC4_DCC_INPUT01_CLK", "Input clock"},
	{82, 10, "DEV_DCC4_DCC_INPUT02_CLK", "Input clock"},
	{82, 11, "DEV_DCC4_DCC_INPUT10_CLK", "Input clock"},
	{82, 12, "DEV_DCC4_VBUS_CLK", "Input clock"},
	{83, 1, "DEV_DCC5_DCC_CLKSRC1_CLK", "Input clock"},
	{83, 2, "DEV_DCC5_DCC_CLKSRC2_CLK", "Input clock"},
	{83, 3, "DEV_DCC5_DCC_CLKSRC3_CLK", "Input clock"},
	{83, 4, "DEV_DCC5_DCC_CLKSRC4_CLK", "Input clock"},
	{83, 6, "DEV_DCC5_DCC_CLKSRC6_CLK", "Input clock"},
	{83, 7, "DEV_DCC5_DCC_CLKSRC7_CLK", "Input clock"},
	{83, 8, "DEV_DCC5_DCC_INPUT00_CLK", "Input clock"},
	{83, 9, "DEV_DCC5_DCC_INPUT01_CLK", "Input clock"},
	{83, 10, "DEV_DCC5_DCC_INPUT02_CLK", "Input clock"},
	{83, 11, "DEV_DCC5_DCC_INPUT10_CLK", "Input clock"},
	{83, 12, "DEV_DCC5_VBUS_CLK", "Input clock"},
	{84, 0, "DEV_DCC6_DCC_CLKSRC0_CLK", "Input clock"},
	{84, 1, "DEV_DCC6_DCC_CLKSRC1_CLK", "Input clock"},
	{84, 2, "DEV_DCC6_DCC_CLKSRC2_CLK", "Input clock"},
	{84, 3, "DEV_DCC6_DCC_CLKSRC3_CLK", "Input clock"},
	{84, 4, "DEV_DCC6_DCC_CLKSRC4_CLK", "Input clock"},
	{84, 5, "DEV_DCC6_DCC_CLKSRC5_CLK", "Input clock"},
	{84, 6, "DEV_DCC6_DCC_CLKSRC6_CLK", "Input clock"},
	{84, 7, "DEV_DCC6_DCC_CLKSRC7_CLK", "Input clock"},
	{84, 8, "DEV_DCC6_DCC_INPUT00_CLK", "Input clock"},
	{84, 9, "DEV_DCC6_DCC_INPUT01_CLK", "Input clock"},
	{84, 10, "DEV_DCC6_DCC_INPUT02_CLK", "Input clock"},
	{84, 11, "DEV_DCC6_DCC_INPUT10_CLK", "Input clock"},
	{84, 12, "DEV_DCC6_VBUS_CLK", "Input clock"},
	{85, 0, "DEV_DCC7_DCC_CLKSRC0_CLK", "Input clock"},
	{85, 1, "DEV_DCC7_DCC_CLKSRC1_CLK", "Input clock"},
	{85, 2, "DEV_DCC7_DCC_CLKSRC2_CLK", "Input clock"},
	{85, 5, "DEV_DCC7_DCC_CLKSRC5_CLK", "Input clock"},
	{85, 6, "DEV_DCC7_DCC_CLKSRC6_CLK", "Input clock"},
	{85, 7, "DEV_DCC7_DCC_CLKSRC7_CLK", "Input clock"},
	{85, 8, "DEV_DCC7_DCC_INPUT00_CLK", "Input clock"},
	{85, 9, "DEV_DCC7_DCC_INPUT01_CLK", "Input clock"},
	{85, 10, "DEV_DCC7_DCC_INPUT02_CLK", "Input clock"},
	{85, 11, "DEV_DCC7_DCC_INPUT10_CLK", "Input clock"},
	{85, 12, "DEV_DCC7_VBUS_CLK", "Input clock"},
	{86, 0, "DEV_DCC8_DCC_CLKSRC0_CLK", "Input clock"},
	{86, 1, "DEV_DCC8_DCC_CLKSRC1_CLK", "Input clock"},
	{86, 2, "DEV_DCC8_DCC_CLKSRC2_CLK", "Input clock"},
	{86, 3, "DEV_DCC8_DCC_CLKSRC3_CLK", "Input clock"},
	{86, 4, "DEV_DCC8_DCC_CLKSRC4_CLK", "Input clock"},
	{86, 5, "DEV_DCC8_DCC_CLKSRC5_CLK", "Input clock"},
	{86, 6, "DEV_DCC8_DCC_CLKSRC6_CLK", "Input clock"},
	{86, 7, "DEV_DCC8_DCC_CLKSRC7_CLK", "Input clock"},
	{86, 8, "DEV_DCC8_DCC_INPUT00_CLK", "Input clock"},
	{86, 9, "DEV_DCC8_DCC_INPUT01_CLK", "Input clock"},
	{86, 10, "DEV_DCC8_DCC_INPUT02_CLK", "Input clock"},
	{86, 11, "DEV_DCC8_DCC_INPUT10_CLK", "Input clock"},
	{86, 12, "DEV_DCC8_VBUS_CLK", "Input clock"},
	{87, 0, "DEV_DCC9_DCC_CLKSRC0_CLK", "Input clock"},
	{87, 1, "DEV_DCC9_DCC_CLKSRC1_CLK", "Input clock"},
	{87, 2, "DEV_DCC9_DCC_CLKSRC2_CLK", "Input clock"},
	{87, 3, "DEV_DCC9_DCC_CLKSRC3_CLK", "Input clock"},
	{87, 4, "DEV_DCC9_DCC_CLKSRC4_CLK", "Input clock"},
	{87, 5, "DEV_DCC9_DCC_CLKSRC5_CLK", "Input clock"},
	{87, 6, "DEV_DCC9_DCC_CLKSRC6_CLK", "Input clock"},
	{87, 8, "DEV_DCC9_DCC_INPUT00_CLK", "Input clock"},
	{87, 9, "DEV_DCC9_DCC_INPUT01_CLK", "Input clock"},
	{87, 10, "DEV_DCC9_DCC_INPUT02_CLK", "Input clock"},
	{87, 11, "DEV_DCC9_DCC_INPUT10_CLK", "Input clock"},
	{87, 12, "DEV_DCC9_VBUS_CLK", "Input clock"},
	{191, 0, "DEV_DDR0_DDRSS_CFG_CLK", "Input clock"},
	{191, 1, "DEV_DDR0_DDRSS_DDR_PLL_CLK", "Input clock"},
	{191, 4, "DEV_DDR0_DDRSS_VBUS_CLK", "Input clock"},
	{191, 5, "DEV_DDR0_PLL_CTRL_CLK", "Input clock"},
	{192, 0, "DEV_DDR1_DDRSS_CFG_CLK", "Input clock"},
	{192, 1, "DEV_DDR1_DDRSS_DDR_PLL_CLK", "Input clock"},
	{192, 4, "DEV_DDR1_DDRSS_VBUS_CLK", "Input clock"},
	{192, 5, "DEV_DDR1_PLL_CTRL_CLK", "Input clock"},
	{193, 0, "DEV_DDR2_DDRSS_CFG_CLK", "Input clock"},
	{193, 1, "DEV_DDR2_DDRSS_DDR_PLL_CLK", "Input clock"},
	{193, 4, "DEV_DDR2_DDRSS_VBUS_CLK", "Input clock"},
	{193, 5, "DEV_DDR2_PLL_CTRL_CLK", "Input clock"},
	{194, 0, "DEV_DDR3_DDRSS_CFG_CLK", "Input clock"},
	{194, 1, "DEV_DDR3_DDRSS_DDR_PLL_CLK", "Input clock"},
	{194, 4, "DEV_DDR3_DDRSS_VBUS_CLK", "Input clock"},
	{194, 5, "DEV_DDR3_PLL_CTRL_CLK", "Input clock"},
	{91, 0, "DEV_DEBUGSS_WRAP0_ATB_CLK", "Input clock"},
	{91, 1, "DEV_DEBUGSS_WRAP0_CORE_CLK", "Input clock"},
	{91, 2, "DEV_DEBUGSS_WRAP0_CSTPIU_TRACECLK", "Output clock"},
	{91, 20, "DEV_DEBUGSS_WRAP0_JTAG_TCK", "Input clock"},
	{91, 22, "DEV_DEBUGSS_WRAP0_TREXPT_CLK", "Input clock"},
	{190, 0, "DEV_DEBUGSUSPENDRTR0_INTR_CLK", "Input clock"},
	{92, 0, "DEV_DMPAC0_CLK", "Input clock"},
	{96, 0, "DEV_DMPAC0_SDE_0_CLK", "Input clock"},
	{95, 0, "DEV_DMPAC0_UTC_0_PSIL_LEAF_CLK", "Input clock"},
	{195, 0, "DEV_DMPAC_VPAC_PSILSS0_MAIN_CLK", "Input clock"},
	{212, 2, "DEV_DPHY_RX0_IO_RX_CL_L_M", "Input clock"},
	{212, 3, "DEV_DPHY_RX0_IO_RX_CL_L_P", "Input clock"},
	{212, 4, "DEV_DPHY_RX0_JTAG_TCK", "Input clock"},
	{212, 5, "DEV_DPHY_RX0_MAIN_CLK_CLK", "Input clock"},
	{212, 6, "DEV_DPHY_RX0_PPI_D_RX_ULPS_ESC", "Output clock"},
	{212, 7, "DEV_DPHY_RX0_PPI_RX_BYTE_CLK", "Output clock"},
	{213, 2, "DEV_DPHY_RX1_IO_RX_CL_L_M", "Input clock"},
	{213, 3, "DEV_DPHY_RX1_IO_RX_CL_L_P", "Input clock"},
	{213, 4, "DEV_DPHY_RX1_JTAG_TCK", "Input clock"},
	{213, 5, "DEV_DPHY_RX1_MAIN_CLK_CLK", "Input clock"},
	{213, 6, "DEV_DPHY_RX1_PPI_D_RX_ULPS_ESC", "Output clock"},
	{213, 7, "DEV_DPHY_RX1_PPI_RX_BYTE_CLK", "Output clock"},
	{214, 2, "DEV_DPHY_RX2_IO_RX_CL_L_M", "Input clock"},
	{214, 3, "DEV_DPHY_RX2_IO_RX_CL_L_P", "Input clock"},
	{214, 4, "DEV_DPHY_RX2_JTAG_TCK", "Input clock"},
	{214, 5, "DEV_DPHY_RX2_MAIN_CLK_CLK", "Input clock"},
	{214, 6, "DEV_DPHY_RX2_PPI_D_RX_ULPS_ESC", "Output clock"},
	{214, 7, "DEV_DPHY_RX2_PPI_RX_BYTE_CLK", "Output clock"},
	{402, 0, "DEV_DPHY_TX0_CK_M", "Output clock"},
	{402, 1, "DEV_DPHY_TX0_CK_P", "Output clock"},
	{402, 2, "DEV_DPHY_TX0_CLK", "Input clock"},
	{402, 3, "DEV_DPHY_TX0_DPHY_REF_CLK", "Input muxed clock"},
	{402, 4, "DEV_DPHY_TX0_DPHY_REF_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_DPHY_TX0_DPHY_REF_CLK"},
	{402, 5, "DEV_DPHY_TX0_DPHY_REF_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_DPHY_TX0_DPHY_REF_CLK"},
	{402, 6, "DEV_DPHY_TX0_DPHY_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT4_CLK", "Parent input clock option to DEV_DPHY_TX0_DPHY_REF_CLK"},
	{402, 7, "DEV_DPHY_TX0_DPHY_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT4_CLK", "Parent input clock option to DEV_DPHY_TX0_DPHY_REF_CLK"},
	{402, 8, "DEV_DPHY_TX0_IP1_PPI_M_RXCLKESC_CLK", "Output clock"},
	{402, 9, "DEV_DPHY_TX0_IP1_PPI_M_TXCLKESC_CLK", "Input clock"},
	{402, 10, "DEV_DPHY_TX0_IP1_PPI_TXBYTECLKHS_CL_CLK", "Output clock"},
	{402, 12, "DEV_DPHY_TX0_IP2_PPI_M_TXCLKESC_CLK", "Input clock"},
	{402, 13, "DEV_DPHY_TX0_IP2_PPI_TXBYTECLKHS_CL_CLK", "Output clock"},
	{402, 20, "DEV_DPHY_TX0_PSM_CLK", "Input clock"},
	{402, 24, "DEV_DPHY_TX0_TAP_TCK", "Input clock"},
	{403, 0, "DEV_DPHY_TX1_CK_M", "Output clock"},
	{403, 1, "DEV_DPHY_TX1_CK_P", "Output clock"},
	{403, 2, "DEV_DPHY_TX1_CLK", "Input clock"},
	{403, 3, "DEV_DPHY_TX1_DPHY_REF_CLK", "Input muxed clock"},
	{403, 4, "DEV_DPHY_TX1_DPHY_REF_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_DPHY_TX1_DPHY_REF_CLK"},
	{403, 5, "DEV_DPHY_TX1_DPHY_REF_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_DPHY_TX1_DPHY_REF_CLK"},
	{403, 6, "DEV_DPHY_TX1_DPHY_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT4_CLK", "Parent input clock option to DEV_DPHY_TX1_DPHY_REF_CLK"},
	{403, 7, "DEV_DPHY_TX1_DPHY_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT4_CLK", "Parent input clock option to DEV_DPHY_TX1_DPHY_REF_CLK"},
	{403, 8, "DEV_DPHY_TX1_IP1_PPI_M_RXCLKESC_CLK", "Output clock"},
	{403, 9, "DEV_DPHY_TX1_IP1_PPI_M_TXCLKESC_CLK", "Input clock"},
	{403, 10, "DEV_DPHY_TX1_IP1_PPI_TXBYTECLKHS_CL_CLK", "Output clock"},
	{403, 13, "DEV_DPHY_TX1_IP2_PPI_TXBYTECLKHS_CL_CLK", "Output clock"},
	{403, 20, "DEV_DPHY_TX1_PSM_CLK", "Input clock"},
	{403, 24, "DEV_DPHY_TX1_TAP_TCK", "Input clock"},
	{218, 0, "DEV_DSS0_DSS_FUNC_CLK", "Input clock"},
	{218, 1, "DEV_DSS0_DSS_INST0_DPI_0_IN_CLK", "Input clock"},
	{218, 2, "DEV_DSS0_DSS_INST0_DPI_0_IN_2X_CLK", "Input muxed clock"},
	{218, 3, "DEV_DSS0_DSS_INST0_DPI_0_IN_2X_CLK_PARENT_HSDIV1_16FFT_MAIN_16_HSDIVOUT0_CLK", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_0_IN_2X_CLK"},
	{218, 4, "DEV_DSS0_DSS_INST0_DPI_0_IN_2X_CLK_PARENT_DPI_1_PCLK_SEL_OUT0", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_0_IN_2X_CLK"},
	{218, 5, "DEV_DSS0_DSS_INST0_DPI_1_IN_2X_CLK", "Input muxed clock"},
	{218, 6, "DEV_DSS0_DSS_INST0_DPI_1_IN_2X_CLK_PARENT_HSDIV1_16FFT_MAIN_17_HSDIVOUT0_CLK", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_1_IN_2X_CLK"},
	{218, 7, "DEV_DSS0_DSS_INST0_DPI_1_IN_2X_CLK_PARENT_DPI0_EXT_CLKSEL_OUT0", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_1_IN_2X_CLK"},
	{218, 8, "DEV_DSS0_DSS_INST0_DPI_1_IN_2X_CLK_PARENT_DPI0_EXT_CLKSEL_OUT0_DUP0", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_1_IN_2X_CLK"},
	{218, 9, "DEV_DSS0_DSS_INST0_DPI_1_IN_2X_CLK_PARENT_HSDIV1_16FFT_MAIN_16_HSDIVOUT0_CLK", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_1_IN_2X_CLK"},
	{218, 10, "DEV_DSS0_DSS_INST0_DPI_2_IN_CLK", "Input muxed clock"},
	{218, 11, "DEV_DSS0_DSS_INST0_DPI_2_IN_CLK_PARENT_HSDIV1_16FFT_MAIN_16_HSDIVOUT0_CLK", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_2_IN_CLK"},
	{218, 12, "DEV_DSS0_DSS_INST0_DPI_2_IN_CLK_PARENT_HSDIV1_16FFT_MAIN_17_HSDIVOUT0_CLK", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_2_IN_CLK"},
	{218, 13, "DEV_DSS0_DSS_INST0_DPI_2_IN_CLK_PARENT_DPI0_EXT_CLKSEL_OUT0", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_2_IN_CLK"},
	{218, 14, "DEV_DSS0_DSS_INST0_DPI_2_IN_2X_CLK", "Input muxed clock"},
	{218, 15, "DEV_DSS0_DSS_INST0_DPI_2_IN_2X_CLK_PARENT_HSDIV1_16FFT_MAIN_16_HSDIVOUT0_CLK", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_2_IN_2X_CLK"},
	{218, 16, "DEV_DSS0_DSS_INST0_DPI_2_IN_2X_CLK_PARENT_HSDIV1_16FFT_MAIN_17_HSDIVOUT0_CLK", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_2_IN_2X_CLK"},
	{218, 17, "DEV_DSS0_DSS_INST0_DPI_2_IN_2X_CLK_PARENT_DPI0_EXT_CLKSEL_OUT0", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_2_IN_2X_CLK"},
	{218, 18, "DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK", "Input muxed clock"},
	{218, 19, "DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK_PARENT_HSDIV1_16FFT_MAIN_16_HSDIVOUT1_CLK", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK"},
	{218, 20, "DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK_PARENT_HSDIV1_16FFT_MAIN_17_HSDIVOUT1_CLK", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK"},
	{218, 21, "DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK_PARENT_HSDIV1_16FFT_MAIN_17_HSDIVOUT1_CLK_DUP0", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK"},
	{218, 22, "DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK_PARENT_DPI0_EXT_CLKSEL_OUT0", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK"},
	{218, 23, "DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK_PARENT_DPI0_EXT_CLKSEL_OUT0_DUP0", "Parent input clock option to DEV_DSS0_DSS_INST0_DPI_3_IN_2X_CLK"},
	{218, 24, "DEV_DSS0_DSS_INST0_PARA_1_OUT_CLK", "Output clock"},
	{218, 25, "DEV_DSS0_DSS_INST0_PARA_3_OUT_CLK", "Output clock"},
	{218, 26, "DEV_DSS0_DSS_INST0_DPI_0_OUT_CLK", "Output clock"},
	{218, 27, "DEV_DSS0_DSS_INST0_DPI_1_OUT_CLK", "Output clock"},
	{218, 28, "DEV_DSS0_DSS_INST0_DPI_2_OUT_CLK", "Output clock"},
	{218, 29, "DEV_DSS0_DSS_INST0_DPI_3_OUT_CLK", "Output clock"},
	{218, 30, "DEV_DSS0_DSS_INST0_DPI_0_OUT_2X_CLK", "Output clock"},
	{215, 0, "DEV_DSS_DSI0_DPHY_0_RX_ESC_CLK", "Input clock"},
	{215, 1, "DEV_DSS_DSI0_DPHY_0_TX_ESC_CLK", "Input clock"},
	{215, 2, "DEV_DSS_DSI0_DPI_0_CLK", "Input clock"},
	{215, 3, "DEV_DSS_DSI0_PLL_CTRL_CLK", "Input clock"},
	{215, 4, "DEV_DSS_DSI0_PPI_0_TXBYTECLKHS_CL_CLK", "Input clock"},
	{215, 5, "DEV_DSS_DSI0_SYS_CLK", "Input clock"},
	{216, 0, "DEV_DSS_DSI1_DPHY_0_RX_ESC_CLK", "Input clock"},
	{216, 1, "DEV_DSS_DSI1_DPHY_0_TX_ESC_CLK", "Input clock"},
	{216, 2, "DEV_DSS_DSI1_DPI_0_CLK", "Input clock"},
	{216, 3, "DEV_DSS_DSI1_PLL_CTRL_CLK", "Input clock"},
	{216, 4, "DEV_DSS_DSI1_PPI_0_TXBYTECLKHS_CL_CLK", "Input clock"},
	{216, 5, "DEV_DSS_DSI1_SYS_CLK", "Input clock"},
	{217, 0, "DEV_DSS_EDP0_AIF_I2S_CLK", "Input clock"},
	{217, 6, "DEV_DSS_EDP0_DPI_2_2X_CLK", "Input clock"},
	{217, 7, "DEV_DSS_EDP0_DPI_2_CLK", "Input clock"},
	{217, 8, "DEV_DSS_EDP0_DPI_3_CLK", "Input clock"},
	{217, 9, "DEV_DSS_EDP0_DPI_4_CLK", "Input clock"},
	{217, 10, "DEV_DSS_EDP0_DPI_5_CLK", "Input clock"},
	{217, 11, "DEV_DSS_EDP0_DPTX_MOD_CLK", "Input clock"},
	{217, 12, "DEV_DSS_EDP0_PHY_LN0_REFCLK", "Input clock"},
	{217, 13, "DEV_DSS_EDP0_PHY_LN0_RXCLK", "Input clock"},
	{217, 14, "DEV_DSS_EDP0_PHY_LN0_RXFCLK", "Input clock"},
	{217, 15, "DEV_DSS_EDP0_PHY_LN0_TXCLK", "Output clock"},
	{217, 16, "DEV_DSS_EDP0_PHY_LN0_TXFCLK", "Input clock"},
	{217, 17, "DEV_DSS_EDP0_PHY_LN0_TXMCLK", "Input clock"},
	{217, 18, "DEV_DSS_EDP0_PHY_LN1_REFCLK", "Input clock"},
	{217, 19, "DEV_DSS_EDP0_PHY_LN1_RXCLK", "Input clock"},
	{217, 20, "DEV_DSS_EDP0_PHY_LN1_RXFCLK", "Input clock"},
	{217, 21, "DEV_DSS_EDP0_PHY_LN1_TXCLK", "Output clock"},
	{217, 22, "DEV_DSS_EDP0_PHY_LN1_TXFCLK", "Input clock"},
	{217, 23, "DEV_DSS_EDP0_PHY_LN1_TXMCLK", "Input clock"},
	{217, 24, "DEV_DSS_EDP0_PHY_LN2_REFCLK", "Input clock"},
	{217, 25, "DEV_DSS_EDP0_PHY_LN2_RXCLK", "Input clock"},
	{217, 26, "DEV_DSS_EDP0_PHY_LN2_RXFCLK", "Input clock"},
	{217, 27, "DEV_DSS_EDP0_PHY_LN2_TXCLK", "Output clock"},
	{217, 28, "DEV_DSS_EDP0_PHY_LN2_TXFCLK", "Input clock"},
	{217, 29, "DEV_DSS_EDP0_PHY_LN2_TXMCLK", "Input clock"},
	{217, 30, "DEV_DSS_EDP0_PHY_LN3_REFCLK", "Input clock"},
	{217, 31, "DEV_DSS_EDP0_PHY_LN3_RXCLK", "Input clock"},
	{217, 32, "DEV_DSS_EDP0_PHY_LN3_RXFCLK", "Input clock"},
	{217, 33, "DEV_DSS_EDP0_PHY_LN3_TXCLK", "Output clock"},
	{217, 34, "DEV_DSS_EDP0_PHY_LN3_TXFCLK", "Input clock"},
	{217, 35, "DEV_DSS_EDP0_PHY_LN3_TXMCLK", "Input clock"},
	{217, 36, "DEV_DSS_EDP0_PLL_CTRL_CLK", "Input clock"},
	{126, 0, "DEV_ECAP0_VBUS_CLK", "Input clock"},
	{127, 0, "DEV_ECAP1_VBUS_CLK", "Input clock"},
	{128, 0, "DEV_ECAP2_VBUS_CLK", "Input clock"},
	{130, 0, "DEV_ELM0_VBUSP_CLK", "Input clock"},
	{219, 0, "DEV_EPWM0_VBUSP_CLK", "Input clock"},
	{220, 0, "DEV_EPWM1_VBUSP_CLK", "Input clock"},
	{221, 0, "DEV_EPWM2_VBUSP_CLK", "Input clock"},
	{222, 0, "DEV_EPWM3_VBUSP_CLK", "Input clock"},
	{223, 0, "DEV_EPWM4_VBUSP_CLK", "Input clock"},
	{224, 0, "DEV_EPWM5_VBUSP_CLK", "Input clock"},
	{142, 0, "DEV_EQEP0_VBUS_CLK", "Input clock"},
	{143, 0, "DEV_EQEP1_VBUS_CLK", "Input clock"},
	{144, 0, "DEV_EQEP2_VBUS_CLK", "Input clock"},
	{145, 0, "DEV_ESM0_CLK", "Input clock"},
	{417, 0, "DEV_GLUELOGIC_ACSPCIE0_BUFFER_CLKIN0", "Input clock"},
	{417, 1, "DEV_GLUELOGIC_ACSPCIE0_BUFFER_CLKIN1", "Input clock"},
	{417, 2, "DEV_GLUELOGIC_ACSPCIE0_BUFFER_PAD0_M", "Output clock"},
	{417, 3, "DEV_GLUELOGIC_ACSPCIE0_BUFFER_PAD0_P", "Output clock"},
	{417, 4, "DEV_GLUELOGIC_ACSPCIE0_BUFFER_PAD1_M", "Output clock"},
	{417, 5, "DEV_GLUELOGIC_ACSPCIE0_BUFFER_PAD1_P", "Output clock"},
	{418, 0, "DEV_GLUELOGIC_ACSPCIE1_BUFFER_CLKIN0", "Input clock"},
	{418, 1, "DEV_GLUELOGIC_ACSPCIE1_BUFFER_CLKIN1", "Input clock"},
	{418, 2, "DEV_GLUELOGIC_ACSPCIE1_BUFFER_PAD0_M", "Output clock"},
	{418, 3, "DEV_GLUELOGIC_ACSPCIE1_BUFFER_PAD0_P", "Output clock"},
	{418, 4, "DEV_GLUELOGIC_ACSPCIE1_BUFFER_PAD1_M", "Output clock"},
	{418, 5, "DEV_GLUELOGIC_ACSPCIE1_BUFFER_PAD1_P", "Output clock"},
	{163, 0, "DEV_GPIO0_MMR_CLK", "Input clock"},
	{164, 0, "DEV_GPIO2_MMR_CLK", "Input clock"},
	{165, 0, "DEV_GPIO4_MMR_CLK", "Input clock"},
	{166, 0, "DEV_GPIO6_MMR_CLK", "Input clock"},
	{10, 0, "DEV_GPIOMUX_INTRTR0_INTR_CLK", "Input clock"},
	{169, 0, "DEV_GPMC0_FUNC_CLK", "Input muxed clock"},
	{169, 1, "DEV_GPMC0_FUNC_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT3_CLK", "Parent input clock option to DEV_GPMC0_FUNC_CLK"},
	{169, 2, "DEV_GPMC0_FUNC_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT1_CLK6", "Parent input clock option to DEV_GPMC0_FUNC_CLK"},
	{169, 3, "DEV_GPMC0_FUNC_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT1_CLK4", "Parent input clock option to DEV_GPMC0_FUNC_CLK"},
	{169, 4, "DEV_GPMC0_FUNC_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK4", "Parent input clock option to DEV_GPMC0_FUNC_CLK"},
	{169, 5, "DEV_GPMC0_PI_GPMC_RET_CLK", "Input clock"},
	{169, 6, "DEV_GPMC0_PO_GPMC_DEV_CLK", "Output clock"},
	{169, 7, "DEV_GPMC0_VBUSM_CLK", "Input clock"},
	{61, 0, "DEV_GTC0_GTC_CLK", "Input muxed clock"},
	{61, 1, "DEV_GTC0_GTC_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 2, "DEV_GTC0_GTC_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 3, "DEV_GTC0_GTC_CLK_PARENT_BOARD_0_MCU_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 4, "DEV_GTC0_GTC_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 5, "DEV_GTC0_GTC_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 6, "DEV_GTC0_GTC_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 7, "DEV_GTC0_GTC_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN0_TXMCLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 8, "DEV_GTC0_GTC_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN1_TXMCLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 9, "DEV_GTC0_GTC_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN2_TXMCLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 10, "DEV_GTC0_GTC_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN3_TXMCLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 11, "DEV_GTC0_GTC_CLK_PARENT_WIZ16B8M4CT3_MAIN_1_IP2_LN0_TXMCLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 12, "DEV_GTC0_GTC_CLK_PARENT_WIZ16B8M4CT3_MAIN_1_IP2_LN1_TXMCLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 13, "DEV_GTC0_GTC_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP1_LN2_TXMCLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 14, "DEV_GTC0_GTC_CLK_PARENT_WIZ16B8M4CT3_MAIN_1_IP3_LN2_TXMCLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 15, "DEV_GTC0_GTC_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 16, "DEV_GTC0_GTC_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 17, "DEV_GTC0_VBUSP_CLK", "Input clock"},
	{270, 0, "DEV_I2C0_CLK", "Input clock"},
	{270, 1, "DEV_I2C0_PISCL", "Input clock"},
	{270, 2, "DEV_I2C0_PISYS_CLK", "Input clock"},
	{270, 3, "DEV_I2C0_PORSCL", "Output clock"},
	{271, 0, "DEV_I2C1_CLK", "Input clock"},
	{271, 1, "DEV_I2C1_PISCL", "Input clock"},
	{271, 2, "DEV_I2C1_PISYS_CLK", "Input clock"},
	{271, 3, "DEV_I2C1_PORSCL", "Output clock"},
	{272, 0, "DEV_I2C2_CLK", "Input clock"},
	{272, 1, "DEV_I2C2_PISCL", "Input clock"},
	{272, 2, "DEV_I2C2_PISYS_CLK", "Input clock"},
	{272, 3, "DEV_I2C2_PORSCL", "Output clock"},
	{273, 0, "DEV_I2C3_CLK", "Input clock"},
	{273, 1, "DEV_I2C3_PISCL", "Input clock"},
	{273, 2, "DEV_I2C3_PISYS_CLK", "Input clock"},
	{273, 3, "DEV_I2C3_PORSCL", "Output clock"},
	{274, 0, "DEV_I2C4_CLK", "Input clock"},
	{274, 1, "DEV_I2C4_PISCL", "Input clock"},
	{274, 2, "DEV_I2C4_PISYS_CLK", "Input clock"},
	{274, 3, "DEV_I2C4_PORSCL", "Output clock"},
	{275, 0, "DEV_I2C5_CLK", "Input clock"},
	{275, 1, "DEV_I2C5_PISCL", "Input clock"},
	{275, 2, "DEV_I2C5_PISYS_CLK", "Input clock"},
	{275, 3, "DEV_I2C5_PORSCL", "Output clock"},
	{276, 0, "DEV_I2C6_CLK", "Input clock"},
	{276, 1, "DEV_I2C6_PISCL", "Input clock"},
	{276, 2, "DEV_I2C6_PISYS_CLK", "Input clock"},
	{276, 3, "DEV_I2C6_PORSCL", "Output clock"},
	{181, 1, "DEV_J7AEP_GPU_BXS464_WRAP0_GPU_SS_0_GPU_PLL_CLK", "Input clock"},
	{181, 4, "DEV_J7AEP_GPU_BXS464_WRAP0_GPU_SS_0_PLL_CTRL_CLK", "Input clock"},
	{183, 0, "DEV_J7AM_32_64_ATB_FUNNEL0_DBG_CLK", "Input clock"},
	{184, 0, "DEV_J7AM_32_64_ATB_FUNNEL1_DBG_CLK", "Input clock"},
	{185, 0, "DEV_J7AM_32_64_ATB_FUNNEL2_DBG_CLK", "Input clock"},
	{187, 0, "DEV_J7AM_BOLT_PGD0_WKUP_OSC0_CLK", "Input clock"},
	{188, 0, "DEV_J7AM_BOLT_PSC_WRAP0_CLK", "Input clock"},
	{188, 1, "DEV_J7AM_BOLT_PSC_WRAP0_SLOW_CLK", "Input clock"},
	{197, 0, "DEV_J7AM_HWA_ATB_FUNNEL0_DBG_CLK", "Input clock"},
	{199, 0, "DEV_J7AM_MAIN_16FF0_WKUP_OSC0_CLK", "Input clock"},
	{7, 0, "DEV_J7AM_PULSAR_ATB_FUNNEL0_DBG_CLK", "Input clock"},
	{172, 0, "DEV_LED0_LED_CLK", "Input clock"},
	{172, 1, "DEV_LED0_VBUS_CLK", "Input clock"},
	{173, 0, "DEV_MAIN2MCU_LVL_INTRTR0_INTR_CLK", "Input clock"},
	{174, 0, "DEV_MAIN2MCU_PLS_INTRTR0_INTR_CLK", "Input clock"},
	{245, 0, "DEV_MCAN0_MCANSS_CAN_RXD", "Input clock"},
	{245, 1, "DEV_MCAN0_MCANSS_CCLK_CLK", "Input muxed clock"},
	{245, 2, "DEV_MCAN0_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN0_MCANSS_CCLK_CLK"},
	{245, 3, "DEV_MCAN0_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN0_MCANSS_CCLK_CLK"},
	{245, 4, "DEV_MCAN0_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN0_MCANSS_CCLK_CLK"},
	{245, 5, "DEV_MCAN0_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN0_MCANSS_CCLK_CLK"},
	{245, 6, "DEV_MCAN0_MCANSS_HCLK_CLK", "Input clock"},
	{246, 0, "DEV_MCAN1_MCANSS_CAN_RXD", "Input clock"},
	{246, 1, "DEV_MCAN1_MCANSS_CCLK_CLK", "Input muxed clock"},
	{246, 2, "DEV_MCAN1_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN1_MCANSS_CCLK_CLK"},
	{246, 3, "DEV_MCAN1_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN1_MCANSS_CCLK_CLK"},
	{246, 4, "DEV_MCAN1_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN1_MCANSS_CCLK_CLK"},
	{246, 5, "DEV_MCAN1_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN1_MCANSS_CCLK_CLK"},
	{246, 6, "DEV_MCAN1_MCANSS_HCLK_CLK", "Input clock"},
	{255, 0, "DEV_MCAN10_MCANSS_CAN_RXD", "Input clock"},
	{255, 1, "DEV_MCAN10_MCANSS_CCLK_CLK", "Input muxed clock"},
	{255, 2, "DEV_MCAN10_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN10_MCANSS_CCLK_CLK"},
	{255, 3, "DEV_MCAN10_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN10_MCANSS_CCLK_CLK"},
	{255, 4, "DEV_MCAN10_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN10_MCANSS_CCLK_CLK"},
	{255, 5, "DEV_MCAN10_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN10_MCANSS_CCLK_CLK"},
	{255, 6, "DEV_MCAN10_MCANSS_HCLK_CLK", "Input clock"},
	{256, 0, "DEV_MCAN11_MCANSS_CAN_RXD", "Input clock"},
	{256, 1, "DEV_MCAN11_MCANSS_CCLK_CLK", "Input muxed clock"},
	{256, 2, "DEV_MCAN11_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN11_MCANSS_CCLK_CLK"},
	{256, 3, "DEV_MCAN11_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN11_MCANSS_CCLK_CLK"},
	{256, 4, "DEV_MCAN11_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN11_MCANSS_CCLK_CLK"},
	{256, 5, "DEV_MCAN11_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN11_MCANSS_CCLK_CLK"},
	{256, 6, "DEV_MCAN11_MCANSS_HCLK_CLK", "Input clock"},
	{257, 0, "DEV_MCAN12_MCANSS_CAN_RXD", "Input clock"},
	{257, 1, "DEV_MCAN12_MCANSS_CCLK_CLK", "Input muxed clock"},
	{257, 2, "DEV_MCAN12_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN12_MCANSS_CCLK_CLK"},
	{257, 3, "DEV_MCAN12_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN12_MCANSS_CCLK_CLK"},
	{257, 4, "DEV_MCAN12_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN12_MCANSS_CCLK_CLK"},
	{257, 5, "DEV_MCAN12_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN12_MCANSS_CCLK_CLK"},
	{257, 6, "DEV_MCAN12_MCANSS_HCLK_CLK", "Input clock"},
	{258, 0, "DEV_MCAN13_MCANSS_CAN_RXD", "Input clock"},
	{258, 1, "DEV_MCAN13_MCANSS_CCLK_CLK", "Input muxed clock"},
	{258, 2, "DEV_MCAN13_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN13_MCANSS_CCLK_CLK"},
	{258, 3, "DEV_MCAN13_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN13_MCANSS_CCLK_CLK"},
	{258, 4, "DEV_MCAN13_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN13_MCANSS_CCLK_CLK"},
	{258, 5, "DEV_MCAN13_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN13_MCANSS_CCLK_CLK"},
	{258, 6, "DEV_MCAN13_MCANSS_HCLK_CLK", "Input clock"},
	{259, 0, "DEV_MCAN14_MCANSS_CAN_RXD", "Input clock"},
	{259, 1, "DEV_MCAN14_MCANSS_CCLK_CLK", "Input muxed clock"},
	{259, 2, "DEV_MCAN14_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN14_MCANSS_CCLK_CLK"},
	{259, 3, "DEV_MCAN14_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN14_MCANSS_CCLK_CLK"},
	{259, 4, "DEV_MCAN14_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN14_MCANSS_CCLK_CLK"},
	{259, 5, "DEV_MCAN14_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN14_MCANSS_CCLK_CLK"},
	{259, 6, "DEV_MCAN14_MCANSS_HCLK_CLK", "Input clock"},
	{260, 0, "DEV_MCAN15_MCANSS_CAN_RXD", "Input clock"},
	{260, 1, "DEV_MCAN15_MCANSS_CCLK_CLK", "Input muxed clock"},
	{260, 2, "DEV_MCAN15_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN15_MCANSS_CCLK_CLK"},
	{260, 3, "DEV_MCAN15_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN15_MCANSS_CCLK_CLK"},
	{260, 4, "DEV_MCAN15_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN15_MCANSS_CCLK_CLK"},
	{260, 5, "DEV_MCAN15_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN15_MCANSS_CCLK_CLK"},
	{260, 6, "DEV_MCAN15_MCANSS_HCLK_CLK", "Input clock"},
	{261, 0, "DEV_MCAN16_MCANSS_CAN_RXD", "Input clock"},
	{261, 1, "DEV_MCAN16_MCANSS_CCLK_CLK", "Input muxed clock"},
	{261, 2, "DEV_MCAN16_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN16_MCANSS_CCLK_CLK"},
	{261, 3, "DEV_MCAN16_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN16_MCANSS_CCLK_CLK"},
	{261, 4, "DEV_MCAN16_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN16_MCANSS_CCLK_CLK"},
	{261, 5, "DEV_MCAN16_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN16_MCANSS_CCLK_CLK"},
	{261, 6, "DEV_MCAN16_MCANSS_HCLK_CLK", "Input clock"},
	{262, 0, "DEV_MCAN17_MCANSS_CAN_RXD", "Input clock"},
	{262, 1, "DEV_MCAN17_MCANSS_CCLK_CLK", "Input muxed clock"},
	{262, 2, "DEV_MCAN17_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN17_MCANSS_CCLK_CLK"},
	{262, 3, "DEV_MCAN17_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN17_MCANSS_CCLK_CLK"},
	{262, 4, "DEV_MCAN17_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN17_MCANSS_CCLK_CLK"},
	{262, 5, "DEV_MCAN17_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN17_MCANSS_CCLK_CLK"},
	{262, 6, "DEV_MCAN17_MCANSS_HCLK_CLK", "Input clock"},
	{247, 0, "DEV_MCAN2_MCANSS_CAN_RXD", "Input clock"},
	{247, 1, "DEV_MCAN2_MCANSS_CCLK_CLK", "Input muxed clock"},
	{247, 2, "DEV_MCAN2_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN2_MCANSS_CCLK_CLK"},
	{247, 3, "DEV_MCAN2_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN2_MCANSS_CCLK_CLK"},
	{247, 4, "DEV_MCAN2_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN2_MCANSS_CCLK_CLK"},
	{247, 5, "DEV_MCAN2_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN2_MCANSS_CCLK_CLK"},
	{247, 6, "DEV_MCAN2_MCANSS_HCLK_CLK", "Input clock"},
	{248, 0, "DEV_MCAN3_MCANSS_CAN_RXD", "Input clock"},
	{248, 1, "DEV_MCAN3_MCANSS_CCLK_CLK", "Input muxed clock"},
	{248, 2, "DEV_MCAN3_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN3_MCANSS_CCLK_CLK"},
	{248, 3, "DEV_MCAN3_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN3_MCANSS_CCLK_CLK"},
	{248, 4, "DEV_MCAN3_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN3_MCANSS_CCLK_CLK"},
	{248, 5, "DEV_MCAN3_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN3_MCANSS_CCLK_CLK"},
	{248, 6, "DEV_MCAN3_MCANSS_HCLK_CLK", "Input clock"},
	{249, 0, "DEV_MCAN4_MCANSS_CAN_RXD", "Input clock"},
	{249, 1, "DEV_MCAN4_MCANSS_CCLK_CLK", "Input muxed clock"},
	{249, 2, "DEV_MCAN4_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN4_MCANSS_CCLK_CLK"},
	{249, 3, "DEV_MCAN4_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN4_MCANSS_CCLK_CLK"},
	{249, 4, "DEV_MCAN4_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN4_MCANSS_CCLK_CLK"},
	{249, 5, "DEV_MCAN4_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN4_MCANSS_CCLK_CLK"},
	{249, 6, "DEV_MCAN4_MCANSS_HCLK_CLK", "Input clock"},
	{250, 0, "DEV_MCAN5_MCANSS_CAN_RXD", "Input clock"},
	{250, 1, "DEV_MCAN5_MCANSS_CCLK_CLK", "Input muxed clock"},
	{250, 2, "DEV_MCAN5_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN5_MCANSS_CCLK_CLK"},
	{250, 3, "DEV_MCAN5_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN5_MCANSS_CCLK_CLK"},
	{250, 4, "DEV_MCAN5_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN5_MCANSS_CCLK_CLK"},
	{250, 5, "DEV_MCAN5_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN5_MCANSS_CCLK_CLK"},
	{250, 6, "DEV_MCAN5_MCANSS_HCLK_CLK", "Input clock"},
	{251, 0, "DEV_MCAN6_MCANSS_CAN_RXD", "Input clock"},
	{251, 1, "DEV_MCAN6_MCANSS_CCLK_CLK", "Input muxed clock"},
	{251, 2, "DEV_MCAN6_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN6_MCANSS_CCLK_CLK"},
	{251, 3, "DEV_MCAN6_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN6_MCANSS_CCLK_CLK"},
	{251, 4, "DEV_MCAN6_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN6_MCANSS_CCLK_CLK"},
	{251, 5, "DEV_MCAN6_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN6_MCANSS_CCLK_CLK"},
	{251, 6, "DEV_MCAN6_MCANSS_HCLK_CLK", "Input clock"},
	{252, 0, "DEV_MCAN7_MCANSS_CAN_RXD", "Input clock"},
	{252, 1, "DEV_MCAN7_MCANSS_CCLK_CLK", "Input muxed clock"},
	{252, 2, "DEV_MCAN7_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN7_MCANSS_CCLK_CLK"},
	{252, 3, "DEV_MCAN7_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN7_MCANSS_CCLK_CLK"},
	{252, 4, "DEV_MCAN7_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN7_MCANSS_CCLK_CLK"},
	{252, 5, "DEV_MCAN7_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN7_MCANSS_CCLK_CLK"},
	{252, 6, "DEV_MCAN7_MCANSS_HCLK_CLK", "Input clock"},
	{253, 0, "DEV_MCAN8_MCANSS_CAN_RXD", "Input clock"},
	{253, 1, "DEV_MCAN8_MCANSS_CCLK_CLK", "Input muxed clock"},
	{253, 2, "DEV_MCAN8_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN8_MCANSS_CCLK_CLK"},
	{253, 3, "DEV_MCAN8_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN8_MCANSS_CCLK_CLK"},
	{253, 4, "DEV_MCAN8_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN8_MCANSS_CCLK_CLK"},
	{253, 5, "DEV_MCAN8_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN8_MCANSS_CCLK_CLK"},
	{253, 6, "DEV_MCAN8_MCANSS_HCLK_CLK", "Input clock"},
	{254, 0, "DEV_MCAN9_MCANSS_CAN_RXD", "Input clock"},
	{254, 1, "DEV_MCAN9_MCANSS_CCLK_CLK", "Input muxed clock"},
	{254, 2, "DEV_MCAN9_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN9_MCANSS_CCLK_CLK"},
	{254, 3, "DEV_MCAN9_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN9_MCANSS_CCLK_CLK"},
	{254, 4, "DEV_MCAN9_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN9_MCANSS_CCLK_CLK"},
	{254, 5, "DEV_MCAN9_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN9_MCANSS_CCLK_CLK"},
	{254, 6, "DEV_MCAN9_MCANSS_HCLK_CLK", "Input clock"},
	{265, 0, "DEV_MCASP0_AUX_CLK", "Input muxed clock"},
	{265, 1, "DEV_MCASP0_AUX_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP0_AUX_CLK"},
	{265, 2, "DEV_MCASP0_AUX_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCASP0_AUX_CLK"},
	{265, 5, "DEV_MCASP0_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP0_AUX_CLK"},
	{265, 6, "DEV_MCASP0_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP0_AUX_CLK"},
	{265, 7, "DEV_MCASP0_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP0_AUX_CLK"},
	{265, 8, "DEV_MCASP0_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP0_AUX_CLK"},
	{265, 9, "DEV_MCASP0_MCASP_ACLKR_PIN", "Input clock"},
	{265, 10, "DEV_MCASP0_MCASP_ACLKR_POUT", "Output clock"},
	{265, 11, "DEV_MCASP0_MCASP_ACLKX_PIN", "Input clock"},
	{265, 12, "DEV_MCASP0_MCASP_ACLKX_POUT", "Output clock"},
	{265, 13, "DEV_MCASP0_MCASP_AFSR_POUT", "Output clock"},
	{265, 14, "DEV_MCASP0_MCASP_AFSX_POUT", "Output clock"},
	{265, 15, "DEV_MCASP0_MCASP_AHCLKR_PIN", "Input muxed clock"},
	{265, 16, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{265, 17, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{265, 18, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{265, 19, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{265, 24, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{265, 25, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{265, 26, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{265, 27, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{265, 32, "DEV_MCASP0_MCASP_AHCLKR_POUT", "Output clock"},
	{265, 33, "DEV_MCASP0_MCASP_AHCLKX_PIN", "Input muxed clock"},
	{265, 34, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{265, 35, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{265, 36, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{265, 37, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{265, 42, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{265, 43, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{265, 44, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{265, 45, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{265, 50, "DEV_MCASP0_MCASP_AHCLKX_POUT", "Output clock"},
	{265, 51, "DEV_MCASP0_VBUSP_CLK", "Input clock"},
	{266, 0, "DEV_MCASP1_AUX_CLK", "Input muxed clock"},
	{266, 1, "DEV_MCASP1_AUX_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP1_AUX_CLK"},
	{266, 2, "DEV_MCASP1_AUX_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCASP1_AUX_CLK"},
	{266, 5, "DEV_MCASP1_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP1_AUX_CLK"},
	{266, 6, "DEV_MCASP1_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP1_AUX_CLK"},
	{266, 7, "DEV_MCASP1_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP1_AUX_CLK"},
	{266, 8, "DEV_MCASP1_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP1_AUX_CLK"},
	{266, 9, "DEV_MCASP1_MCASP_ACLKR_PIN", "Input clock"},
	{266, 10, "DEV_MCASP1_MCASP_ACLKR_POUT", "Output clock"},
	{266, 11, "DEV_MCASP1_MCASP_ACLKX_PIN", "Input clock"},
	{266, 12, "DEV_MCASP1_MCASP_ACLKX_POUT", "Output clock"},
	{266, 13, "DEV_MCASP1_MCASP_AFSR_POUT", "Output clock"},
	{266, 14, "DEV_MCASP1_MCASP_AFSX_POUT", "Output clock"},
	{266, 15, "DEV_MCASP1_MCASP_AHCLKR_PIN", "Input muxed clock"},
	{266, 16, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{266, 17, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{266, 18, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{266, 19, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{266, 24, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{266, 25, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{266, 26, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{266, 27, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{266, 32, "DEV_MCASP1_MCASP_AHCLKR_POUT", "Output clock"},
	{266, 33, "DEV_MCASP1_MCASP_AHCLKX_PIN", "Input muxed clock"},
	{266, 34, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{266, 35, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{266, 36, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{266, 37, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{266, 42, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{266, 43, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{266, 44, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{266, 45, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{266, 50, "DEV_MCASP1_MCASP_AHCLKX_POUT", "Output clock"},
	{266, 51, "DEV_MCASP1_VBUSP_CLK", "Input clock"},
	{267, 0, "DEV_MCASP2_AUX_CLK", "Input muxed clock"},
	{267, 1, "DEV_MCASP2_AUX_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP2_AUX_CLK"},
	{267, 2, "DEV_MCASP2_AUX_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCASP2_AUX_CLK"},
	{267, 5, "DEV_MCASP2_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP2_AUX_CLK"},
	{267, 6, "DEV_MCASP2_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP2_AUX_CLK"},
	{267, 7, "DEV_MCASP2_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP2_AUX_CLK"},
	{267, 8, "DEV_MCASP2_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP2_AUX_CLK"},
	{267, 9, "DEV_MCASP2_MCASP_ACLKR_PIN", "Input clock"},
	{267, 10, "DEV_MCASP2_MCASP_ACLKR_POUT", "Output clock"},
	{267, 11, "DEV_MCASP2_MCASP_ACLKX_PIN", "Input clock"},
	{267, 12, "DEV_MCASP2_MCASP_ACLKX_POUT", "Output clock"},
	{267, 13, "DEV_MCASP2_MCASP_AFSR_POUT", "Output clock"},
	{267, 14, "DEV_MCASP2_MCASP_AFSX_POUT", "Output clock"},
	{267, 15, "DEV_MCASP2_MCASP_AHCLKR_PIN", "Input muxed clock"},
	{267, 16, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{267, 17, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{267, 18, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{267, 19, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{267, 24, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{267, 25, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{267, 26, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{267, 27, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{267, 32, "DEV_MCASP2_MCASP_AHCLKR_POUT", "Output clock"},
	{267, 33, "DEV_MCASP2_MCASP_AHCLKX_PIN", "Input muxed clock"},
	{267, 34, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{267, 35, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{267, 36, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{267, 37, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{267, 42, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{267, 43, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{267, 44, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{267, 45, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{267, 50, "DEV_MCASP2_MCASP_AHCLKX_POUT", "Output clock"},
	{267, 51, "DEV_MCASP2_VBUSP_CLK", "Input clock"},
	{268, 0, "DEV_MCASP3_AUX_CLK", "Input muxed clock"},
	{268, 1, "DEV_MCASP3_AUX_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP3_AUX_CLK"},
	{268, 2, "DEV_MCASP3_AUX_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCASP3_AUX_CLK"},
	{268, 5, "DEV_MCASP3_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP3_AUX_CLK"},
	{268, 6, "DEV_MCASP3_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP3_AUX_CLK"},
	{268, 7, "DEV_MCASP3_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP3_AUX_CLK"},
	{268, 8, "DEV_MCASP3_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP3_AUX_CLK"},
	{268, 9, "DEV_MCASP3_MCASP_ACLKR_PIN", "Input clock"},
	{268, 10, "DEV_MCASP3_MCASP_ACLKR_POUT", "Output clock"},
	{268, 11, "DEV_MCASP3_MCASP_ACLKX_PIN", "Input clock"},
	{268, 12, "DEV_MCASP3_MCASP_ACLKX_POUT", "Output clock"},
	{268, 13, "DEV_MCASP3_MCASP_AFSR_POUT", "Output clock"},
	{268, 14, "DEV_MCASP3_MCASP_AFSX_POUT", "Output clock"},
	{268, 15, "DEV_MCASP3_MCASP_AHCLKR_PIN", "Input muxed clock"},
	{268, 16, "DEV_MCASP3_MCASP_AHCLKR_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKR_PIN"},
	{268, 17, "DEV_MCASP3_MCASP_AHCLKR_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKR_PIN"},
	{268, 18, "DEV_MCASP3_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKR_PIN"},
	{268, 19, "DEV_MCASP3_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKR_PIN"},
	{268, 24, "DEV_MCASP3_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKR_PIN"},
	{268, 25, "DEV_MCASP3_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKR_PIN"},
	{268, 26, "DEV_MCASP3_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKR_PIN"},
	{268, 27, "DEV_MCASP3_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKR_PIN"},
	{268, 32, "DEV_MCASP3_MCASP_AHCLKR_POUT", "Output clock"},
	{268, 33, "DEV_MCASP3_MCASP_AHCLKX_PIN", "Input muxed clock"},
	{268, 34, "DEV_MCASP3_MCASP_AHCLKX_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKX_PIN"},
	{268, 35, "DEV_MCASP3_MCASP_AHCLKX_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKX_PIN"},
	{268, 36, "DEV_MCASP3_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKX_PIN"},
	{268, 37, "DEV_MCASP3_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKX_PIN"},
	{268, 42, "DEV_MCASP3_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKX_PIN"},
	{268, 43, "DEV_MCASP3_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKX_PIN"},
	{268, 44, "DEV_MCASP3_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKX_PIN"},
	{268, 45, "DEV_MCASP3_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP3_MCASP_AHCLKX_PIN"},
	{268, 50, "DEV_MCASP3_MCASP_AHCLKX_POUT", "Output clock"},
	{268, 51, "DEV_MCASP3_VBUSP_CLK", "Input clock"},
	{269, 0, "DEV_MCASP4_AUX_CLK", "Input muxed clock"},
	{269, 1, "DEV_MCASP4_AUX_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP4_AUX_CLK"},
	{269, 2, "DEV_MCASP4_AUX_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCASP4_AUX_CLK"},
	{269, 5, "DEV_MCASP4_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP4_AUX_CLK"},
	{269, 6, "DEV_MCASP4_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP4_AUX_CLK"},
	{269, 7, "DEV_MCASP4_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP4_AUX_CLK"},
	{269, 8, "DEV_MCASP4_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP4_AUX_CLK"},
	{269, 9, "DEV_MCASP4_MCASP_ACLKR_PIN", "Input clock"},
	{269, 10, "DEV_MCASP4_MCASP_ACLKR_POUT", "Output clock"},
	{269, 11, "DEV_MCASP4_MCASP_ACLKX_PIN", "Input clock"},
	{269, 12, "DEV_MCASP4_MCASP_ACLKX_POUT", "Output clock"},
	{269, 13, "DEV_MCASP4_MCASP_AFSR_POUT", "Output clock"},
	{269, 14, "DEV_MCASP4_MCASP_AFSX_POUT", "Output clock"},
	{269, 15, "DEV_MCASP4_MCASP_AHCLKR_PIN", "Input muxed clock"},
	{269, 16, "DEV_MCASP4_MCASP_AHCLKR_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKR_PIN"},
	{269, 17, "DEV_MCASP4_MCASP_AHCLKR_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKR_PIN"},
	{269, 18, "DEV_MCASP4_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKR_PIN"},
	{269, 19, "DEV_MCASP4_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKR_PIN"},
	{269, 24, "DEV_MCASP4_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKR_PIN"},
	{269, 25, "DEV_MCASP4_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKR_PIN"},
	{269, 26, "DEV_MCASP4_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKR_PIN"},
	{269, 27, "DEV_MCASP4_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKR_PIN"},
	{269, 32, "DEV_MCASP4_MCASP_AHCLKR_POUT", "Output clock"},
	{269, 33, "DEV_MCASP4_MCASP_AHCLKX_PIN", "Input muxed clock"},
	{269, 34, "DEV_MCASP4_MCASP_AHCLKX_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKX_PIN"},
	{269, 35, "DEV_MCASP4_MCASP_AHCLKX_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKX_PIN"},
	{269, 36, "DEV_MCASP4_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKX_PIN"},
	{269, 37, "DEV_MCASP4_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKX_PIN"},
	{269, 42, "DEV_MCASP4_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKX_PIN"},
	{269, 43, "DEV_MCASP4_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKX_PIN"},
	{269, 44, "DEV_MCASP4_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKX_PIN"},
	{269, 45, "DEV_MCASP4_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP4_MCASP_AHCLKX_PIN"},
	{269, 50, "DEV_MCASP4_MCASP_AHCLKX_POUT", "Output clock"},
	{269, 51, "DEV_MCASP4_VBUSP_CLK", "Input clock"},
	{376, 0, "DEV_MCSPI0_CLKSPIREF_CLK", "Input clock"},
	{376, 1, "DEV_MCSPI0_IO_CLKSPII_CLK", "Input muxed clock"},
	{376, 2, "DEV_MCSPI0_IO_CLKSPII_CLK_PARENT_BOARD_0_SPI0_CLK_OUT", "Parent input clock option to DEV_MCSPI0_IO_CLKSPII_CLK"},
	{376, 3, "DEV_MCSPI0_IO_CLKSPII_CLK_PARENT_SPI_MAIN_0_IO_CLKSPIO_CLK", "Parent input clock option to DEV_MCSPI0_IO_CLKSPII_CLK"},
	{376, 4, "DEV_MCSPI0_IO_CLKSPIO_CLK", "Output clock"},
	{376, 5, "DEV_MCSPI0_VBUSP_CLK", "Input clock"},
	{377, 0, "DEV_MCSPI1_CLKSPIREF_CLK", "Input clock"},
	{377, 1, "DEV_MCSPI1_IO_CLKSPII_CLK", "Input muxed clock"},
	{377, 2, "DEV_MCSPI1_IO_CLKSPII_CLK_PARENT_BOARD_0_SPI1_CLK_OUT", "Parent input clock option to DEV_MCSPI1_IO_CLKSPII_CLK"},
	{377, 3, "DEV_MCSPI1_IO_CLKSPII_CLK_PARENT_SPI_MAIN_1_IO_CLKSPIO_CLK", "Parent input clock option to DEV_MCSPI1_IO_CLKSPII_CLK"},
	{377, 4, "DEV_MCSPI1_IO_CLKSPIO_CLK", "Output clock"},
	{377, 5, "DEV_MCSPI1_VBUSP_CLK", "Input clock"},
	{378, 0, "DEV_MCSPI2_CLKSPIREF_CLK", "Input clock"},
	{378, 1, "DEV_MCSPI2_IO_CLKSPII_CLK", "Input muxed clock"},
	{378, 2, "DEV_MCSPI2_IO_CLKSPII_CLK_PARENT_BOARD_0_SPI2_CLK_OUT", "Parent input clock option to DEV_MCSPI2_IO_CLKSPII_CLK"},
	{378, 3, "DEV_MCSPI2_IO_CLKSPII_CLK_PARENT_SPI_MAIN_2_IO_CLKSPIO_CLK", "Parent input clock option to DEV_MCSPI2_IO_CLKSPII_CLK"},
	{378, 4, "DEV_MCSPI2_IO_CLKSPIO_CLK", "Output clock"},
	{378, 5, "DEV_MCSPI2_VBUSP_CLK", "Input clock"},
	{379, 0, "DEV_MCSPI3_CLKSPIREF_CLK", "Input clock"},
	{379, 1, "DEV_MCSPI3_IO_CLKSPII_CLK", "Input muxed clock"},
	{379, 2, "DEV_MCSPI3_IO_CLKSPII_CLK_PARENT_SPI_MAIN_3_IO_CLKSPIO_CLK", "Parent input clock option to DEV_MCSPI3_IO_CLKSPII_CLK"},
	{379, 3, "DEV_MCSPI3_IO_CLKSPII_CLK_PARENT_SPI3_CLK_LPBK_MUX_OUT0", "Parent input clock option to DEV_MCSPI3_IO_CLKSPII_CLK"},
	{379, 4, "DEV_MCSPI3_IO_CLKSPIO_CLK", "Output clock"},
	{379, 5, "DEV_MCSPI3_VBUSP_CLK", "Input clock"},
	{380, 0, "DEV_MCSPI4_CLKSPIREF_CLK", "Input clock"},
	{380, 1, "DEV_MCSPI4_IO_CLKSPII_CLK", "Input clock"},
	{380, 2, "DEV_MCSPI4_IO_CLKSPIO_CLK", "Output clock"},
	{380, 3, "DEV_MCSPI4_VBUSP_CLK", "Input clock"},
	{381, 0, "DEV_MCSPI5_CLKSPIREF_CLK", "Input clock"},
	{381, 1, "DEV_MCSPI5_IO_CLKSPII_CLK", "Input muxed clock"},
	{381, 2, "DEV_MCSPI5_IO_CLKSPII_CLK_PARENT_BOARD_0_SPI5_CLK_OUT", "Parent input clock option to DEV_MCSPI5_IO_CLKSPII_CLK"},
	{381, 3, "DEV_MCSPI5_IO_CLKSPII_CLK_PARENT_SPI_MAIN_5_IO_CLKSPIO_CLK", "Parent input clock option to DEV_MCSPI5_IO_CLKSPII_CLK"},
	{381, 4, "DEV_MCSPI5_IO_CLKSPIO_CLK", "Output clock"},
	{381, 5, "DEV_MCSPI5_VBUSP_CLK", "Input clock"},
	{382, 0, "DEV_MCSPI6_CLKSPIREF_CLK", "Input clock"},
	{382, 1, "DEV_MCSPI6_IO_CLKSPII_CLK", "Input muxed clock"},
	{382, 2, "DEV_MCSPI6_IO_CLKSPII_CLK_PARENT_BOARD_0_SPI6_CLK_OUT", "Parent input clock option to DEV_MCSPI6_IO_CLKSPII_CLK"},
	{382, 3, "DEV_MCSPI6_IO_CLKSPII_CLK_PARENT_SPI_MAIN_6_IO_CLKSPIO_CLK", "Parent input clock option to DEV_MCSPI6_IO_CLKSPII_CLK"},
	{382, 4, "DEV_MCSPI6_IO_CLKSPIO_CLK", "Output clock"},
	{382, 5, "DEV_MCSPI6_VBUSP_CLK", "Input clock"},
	{383, 0, "DEV_MCSPI7_CLKSPIREF_CLK", "Input clock"},
	{383, 1, "DEV_MCSPI7_IO_CLKSPII_CLK", "Input muxed clock"},
	{383, 2, "DEV_MCSPI7_IO_CLKSPII_CLK_PARENT_BOARD_0_SPI7_CLK_OUT", "Parent input clock option to DEV_MCSPI7_IO_CLKSPII_CLK"},
	{383, 3, "DEV_MCSPI7_IO_CLKSPII_CLK_PARENT_SPI_MAIN_7_IO_CLKSPIO_CLK", "Parent input clock option to DEV_MCSPI7_IO_CLKSPII_CLK"},
	{383, 4, "DEV_MCSPI7_IO_CLKSPIO_CLK", "Output clock"},
	{383, 5, "DEV_MCSPI7_VBUSP_CLK", "Input clock"},
	{0, 0, "DEV_MCU_ADC12FC_16FFC0_ADC_CLK", "Input muxed clock"},
	{0, 1, "DEV_MCU_ADC12FC_16FFC0_ADC_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_ADC12FC_16FFC0_ADC_CLK"},
	{0, 2, "DEV_MCU_ADC12FC_16FFC0_ADC_CLK_PARENT_HSDIV4_16FFT_MCU_1_HSDIVOUT1_CLK", "Parent input clock option to DEV_MCU_ADC12FC_16FFC0_ADC_CLK"},
	{0, 3, "DEV_MCU_ADC12FC_16FFC0_ADC_CLK_PARENT_HSDIV1_16FFT_MCU_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_MCU_ADC12FC_16FFC0_ADC_CLK"},
	{0, 4, "DEV_MCU_ADC12FC_16FFC0_ADC_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_ADC12FC_16FFC0_ADC_CLK"},
	{0, 5, "DEV_MCU_ADC12FC_16FFC0_SYS_CLK", "Input clock"},
	{0, 6, "DEV_MCU_ADC12FC_16FFC0_VBUS_CLK", "Input clock"},
	{1, 0, "DEV_MCU_ADC12FC_16FFC1_ADC_CLK", "Input muxed clock"},
	{1, 1, "DEV_MCU_ADC12FC_16FFC1_ADC_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_ADC12FC_16FFC1_ADC_CLK"},
	{1, 2, "DEV_MCU_ADC12FC_16FFC1_ADC_CLK_PARENT_HSDIV4_16FFT_MCU_1_HSDIVOUT1_CLK", "Parent input clock option to DEV_MCU_ADC12FC_16FFC1_ADC_CLK"},
	{1, 3, "DEV_MCU_ADC12FC_16FFC1_ADC_CLK_PARENT_HSDIV1_16FFT_MCU_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_MCU_ADC12FC_16FFC1_ADC_CLK"},
	{1, 4, "DEV_MCU_ADC12FC_16FFC1_ADC_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_ADC12FC_16FFC1_ADC_CLK"},
	{1, 5, "DEV_MCU_ADC12FC_16FFC1_SYS_CLK", "Input clock"},
	{1, 6, "DEV_MCU_ADC12FC_16FFC1_VBUS_CLK", "Input clock"},
	{63, 0, "DEV_MCU_CPSW0_CPPI_CLK_CLK", "Input clock"},
	{63, 1, "DEV_MCU_CPSW0_CPTS_GENF0", "Output clock"},
	{63, 3, "DEV_MCU_CPSW0_CPTS_RFT_CLK", "Input muxed clock"},
	{63, 4, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{63, 5, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{63, 6, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_MCU_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{63, 7, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{63, 8, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{63, 9, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{63, 10, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN0_TXMCLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{63, 11, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN1_TXMCLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{63, 12, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN2_TXMCLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{63, 13, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN3_TXMCLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{63, 14, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT3_MAIN_1_IP2_LN0_TXMCLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{63, 15, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT3_MAIN_1_IP2_LN1_TXMCLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{63, 16, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP1_LN2_TXMCLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{63, 17, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT3_MAIN_1_IP3_LN2_TXMCLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{63, 18, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{63, 19, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK2", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{63, 20, "DEV_MCU_CPSW0_GMII1_MR_CLK", "Input clock"},
	{63, 21, "DEV_MCU_CPSW0_GMII1_MT_CLK", "Input clock"},
	{63, 22, "DEV_MCU_CPSW0_GMII_RFT_CLK", "Input clock"},
	{63, 23, "DEV_MCU_CPSW0_MDIO_MDCLK_O", "Output clock"},
	{63, 24, "DEV_MCU_CPSW0_RGMII1_RXC_I", "Input clock"},
	{63, 26, "DEV_MCU_CPSW0_RGMII1_TXC_O", "Output clock"},
	{63, 27, "DEV_MCU_CPSW0_RGMII_MHZ_250_CLK", "Input clock"},
	{63, 28, "DEV_MCU_CPSW0_RGMII_MHZ_50_CLK", "Input clock"},
	{63, 29, "DEV_MCU_CPSW0_RGMII_MHZ_5_CLK", "Input clock"},
	{63, 30, "DEV_MCU_CPSW0_RMII_MHZ_50_CLK", "Input clock"},
	{71, 0, "DEV_MCU_CPT2_AGGR0_VCLK_CLK", "Input clock"},
	{88, 0, "DEV_MCU_DCC0_DCC_CLKSRC0_CLK", "Input clock"},
	{88, 1, "DEV_MCU_DCC0_DCC_CLKSRC1_CLK", "Input clock"},
	{88, 2, "DEV_MCU_DCC0_DCC_CLKSRC2_CLK", "Input clock"},
	{88, 3, "DEV_MCU_DCC0_DCC_CLKSRC3_CLK", "Input clock"},
	{88, 4, "DEV_MCU_DCC0_DCC_CLKSRC4_CLK", "Input clock"},
	{88, 5, "DEV_MCU_DCC0_DCC_CLKSRC5_CLK", "Input clock"},
	{88, 6, "DEV_MCU_DCC0_DCC_CLKSRC6_CLK", "Input clock"},
	{88, 7, "DEV_MCU_DCC0_DCC_CLKSRC7_CLK", "Input clock"},
	{88, 8, "DEV_MCU_DCC0_DCC_INPUT00_CLK", "Input clock"},
	{88, 9, "DEV_MCU_DCC0_DCC_INPUT01_CLK", "Input clock"},
	{88, 10, "DEV_MCU_DCC0_DCC_INPUT02_CLK", "Input clock"},
	{88, 11, "DEV_MCU_DCC0_DCC_INPUT10_CLK", "Input clock"},
	{88, 12, "DEV_MCU_DCC0_VBUS_CLK", "Input clock"},
	{89, 0, "DEV_MCU_DCC1_DCC_CLKSRC0_CLK", "Input clock"},
	{89, 1, "DEV_MCU_DCC1_DCC_CLKSRC1_CLK", "Input clock"},
	{89, 2, "DEV_MCU_DCC1_DCC_CLKSRC2_CLK", "Input clock"},
	{89, 3, "DEV_MCU_DCC1_DCC_CLKSRC3_CLK", "Input clock"},
	{89, 4, "DEV_MCU_DCC1_DCC_CLKSRC4_CLK", "Input clock"},
	{89, 5, "DEV_MCU_DCC1_DCC_CLKSRC5_CLK", "Input clock"},
	{89, 6, "DEV_MCU_DCC1_DCC_CLKSRC6_CLK", "Input clock"},
	{89, 7, "DEV_MCU_DCC1_DCC_CLKSRC7_CLK", "Input clock"},
	{89, 8, "DEV_MCU_DCC1_DCC_INPUT00_CLK", "Input clock"},
	{89, 9, "DEV_MCU_DCC1_DCC_INPUT01_CLK", "Input clock"},
	{89, 10, "DEV_MCU_DCC1_DCC_INPUT02_CLK", "Input clock"},
	{89, 11, "DEV_MCU_DCC1_DCC_INPUT10_CLK", "Input clock"},
	{89, 12, "DEV_MCU_DCC1_VBUS_CLK", "Input clock"},
	{90, 0, "DEV_MCU_DCC2_DCC_CLKSRC0_CLK", "Input clock"},
	{90, 1, "DEV_MCU_DCC2_DCC_CLKSRC1_CLK", "Input clock"},
	{90, 2, "DEV_MCU_DCC2_DCC_CLKSRC2_CLK", "Input clock"},
	{90, 3, "DEV_MCU_DCC2_DCC_CLKSRC3_CLK", "Input clock"},
	{90, 4, "DEV_MCU_DCC2_DCC_CLKSRC4_CLK", "Input clock"},
	{90, 6, "DEV_MCU_DCC2_DCC_CLKSRC6_CLK", "Input clock"},
	{90, 7, "DEV_MCU_DCC2_DCC_CLKSRC7_CLK", "Input clock"},
	{90, 8, "DEV_MCU_DCC2_DCC_INPUT00_CLK", "Input clock"},
	{90, 9, "DEV_MCU_DCC2_DCC_INPUT01_CLK", "Input clock"},
	{90, 10, "DEV_MCU_DCC2_DCC_INPUT02_CLK", "Input clock"},
	{90, 11, "DEV_MCU_DCC2_DCC_INPUT10_CLK", "Input clock"},
	{90, 12, "DEV_MCU_DCC2_VBUS_CLK", "Input clock"},
	{148, 0, "DEV_MCU_ESM0_CLK", "Input clock"},
	{158, 0, "DEV_MCU_FSS0_FSAS_0_GCLK", "Input clock"},
	{160, 0, "DEV_MCU_FSS0_HYPERBUS1P0_0_CBA_CLK", "Input clock"},
	{160, 2, "DEV_MCU_FSS0_HYPERBUS1P0_0_HPB_CLKX1_CLK", "Input clock"},
	{160, 4, "DEV_MCU_FSS0_HYPERBUS1P0_0_HPB_CLKX1_INV_CLK", "Input clock"},
	{160, 6, "DEV_MCU_FSS0_HYPERBUS1P0_0_HPB_CLKX2_CLK", "Input clock"},
	{160, 8, "DEV_MCU_FSS0_HYPERBUS1P0_0_HPB_CLKX2_INV_CLK", "Input clock"},
	{160, 10, "DEV_MCU_FSS0_HYPERBUS1P0_0_HPB_OUT_CLK_N", "Output clock"},
	{160, 11, "DEV_MCU_FSS0_HYPERBUS1P0_0_HPB_OUT_CLK_P", "Output clock"},
	{161, 0, "DEV_MCU_FSS0_OSPI_0_OSPI_DQS_CLK", "Input clock"},
	{161, 1, "DEV_MCU_FSS0_OSPI_0_OSPI_HCLK_CLK", "Input clock"},
	{161, 2, "DEV_MCU_FSS0_OSPI_0_OSPI_ICLK_CLK", "Input muxed clock"},
	{161, 3, "DEV_MCU_FSS0_OSPI_0_OSPI_ICLK_CLK_PARENT_BOARD_0_MCU_OSPI0_DQS_OUT", "Parent input clock option to DEV_MCU_FSS0_OSPI_0_OSPI_ICLK_CLK"},
	{161, 4, "DEV_MCU_FSS0_OSPI_0_OSPI_ICLK_CLK_PARENT_FSS_MCU_0_OSPI_0_OSPI_OCLK_CLK", "Parent input clock option to DEV_MCU_FSS0_OSPI_0_OSPI_ICLK_CLK"},
	{161, 5, "DEV_MCU_FSS0_OSPI_0_OSPI_OCLK_CLK", "Output clock"},
	{161, 6, "DEV_MCU_FSS0_OSPI_0_OSPI_PCLK_CLK", "Input clock"},
	{161, 7, "DEV_MCU_FSS0_OSPI_0_OSPI_RCLK_CLK", "Input muxed clock"},
	{161, 8, "DEV_MCU_FSS0_OSPI_0_OSPI_RCLK_CLK_PARENT_HSDIV4_16FFT_MCU_1_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCU_FSS0_OSPI_0_OSPI_RCLK_CLK"},
	{161, 9, "DEV_MCU_FSS0_OSPI_0_OSPI_RCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCU_FSS0_OSPI_0_OSPI_RCLK_CLK"},
	{162, 0, "DEV_MCU_FSS0_OSPI_1_OSPI_DQS_CLK", "Input clock"},
	{162, 1, "DEV_MCU_FSS0_OSPI_1_OSPI_HCLK_CLK", "Input clock"},
	{162, 2, "DEV_MCU_FSS0_OSPI_1_OSPI_ICLK_CLK", "Input muxed clock"},
	{162, 3, "DEV_MCU_FSS0_OSPI_1_OSPI_ICLK_CLK_PARENT_BOARD_0_MCU_OSPI1_DQS_OUT", "Parent input clock option to DEV_MCU_FSS0_OSPI_1_OSPI_ICLK_CLK"},
	{162, 4, "DEV_MCU_FSS0_OSPI_1_OSPI_ICLK_CLK_PARENT_FSS_MCU_0_OSPI_1_OSPI_OCLK_CLK", "Parent input clock option to DEV_MCU_FSS0_OSPI_1_OSPI_ICLK_CLK"},
	{162, 5, "DEV_MCU_FSS0_OSPI_1_OSPI_OCLK_CLK", "Output clock"},
	{162, 6, "DEV_MCU_FSS0_OSPI_1_OSPI_PCLK_CLK", "Input clock"},
	{162, 7, "DEV_MCU_FSS0_OSPI_1_OSPI_RCLK_CLK", "Input muxed clock"},
	{162, 8, "DEV_MCU_FSS0_OSPI_1_OSPI_RCLK_CLK_PARENT_HSDIV4_16FFT_MCU_1_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCU_FSS0_OSPI_1_OSPI_RCLK_CLK"},
	{162, 9, "DEV_MCU_FSS0_OSPI_1_OSPI_RCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCU_FSS0_OSPI_1_OSPI_RCLK_CLK"},
	{277, 0, "DEV_MCU_I2C0_CLK", "Input clock"},
	{277, 1, "DEV_MCU_I2C0_PISCL", "Input clock"},
	{277, 2, "DEV_MCU_I2C0_PISYS_CLK", "Input clock"},
	{277, 3, "DEV_MCU_I2C0_PORSCL", "Output clock"},
	{278, 0, "DEV_MCU_I2C1_CLK", "Input clock"},
	{278, 1, "DEV_MCU_I2C1_PISCL", "Input clock"},
	{278, 2, "DEV_MCU_I2C1_PISYS_CLK", "Input clock"},
	{278, 3, "DEV_MCU_I2C1_PORSCL", "Output clock"},
	{170, 0, "DEV_MCU_I3C0_I3C_PCLK_CLK", "Input clock"},
	{170, 1, "DEV_MCU_I3C0_I3C_SCL_DI", "Input clock"},
	{170, 2, "DEV_MCU_I3C0_I3C_SCL_DO", "Output clock"},
	{170, 3, "DEV_MCU_I3C0_I3C_SCLK_CLK", "Input clock"},
	{170, 4, "DEV_MCU_I3C0_I3C_SDA_DI", "Input clock"},
	{171, 0, "DEV_MCU_I3C1_I3C_PCLK_CLK", "Input clock"},
	{171, 3, "DEV_MCU_I3C1_I3C_SCLK_CLK", "Input clock"},
	{263, 0, "DEV_MCU_MCAN0_MCANSS_CAN_RXD", "Input clock"},
	{263, 1, "DEV_MCU_MCAN0_MCANSS_CCLK_CLK", "Input muxed clock"},
	{263, 2, "DEV_MCU_MCAN0_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT3_CLK", "Parent input clock option to DEV_MCU_MCAN0_MCANSS_CCLK_CLK"},
	{263, 3, "DEV_MCU_MCAN0_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_MCAN0_MCANSS_CCLK_CLK"},
	{263, 4, "DEV_MCU_MCAN0_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MCU_1_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_MCAN0_MCANSS_CCLK_CLK"},
	{263, 5, "DEV_MCU_MCAN0_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_MCAN0_MCANSS_CCLK_CLK"},
	{263, 6, "DEV_MCU_MCAN0_MCANSS_HCLK_CLK", "Input clock"},
	{264, 0, "DEV_MCU_MCAN1_MCANSS_CAN_RXD", "Input clock"},
	{264, 1, "DEV_MCU_MCAN1_MCANSS_CCLK_CLK", "Input muxed clock"},
	{264, 2, "DEV_MCU_MCAN1_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT3_CLK", "Parent input clock option to DEV_MCU_MCAN1_MCANSS_CCLK_CLK"},
	{264, 3, "DEV_MCU_MCAN1_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_MCAN1_MCANSS_CCLK_CLK"},
	{264, 4, "DEV_MCU_MCAN1_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MCU_1_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_MCAN1_MCANSS_CCLK_CLK"},
	{264, 5, "DEV_MCU_MCAN1_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_MCAN1_MCANSS_CCLK_CLK"},
	{264, 6, "DEV_MCU_MCAN1_MCANSS_HCLK_CLK", "Input clock"},
	{384, 0, "DEV_MCU_MCSPI0_CLKSPIREF_CLK", "Input clock"},
	{384, 1, "DEV_MCU_MCSPI0_IO_CLKSPII_CLK", "Input muxed clock"},
	{384, 2, "DEV_MCU_MCSPI0_IO_CLKSPII_CLK_PARENT_BOARD_0_MCU_SPI0_CLK_OUT", "Parent input clock option to DEV_MCU_MCSPI0_IO_CLKSPII_CLK"},
	{384, 3, "DEV_MCU_MCSPI0_IO_CLKSPII_CLK_PARENT_SPI_MCU_0_IO_CLKSPIO_CLK", "Parent input clock option to DEV_MCU_MCSPI0_IO_CLKSPII_CLK"},
	{384, 4, "DEV_MCU_MCSPI0_IO_CLKSPIO_CLK", "Output clock"},
	{384, 5, "DEV_MCU_MCSPI0_VBUSP_CLK", "Input clock"},
	{385, 0, "DEV_MCU_MCSPI1_CLKSPIREF_CLK", "Input clock"},
	{385, 1, "DEV_MCU_MCSPI1_IO_CLKSPII_CLK", "Input muxed clock"},
	{385, 2, "DEV_MCU_MCSPI1_IO_CLKSPII_CLK_PARENT_SPI_MAIN_3_IO_CLKSPIO_CLK", "Parent input clock option to DEV_MCU_MCSPI1_IO_CLKSPII_CLK"},
	{385, 3, "DEV_MCU_MCSPI1_IO_CLKSPII_CLK_PARENT_MCU_SPI1_CLK_LPBK_MUX_OUT0", "Parent input clock option to DEV_MCU_MCSPI1_IO_CLKSPII_CLK"},
	{385, 4, "DEV_MCU_MCSPI1_IO_CLKSPIO_CLK", "Output clock"},
	{385, 5, "DEV_MCU_MCSPI1_VBUSP_CLK", "Input clock"},
	{386, 0, "DEV_MCU_MCSPI2_CLKSPIREF_CLK", "Input clock"},
	{386, 1, "DEV_MCU_MCSPI2_IO_CLKSPII_CLK", "Input clock"},
	{386, 2, "DEV_MCU_MCSPI2_IO_CLKSPIO_CLK", "Output clock"},
	{386, 3, "DEV_MCU_MCSPI2_VBUSP_CLK", "Input clock"},
	{324, 0, "DEV_MCU_NAVSS0_INTR_ROUTER_0_INTR_CLK", "Input clock"},
	{325, 0, "DEV_MCU_NAVSS0_MCRC_0_CLK", "Input clock"},
	{326, 0, "DEV_MCU_NAVSS0_MODSS_VD2CLK", "Input clock"},
	{327, 0, "DEV_MCU_NAVSS0_PROXY0_CLK_CLK", "Input clock"},
	{328, 0, "DEV_MCU_NAVSS0_RINGACC0_SYS_CLK", "Input clock"},
	{329, 0, "DEV_MCU_NAVSS0_UDMAP_0_SYS_CLK", "Input clock"},
	{330, 0, "DEV_MCU_NAVSS0_UDMASS_VD2CLK", "Input clock"},
	{331, 0, "DEV_MCU_NAVSS0_UDMASS_INTA_0_SYS_CLK", "Input clock"},
	{238, 0, "DEV_MCU_PBIST0_CLK1_CLK", "Input clock"},
	{238, 1, "DEV_MCU_PBIST0_CLK2_CLK", "Input clock"},
	{238, 2, "DEV_MCU_PBIST0_CLK3_CLK", "Input clock"},
	{238, 3, "DEV_MCU_PBIST0_CLK4_CLK", "Input clock"},
	{238, 4, "DEV_MCU_PBIST0_CLK5_CLK", "Input clock"},
	{238, 5, "DEV_MCU_PBIST0_CLK6_CLK", "Input clock"},
	{238, 6, "DEV_MCU_PBIST0_CLK7_CLK", "Input clock"},
	{238, 7, "DEV_MCU_PBIST0_CLK8_CLK", "Input clock"},
	{239, 0, "DEV_MCU_PBIST1_CLK1_CLK", "Input clock"},
	{239, 1, "DEV_MCU_PBIST1_CLK2_CLK", "Input clock"},
	{239, 2, "DEV_MCU_PBIST1_CLK3_CLK", "Input clock"},
	{239, 3, "DEV_MCU_PBIST1_CLK4_CLK", "Input clock"},
	{239, 4, "DEV_MCU_PBIST1_CLK5_CLK", "Input clock"},
	{239, 5, "DEV_MCU_PBIST1_CLK6_CLK", "Input clock"},
	{239, 6, "DEV_MCU_PBIST1_CLK7_CLK", "Input clock"},
	{239, 7, "DEV_MCU_PBIST1_CLK8_CLK", "Input clock"},
	{240, 7, "DEV_MCU_PBIST2_CLK8_CLK", "Input clock"},
	{346, 0, "DEV_MCU_R5FSS0_CORE0_CPU_CLK", "Input muxed clock"},
	{346, 1, "DEV_MCU_R5FSS0_CORE0_CPU_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_MCU_R5FSS0_CORE0_CPU_CLK"},
	{346, 2, "DEV_MCU_R5FSS0_CORE0_CPU_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK3", "Parent input clock option to DEV_MCU_R5FSS0_CORE0_CPU_CLK"},
	{346, 3, "DEV_MCU_R5FSS0_CORE0_INTERFACE_CLK", "Input clock"},
	{346, 4, "DEV_MCU_R5FSS0_CORE0_INTERFACE_PHASE", "Input clock"},
	{347, 0, "DEV_MCU_R5FSS0_CORE1_CPU_CLK", "Input muxed clock"},
	{347, 1, "DEV_MCU_R5FSS0_CORE1_CPU_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_MCU_R5FSS0_CORE1_CPU_CLK"},
	{347, 2, "DEV_MCU_R5FSS0_CORE1_CPU_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK3", "Parent input clock option to DEV_MCU_R5FSS0_CORE1_CPU_CLK"},
	{347, 3, "DEV_MCU_R5FSS0_CORE1_INTERFACE_CLK", "Input clock"},
	{347, 4, "DEV_MCU_R5FSS0_CORE1_INTERFACE_PHASE", "Input clock"},
	{367, 0, "DEV_MCU_RTI0_RTI_CLK", "Input muxed clock"},
	{367, 1, "DEV_MCU_RTI0_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_RTI0_RTI_CLK"},
	{367, 2, "DEV_MCU_RTI0_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_MCU_RTI0_RTI_CLK"},
	{367, 3, "DEV_MCU_RTI0_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_RTI0_RTI_CLK"},
	{367, 4, "DEV_MCU_RTI0_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_RTI0_RTI_CLK"},
	{367, 9, "DEV_MCU_RTI0_VBUSP_CLK", "Input clock"},
	{368, 0, "DEV_MCU_RTI1_RTI_CLK", "Input muxed clock"},
	{368, 1, "DEV_MCU_RTI1_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_RTI1_RTI_CLK"},
	{368, 2, "DEV_MCU_RTI1_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_MCU_RTI1_RTI_CLK"},
	{368, 3, "DEV_MCU_RTI1_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_RTI1_RTI_CLK"},
	{368, 4, "DEV_MCU_RTI1_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_RTI1_RTI_CLK"},
	{368, 9, "DEV_MCU_RTI1_VBUSP_CLK", "Input clock"},
	{35, 0, "DEV_MCU_TIMER0_TIMER_HCLK_CLK", "Input clock"},
	{35, 1, "DEV_MCU_TIMER0_TIMER_PWM", "Output clock"},
	{35, 2, "DEV_MCU_TIMER0_TIMER_TCLK_CLK", "Input muxed clock"},
	{35, 3, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 4, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK16", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 5, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 6, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 7, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 8, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 9, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MCU_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 10, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{117, 0, "DEV_MCU_TIMER1_TIMER_HCLK_CLK", "Input clock"},
	{117, 2, "DEV_MCU_TIMER1_TIMER_TCLK_CLK", "Input muxed clock"},
	{117, 3, "DEV_MCU_TIMER1_TIMER_TCLK_CLK_PARENT_MCU_TIMER_CLKSEL_OUT1", "Parent input clock option to DEV_MCU_TIMER1_TIMER_TCLK_CLK"},
	{117, 4, "DEV_MCU_TIMER1_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MCU_0_TIMER_PWM", "Parent input clock option to DEV_MCU_TIMER1_TIMER_TCLK_CLK"},
	{118, 0, "DEV_MCU_TIMER2_TIMER_HCLK_CLK", "Input clock"},
	{118, 1, "DEV_MCU_TIMER2_TIMER_PWM", "Output clock"},
	{118, 2, "DEV_MCU_TIMER2_TIMER_TCLK_CLK", "Input muxed clock"},
	{118, 3, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{118, 4, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK16", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{118, 5, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{118, 6, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{118, 7, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{118, 8, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{118, 9, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MCU_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{118, 10, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{119, 0, "DEV_MCU_TIMER3_TIMER_HCLK_CLK", "Input clock"},
	{119, 2, "DEV_MCU_TIMER3_TIMER_TCLK_CLK", "Input muxed clock"},
	{119, 3, "DEV_MCU_TIMER3_TIMER_TCLK_CLK_PARENT_MCU_TIMER_CLKSEL_OUT3", "Parent input clock option to DEV_MCU_TIMER3_TIMER_TCLK_CLK"},
	{119, 4, "DEV_MCU_TIMER3_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MCU_2_TIMER_PWM", "Parent input clock option to DEV_MCU_TIMER3_TIMER_TCLK_CLK"},
	{120, 0, "DEV_MCU_TIMER4_TIMER_HCLK_CLK", "Input clock"},
	{120, 1, "DEV_MCU_TIMER4_TIMER_PWM", "Output clock"},
	{120, 2, "DEV_MCU_TIMER4_TIMER_TCLK_CLK", "Input muxed clock"},
	{120, 3, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{120, 4, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK16", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{120, 5, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{120, 6, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{120, 7, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{120, 8, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{120, 9, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MCU_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{120, 10, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{121, 0, "DEV_MCU_TIMER5_TIMER_HCLK_CLK", "Input clock"},
	{121, 2, "DEV_MCU_TIMER5_TIMER_TCLK_CLK", "Input muxed clock"},
	{121, 3, "DEV_MCU_TIMER5_TIMER_TCLK_CLK_PARENT_MCU_TIMER_CLKSEL_OUT5", "Parent input clock option to DEV_MCU_TIMER5_TIMER_TCLK_CLK"},
	{121, 4, "DEV_MCU_TIMER5_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MCU_4_TIMER_PWM", "Parent input clock option to DEV_MCU_TIMER5_TIMER_TCLK_CLK"},
	{122, 0, "DEV_MCU_TIMER6_TIMER_HCLK_CLK", "Input clock"},
	{122, 1, "DEV_MCU_TIMER6_TIMER_PWM", "Output clock"},
	{122, 2, "DEV_MCU_TIMER6_TIMER_TCLK_CLK", "Input muxed clock"},
	{122, 3, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{122, 4, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK16", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{122, 5, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{122, 6, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{122, 7, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{122, 8, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{122, 9, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MCU_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{122, 10, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{123, 0, "DEV_MCU_TIMER7_TIMER_HCLK_CLK", "Input clock"},
	{123, 2, "DEV_MCU_TIMER7_TIMER_TCLK_CLK", "Input muxed clock"},
	{123, 3, "DEV_MCU_TIMER7_TIMER_TCLK_CLK_PARENT_MCU_TIMER_CLKSEL_OUT7", "Parent input clock option to DEV_MCU_TIMER7_TIMER_TCLK_CLK"},
	{123, 4, "DEV_MCU_TIMER7_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MCU_6_TIMER_PWM", "Parent input clock option to DEV_MCU_TIMER7_TIMER_TCLK_CLK"},
	{124, 0, "DEV_MCU_TIMER8_TIMER_HCLK_CLK", "Input clock"},
	{124, 1, "DEV_MCU_TIMER8_TIMER_PWM", "Output clock"},
	{124, 2, "DEV_MCU_TIMER8_TIMER_TCLK_CLK", "Input muxed clock"},
	{124, 3, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{124, 4, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK16", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{124, 5, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{124, 6, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{124, 7, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{124, 8, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{124, 9, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MCU_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{124, 10, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{125, 0, "DEV_MCU_TIMER9_TIMER_HCLK_CLK", "Input clock"},
	{125, 2, "DEV_MCU_TIMER9_TIMER_TCLK_CLK", "Input muxed clock"},
	{125, 3, "DEV_MCU_TIMER9_TIMER_TCLK_CLK_PARENT_MCU_TIMER_CLKSEL_OUT9", "Parent input clock option to DEV_MCU_TIMER9_TIMER_TCLK_CLK"},
	{125, 4, "DEV_MCU_TIMER9_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MCU_8_TIMER_PWM", "Parent input clock option to DEV_MCU_TIMER9_TIMER_TCLK_CLK"},
	{149, 0, "DEV_MCU_UART0_FCLK_CLK", "Input muxed clock"},
	{149, 1, "DEV_MCU_UART0_FCLK_CLK_PARENT_HSDIV4_16FFT_MCU_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_MCU_UART0_FCLK_CLK"},
	{149, 2, "DEV_MCU_UART0_FCLK_CLK_PARENT_POSTDIV3_16FFT_MAIN_1_HSDIVOUT5_CLK", "Parent input clock option to DEV_MCU_UART0_FCLK_CLK"},
	{149, 5, "DEV_MCU_UART0_VBUSP_CLK", "Input clock"},
	{140, 1, "DEV_MMCSD0_EMMCSS_VBUS_CLK", "Input clock"},
	{140, 2, "DEV_MMCSD0_EMMCSS_XIN_CLK", "Input muxed clock"},
	{140, 3, "DEV_MMCSD0_EMMCSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD0_EMMCSS_XIN_CLK"},
	{140, 4, "DEV_MMCSD0_EMMCSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD0_EMMCSS_XIN_CLK"},
	{140, 5, "DEV_MMCSD0_EMMCSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD0_EMMCSS_XIN_CLK"},
	{140, 6, "DEV_MMCSD0_EMMCSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD0_EMMCSS_XIN_CLK"},
	{141, 0, "DEV_MMCSD1_EMMCSDSS_IO_CLK_I", "Input clock"},
	{141, 1, "DEV_MMCSD1_EMMCSDSS_IO_CLK_O", "Output clock"},
	{141, 3, "DEV_MMCSD1_EMMCSDSS_VBUS_CLK", "Input clock"},
	{141, 4, "DEV_MMCSD1_EMMCSDSS_XIN_CLK", "Input muxed clock"},
	{141, 5, "DEV_MMCSD1_EMMCSDSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD1_EMMCSDSS_XIN_CLK"},
	{141, 6, "DEV_MMCSD1_EMMCSDSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD1_EMMCSDSS_XIN_CLK"},
	{141, 7, "DEV_MMCSD1_EMMCSDSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD1_EMMCSDSS_XIN_CLK"},
	{141, 8, "DEV_MMCSD1_EMMCSDSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD1_EMMCSDSS_XIN_CLK"},
	{280, 0, "DEV_NAVSS0_CPTS0_GENF2", "Output clock"},
	{280, 1, "DEV_NAVSS0_CPTS0_GENF3", "Output clock"},
	{281, 0, "DEV_NAVSS0_BCDMA_0_CLK", "Input clock"},
	{282, 0, "DEV_NAVSS0_CPTS_0_RCLK", "Input muxed clock"},
	{282, 1, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{282, 2, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{282, 3, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_BOARD_0_MCU_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{282, 4, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{282, 5, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{282, 6, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{282, 7, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN0_TXMCLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{282, 8, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN1_TXMCLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{282, 9, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN2_TXMCLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{282, 10, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN3_TXMCLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{282, 11, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_WIZ16B8M4CT3_MAIN_1_IP2_LN0_TXMCLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{282, 12, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_WIZ16B8M4CT3_MAIN_1_IP2_LN1_TXMCLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{282, 13, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP1_LN2_TXMCLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{282, 14, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_WIZ16B8M4CT3_MAIN_1_IP3_LN2_TXMCLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{282, 15, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{282, 16, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{282, 17, "DEV_NAVSS0_CPTS_0_TS_GENF0", "Output clock"},
	{282, 18, "DEV_NAVSS0_CPTS_0_TS_GENF1", "Output clock"},
	{282, 21, "DEV_NAVSS0_CPTS_0_VBUSP_GCLK", "Input clock"},
	{283, 0, "DEV_NAVSS0_INTR_0_INTR_CLK", "Input clock"},
	{284, 0, "DEV_NAVSS0_MAILBOX1_0_VCLK_CLK", "Input clock"},
	{285, 0, "DEV_NAVSS0_MAILBOX1_1_VCLK_CLK", "Input clock"},
	{294, 0, "DEV_NAVSS0_MAILBOX1_10_VCLK_CLK", "Input clock"},
	{295, 0, "DEV_NAVSS0_MAILBOX1_11_VCLK_CLK", "Input clock"},
	{286, 0, "DEV_NAVSS0_MAILBOX1_2_VCLK_CLK", "Input clock"},
	{287, 0, "DEV_NAVSS0_MAILBOX1_3_VCLK_CLK", "Input clock"},
	{288, 0, "DEV_NAVSS0_MAILBOX1_4_VCLK_CLK", "Input clock"},
	{289, 0, "DEV_NAVSS0_MAILBOX1_5_VCLK_CLK", "Input clock"},
	{290, 0, "DEV_NAVSS0_MAILBOX1_6_VCLK_CLK", "Input clock"},
	{291, 0, "DEV_NAVSS0_MAILBOX1_7_VCLK_CLK", "Input clock"},
	{292, 0, "DEV_NAVSS0_MAILBOX1_8_VCLK_CLK", "Input clock"},
	{293, 0, "DEV_NAVSS0_MAILBOX1_9_VCLK_CLK", "Input clock"},
	{296, 0, "DEV_NAVSS0_MAILBOX_0_VCLK_CLK", "Input clock"},
	{297, 0, "DEV_NAVSS0_MAILBOX_1_VCLK_CLK", "Input clock"},
	{306, 0, "DEV_NAVSS0_MAILBOX_10_VCLK_CLK", "Input clock"},
	{307, 0, "DEV_NAVSS0_MAILBOX_11_VCLK_CLK", "Input clock"},
	{298, 0, "DEV_NAVSS0_MAILBOX_2_VCLK_CLK", "Input clock"},
	{299, 0, "DEV_NAVSS0_MAILBOX_3_VCLK_CLK", "Input clock"},
	{300, 0, "DEV_NAVSS0_MAILBOX_4_VCLK_CLK", "Input clock"},
	{301, 0, "DEV_NAVSS0_MAILBOX_5_VCLK_CLK", "Input clock"},
	{302, 0, "DEV_NAVSS0_MAILBOX_6_VCLK_CLK", "Input clock"},
	{303, 0, "DEV_NAVSS0_MAILBOX_7_VCLK_CLK", "Input clock"},
	{304, 0, "DEV_NAVSS0_MAILBOX_8_VCLK_CLK", "Input clock"},
	{305, 0, "DEV_NAVSS0_MAILBOX_9_VCLK_CLK", "Input clock"},
	{308, 0, "DEV_NAVSS0_MCRC_0_CLK", "Input clock"},
	{309, 0, "DEV_NAVSS0_MODSS_VD2CLK", "Input clock"},
	{310, 0, "DEV_NAVSS0_MODSS_INTA_0_SYS_CLK", "Input clock"},
	{311, 0, "DEV_NAVSS0_MODSS_INTA_1_SYS_CLK", "Input clock"},
	{312, 0, "DEV_NAVSS0_PROXY_0_CLK_CLK", "Input clock"},
	{313, 0, "DEV_NAVSS0_PVU_0_CLK_CLK", "Input clock"},
	{314, 0, "DEV_NAVSS0_PVU_1_CLK_CLK", "Input clock"},
	{315, 0, "DEV_NAVSS0_RINGACC_0_SYS_CLK", "Input clock"},
	{316, 0, "DEV_NAVSS0_SPINLOCK_0_CLK", "Input clock"},
	{317, 0, "DEV_NAVSS0_TIMERMGR_0_EON_TICK_EVT", "Input clock"},
	{317, 1, "DEV_NAVSS0_TIMERMGR_0_VCLK_CLK", "Input clock"},
	{318, 0, "DEV_NAVSS0_TIMERMGR_1_EON_TICK_EVT", "Input clock"},
	{318, 1, "DEV_NAVSS0_TIMERMGR_1_VCLK_CLK", "Input clock"},
	{319, 0, "DEV_NAVSS0_UDMAP_0_SYS_CLK", "Input clock"},
	{320, 0, "DEV_NAVSS0_UDMASS_VD2CLK", "Input clock"},
	{321, 0, "DEV_NAVSS0_UDMASS_INTA_0_SYS_CLK", "Input clock"},
	{322, 0, "DEV_NAVSS0_VIRTSS_VD2CLK", "Input clock"},
	{232, 7, "DEV_PBIST0_CLK8_CLK", "Input clock"},
	{233, 7, "DEV_PBIST1_CLK8_CLK", "Input clock"},
	{236, 7, "DEV_PBIST10_CLK8_CLK", "Input clock"},
	{227, 6, "DEV_PBIST11_CLK7_CLK", "Input clock"},
	{237, 7, "DEV_PBIST14_CLK8_CLK", "Input clock"},
	{235, 7, "DEV_PBIST2_CLK8_CLK", "Input clock"},
	{231, 7, "DEV_PBIST3_CLK8_CLK", "Input clock"},
	{234, 7, "DEV_PBIST4_CLK8_CLK", "Input clock"},
	{226, 7, "DEV_PBIST5_CLK8_CLK", "Input clock"},
	{332, 0, "DEV_PCIE0_PCIE_CBA_CLK", "Input clock"},
	{332, 2, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK", "Input muxed clock"},
	{332, 3, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{332, 4, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{332, 5, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_MCU_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{332, 6, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{332, 7, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{332, 8, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{332, 9, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN0_TXMCLK", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{332, 10, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN1_TXMCLK", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{332, 11, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN2_TXMCLK", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{332, 12, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN3_TXMCLK", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{332, 13, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_1_IP2_LN0_TXMCLK", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{332, 14, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_1_IP2_LN1_TXMCLK", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{332, 15, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP1_LN2_TXMCLK", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{332, 16, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_1_IP3_LN2_TXMCLK", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{332, 17, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{332, 18, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{332, 19, "DEV_PCIE0_PCIE_LANE0_REFCLK", "Input clock"},
	{332, 20, "DEV_PCIE0_PCIE_LANE0_RXCLK", "Input clock"},
	{332, 21, "DEV_PCIE0_PCIE_LANE0_RXFCLK", "Input clock"},
	{332, 22, "DEV_PCIE0_PCIE_LANE0_TXCLK", "Output clock"},
	{332, 23, "DEV_PCIE0_PCIE_LANE0_TXFCLK", "Input clock"},
	{332, 24, "DEV_PCIE0_PCIE_LANE0_TXMCLK", "Input clock"},
	{332, 25, "DEV_PCIE0_PCIE_LANE1_REFCLK", "Input clock"},
	{332, 26, "DEV_PCIE0_PCIE_LANE1_RXCLK", "Input clock"},
	{332, 27, "DEV_PCIE0_PCIE_LANE1_RXFCLK", "Input clock"},
	{332, 28, "DEV_PCIE0_PCIE_LANE1_TXCLK", "Output clock"},
	{332, 29, "DEV_PCIE0_PCIE_LANE1_TXFCLK", "Input clock"},
	{332, 30, "DEV_PCIE0_PCIE_LANE1_TXMCLK", "Input clock"},
	{332, 31, "DEV_PCIE0_PCIE_LANE2_REFCLK", "Input clock"},
	{332, 32, "DEV_PCIE0_PCIE_LANE2_RXCLK", "Input clock"},
	{332, 33, "DEV_PCIE0_PCIE_LANE2_RXFCLK", "Input clock"},
	{332, 34, "DEV_PCIE0_PCIE_LANE2_TXCLK", "Output clock"},
	{332, 35, "DEV_PCIE0_PCIE_LANE2_TXFCLK", "Input clock"},
	{332, 36, "DEV_PCIE0_PCIE_LANE2_TXMCLK", "Input clock"},
	{332, 37, "DEV_PCIE0_PCIE_LANE3_REFCLK", "Input clock"},
	{332, 38, "DEV_PCIE0_PCIE_LANE3_RXCLK", "Input clock"},
	{332, 39, "DEV_PCIE0_PCIE_LANE3_RXFCLK", "Input clock"},
	{332, 40, "DEV_PCIE0_PCIE_LANE3_TXCLK", "Output clock"},
	{332, 41, "DEV_PCIE0_PCIE_LANE3_TXFCLK", "Input clock"},
	{332, 42, "DEV_PCIE0_PCIE_LANE3_TXMCLK", "Input clock"},
	{332, 43, "DEV_PCIE0_PCIE_PM_CLK", "Input clock"},
	{333, 0, "DEV_PCIE1_PCIE_CBA_CLK", "Input clock"},
	{333, 2, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK", "Input muxed clock"},
	{333, 3, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{333, 4, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{333, 5, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_MCU_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{333, 6, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{333, 7, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{333, 8, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{333, 9, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN0_TXMCLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{333, 10, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN1_TXMCLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{333, 11, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN2_TXMCLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{333, 12, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN3_TXMCLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{333, 13, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_1_IP2_LN0_TXMCLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{333, 14, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_1_IP2_LN1_TXMCLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{333, 15, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP1_LN2_TXMCLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{333, 16, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_1_IP3_LN2_TXMCLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{333, 17, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{333, 18, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{333, 19, "DEV_PCIE1_PCIE_LANE0_REFCLK", "Input clock"},
	{333, 20, "DEV_PCIE1_PCIE_LANE0_RXCLK", "Input clock"},
	{333, 21, "DEV_PCIE1_PCIE_LANE0_RXFCLK", "Input clock"},
	{333, 22, "DEV_PCIE1_PCIE_LANE0_TXCLK", "Output clock"},
	{333, 23, "DEV_PCIE1_PCIE_LANE0_TXFCLK", "Input clock"},
	{333, 24, "DEV_PCIE1_PCIE_LANE0_TXMCLK", "Input clock"},
	{333, 25, "DEV_PCIE1_PCIE_LANE1_REFCLK", "Input clock"},
	{333, 26, "DEV_PCIE1_PCIE_LANE1_RXCLK", "Input clock"},
	{333, 27, "DEV_PCIE1_PCIE_LANE1_RXFCLK", "Input clock"},
	{333, 28, "DEV_PCIE1_PCIE_LANE1_TXCLK", "Output clock"},
	{333, 29, "DEV_PCIE1_PCIE_LANE1_TXFCLK", "Input clock"},
	{333, 30, "DEV_PCIE1_PCIE_LANE1_TXMCLK", "Input clock"},
	{333, 31, "DEV_PCIE1_PCIE_LANE2_REFCLK", "Input clock"},
	{333, 32, "DEV_PCIE1_PCIE_LANE2_RXCLK", "Input clock"},
	{333, 33, "DEV_PCIE1_PCIE_LANE2_RXFCLK", "Input clock"},
	{333, 34, "DEV_PCIE1_PCIE_LANE2_TXCLK", "Output clock"},
	{333, 35, "DEV_PCIE1_PCIE_LANE2_TXFCLK", "Input clock"},
	{333, 36, "DEV_PCIE1_PCIE_LANE2_TXMCLK", "Input clock"},
	{333, 37, "DEV_PCIE1_PCIE_LANE3_REFCLK", "Input clock"},
	{333, 38, "DEV_PCIE1_PCIE_LANE3_RXCLK", "Input clock"},
	{333, 39, "DEV_PCIE1_PCIE_LANE3_RXFCLK", "Input clock"},
	{333, 40, "DEV_PCIE1_PCIE_LANE3_TXCLK", "Output clock"},
	{333, 41, "DEV_PCIE1_PCIE_LANE3_TXFCLK", "Input clock"},
	{333, 42, "DEV_PCIE1_PCIE_LANE3_TXMCLK", "Input clock"},
	{333, 43, "DEV_PCIE1_PCIE_PM_CLK", "Input clock"},
	{334, 0, "DEV_PCIE2_PCIE_CBA_CLK", "Input clock"},
	{334, 2, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK", "Input muxed clock"},
	{334, 3, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{334, 4, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{334, 5, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_MCU_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{334, 6, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{334, 7, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{334, 8, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{334, 9, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN0_TXMCLK", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{334, 10, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN1_TXMCLK", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{334, 11, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN2_TXMCLK", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{334, 12, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN3_TXMCLK", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{334, 13, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_1_IP2_LN0_TXMCLK", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{334, 14, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_1_IP2_LN1_TXMCLK", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{334, 15, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP1_LN2_TXMCLK", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{334, 16, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_1_IP3_LN2_TXMCLK", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{334, 17, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{334, 18, "DEV_PCIE2_PCIE_CPTS_RCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_PCIE2_PCIE_CPTS_RCLK_CLK"},
	{334, 19, "DEV_PCIE2_PCIE_LANE0_REFCLK", "Input clock"},
	{334, 20, "DEV_PCIE2_PCIE_LANE0_RXCLK", "Input clock"},
	{334, 21, "DEV_PCIE2_PCIE_LANE0_RXFCLK", "Input clock"},
	{334, 22, "DEV_PCIE2_PCIE_LANE0_TXCLK", "Output clock"},
	{334, 23, "DEV_PCIE2_PCIE_LANE0_TXFCLK", "Input clock"},
	{334, 24, "DEV_PCIE2_PCIE_LANE0_TXMCLK", "Input clock"},
	{334, 25, "DEV_PCIE2_PCIE_LANE1_REFCLK", "Input clock"},
	{334, 26, "DEV_PCIE2_PCIE_LANE1_RXCLK", "Input clock"},
	{334, 27, "DEV_PCIE2_PCIE_LANE1_RXFCLK", "Input clock"},
	{334, 28, "DEV_PCIE2_PCIE_LANE1_TXCLK", "Output clock"},
	{334, 29, "DEV_PCIE2_PCIE_LANE1_TXFCLK", "Input clock"},
	{334, 30, "DEV_PCIE2_PCIE_LANE1_TXMCLK", "Input clock"},
	{334, 43, "DEV_PCIE2_PCIE_PM_CLK", "Input clock"},
	{335, 0, "DEV_PCIE3_PCIE_CBA_CLK", "Input clock"},
	{335, 2, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK", "Input muxed clock"},
	{335, 3, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{335, 4, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{335, 5, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_MCU_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{335, 6, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{335, 7, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{335, 8, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{335, 9, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN0_TXMCLK", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{335, 10, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN1_TXMCLK", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{335, 11, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN2_TXMCLK", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{335, 12, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP2_LN3_TXMCLK", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{335, 13, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_1_IP2_LN0_TXMCLK", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{335, 14, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_1_IP2_LN1_TXMCLK", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{335, 15, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP1_LN2_TXMCLK", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{335, 16, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT3_MAIN_1_IP3_LN2_TXMCLK", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{335, 17, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{335, 18, "DEV_PCIE3_PCIE_CPTS_RCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_PCIE3_PCIE_CPTS_RCLK_CLK"},
	{335, 19, "DEV_PCIE3_PCIE_LANE0_REFCLK", "Input clock"},
	{335, 20, "DEV_PCIE3_PCIE_LANE0_RXCLK", "Input clock"},
	{335, 21, "DEV_PCIE3_PCIE_LANE0_RXFCLK", "Input clock"},
	{335, 22, "DEV_PCIE3_PCIE_LANE0_TXCLK", "Output clock"},
	{335, 23, "DEV_PCIE3_PCIE_LANE0_TXFCLK", "Input clock"},
	{335, 24, "DEV_PCIE3_PCIE_LANE0_TXMCLK", "Input clock"},
	{335, 25, "DEV_PCIE3_PCIE_LANE1_REFCLK", "Input clock"},
	{335, 26, "DEV_PCIE3_PCIE_LANE1_RXCLK", "Input clock"},
	{335, 27, "DEV_PCIE3_PCIE_LANE1_RXFCLK", "Input clock"},
	{335, 28, "DEV_PCIE3_PCIE_LANE1_TXCLK", "Output clock"},
	{335, 29, "DEV_PCIE3_PCIE_LANE1_TXFCLK", "Input clock"},
	{335, 30, "DEV_PCIE3_PCIE_LANE1_TXMCLK", "Input clock"},
	{335, 43, "DEV_PCIE3_PCIE_PM_CLK", "Input clock"},
	{201, 0, "DEV_PSC0_CLK", "Input clock"},
	{201, 1, "DEV_PSC0_SLOW_CLK", "Input clock"},
	{339, 0, "DEV_R5FSS0_CORE0_CPU_CLK", "Input clock"},
	{339, 1, "DEV_R5FSS0_CORE0_INTERFACE_CLK", "Input clock"},
	{340, 0, "DEV_R5FSS0_CORE1_CPU_CLK", "Input clock"},
	{340, 1, "DEV_R5FSS0_CORE1_INTERFACE_CLK", "Input clock"},
	{341, 0, "DEV_R5FSS1_CORE0_CPU_CLK", "Input clock"},
	{341, 1, "DEV_R5FSS1_CORE0_INTERFACE_CLK", "Input clock"},
	{342, 0, "DEV_R5FSS1_CORE1_CPU_CLK", "Input clock"},
	{342, 1, "DEV_R5FSS1_CORE1_INTERFACE_CLK", "Input clock"},
	{343, 0, "DEV_R5FSS2_CORE0_CPU_CLK", "Input clock"},
	{343, 1, "DEV_R5FSS2_CORE0_INTERFACE_CLK", "Input clock"},
	{344, 0, "DEV_R5FSS2_CORE1_CPU_CLK", "Input clock"},
	{344, 1, "DEV_R5FSS2_CORE1_INTERFACE_CLK", "Input clock"},
	{348, 0, "DEV_RTI0_RTI_CLK", "Input muxed clock"},
	{348, 1, "DEV_RTI0_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{348, 2, "DEV_RTI0_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{348, 3, "DEV_RTI0_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{348, 4, "DEV_RTI0_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{348, 5, "DEV_RTI0_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{348, 6, "DEV_RTI0_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{348, 7, "DEV_RTI0_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{348, 8, "DEV_RTI0_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{348, 9, "DEV_RTI0_VBUSP_CLK", "Input clock"},
	{349, 0, "DEV_RTI1_RTI_CLK", "Input muxed clock"},
	{349, 1, "DEV_RTI1_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{349, 2, "DEV_RTI1_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{349, 3, "DEV_RTI1_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{349, 4, "DEV_RTI1_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{349, 5, "DEV_RTI1_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{349, 6, "DEV_RTI1_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{349, 7, "DEV_RTI1_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{349, 8, "DEV_RTI1_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{349, 9, "DEV_RTI1_VBUSP_CLK", "Input clock"},
	{360, 0, "DEV_RTI15_RTI_CLK", "Input muxed clock"},
	{360, 1, "DEV_RTI15_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI15_RTI_CLK"},
	{360, 2, "DEV_RTI15_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI15_RTI_CLK"},
	{360, 3, "DEV_RTI15_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI15_RTI_CLK"},
	{360, 4, "DEV_RTI15_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI15_RTI_CLK"},
	{360, 5, "DEV_RTI15_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI15_RTI_CLK"},
	{360, 6, "DEV_RTI15_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI15_RTI_CLK"},
	{360, 7, "DEV_RTI15_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI15_RTI_CLK"},
	{360, 8, "DEV_RTI15_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI15_RTI_CLK"},
	{360, 9, "DEV_RTI15_VBUSP_CLK", "Input clock"},
	{356, 0, "DEV_RTI16_RTI_CLK", "Input muxed clock"},
	{356, 1, "DEV_RTI16_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI16_RTI_CLK"},
	{356, 2, "DEV_RTI16_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI16_RTI_CLK"},
	{356, 3, "DEV_RTI16_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI16_RTI_CLK"},
	{356, 4, "DEV_RTI16_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI16_RTI_CLK"},
	{356, 5, "DEV_RTI16_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI16_RTI_CLK"},
	{356, 6, "DEV_RTI16_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI16_RTI_CLK"},
	{356, 7, "DEV_RTI16_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI16_RTI_CLK"},
	{356, 8, "DEV_RTI16_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI16_RTI_CLK"},
	{356, 9, "DEV_RTI16_VBUSP_CLK", "Input clock"},
	{357, 0, "DEV_RTI17_RTI_CLK", "Input muxed clock"},
	{357, 1, "DEV_RTI17_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI17_RTI_CLK"},
	{357, 2, "DEV_RTI17_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI17_RTI_CLK"},
	{357, 3, "DEV_RTI17_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI17_RTI_CLK"},
	{357, 4, "DEV_RTI17_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI17_RTI_CLK"},
	{357, 5, "DEV_RTI17_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI17_RTI_CLK"},
	{357, 6, "DEV_RTI17_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI17_RTI_CLK"},
	{357, 7, "DEV_RTI17_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI17_RTI_CLK"},
	{357, 8, "DEV_RTI17_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI17_RTI_CLK"},
	{357, 9, "DEV_RTI17_VBUSP_CLK", "Input clock"},
	{358, 0, "DEV_RTI18_RTI_CLK", "Input muxed clock"},
	{358, 1, "DEV_RTI18_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI18_RTI_CLK"},
	{358, 2, "DEV_RTI18_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI18_RTI_CLK"},
	{358, 3, "DEV_RTI18_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI18_RTI_CLK"},
	{358, 4, "DEV_RTI18_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI18_RTI_CLK"},
	{358, 5, "DEV_RTI18_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI18_RTI_CLK"},
	{358, 6, "DEV_RTI18_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI18_RTI_CLK"},
	{358, 7, "DEV_RTI18_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI18_RTI_CLK"},
	{358, 8, "DEV_RTI18_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI18_RTI_CLK"},
	{358, 9, "DEV_RTI18_VBUSP_CLK", "Input clock"},
	{359, 0, "DEV_RTI19_RTI_CLK", "Input muxed clock"},
	{359, 1, "DEV_RTI19_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI19_RTI_CLK"},
	{359, 2, "DEV_RTI19_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI19_RTI_CLK"},
	{359, 3, "DEV_RTI19_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI19_RTI_CLK"},
	{359, 4, "DEV_RTI19_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI19_RTI_CLK"},
	{359, 5, "DEV_RTI19_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI19_RTI_CLK"},
	{359, 6, "DEV_RTI19_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI19_RTI_CLK"},
	{359, 7, "DEV_RTI19_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI19_RTI_CLK"},
	{359, 8, "DEV_RTI19_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI19_RTI_CLK"},
	{359, 9, "DEV_RTI19_VBUSP_CLK", "Input clock"},
	{350, 0, "DEV_RTI2_RTI_CLK", "Input muxed clock"},
	{350, 1, "DEV_RTI2_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI2_RTI_CLK"},
	{350, 2, "DEV_RTI2_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI2_RTI_CLK"},
	{350, 3, "DEV_RTI2_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI2_RTI_CLK"},
	{350, 4, "DEV_RTI2_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI2_RTI_CLK"},
	{350, 5, "DEV_RTI2_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI2_RTI_CLK"},
	{350, 6, "DEV_RTI2_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI2_RTI_CLK"},
	{350, 7, "DEV_RTI2_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI2_RTI_CLK"},
	{350, 8, "DEV_RTI2_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI2_RTI_CLK"},
	{350, 9, "DEV_RTI2_VBUSP_CLK", "Input clock"},
	{361, 0, "DEV_RTI28_RTI_CLK", "Input muxed clock"},
	{361, 1, "DEV_RTI28_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{361, 2, "DEV_RTI28_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{361, 3, "DEV_RTI28_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{361, 4, "DEV_RTI28_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{361, 5, "DEV_RTI28_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{361, 6, "DEV_RTI28_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{361, 7, "DEV_RTI28_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{361, 8, "DEV_RTI28_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{361, 9, "DEV_RTI28_VBUSP_CLK", "Input clock"},
	{362, 0, "DEV_RTI29_RTI_CLK", "Input muxed clock"},
	{362, 1, "DEV_RTI29_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{362, 2, "DEV_RTI29_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{362, 3, "DEV_RTI29_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{362, 4, "DEV_RTI29_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{362, 5, "DEV_RTI29_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{362, 6, "DEV_RTI29_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{362, 7, "DEV_RTI29_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{362, 8, "DEV_RTI29_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{362, 9, "DEV_RTI29_VBUSP_CLK", "Input clock"},
	{351, 0, "DEV_RTI3_RTI_CLK", "Input muxed clock"},
	{351, 1, "DEV_RTI3_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI3_RTI_CLK"},
	{351, 2, "DEV_RTI3_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI3_RTI_CLK"},
	{351, 3, "DEV_RTI3_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI3_RTI_CLK"},
	{351, 4, "DEV_RTI3_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI3_RTI_CLK"},
	{351, 5, "DEV_RTI3_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI3_RTI_CLK"},
	{351, 6, "DEV_RTI3_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI3_RTI_CLK"},
	{351, 7, "DEV_RTI3_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI3_RTI_CLK"},
	{351, 8, "DEV_RTI3_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI3_RTI_CLK"},
	{351, 9, "DEV_RTI3_VBUSP_CLK", "Input clock"},
	{363, 0, "DEV_RTI30_RTI_CLK", "Input muxed clock"},
	{363, 1, "DEV_RTI30_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI30_RTI_CLK"},
	{363, 2, "DEV_RTI30_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI30_RTI_CLK"},
	{363, 3, "DEV_RTI30_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI30_RTI_CLK"},
	{363, 4, "DEV_RTI30_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI30_RTI_CLK"},
	{363, 5, "DEV_RTI30_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI30_RTI_CLK"},
	{363, 6, "DEV_RTI30_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI30_RTI_CLK"},
	{363, 7, "DEV_RTI30_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI30_RTI_CLK"},
	{363, 8, "DEV_RTI30_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI30_RTI_CLK"},
	{363, 9, "DEV_RTI30_VBUSP_CLK", "Input clock"},
	{364, 0, "DEV_RTI31_RTI_CLK", "Input muxed clock"},
	{364, 1, "DEV_RTI31_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI31_RTI_CLK"},
	{364, 2, "DEV_RTI31_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI31_RTI_CLK"},
	{364, 3, "DEV_RTI31_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI31_RTI_CLK"},
	{364, 4, "DEV_RTI31_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI31_RTI_CLK"},
	{364, 5, "DEV_RTI31_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI31_RTI_CLK"},
	{364, 6, "DEV_RTI31_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI31_RTI_CLK"},
	{364, 7, "DEV_RTI31_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI31_RTI_CLK"},
	{364, 8, "DEV_RTI31_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI31_RTI_CLK"},
	{364, 9, "DEV_RTI31_VBUSP_CLK", "Input clock"},
	{365, 0, "DEV_RTI32_RTI_CLK", "Input muxed clock"},
	{365, 1, "DEV_RTI32_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI32_RTI_CLK"},
	{365, 2, "DEV_RTI32_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI32_RTI_CLK"},
	{365, 3, "DEV_RTI32_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI32_RTI_CLK"},
	{365, 4, "DEV_RTI32_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI32_RTI_CLK"},
	{365, 5, "DEV_RTI32_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI32_RTI_CLK"},
	{365, 6, "DEV_RTI32_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI32_RTI_CLK"},
	{365, 7, "DEV_RTI32_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI32_RTI_CLK"},
	{365, 8, "DEV_RTI32_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI32_RTI_CLK"},
	{365, 9, "DEV_RTI32_VBUSP_CLK", "Input clock"},
	{366, 0, "DEV_RTI33_RTI_CLK", "Input muxed clock"},
	{366, 1, "DEV_RTI33_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI33_RTI_CLK"},
	{366, 2, "DEV_RTI33_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI33_RTI_CLK"},
	{366, 3, "DEV_RTI33_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI33_RTI_CLK"},
	{366, 4, "DEV_RTI33_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI33_RTI_CLK"},
	{366, 5, "DEV_RTI33_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI33_RTI_CLK"},
	{366, 6, "DEV_RTI33_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI33_RTI_CLK"},
	{366, 7, "DEV_RTI33_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI33_RTI_CLK"},
	{366, 8, "DEV_RTI33_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI33_RTI_CLK"},
	{366, 9, "DEV_RTI33_VBUSP_CLK", "Input clock"},
	{352, 0, "DEV_RTI4_RTI_CLK", "Input muxed clock"},
	{352, 1, "DEV_RTI4_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI4_RTI_CLK"},
	{352, 2, "DEV_RTI4_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI4_RTI_CLK"},
	{352, 3, "DEV_RTI4_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI4_RTI_CLK"},
	{352, 4, "DEV_RTI4_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI4_RTI_CLK"},
	{352, 5, "DEV_RTI4_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI4_RTI_CLK"},
	{352, 6, "DEV_RTI4_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI4_RTI_CLK"},
	{352, 7, "DEV_RTI4_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI4_RTI_CLK"},
	{352, 8, "DEV_RTI4_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI4_RTI_CLK"},
	{352, 9, "DEV_RTI4_VBUSP_CLK", "Input clock"},
	{353, 0, "DEV_RTI5_RTI_CLK", "Input muxed clock"},
	{353, 1, "DEV_RTI5_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI5_RTI_CLK"},
	{353, 2, "DEV_RTI5_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI5_RTI_CLK"},
	{353, 3, "DEV_RTI5_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI5_RTI_CLK"},
	{353, 4, "DEV_RTI5_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI5_RTI_CLK"},
	{353, 5, "DEV_RTI5_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI5_RTI_CLK"},
	{353, 6, "DEV_RTI5_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI5_RTI_CLK"},
	{353, 7, "DEV_RTI5_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI5_RTI_CLK"},
	{353, 8, "DEV_RTI5_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI5_RTI_CLK"},
	{353, 9, "DEV_RTI5_VBUSP_CLK", "Input clock"},
	{354, 0, "DEV_RTI6_RTI_CLK", "Input muxed clock"},
	{354, 1, "DEV_RTI6_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI6_RTI_CLK"},
	{354, 2, "DEV_RTI6_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI6_RTI_CLK"},
	{354, 3, "DEV_RTI6_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI6_RTI_CLK"},
	{354, 4, "DEV_RTI6_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI6_RTI_CLK"},
	{354, 5, "DEV_RTI6_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI6_RTI_CLK"},
	{354, 6, "DEV_RTI6_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI6_RTI_CLK"},
	{354, 7, "DEV_RTI6_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI6_RTI_CLK"},
	{354, 8, "DEV_RTI6_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI6_RTI_CLK"},
	{354, 9, "DEV_RTI6_VBUSP_CLK", "Input clock"},
	{355, 0, "DEV_RTI7_RTI_CLK", "Input muxed clock"},
	{355, 1, "DEV_RTI7_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI7_RTI_CLK"},
	{355, 2, "DEV_RTI7_RTI_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_RTI7_RTI_CLK"},
	{355, 3, "DEV_RTI7_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI7_RTI_CLK"},
	{355, 4, "DEV_RTI7_RTI_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI7_RTI_CLK"},
	{355, 5, "DEV_RTI7_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI7_RTI_CLK"},
	{355, 6, "DEV_RTI7_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI7_RTI_CLK"},
	{355, 7, "DEV_RTI7_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI7_RTI_CLK"},
	{355, 8, "DEV_RTI7_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI7_RTI_CLK"},
	{355, 9, "DEV_RTI7_VBUSP_CLK", "Input clock"},
	{8, 0, "DEV_SA2_CPSW_PSILSS0_MAIN_2_CLK", "Input clock"},
	{8, 1, "DEV_SA2_CPSW_PSILSS0_MAIN_CLK", "Input clock"},
	{369, 0, "DEV_SA2_UL0_PKA_IN_CLK", "Input clock"},
	{369, 1, "DEV_SA2_UL0_X1_CLK", "Input clock"},
	{369, 2, "DEV_SA2_UL0_X2_CLK", "Input clock"},
	{404, 2, "DEV_SERDES_10G0_CLK", "Input clock"},
	{404, 3, "DEV_SERDES_10G0_CMN_REFCLK_M", "Input clock"},
	{404, 3, "DEV_SERDES_10G0_CMN_REFCLK_M", "Output clock"},
	{404, 4, "DEV_SERDES_10G0_CMN_REFCLK_P", "Input clock"},
	{404, 4, "DEV_SERDES_10G0_CMN_REFCLK_P", "Output clock"},
	{404, 5, "DEV_SERDES_10G0_CORE_REF1_CLK", "Input clock"},
	{404, 6, "DEV_SERDES_10G0_CORE_REF_CLK", "Input muxed clock"},
	{404, 7, "DEV_SERDES_10G0_CORE_REF_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_SERDES_10G0_CORE_REF_CLK"},
	{404, 8, "DEV_SERDES_10G0_CORE_REF_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_SERDES_10G0_CORE_REF_CLK"},
	{404, 9, "DEV_SERDES_10G0_CORE_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_10G0_CORE_REF_CLK"},
	{404, 10, "DEV_SERDES_10G0_CORE_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_10G0_CORE_REF_CLK"},
	{404, 15, "DEV_SERDES_10G0_IP1_LN0_TXCLK", "Input clock"},
	{404, 21, "DEV_SERDES_10G0_IP1_LN1_TXCLK", "Input clock"},
	{404, 24, "DEV_SERDES_10G0_IP1_LN2_REFCLK", "Output clock"},
	{404, 25, "DEV_SERDES_10G0_IP1_LN2_RXCLK", "Output clock"},
	{404, 26, "DEV_SERDES_10G0_IP1_LN2_RXFCLK", "Output clock"},
	{404, 27, "DEV_SERDES_10G0_IP1_LN2_TXCLK", "Input clock"},
	{404, 28, "DEV_SERDES_10G0_IP1_LN2_TXFCLK", "Output clock"},
	{404, 29, "DEV_SERDES_10G0_IP1_LN2_TXMCLK", "Output clock"},
	{404, 30, "DEV_SERDES_10G0_IP1_LN3_REFCLK", "Output clock"},
	{404, 31, "DEV_SERDES_10G0_IP1_LN3_RXCLK", "Output clock"},
	{404, 32, "DEV_SERDES_10G0_IP1_LN3_RXFCLK", "Output clock"},
	{404, 33, "DEV_SERDES_10G0_IP1_LN3_TXCLK", "Input clock"},
	{404, 34, "DEV_SERDES_10G0_IP1_LN3_TXFCLK", "Output clock"},
	{404, 35, "DEV_SERDES_10G0_IP1_LN3_TXMCLK", "Output clock"},
	{404, 36, "DEV_SERDES_10G0_IP2_LN0_REFCLK", "Output clock"},
	{404, 37, "DEV_SERDES_10G0_IP2_LN0_RXCLK", "Output clock"},
	{404, 38, "DEV_SERDES_10G0_IP2_LN0_RXFCLK", "Output clock"},
	{404, 39, "DEV_SERDES_10G0_IP2_LN0_TXCLK", "Input clock"},
	{404, 40, "DEV_SERDES_10G0_IP2_LN0_TXFCLK", "Output clock"},
	{404, 41, "DEV_SERDES_10G0_IP2_LN0_TXMCLK", "Output clock"},
	{404, 42, "DEV_SERDES_10G0_IP2_LN1_REFCLK", "Output clock"},
	{404, 43, "DEV_SERDES_10G0_IP2_LN1_RXCLK", "Output clock"},
	{404, 44, "DEV_SERDES_10G0_IP2_LN1_RXFCLK", "Output clock"},
	{404, 45, "DEV_SERDES_10G0_IP2_LN1_TXCLK", "Input clock"},
	{404, 46, "DEV_SERDES_10G0_IP2_LN1_TXFCLK", "Output clock"},
	{404, 47, "DEV_SERDES_10G0_IP2_LN1_TXMCLK", "Output clock"},
	{404, 48, "DEV_SERDES_10G0_IP2_LN2_REFCLK", "Output clock"},
	{404, 49, "DEV_SERDES_10G0_IP2_LN2_RXCLK", "Output clock"},
	{404, 50, "DEV_SERDES_10G0_IP2_LN2_RXFCLK", "Output clock"},
	{404, 51, "DEV_SERDES_10G0_IP2_LN2_TXCLK", "Input clock"},
	{404, 52, "DEV_SERDES_10G0_IP2_LN2_TXFCLK", "Output clock"},
	{404, 53, "DEV_SERDES_10G0_IP2_LN2_TXMCLK", "Output clock"},
	{404, 54, "DEV_SERDES_10G0_IP2_LN3_REFCLK", "Output clock"},
	{404, 55, "DEV_SERDES_10G0_IP2_LN3_RXCLK", "Output clock"},
	{404, 56, "DEV_SERDES_10G0_IP2_LN3_RXFCLK", "Output clock"},
	{404, 57, "DEV_SERDES_10G0_IP2_LN3_TXCLK", "Input clock"},
	{404, 58, "DEV_SERDES_10G0_IP2_LN3_TXFCLK", "Output clock"},
	{404, 59, "DEV_SERDES_10G0_IP2_LN3_TXMCLK", "Output clock"},
	{404, 78, "DEV_SERDES_10G0_IP3_LN3_REFCLK", "Output clock"},
	{404, 79, "DEV_SERDES_10G0_IP3_LN3_RXCLK", "Output clock"},
	{404, 80, "DEV_SERDES_10G0_IP3_LN3_RXFCLK", "Output clock"},
	{404, 81, "DEV_SERDES_10G0_IP3_LN3_TXCLK", "Input clock"},
	{404, 82, "DEV_SERDES_10G0_IP3_LN3_TXFCLK", "Output clock"},
	{404, 83, "DEV_SERDES_10G0_IP3_LN3_TXMCLK", "Output clock"},
	{404, 84, "DEV_SERDES_10G0_IP4_LN0_REFCLK", "Output clock"},
	{404, 85, "DEV_SERDES_10G0_IP4_LN0_RXCLK", "Output clock"},
	{404, 86, "DEV_SERDES_10G0_IP4_LN0_RXFCLK", "Output clock"},
	{404, 87, "DEV_SERDES_10G0_IP4_LN0_TXCLK", "Input clock"},
	{404, 88, "DEV_SERDES_10G0_IP4_LN0_TXFCLK", "Output clock"},
	{404, 89, "DEV_SERDES_10G0_IP4_LN0_TXMCLK", "Output clock"},
	{404, 90, "DEV_SERDES_10G0_IP4_LN1_REFCLK", "Output clock"},
	{404, 91, "DEV_SERDES_10G0_IP4_LN1_RXCLK", "Output clock"},
	{404, 92, "DEV_SERDES_10G0_IP4_LN1_RXFCLK", "Output clock"},
	{404, 93, "DEV_SERDES_10G0_IP4_LN1_TXCLK", "Input clock"},
	{404, 94, "DEV_SERDES_10G0_IP4_LN1_TXFCLK", "Output clock"},
	{404, 95, "DEV_SERDES_10G0_IP4_LN1_TXMCLK", "Output clock"},
	{404, 96, "DEV_SERDES_10G0_IP4_LN2_REFCLK", "Output clock"},
	{404, 97, "DEV_SERDES_10G0_IP4_LN2_RXCLK", "Output clock"},
	{404, 98, "DEV_SERDES_10G0_IP4_LN2_RXFCLK", "Output clock"},
	{404, 99, "DEV_SERDES_10G0_IP4_LN2_TXCLK", "Input clock"},
	{404, 100, "DEV_SERDES_10G0_IP4_LN2_TXFCLK", "Output clock"},
	{404, 101, "DEV_SERDES_10G0_IP4_LN2_TXMCLK", "Output clock"},
	{404, 102, "DEV_SERDES_10G0_IP4_LN3_REFCLK", "Output clock"},
	{404, 103, "DEV_SERDES_10G0_IP4_LN3_RXCLK", "Output clock"},
	{404, 104, "DEV_SERDES_10G0_IP4_LN3_RXFCLK", "Output clock"},
	{404, 105, "DEV_SERDES_10G0_IP4_LN3_TXCLK", "Input clock"},
	{404, 106, "DEV_SERDES_10G0_IP4_LN3_TXFCLK", "Output clock"},
	{404, 107, "DEV_SERDES_10G0_IP4_LN3_TXMCLK", "Output clock"},
	{404, 124, "DEV_SERDES_10G0_REF_DER_OUT_CLK", "Output clock"},
	{404, 125, "DEV_SERDES_10G0_REF_OUT_CLK", "Output clock"},
	{404, 129, "DEV_SERDES_10G0_TAP_TCK", "Input clock"},
	{405, 2, "DEV_SERDES_10G1_CLK", "Input clock"},
	{405, 3, "DEV_SERDES_10G1_CMN_REFCLK_M", "Input clock"},
	{405, 3, "DEV_SERDES_10G1_CMN_REFCLK_M", "Output clock"},
	{405, 4, "DEV_SERDES_10G1_CMN_REFCLK_P", "Input clock"},
	{405, 4, "DEV_SERDES_10G1_CMN_REFCLK_P", "Output clock"},
	{405, 5, "DEV_SERDES_10G1_CORE_REF1_CLK", "Input clock"},
	{405, 6, "DEV_SERDES_10G1_CORE_REF_CLK", "Input muxed clock"},
	{405, 7, "DEV_SERDES_10G1_CORE_REF_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_SERDES_10G1_CORE_REF_CLK"},
	{405, 8, "DEV_SERDES_10G1_CORE_REF_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_SERDES_10G1_CORE_REF_CLK"},
	{405, 9, "DEV_SERDES_10G1_CORE_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_10G1_CORE_REF_CLK"},
	{405, 10, "DEV_SERDES_10G1_CORE_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_10G1_CORE_REF_CLK"},
	{405, 12, "DEV_SERDES_10G1_IP1_LN0_REFCLK", "Output clock"},
	{405, 13, "DEV_SERDES_10G1_IP1_LN0_RXCLK", "Output clock"},
	{405, 14, "DEV_SERDES_10G1_IP1_LN0_RXFCLK", "Output clock"},
	{405, 15, "DEV_SERDES_10G1_IP1_LN0_TXCLK", "Input clock"},
	{405, 16, "DEV_SERDES_10G1_IP1_LN0_TXFCLK", "Output clock"},
	{405, 17, "DEV_SERDES_10G1_IP1_LN0_TXMCLK", "Output clock"},
	{405, 18, "DEV_SERDES_10G1_IP1_LN1_REFCLK", "Output clock"},
	{405, 19, "DEV_SERDES_10G1_IP1_LN1_RXCLK", "Output clock"},
	{405, 20, "DEV_SERDES_10G1_IP1_LN1_RXFCLK", "Output clock"},
	{405, 21, "DEV_SERDES_10G1_IP1_LN1_TXCLK", "Input clock"},
	{405, 22, "DEV_SERDES_10G1_IP1_LN1_TXFCLK", "Output clock"},
	{405, 23, "DEV_SERDES_10G1_IP1_LN1_TXMCLK", "Output clock"},
	{405, 24, "DEV_SERDES_10G1_IP1_LN2_REFCLK", "Output clock"},
	{405, 25, "DEV_SERDES_10G1_IP1_LN2_RXCLK", "Output clock"},
	{405, 26, "DEV_SERDES_10G1_IP1_LN2_RXFCLK", "Output clock"},
	{405, 27, "DEV_SERDES_10G1_IP1_LN2_TXCLK", "Input clock"},
	{405, 28, "DEV_SERDES_10G1_IP1_LN2_TXFCLK", "Output clock"},
	{405, 29, "DEV_SERDES_10G1_IP1_LN2_TXMCLK", "Output clock"},
	{405, 30, "DEV_SERDES_10G1_IP1_LN3_REFCLK", "Output clock"},
	{405, 31, "DEV_SERDES_10G1_IP1_LN3_RXCLK", "Output clock"},
	{405, 32, "DEV_SERDES_10G1_IP1_LN3_RXFCLK", "Output clock"},
	{405, 33, "DEV_SERDES_10G1_IP1_LN3_TXCLK", "Input clock"},
	{405, 34, "DEV_SERDES_10G1_IP1_LN3_TXFCLK", "Output clock"},
	{405, 35, "DEV_SERDES_10G1_IP1_LN3_TXMCLK", "Output clock"},
	{405, 36, "DEV_SERDES_10G1_IP2_LN0_REFCLK", "Output clock"},
	{405, 37, "DEV_SERDES_10G1_IP2_LN0_RXCLK", "Output clock"},
	{405, 38, "DEV_SERDES_10G1_IP2_LN0_RXFCLK", "Output clock"},
	{405, 39, "DEV_SERDES_10G1_IP2_LN0_TXCLK", "Input clock"},
	{405, 40, "DEV_SERDES_10G1_IP2_LN0_TXFCLK", "Output clock"},
	{405, 41, "DEV_SERDES_10G1_IP2_LN0_TXMCLK", "Output clock"},
	{405, 42, "DEV_SERDES_10G1_IP2_LN1_REFCLK", "Output clock"},
	{405, 43, "DEV_SERDES_10G1_IP2_LN1_RXCLK", "Output clock"},
	{405, 44, "DEV_SERDES_10G1_IP2_LN1_RXFCLK", "Output clock"},
	{405, 45, "DEV_SERDES_10G1_IP2_LN1_TXCLK", "Input clock"},
	{405, 46, "DEV_SERDES_10G1_IP2_LN1_TXFCLK", "Output clock"},
	{405, 47, "DEV_SERDES_10G1_IP2_LN1_TXMCLK", "Output clock"},
	{405, 48, "DEV_SERDES_10G1_IP2_LN2_REFCLK", "Output clock"},
	{405, 49, "DEV_SERDES_10G1_IP2_LN2_RXCLK", "Output clock"},
	{405, 50, "DEV_SERDES_10G1_IP2_LN2_RXFCLK", "Output clock"},
	{405, 51, "DEV_SERDES_10G1_IP2_LN2_TXCLK", "Input clock"},
	{405, 52, "DEV_SERDES_10G1_IP2_LN2_TXFCLK", "Output clock"},
	{405, 53, "DEV_SERDES_10G1_IP2_LN2_TXMCLK", "Output clock"},
	{405, 54, "DEV_SERDES_10G1_IP2_LN3_REFCLK", "Output clock"},
	{405, 55, "DEV_SERDES_10G1_IP2_LN3_RXCLK", "Output clock"},
	{405, 56, "DEV_SERDES_10G1_IP2_LN3_RXFCLK", "Output clock"},
	{405, 57, "DEV_SERDES_10G1_IP2_LN3_TXCLK", "Input clock"},
	{405, 58, "DEV_SERDES_10G1_IP2_LN3_TXFCLK", "Output clock"},
	{405, 59, "DEV_SERDES_10G1_IP2_LN3_TXMCLK", "Output clock"},
	{405, 72, "DEV_SERDES_10G1_IP3_LN2_REFCLK", "Output clock"},
	{405, 73, "DEV_SERDES_10G1_IP3_LN2_RXCLK", "Output clock"},
	{405, 74, "DEV_SERDES_10G1_IP3_LN2_RXFCLK", "Output clock"},
	{405, 75, "DEV_SERDES_10G1_IP3_LN2_TXCLK", "Input clock"},
	{405, 76, "DEV_SERDES_10G1_IP3_LN2_TXFCLK", "Output clock"},
	{405, 77, "DEV_SERDES_10G1_IP3_LN2_TXMCLK", "Output clock"},
	{405, 78, "DEV_SERDES_10G1_IP3_LN3_REFCLK", "Output clock"},
	{405, 79, "DEV_SERDES_10G1_IP3_LN3_RXCLK", "Output clock"},
	{405, 80, "DEV_SERDES_10G1_IP3_LN3_RXFCLK", "Output clock"},
	{405, 81, "DEV_SERDES_10G1_IP3_LN3_TXCLK", "Input clock"},
	{405, 82, "DEV_SERDES_10G1_IP3_LN3_TXFCLK", "Output clock"},
	{405, 83, "DEV_SERDES_10G1_IP3_LN3_TXMCLK", "Output clock"},
	{405, 124, "DEV_SERDES_10G1_REF_DER_OUT_CLK", "Output clock"},
	{405, 125, "DEV_SERDES_10G1_REF_OUT_CLK", "Output clock"},
	{405, 129, "DEV_SERDES_10G1_TAP_TCK", "Input clock"},
	{406, 2, "DEV_SERDES_10G2_CLK", "Input clock"},
	{406, 3, "DEV_SERDES_10G2_CMN_REFCLK_M", "Input clock"},
	{406, 3, "DEV_SERDES_10G2_CMN_REFCLK_M", "Output clock"},
	{406, 4, "DEV_SERDES_10G2_CMN_REFCLK_P", "Input clock"},
	{406, 5, "DEV_SERDES_10G2_CORE_REF1_CLK", "Input clock"},
	{406, 6, "DEV_SERDES_10G2_CORE_REF_CLK", "Input muxed clock"},
	{406, 7, "DEV_SERDES_10G2_CORE_REF_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_SERDES_10G2_CORE_REF_CLK"},
	{406, 8, "DEV_SERDES_10G2_CORE_REF_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_SERDES_10G2_CORE_REF_CLK"},
	{406, 9, "DEV_SERDES_10G2_CORE_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_10G2_CORE_REF_CLK"},
	{406, 10, "DEV_SERDES_10G2_CORE_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_10G2_CORE_REF_CLK"},
	{406, 12, "DEV_SERDES_10G2_IP1_LN0_REFCLK", "Output clock"},
	{406, 13, "DEV_SERDES_10G2_IP1_LN0_RXCLK", "Output clock"},
	{406, 14, "DEV_SERDES_10G2_IP1_LN0_RXFCLK", "Output clock"},
	{406, 15, "DEV_SERDES_10G2_IP1_LN0_TXCLK", "Input clock"},
	{406, 16, "DEV_SERDES_10G2_IP1_LN0_TXFCLK", "Output clock"},
	{406, 17, "DEV_SERDES_10G2_IP1_LN0_TXMCLK", "Output clock"},
	{406, 18, "DEV_SERDES_10G2_IP1_LN1_REFCLK", "Output clock"},
	{406, 19, "DEV_SERDES_10G2_IP1_LN1_RXCLK", "Output clock"},
	{406, 20, "DEV_SERDES_10G2_IP1_LN1_RXFCLK", "Output clock"},
	{406, 21, "DEV_SERDES_10G2_IP1_LN1_TXCLK", "Input clock"},
	{406, 22, "DEV_SERDES_10G2_IP1_LN1_TXFCLK", "Output clock"},
	{406, 23, "DEV_SERDES_10G2_IP1_LN1_TXMCLK", "Output clock"},
	{406, 24, "DEV_SERDES_10G2_IP1_LN2_REFCLK", "Output clock"},
	{406, 25, "DEV_SERDES_10G2_IP1_LN2_RXCLK", "Output clock"},
	{406, 26, "DEV_SERDES_10G2_IP1_LN2_RXFCLK", "Output clock"},
	{406, 27, "DEV_SERDES_10G2_IP1_LN2_TXCLK", "Input clock"},
	{406, 28, "DEV_SERDES_10G2_IP1_LN2_TXFCLK", "Output clock"},
	{406, 29, "DEV_SERDES_10G2_IP1_LN2_TXMCLK", "Output clock"},
	{406, 30, "DEV_SERDES_10G2_IP1_LN3_REFCLK", "Output clock"},
	{406, 31, "DEV_SERDES_10G2_IP1_LN3_RXCLK", "Output clock"},
	{406, 32, "DEV_SERDES_10G2_IP1_LN3_RXFCLK", "Output clock"},
	{406, 33, "DEV_SERDES_10G2_IP1_LN3_TXCLK", "Input clock"},
	{406, 34, "DEV_SERDES_10G2_IP1_LN3_TXFCLK", "Output clock"},
	{406, 35, "DEV_SERDES_10G2_IP1_LN3_TXMCLK", "Output clock"},
	{406, 48, "DEV_SERDES_10G2_IP2_LN2_REFCLK", "Output clock"},
	{406, 49, "DEV_SERDES_10G2_IP2_LN2_RXCLK", "Output clock"},
	{406, 50, "DEV_SERDES_10G2_IP2_LN2_RXFCLK", "Output clock"},
	{406, 51, "DEV_SERDES_10G2_IP2_LN2_TXCLK", "Input clock"},
	{406, 52, "DEV_SERDES_10G2_IP2_LN2_TXFCLK", "Output clock"},
	{406, 53, "DEV_SERDES_10G2_IP2_LN2_TXMCLK", "Output clock"},
	{406, 54, "DEV_SERDES_10G2_IP2_LN3_REFCLK", "Output clock"},
	{406, 55, "DEV_SERDES_10G2_IP2_LN3_RXCLK", "Output clock"},
	{406, 56, "DEV_SERDES_10G2_IP2_LN3_RXFCLK", "Output clock"},
	{406, 57, "DEV_SERDES_10G2_IP2_LN3_TXCLK", "Input clock"},
	{406, 58, "DEV_SERDES_10G2_IP2_LN3_TXFCLK", "Output clock"},
	{406, 59, "DEV_SERDES_10G2_IP2_LN3_TXMCLK", "Output clock"},
	{406, 129, "DEV_SERDES_10G2_TAP_TCK", "Input clock"},
	{407, 2, "DEV_SERDES_10G4_CLK", "Input clock"},
	{407, 3, "DEV_SERDES_10G4_CMN_REFCLK_M", "Input clock"},
	{407, 3, "DEV_SERDES_10G4_CMN_REFCLK_M", "Output clock"},
	{407, 4, "DEV_SERDES_10G4_CMN_REFCLK_P", "Input clock"},
	{407, 4, "DEV_SERDES_10G4_CMN_REFCLK_P", "Output clock"},
	{407, 5, "DEV_SERDES_10G4_CORE_REF1_CLK", "Input clock"},
	{407, 6, "DEV_SERDES_10G4_CORE_REF_CLK", "Input muxed clock"},
	{407, 7, "DEV_SERDES_10G4_CORE_REF_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_SERDES_10G4_CORE_REF_CLK"},
	{407, 8, "DEV_SERDES_10G4_CORE_REF_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_SERDES_10G4_CORE_REF_CLK"},
	{407, 9, "DEV_SERDES_10G4_CORE_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_10G4_CORE_REF_CLK"},
	{407, 10, "DEV_SERDES_10G4_CORE_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_10G4_CORE_REF_CLK"},
	{407, 12, "DEV_SERDES_10G4_IP1_LN0_REFCLK", "Output clock"},
	{407, 13, "DEV_SERDES_10G4_IP1_LN0_RXCLK", "Output clock"},
	{407, 14, "DEV_SERDES_10G4_IP1_LN0_RXFCLK", "Output clock"},
	{407, 15, "DEV_SERDES_10G4_IP1_LN0_TXCLK", "Input clock"},
	{407, 16, "DEV_SERDES_10G4_IP1_LN0_TXFCLK", "Output clock"},
	{407, 17, "DEV_SERDES_10G4_IP1_LN0_TXMCLK", "Output clock"},
	{407, 18, "DEV_SERDES_10G4_IP1_LN1_REFCLK", "Output clock"},
	{407, 19, "DEV_SERDES_10G4_IP1_LN1_RXCLK", "Output clock"},
	{407, 20, "DEV_SERDES_10G4_IP1_LN1_RXFCLK", "Output clock"},
	{407, 21, "DEV_SERDES_10G4_IP1_LN1_TXCLK", "Input clock"},
	{407, 22, "DEV_SERDES_10G4_IP1_LN1_TXFCLK", "Output clock"},
	{407, 23, "DEV_SERDES_10G4_IP1_LN1_TXMCLK", "Output clock"},
	{407, 24, "DEV_SERDES_10G4_IP1_LN2_REFCLK", "Output clock"},
	{407, 25, "DEV_SERDES_10G4_IP1_LN2_RXCLK", "Output clock"},
	{407, 26, "DEV_SERDES_10G4_IP1_LN2_RXFCLK", "Output clock"},
	{407, 27, "DEV_SERDES_10G4_IP1_LN2_TXCLK", "Input clock"},
	{407, 28, "DEV_SERDES_10G4_IP1_LN2_TXFCLK", "Output clock"},
	{407, 29, "DEV_SERDES_10G4_IP1_LN2_TXMCLK", "Output clock"},
	{407, 30, "DEV_SERDES_10G4_IP1_LN3_REFCLK", "Output clock"},
	{407, 31, "DEV_SERDES_10G4_IP1_LN3_RXCLK", "Output clock"},
	{407, 32, "DEV_SERDES_10G4_IP1_LN3_RXFCLK", "Output clock"},
	{407, 33, "DEV_SERDES_10G4_IP1_LN3_TXCLK", "Input clock"},
	{407, 34, "DEV_SERDES_10G4_IP1_LN3_TXFCLK", "Output clock"},
	{407, 35, "DEV_SERDES_10G4_IP1_LN3_TXMCLK", "Output clock"},
	{407, 36, "DEV_SERDES_10G4_IP2_LN0_REFCLK", "Output clock"},
	{407, 37, "DEV_SERDES_10G4_IP2_LN0_RXCLK", "Output clock"},
	{407, 38, "DEV_SERDES_10G4_IP2_LN0_RXFCLK", "Output clock"},
	{407, 39, "DEV_SERDES_10G4_IP2_LN0_TXCLK", "Input clock"},
	{407, 40, "DEV_SERDES_10G4_IP2_LN0_TXFCLK", "Output clock"},
	{407, 41, "DEV_SERDES_10G4_IP2_LN0_TXMCLK", "Output clock"},
	{407, 42, "DEV_SERDES_10G4_IP2_LN1_REFCLK", "Output clock"},
	{407, 43, "DEV_SERDES_10G4_IP2_LN1_RXCLK", "Output clock"},
	{407, 44, "DEV_SERDES_10G4_IP2_LN1_RXFCLK", "Output clock"},
	{407, 45, "DEV_SERDES_10G4_IP2_LN1_TXCLK", "Input clock"},
	{407, 46, "DEV_SERDES_10G4_IP2_LN1_TXFCLK", "Output clock"},
	{407, 47, "DEV_SERDES_10G4_IP2_LN1_TXMCLK", "Output clock"},
	{407, 48, "DEV_SERDES_10G4_IP2_LN2_REFCLK", "Output clock"},
	{407, 49, "DEV_SERDES_10G4_IP2_LN2_RXCLK", "Output clock"},
	{407, 50, "DEV_SERDES_10G4_IP2_LN2_RXFCLK", "Output clock"},
	{407, 51, "DEV_SERDES_10G4_IP2_LN2_TXCLK", "Input clock"},
	{407, 52, "DEV_SERDES_10G4_IP2_LN2_TXFCLK", "Output clock"},
	{407, 53, "DEV_SERDES_10G4_IP2_LN2_TXMCLK", "Output clock"},
	{407, 54, "DEV_SERDES_10G4_IP2_LN3_REFCLK", "Output clock"},
	{407, 55, "DEV_SERDES_10G4_IP2_LN3_RXCLK", "Output clock"},
	{407, 56, "DEV_SERDES_10G4_IP2_LN3_RXFCLK", "Output clock"},
	{407, 57, "DEV_SERDES_10G4_IP2_LN3_TXCLK", "Input clock"},
	{407, 58, "DEV_SERDES_10G4_IP2_LN3_TXFCLK", "Output clock"},
	{407, 59, "DEV_SERDES_10G4_IP2_LN3_TXMCLK", "Output clock"},
	{407, 78, "DEV_SERDES_10G4_IP3_LN3_REFCLK", "Output clock"},
	{407, 79, "DEV_SERDES_10G4_IP3_LN3_RXCLK", "Output clock"},
	{407, 80, "DEV_SERDES_10G4_IP3_LN3_RXFCLK", "Output clock"},
	{407, 81, "DEV_SERDES_10G4_IP3_LN3_TXCLK", "Input clock"},
	{407, 82, "DEV_SERDES_10G4_IP3_LN3_TXFCLK", "Output clock"},
	{407, 83, "DEV_SERDES_10G4_IP3_LN3_TXMCLK", "Output clock"},
	{407, 84, "DEV_SERDES_10G4_IP4_LN0_REFCLK", "Output clock"},
	{407, 85, "DEV_SERDES_10G4_IP4_LN0_RXCLK", "Output clock"},
	{407, 86, "DEV_SERDES_10G4_IP4_LN0_RXFCLK", "Output clock"},
	{407, 87, "DEV_SERDES_10G4_IP4_LN0_TXCLK", "Input clock"},
	{407, 88, "DEV_SERDES_10G4_IP4_LN0_TXFCLK", "Output clock"},
	{407, 89, "DEV_SERDES_10G4_IP4_LN0_TXMCLK", "Output clock"},
	{407, 90, "DEV_SERDES_10G4_IP4_LN1_REFCLK", "Output clock"},
	{407, 91, "DEV_SERDES_10G4_IP4_LN1_RXCLK", "Output clock"},
	{407, 92, "DEV_SERDES_10G4_IP4_LN1_RXFCLK", "Output clock"},
	{407, 93, "DEV_SERDES_10G4_IP4_LN1_TXCLK", "Input clock"},
	{407, 94, "DEV_SERDES_10G4_IP4_LN1_TXFCLK", "Output clock"},
	{407, 95, "DEV_SERDES_10G4_IP4_LN1_TXMCLK", "Output clock"},
	{407, 96, "DEV_SERDES_10G4_IP4_LN2_REFCLK", "Output clock"},
	{407, 97, "DEV_SERDES_10G4_IP4_LN2_RXCLK", "Output clock"},
	{407, 98, "DEV_SERDES_10G4_IP4_LN2_RXFCLK", "Output clock"},
	{407, 99, "DEV_SERDES_10G4_IP4_LN2_TXCLK", "Input clock"},
	{407, 100, "DEV_SERDES_10G4_IP4_LN2_TXFCLK", "Output clock"},
	{407, 101, "DEV_SERDES_10G4_IP4_LN2_TXMCLK", "Output clock"},
	{407, 102, "DEV_SERDES_10G4_IP4_LN3_REFCLK", "Output clock"},
	{407, 103, "DEV_SERDES_10G4_IP4_LN3_RXCLK", "Output clock"},
	{407, 104, "DEV_SERDES_10G4_IP4_LN3_RXFCLK", "Output clock"},
	{407, 105, "DEV_SERDES_10G4_IP4_LN3_TXCLK", "Input clock"},
	{407, 106, "DEV_SERDES_10G4_IP4_LN3_TXFCLK", "Output clock"},
	{407, 107, "DEV_SERDES_10G4_IP4_LN3_TXMCLK", "Output clock"},
	{77, 0, "DEV_STM0_ATB_CLK", "Input clock"},
	{77, 1, "DEV_STM0_CORE_CLK", "Input clock"},
	{77, 2, "DEV_STM0_VBUSP_CLK", "Input clock"},
	{97, 0, "DEV_TIMER0_TIMER_HCLK_CLK", "Input clock"},
	{97, 1, "DEV_TIMER0_TIMER_PWM", "Output clock"},
	{97, 2, "DEV_TIMER0_TIMER_TCLK_CLK", "Input muxed clock"},
	{97, 3, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{97, 4, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{97, 5, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT8_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{97, 6, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{97, 7, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{97, 8, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{97, 9, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{97, 10, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{97, 11, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{97, 12, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{97, 13, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{97, 14, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{97, 15, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{97, 16, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{97, 17, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{97, 18, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_CPSW_9XUSS_J7AM_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{98, 0, "DEV_TIMER1_TIMER_HCLK_CLK", "Input clock"},
	{98, 2, "DEV_TIMER1_TIMER_TCLK_CLK", "Input muxed clock"},
	{98, 3, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT1", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{98, 4, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_0_TIMER_PWM", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{107, 0, "DEV_TIMER10_TIMER_HCLK_CLK", "Input clock"},
	{107, 1, "DEV_TIMER10_TIMER_PWM", "Output clock"},
	{107, 2, "DEV_TIMER10_TIMER_TCLK_CLK", "Input muxed clock"},
	{107, 3, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{107, 4, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{107, 5, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT8_CLK", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{107, 6, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{107, 7, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{107, 8, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{107, 9, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{107, 10, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{107, 11, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{107, 12, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{107, 13, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{107, 14, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{107, 15, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{107, 16, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{107, 17, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{107, 18, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_CPSW_9XUSS_J7AM_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{108, 0, "DEV_TIMER11_TIMER_HCLK_CLK", "Input clock"},
	{108, 2, "DEV_TIMER11_TIMER_TCLK_CLK", "Input muxed clock"},
	{108, 3, "DEV_TIMER11_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT11", "Parent input clock option to DEV_TIMER11_TIMER_TCLK_CLK"},
	{108, 4, "DEV_TIMER11_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_10_TIMER_PWM", "Parent input clock option to DEV_TIMER11_TIMER_TCLK_CLK"},
	{109, 0, "DEV_TIMER12_TIMER_HCLK_CLK", "Input clock"},
	{109, 1, "DEV_TIMER12_TIMER_PWM", "Output clock"},
	{109, 2, "DEV_TIMER12_TIMER_TCLK_CLK", "Input muxed clock"},
	{109, 3, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{109, 4, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{109, 5, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT8_CLK", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{109, 6, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{109, 7, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{109, 8, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{109, 9, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{109, 10, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{109, 11, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{109, 12, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{109, 13, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{109, 14, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{109, 15, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{109, 16, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{109, 17, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{109, 18, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_CPSW_9XUSS_J7AM_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{110, 0, "DEV_TIMER13_TIMER_HCLK_CLK", "Input clock"},
	{110, 2, "DEV_TIMER13_TIMER_TCLK_CLK", "Input muxed clock"},
	{110, 3, "DEV_TIMER13_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT13", "Parent input clock option to DEV_TIMER13_TIMER_TCLK_CLK"},
	{110, 4, "DEV_TIMER13_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_12_TIMER_PWM", "Parent input clock option to DEV_TIMER13_TIMER_TCLK_CLK"},
	{111, 0, "DEV_TIMER14_TIMER_HCLK_CLK", "Input clock"},
	{111, 1, "DEV_TIMER14_TIMER_PWM", "Output clock"},
	{111, 2, "DEV_TIMER14_TIMER_TCLK_CLK", "Input muxed clock"},
	{111, 3, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{111, 4, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{111, 5, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT8_CLK", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{111, 6, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{111, 7, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{111, 8, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{111, 9, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{111, 10, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{111, 11, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{111, 12, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{111, 13, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{111, 14, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{111, 15, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{111, 16, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{111, 17, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{111, 18, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_CPSW_9XUSS_J7AM_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{112, 0, "DEV_TIMER15_TIMER_HCLK_CLK", "Input clock"},
	{112, 2, "DEV_TIMER15_TIMER_TCLK_CLK", "Input muxed clock"},
	{112, 3, "DEV_TIMER15_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT15", "Parent input clock option to DEV_TIMER15_TIMER_TCLK_CLK"},
	{112, 4, "DEV_TIMER15_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_14_TIMER_PWM", "Parent input clock option to DEV_TIMER15_TIMER_TCLK_CLK"},
	{113, 0, "DEV_TIMER16_TIMER_HCLK_CLK", "Input clock"},
	{113, 1, "DEV_TIMER16_TIMER_PWM", "Output clock"},
	{113, 2, "DEV_TIMER16_TIMER_TCLK_CLK", "Input muxed clock"},
	{113, 3, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT16", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{113, 4, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_MAIN_TIMER16_AFS_SEL_OUT0", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{114, 0, "DEV_TIMER17_TIMER_HCLK_CLK", "Input clock"},
	{114, 2, "DEV_TIMER17_TIMER_TCLK_CLK", "Input muxed clock"},
	{114, 3, "DEV_TIMER17_TIMER_TCLK_CLK_PARENT_MAIN_TIMER17_AFS_EN_OUT0", "Parent input clock option to DEV_TIMER17_TIMER_TCLK_CLK"},
	{114, 4, "DEV_TIMER17_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_16_TIMER_PWM", "Parent input clock option to DEV_TIMER17_TIMER_TCLK_CLK"},
	{115, 0, "DEV_TIMER18_TIMER_HCLK_CLK", "Input clock"},
	{115, 1, "DEV_TIMER18_TIMER_PWM", "Output clock"},
	{115, 2, "DEV_TIMER18_TIMER_TCLK_CLK", "Input muxed clock"},
	{115, 3, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT18", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{115, 4, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_MAIN_TIMER18_AFS_SEL_OUT0", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{116, 0, "DEV_TIMER19_TIMER_HCLK_CLK", "Input clock"},
	{116, 2, "DEV_TIMER19_TIMER_TCLK_CLK", "Input muxed clock"},
	{116, 3, "DEV_TIMER19_TIMER_TCLK_CLK_PARENT_MAIN_TIMER19_AFS_EN_OUT0", "Parent input clock option to DEV_TIMER19_TIMER_TCLK_CLK"},
	{116, 4, "DEV_TIMER19_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_18_TIMER_PWM", "Parent input clock option to DEV_TIMER19_TIMER_TCLK_CLK"},
	{99, 0, "DEV_TIMER2_TIMER_HCLK_CLK", "Input clock"},
	{99, 1, "DEV_TIMER2_TIMER_PWM", "Output clock"},
	{99, 2, "DEV_TIMER2_TIMER_TCLK_CLK", "Input muxed clock"},
	{99, 3, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{99, 4, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{99, 5, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT8_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{99, 6, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{99, 7, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{99, 8, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{99, 9, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{99, 10, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{99, 11, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{99, 12, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{99, 13, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{99, 14, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{99, 15, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{99, 16, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{99, 17, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{99, 18, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_CPSW_9XUSS_J7AM_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{100, 0, "DEV_TIMER3_TIMER_HCLK_CLK", "Input clock"},
	{100, 2, "DEV_TIMER3_TIMER_TCLK_CLK", "Input muxed clock"},
	{100, 3, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT3", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{100, 4, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_2_TIMER_PWM", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{101, 0, "DEV_TIMER4_TIMER_HCLK_CLK", "Input clock"},
	{101, 1, "DEV_TIMER4_TIMER_PWM", "Output clock"},
	{101, 2, "DEV_TIMER4_TIMER_TCLK_CLK", "Input muxed clock"},
	{101, 3, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{101, 4, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{101, 5, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT8_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{101, 6, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{101, 7, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{101, 8, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{101, 9, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{101, 10, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{101, 11, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{101, 12, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{101, 13, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{101, 14, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{101, 15, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{101, 16, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{101, 17, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{101, 18, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_CPSW_9XUSS_J7AM_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{102, 0, "DEV_TIMER5_TIMER_HCLK_CLK", "Input clock"},
	{102, 2, "DEV_TIMER5_TIMER_TCLK_CLK", "Input muxed clock"},
	{102, 3, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT5", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{102, 4, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_4_TIMER_PWM", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{103, 0, "DEV_TIMER6_TIMER_HCLK_CLK", "Input clock"},
	{103, 1, "DEV_TIMER6_TIMER_PWM", "Output clock"},
	{103, 2, "DEV_TIMER6_TIMER_TCLK_CLK", "Input muxed clock"},
	{103, 3, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{103, 4, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{103, 5, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT8_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{103, 6, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{103, 7, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{103, 8, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{103, 9, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{103, 10, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{103, 11, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{103, 12, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{103, 13, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{103, 14, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{103, 15, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{103, 16, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{103, 17, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{103, 18, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_CPSW_9XUSS_J7AM_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{104, 0, "DEV_TIMER7_TIMER_HCLK_CLK", "Input clock"},
	{104, 2, "DEV_TIMER7_TIMER_TCLK_CLK", "Input muxed clock"},
	{104, 3, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT7", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{104, 4, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_6_TIMER_PWM", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{105, 0, "DEV_TIMER8_TIMER_HCLK_CLK", "Input clock"},
	{105, 1, "DEV_TIMER8_TIMER_PWM", "Output clock"},
	{105, 2, "DEV_TIMER8_TIMER_TCLK_CLK", "Input muxed clock"},
	{105, 3, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{105, 4, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{105, 5, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_POSTDIV3_16FFT_MAIN_0_HSDIVOUT8_CLK", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{105, 6, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_J7AM_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{105, 7, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{105, 8, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{105, 9, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{105, 10, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LPXOSC_CLKOUT", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{105, 11, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{105, 12, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{105, 13, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{105, 14, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{105, 15, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{105, 16, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_NAVSS512J7AM_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{105, 17, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{105, 18, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_CPSW_9XUSS_J7AM_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{106, 0, "DEV_TIMER9_TIMER_HCLK_CLK", "Input clock"},
	{106, 2, "DEV_TIMER9_TIMER_TCLK_CLK", "Input muxed clock"},
	{106, 3, "DEV_TIMER9_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT9", "Parent input clock option to DEV_TIMER9_TIMER_TCLK_CLK"},
	{106, 4, "DEV_TIMER9_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_8_TIMER_PWM", "Parent input clock option to DEV_TIMER9_TIMER_TCLK_CLK"},
	{176, 0, "DEV_TIMESYNC_INTRTR0_INTR_CLK", "Input clock"},
	{146, 0, "DEV_UART0_FCLK_CLK", "Input clock"},
	{146, 3, "DEV_UART0_VBUSP_CLK", "Input clock"},
	{388, 0, "DEV_UART1_FCLK_CLK", "Input clock"},
	{388, 3, "DEV_UART1_VBUSP_CLK", "Input clock"},
	{389, 0, "DEV_UART2_FCLK_CLK", "Input clock"},
	{389, 3, "DEV_UART2_VBUSP_CLK", "Input clock"},
	{390, 0, "DEV_UART3_FCLK_CLK", "Input clock"},
	{390, 3, "DEV_UART3_VBUSP_CLK", "Input clock"},
	{391, 0, "DEV_UART4_FCLK_CLK", "Input clock"},
	{391, 3, "DEV_UART4_VBUSP_CLK", "Input clock"},
	{392, 0, "DEV_UART5_FCLK_CLK", "Input clock"},
	{392, 3, "DEV_UART5_VBUSP_CLK", "Input clock"},
	{393, 0, "DEV_UART6_FCLK_CLK", "Input clock"},
	{393, 3, "DEV_UART6_VBUSP_CLK", "Input clock"},
	{394, 0, "DEV_UART7_FCLK_CLK", "Input clock"},
	{394, 3, "DEV_UART7_VBUSP_CLK", "Input clock"},
	{395, 0, "DEV_UART8_FCLK_CLK", "Input clock"},
	{395, 3, "DEV_UART8_VBUSP_CLK", "Input clock"},
	{396, 0, "DEV_UART9_FCLK_CLK", "Input clock"},
	{396, 3, "DEV_UART9_VBUSP_CLK", "Input clock"},
	{387, 1, "DEV_UFS0_UFSHCI_HCLK_CLK", "Input clock"},
	{387, 3, "DEV_UFS0_UFSHCI_MCLK_CLK", "Input muxed clock"},
	{387, 4, "DEV_UFS0_UFSHCI_MCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_UFS0_UFSHCI_MCLK_CLK"},
	{387, 5, "DEV_UFS0_UFSHCI_MCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_UFS0_UFSHCI_MCLK_CLK"},
	{387, 6, "DEV_UFS0_UFSHCI_MCLK_CLK_PARENT_POSTDIV3_16FFT_MAIN_1_HSDIVOUT6_CLK", "Parent input clock option to DEV_UFS0_UFSHCI_MCLK_CLK"},
	{387, 7, "DEV_UFS0_UFSHCI_MCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_UFS0_UFSHCI_MCLK_CLK"},
	{387, 8, "DEV_UFS0_UFSHCI_MPHY_REFCLK", "Output clock"},
	{387, 23, "DEV_UFS0_UFSHCI_MPHY_TX_REF_SYMBOLCLK", "Output clock"},
	{387, 24, "DEV_UFS0_UFSHCI_MPHY_M31_VCO_19P2M_CLK", "Output clock"},
	{387, 25, "DEV_UFS0_UFSHCI_MPHY_M31_VCO_26M_CLK", "Output clock"},
	{398, 0, "DEV_USB0_ACLK_CLK", "Input clock"},
	{398, 1, "DEV_USB0_BUF_CLK", "Input clock"},
	{398, 2, "DEV_USB0_CLK_LPM_CLK", "Input clock"},
	{398, 3, "DEV_USB0_PCLK_CLK", "Input clock"},
	{398, 4, "DEV_USB0_PIPE_REFCLK", "Input muxed clock"},
	{398, 5, "DEV_USB0_PIPE_REFCLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP3_LN3_REFCLK", "Parent input clock option to DEV_USB0_PIPE_REFCLK"},
	{398, 6, "DEV_USB0_PIPE_REFCLK_PARENT_WIZ16B8M4CT3_MAIN_4_IP3_LN3_REFCLK", "Parent input clock option to DEV_USB0_PIPE_REFCLK"},
	{398, 7, "DEV_USB0_PIPE_RXCLK", "Input muxed clock"},
	{398, 8, "DEV_USB0_PIPE_RXCLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP3_LN3_RXCLK", "Parent input clock option to DEV_USB0_PIPE_RXCLK"},
	{398, 9, "DEV_USB0_PIPE_RXCLK_PARENT_WIZ16B8M4CT3_MAIN_4_IP3_LN3_RXCLK", "Parent input clock option to DEV_USB0_PIPE_RXCLK"},
	{398, 10, "DEV_USB0_PIPE_RXFCLK", "Input muxed clock"},
	{398, 11, "DEV_USB0_PIPE_RXFCLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP3_LN3_RXFCLK", "Parent input clock option to DEV_USB0_PIPE_RXFCLK"},
	{398, 12, "DEV_USB0_PIPE_RXFCLK_PARENT_WIZ16B8M4CT3_MAIN_4_IP3_LN3_RXFCLK", "Parent input clock option to DEV_USB0_PIPE_RXFCLK"},
	{398, 13, "DEV_USB0_PIPE_TXCLK", "Output clock"},
	{398, 14, "DEV_USB0_PIPE_TXFCLK", "Input muxed clock"},
	{398, 15, "DEV_USB0_PIPE_TXFCLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP3_LN3_TXFCLK", "Parent input clock option to DEV_USB0_PIPE_TXFCLK"},
	{398, 16, "DEV_USB0_PIPE_TXFCLK_PARENT_WIZ16B8M4CT3_MAIN_4_IP3_LN3_TXFCLK", "Parent input clock option to DEV_USB0_PIPE_TXFCLK"},
	{398, 17, "DEV_USB0_PIPE_TXMCLK", "Input muxed clock"},
	{398, 18, "DEV_USB0_PIPE_TXMCLK_PARENT_WIZ16B8M4CT3_MAIN_0_IP3_LN3_TXMCLK", "Parent input clock option to DEV_USB0_PIPE_TXMCLK"},
	{398, 19, "DEV_USB0_PIPE_TXMCLK_PARENT_WIZ16B8M4CT3_MAIN_4_IP3_LN3_TXMCLK", "Parent input clock option to DEV_USB0_PIPE_TXMCLK"},
	{398, 20, "DEV_USB0_USB2_APB_PCLK_CLK", "Input clock"},
	{398, 21, "DEV_USB0_USB2_REFCLOCK_CLK", "Input muxed clock"},
	{398, 22, "DEV_USB0_USB2_REFCLOCK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_USB0_USB2_REFCLOCK_CLK"},
	{398, 23, "DEV_USB0_USB2_REFCLOCK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_USB0_USB2_REFCLOCK_CLK"},
	{398, 28, "DEV_USB0_USB2_TAP_TCK", "Input clock"},
	{399, 0, "DEV_VPAC0_LDC0_CLK_CLK", "Input clock"},
	{399, 1, "DEV_VPAC0_MAIN_CLK", "Input muxed clock"},
	{399, 2, "DEV_VPAC0_MAIN_CLK_PARENT_HSDIV1_16FFT_MAIN_25_HSDIVOUT1_CLK", "Parent input clock option to DEV_VPAC0_MAIN_CLK"},
	{399, 3, "DEV_VPAC0_MAIN_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_VPAC0_MAIN_CLK"},
	{399, 4, "DEV_VPAC0_MSC_CLK", "Input clock"},
	{399, 5, "DEV_VPAC0_NF_CLK_CLK", "Input clock"},
	{399, 6, "DEV_VPAC0_PSIL_LEAF_CLK", "Input clock"},
	{399, 7, "DEV_VPAC0_VISS0_CLK_CLK", "Input clock"},
	{400, 0, "DEV_VPAC1_LDC0_CLK_CLK", "Input clock"},
	{400, 1, "DEV_VPAC1_MAIN_CLK", "Input muxed clock"},
	{400, 2, "DEV_VPAC1_MAIN_CLK_PARENT_HSDIV1_16FFT_MAIN_25_HSDIVOUT1_CLK", "Parent input clock option to DEV_VPAC1_MAIN_CLK"},
	{400, 3, "DEV_VPAC1_MAIN_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_VPAC1_MAIN_CLK"},
	{400, 4, "DEV_VPAC1_MSC_CLK", "Input clock"},
	{400, 5, "DEV_VPAC1_NF_CLK_CLK", "Input clock"},
	{400, 6, "DEV_VPAC1_PSIL_LEAF_CLK", "Input clock"},
	{400, 7, "DEV_VPAC1_VISS0_CLK_CLK", "Input clock"},
	{401, 0, "DEV_VUSR_DUAL0_V0_CLK", "Input clock"},
	{401, 1, "DEV_VUSR_DUAL0_V0_RXFL_CLK", "Output clock"},
	{401, 2, "DEV_VUSR_DUAL0_V0_RXPM_CLK", "Input clock"},
	{401, 3, "DEV_VUSR_DUAL0_V0_TXFL_CLK", "Input clock"},
	{401, 4, "DEV_VUSR_DUAL0_V0_TXPM_CLK", "Output clock"},
	{401, 5, "DEV_VUSR_DUAL0_V1_CLK", "Input clock"},
	{401, 6, "DEV_VUSR_DUAL0_V1_RXFL_CLK", "Output clock"},
	{401, 7, "DEV_VUSR_DUAL0_V1_RXPM_CLK", "Input clock"},
	{401, 8, "DEV_VUSR_DUAL0_V1_TXFL_CLK", "Input clock"},
	{401, 9, "DEV_VUSR_DUAL0_V1_TXPM_CLK", "Output clock"},
	{401, 10, "DEV_VUSR_DUAL0_VUSRX_LN0_REFCLK", "Input clock"},
	{401, 11, "DEV_VUSR_DUAL0_VUSRX_LN0_RXCLK", "Input clock"},
	{401, 12, "DEV_VUSR_DUAL0_VUSRX_LN0_RXFCLK", "Input clock"},
	{401, 13, "DEV_VUSR_DUAL0_VUSRX_LN0_TXCLK", "Output clock"},
	{401, 14, "DEV_VUSR_DUAL0_VUSRX_LN0_TXFCLK", "Input clock"},
	{401, 15, "DEV_VUSR_DUAL0_VUSRX_LN0_TXMCLK", "Input clock"},
	{401, 16, "DEV_VUSR_DUAL0_VUSRX_LN1_REFCLK", "Input clock"},
	{401, 17, "DEV_VUSR_DUAL0_VUSRX_LN1_RXCLK", "Input clock"},
	{401, 18, "DEV_VUSR_DUAL0_VUSRX_LN1_RXFCLK", "Input clock"},
	{401, 19, "DEV_VUSR_DUAL0_VUSRX_LN1_TXCLK", "Output clock"},
	{401, 20, "DEV_VUSR_DUAL0_VUSRX_LN1_TXFCLK", "Input clock"},
	{401, 21, "DEV_VUSR_DUAL0_VUSRX_LN1_TXMCLK", "Input clock"},
	{401, 22, "DEV_VUSR_DUAL0_VUSRX_LN2_REFCLK", "Input clock"},
	{401, 23, "DEV_VUSR_DUAL0_VUSRX_LN2_RXCLK", "Input clock"},
	{401, 24, "DEV_VUSR_DUAL0_VUSRX_LN2_RXFCLK", "Input clock"},
	{401, 25, "DEV_VUSR_DUAL0_VUSRX_LN2_TXCLK", "Output clock"},
	{401, 26, "DEV_VUSR_DUAL0_VUSRX_LN2_TXFCLK", "Input clock"},
	{401, 27, "DEV_VUSR_DUAL0_VUSRX_LN2_TXMCLK", "Input clock"},
	{401, 28, "DEV_VUSR_DUAL0_VUSRX_LN3_REFCLK", "Input clock"},
	{401, 29, "DEV_VUSR_DUAL0_VUSRX_LN3_RXCLK", "Input clock"},
	{401, 30, "DEV_VUSR_DUAL0_VUSRX_LN3_RXFCLK", "Input clock"},
	{401, 31, "DEV_VUSR_DUAL0_VUSRX_LN3_TXCLK", "Output clock"},
	{401, 32, "DEV_VUSR_DUAL0_VUSRX_LN3_TXFCLK", "Input clock"},
	{401, 33, "DEV_VUSR_DUAL0_VUSRX_LN3_TXMCLK", "Input clock"},
	{211, 0, "DEV_WKUP_DDPA0_DDPA_CLK", "Input clock"},
	{147, 0, "DEV_WKUP_ESM0_CLK", "Input clock"},
	{167, 0, "DEV_WKUP_GPIO0_MMR_CLK", "Input clock"},
	{168, 0, "DEV_WKUP_GPIO1_MMR_CLK", "Input clock"},
	{177, 0, "DEV_WKUP_GPIOMUX_INTRTR0_INTR_CLK", "Input clock"},
	{371, 0, "DEV_WKUP_HSM0_DAP_CLK", "Input clock"},
	{279, 0, "DEV_WKUP_I2C0_CLK", "Input clock"},
	{279, 1, "DEV_WKUP_I2C0_PISCL", "Input clock"},
	{279, 2, "DEV_WKUP_I2C0_PISYS_CLK", "Input muxed clock"},
	{279, 3, "DEV_WKUP_I2C0_PISYS_CLK_PARENT_HSDIV4_16FFT_MCU_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_WKUP_I2C0_PISYS_CLK"},
	{279, 4, "DEV_WKUP_I2C0_PISYS_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_WKUP_I2C0_PISYS_CLK"},
	{279, 5, "DEV_WKUP_I2C0_PORSCL", "Output clock"},
	{9, 0, "DEV_WKUP_J7AM_WAKEUP_16FF0_PLL_CTRL_WKUP_CLK24_CLK", "Input clock"},
	{9, 1, "DEV_WKUP_J7AM_WAKEUP_16FF0_WKUP_RCOSC_12P5M_CLK", "Output clock"},
	{9, 2, "DEV_WKUP_J7AM_WAKEUP_16FF0_WKUP_RCOSC_32K_CLK", "Output clock"},
	{175, 0, "DEV_WKUP_PORZ_SYNC0_CLK_12M_RC_CLK", "Input clock"},
	{178, 0, "DEV_WKUP_PSC0_CLK", "Input clock"},
	{178, 1, "DEV_WKUP_PSC0_SLOW_CLK", "Input clock"},
	{397, 0, "DEV_WKUP_UART0_FCLK_CLK", "Input muxed clock"},
	{397, 1, "DEV_WKUP_UART0_FCLK_CLK_PARENT_WKUP_USART_CLKSEL_OUT0", "Parent input clock option to DEV_WKUP_UART0_FCLK_CLK"},
	{397, 2, "DEV_WKUP_UART0_FCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_WKUP_UART0_FCLK_CLK"},
	{397, 7, "DEV_WKUP_UART0_VBUSP_CLK", "Input clock"},
	{243, 0, "DEV_WKUP_VTM0_FIX_REF2_CLK", "Input clock"},
	{243, 1, "DEV_WKUP_VTM0_FIX_REF_CLK", "Input clock"},
	{243, 2, "DEV_WKUP_VTM0_VBUSP_CLK", "Input clock"},
};
