/*
Cloud Hypervisor API

Local HTTP based API for managing and inspecting a cloud-hypervisor virtual machine.

API version: 0.3.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package openapi

import (
	"encoding/json"
)

// BalloonConfig struct for BalloonConfig
type BalloonConfig struct {
	Size int64 `json:"size"`
	// Whether the balloon should deflate when the guest is under memory pressure.
	DeflateOnOom *bool `json:"deflate_on_oom,omitempty"`
}

// NewBalloonConfig instantiates a new BalloonConfig object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewBalloonConfig(size int64) *BalloonConfig {
	this := BalloonConfig{}
	this.Size = size
	var deflateOnOom bool = false
	this.DeflateOnOom = &deflateOnOom
	return &this
}

// NewBalloonConfigWithDefaults instantiates a new BalloonConfig object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewBalloonConfigWithDefaults() *BalloonConfig {
	this := BalloonConfig{}
	var deflateOnOom bool = false
	this.DeflateOnOom = &deflateOnOom
	return &this
}

// GetSize returns the Size field value
func (o *BalloonConfig) GetSize() int64 {
	if o == nil {
		var ret int64
		return ret
	}

	return o.Size
}

// GetSizeOk returns a tuple with the Size field value
// and a boolean to check if the value has been set.
func (o *BalloonConfig) GetSizeOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Size, true
}

// SetSize sets field value
func (o *BalloonConfig) SetSize(v int64) {
	o.Size = v
}

// GetDeflateOnOom returns the DeflateOnOom field value if set, zero value otherwise.
func (o *BalloonConfig) GetDeflateOnOom() bool {
	if o == nil || o.DeflateOnOom == nil {
		var ret bool
		return ret
	}
	return *o.DeflateOnOom
}

// GetDeflateOnOomOk returns a tuple with the DeflateOnOom field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *BalloonConfig) GetDeflateOnOomOk() (*bool, bool) {
	if o == nil || o.DeflateOnOom == nil {
		return nil, false
	}
	return o.DeflateOnOom, true
}

// HasDeflateOnOom returns a boolean if a field has been set.
func (o *BalloonConfig) HasDeflateOnOom() bool {
	if o != nil && o.DeflateOnOom != nil {
		return true
	}

	return false
}

// SetDeflateOnOom gets a reference to the given bool and assigns it to the DeflateOnOom field.
func (o *BalloonConfig) SetDeflateOnOom(v bool) {
	o.DeflateOnOom = &v
}

func (o BalloonConfig) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["size"] = o.Size
	}
	if o.DeflateOnOom != nil {
		toSerialize["deflate_on_oom"] = o.DeflateOnOom
	}
	return json.Marshal(toSerialize)
}

type NullableBalloonConfig struct {
	value *BalloonConfig
	isSet bool
}

func (v NullableBalloonConfig) Get() *BalloonConfig {
	return v.value
}

func (v *NullableBalloonConfig) Set(val *BalloonConfig) {
	v.value = val
	v.isSet = true
}

func (v NullableBalloonConfig) IsSet() bool {
	return v.isSet
}

func (v *NullableBalloonConfig) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableBalloonConfig(val *BalloonConfig) *NullableBalloonConfig {
	return &NullableBalloonConfig{value: val, isSet: true}
}

func (v NullableBalloonConfig) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableBalloonConfig) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
