### NAME

lib1305-speed - run some lib1305 speed tests

### SYNOPSIS

    lib1305-speed

### DESCRIPTION

`lib1305-speed`
runs some tests of the speed of
the lib1305 implementation of Poly1305.

The `lib1305-speed` output format is subject to change.
Examples of output lines with the current format,
from a `lib1305-speed` run on an Intel Skylake CPU core,
include the following:

    onetimeauth_poly1305 selected implementation amd64-mxaa-g24 compiler clang -Wall -fPIC -fwrapv -Qunused-arguments -O2 -mbmi -mbmi2 -mtune=skylake; Ubuntu clang version 14.0.0-1ubuntu1.1; Target: x86_64-pc-linux-gnu; Thread model: posix; InstalledDir: /usr/bin
    onetimeauth_poly1305_verify selected 8090 6563 +453+92+44+41-4-27+8-32-12+3-5-15+37-28+26+19-18-48-15+28+3+13+66-42+41-25-10+2-9-36+18-64

These lines say that the automatically selected implementation
for `onetimeauth_poly1305_verify`
was the `amd64-mxaa-g24` implementation compiled with the `clang` options shown,
taking an interquartile mean (IQM) of 6563 CPU cycles for 8090-byte inputs.
The numbers `6563 +453+92...` show the timings for a series of consecutive operations:
the IQM was 6563 cycles,
the first run took 453 cycles more than the IQM,
the second run took 92 cycles more than the IQM,
etc.

### SEE ALSO

**lib1305**(3)
