/* ----- core/invsntrup1013, derived from supercop/crypto_core/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *core_invsntrup1013_checksums[] = {
  "f6a51c797d29c780474c27d518d04993a0522cd81996c9b618b42059ba667ec3",
  "53217389455102d1f4fcf9dac3db99bbd39bfbf23559699f6f1913e1aa9b8d82",
} ;

static void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_core_OUTPUTBYTES ntruprime_core_invsntrup1013_OUTPUTBYTES
#define crypto_core_INPUTBYTES ntruprime_core_invsntrup1013_INPUTBYTES
#define crypto_core_KEYBYTES ntruprime_core_invsntrup1013_KEYBYTES
#define crypto_core_CONSTBYTES ntruprime_core_invsntrup1013_CONSTBYTES

static void *storage_core_invsntrup1013_h;
static unsigned char *test_core_invsntrup1013_h;
static void *storage_core_invsntrup1013_n;
static unsigned char *test_core_invsntrup1013_n;
static void *storage_core_invsntrup1013_k;
static unsigned char *test_core_invsntrup1013_k;
static void *storage_core_invsntrup1013_c;
static unsigned char *test_core_invsntrup1013_c;
static void *storage_core_invsntrup1013_h2;
static unsigned char *test_core_invsntrup1013_h2;
static void *storage_core_invsntrup1013_n2;
static unsigned char *test_core_invsntrup1013_n2;
static void *storage_core_invsntrup1013_k2;
static unsigned char *test_core_invsntrup1013_k2;
static void *storage_core_invsntrup1013_c2;
static unsigned char *test_core_invsntrup1013_c2;

#define precomputed_core_invsntrup1013_NUM 4

static const unsigned char precomputed_core_invsntrup1013_h[precomputed_core_invsntrup1013_NUM][crypto_core_OUTPUTBYTES] = {
  {254,254,105,7,48,13,218,13,146,248,152,3,194,8,100,2,178,251,132,252,106,247,33,9,223,10,133,0,156,243,235,250,92,242,131,255,138,243,201,243,122,6,97,253,157,0,71,3,230,9,91,245,167,247,121,3,47,2,102,249,21,10,206,250,5,4,62,254,152,4,159,10,241,254,57,5,249,0,74,12,50,4,130,251,244,246,251,251,75,253,82,6,17,6,151,252,43,255,151,254,235,5,231,251,26,0,11,254,37,255,179,251,14,2,152,243,138,7,51,247,120,248,214,12,189,8,73,244,84,11,169,251,22,248,229,244,157,7,182,1,153,3,129,6,116,254,165,245,159,253,193,11,22,244,131,247,43,243,101,244,65,248,51,250,5,255,127,249,45,251,87,254,159,9,0,9,167,9,184,253,245,249,254,2,179,242,162,12,33,254,83,11,155,10,169,3,72,249,216,3,215,13,66,251,148,7,4,8,102,13,47,9,132,4,140,11,47,247,191,1,154,1,148,247,187,247,76,10,37,245,166,250,153,8,32,5,84,3,190,244,47,2,216,254,180,10,14,0,208,6,121,4,115,250,221,5,221,253,84,12,253,9,55,249,214,242,240,255,0,14,101,252,77,4,250,250,24,250,171,1,150,0,128,10,110,4,183,0,86,249,224,253,49,4,157,3,41,248,250,253,89,252,240,249,200,8,242,7,202,250,118,254,255,5,246,12,166,8,139,251,64,251,38,11,47,245,245,251,94,10,9,9,102,244,136,3,117,249,126,251,24,245,125,255,171,4,46,255,7,8,248,11,125,8,118,249,183,12,202,253,86,10,181,3,66,9,231,2,245,247,200,255,117,245,31,10,50,6,12,11,67,255,213,0,208,242,250,252,190,245,71,252,230,243,222,3,162,1,118,12,102,243,235,247,83,248,208,252,135,252,112,251,242,243,244,10,97,244,40,0,78,245,117,244,238,248,152,243,156,252,82,246,26,249,59,253,49,251,189,250,42,245,118,7,122,253,229,250,16,248,115,2,153,251,41,2,56,4,125,252,101,251,240,0,151,7,5,255,123,4,244,1,182,244,88,2,23,13,203,251,165,2,56,10,38,12,104,249,252,248,134,12,13,7,221,8,4,13,55,254,175,255,185,243,21,13,129,244,43,247,136,247,157,246,202,245,177,8,47,8,229,2,123,1,191,3,175,0,16,4,44,248,124,253,64,13,40,250,75,10,38,9,235,246,18,7,121,254,149,11,169,252,113,3,64,255,162,244,158,2,128,244,199,243,132,11,162,252,63,247,118,11,63,242,192,243,60,11,87,252,44,11,49,6,100,7,40,242,83,243,205,12,1,248,44,244,122,3,23,13,30,13,109,248,199,7,180,4,108,248,93,2,14,244,192,242,9,1,182,10,181,250,120,10,135,1,119,251,78,246,102,4,113,12,117,11,178,251,35,4,192,243,6,1,78,242,254,10,29,255,202,249,2,9,145,3,9,10,170,10,7,4,8,252,30,2,198,248,221,13,188,2,118,10,228,11,13,244,0,253,138,9,67,1,84,251,18,2,104,4,213,242,210,6,143,1,85,246,231,0,62,11,37,9,231,13,105,253,155,251,129,252,157,0,217,12,219,255,196,4,241,2,56,6,181,6,197,3,2,2,50,244,154,247,193,247,4,249,22,243,119,7,155,9,19,13,200,10,10,12,244,247,145,246,53,8,145,244,241,245,28,248,51,246,22,246,134,253,65,246,215,252,19,252,123,252,136,247,234,2,110,12,66,3,66,10,240,5,41,250,73,242,0,242,155,254,85,253,78,4,14,5,102,3,45,253,189,249,235,254,102,13,4,245,110,8,204,252,222,4,85,11,135,245,57,246,51,3,133,0,9,245,240,255,89,251,157,3,222,0,15,242,192,4,51,248,247,255,225,252,164,6,82,3,67,13,47,2,243,11,88,3,50,253,34,2,241,11,41,242,127,9,29,8,138,246,207,10,236,2,176,2,83,12,41,6,23,250,210,6,200,7,204,5,112,248,107,247,123,13,46,2,114,8,237,3,241,253,190,6,113,1,67,248,116,10,7,246,92,6,24,0,187,246,226,245,1,245,225,252,128,255,115,3,254,254,23,242,203,254,32,12,125,246,180,251,91,13,76,255,108,0,130,243,148,11,249,12,166,248,43,246,136,250,211,0,67,13,20,243,132,7,187,3,75,244,109,7,101,248,253,7,244,8,139,242,123,254,200,254,169,250,213,247,204,8,128,254,189,1,110,243,25,251,63,246,149,9,70,242,51,13,136,251,175,247,33,247,213,12,83,249,32,249,209,10,173,245,177,10,147,249,77,5,25,253,138,244,73,250,41,9,174,9,223,13,27,253,13,5,212,8,28,3,101,247,137,246,106,248,161,251,229,251,1,14,1,250,191,242,180,247,105,4,2,242,241,245,115,6,159,249,141,250,242,10,23,12,56,4,224,251,213,245,53,1,122,245,103,4,102,254,117,253,104,250,154,1,82,245,168,6,238,12,50,251,172,6,149,2,225,2,205,5,93,7,112,244,47,4,219,244,28,243,157,251,159,253,141,13,7,0,60,242,136,3,225,251,79,252,0,245,212,244,222,9,217,251,181,4,0,13,244,246,189,12,62,5,204,7,165,8,21,13,181,250,30,6,252,8,142,249,117,6,58,245,228,250,195,243,165,5,199,254,120,0,174,3,255,246,244,10,86,3,182,7,182,246,246,5,115,254,99,252,11,13,83,6,254,13,253,13,216,8,112,242,51,1,58,245,203,243,9,7,55,13,205,5,15,242,137,7,204,8,214,243,239,1,103,5,8,251,96,248,153,1,39,244,117,255,161,251,2,247,48,8,203,7,23,9,210,248,50,2,204,10,50,254,45,247,198,251,67,242,208,248,146,8,13,245,24,1,125,250,51,8,240,247,75,244,68,255,89,255,177,11,228,246,152,248,184,245,11,251,50,2,72,9,71,242,255,11,153,254,193,6,69,246,214,243,160,253,0,250,205,13,70,245,222,245,102,3,43,254,86,1,86,251,146,9,245,251,60,253,73,6,194,242,33,6,108,5,179,12,43,6,166,1,174,245,137,10,38,2,34,1,104,254,108,8,118,11,54,250,254,248,46,248,188,8,15,246,222,251,241,251,193,252,219,4,48,252,206,2,8,7,192,3,6,0,119,1,246,243,247,252,67,250,124,3,249,6,8,244,179,3,157,248,239,12,191,2,238,243,163,10,74,250,163,7,213,13,201,248,43,7,38,5,128,252,236,5,243,254,193,252,154,249,11,250,39,5,51,6,236,245,132,1,130,9,227,8,224,249,249,12,133,242,185,246,238,11,143,249,98,12,0,12,159,251,150,9,237,4,192,11,122,249,227,254,57,255,136,248,39,0,123,247,90,11,5,1,244,6,223,12,48,12,175,5,64,243,180,12,235,2,53,242,232,5,171,8,207,3,50,0,71,255,148,245,116,254,69,248,229,4,173,0,130,0,144,243,24,252,123,251,118,2,13,254,237,0,105,5,4,250,176,246,247,1,151,9,214,247,48,3,108,251,78,252,232,5,238,253,62,247,191,10,155,252,132,5,90,243,76,1,211,249,243,245,207,248,241,8,203,245,135,3,85,3,249,254,17,242,238,242,170,8,36,244,74,245,32,4,71,242,149,2,1,252,200,250,112,246,175,11,22,1,49,8,79,245,39,1,47,10,119,9,137,7,221,11,34,253,56,4,83,3,220,11,240,251,189,2,173,252,62,244,86,254,168,11,152,245,244,255,105,251,208,254,164,9,166,250,197,10,147,3,195,255,87,242,98,252,118,253,144,246,193,242,40,11,12,254,141,247,145,0,217,5,151,254,92,13,91,2,238,7,19,12,211,6,165,5,62,8,237,244,219,9,175,12,149,252,173,248,221,4,10,255,67,7,186,5,185,4,244,243,4,254,244,9,187,254,179,4,241,252,6,245,121,10,137,5,168,1,166,8,184,9,213,10,10,242,132,9,229,253,84,13,241,249,45,4,64,243,194,253,204,246,80,5,118,11,231,255,42,249,27,246,54,255,176,248,152,11,174,249,88,4,188,254,192,242,151,6,123,6,53,245,190,10,136,4,59,242,153,242,154,247,246,7,117,4,20,9,152,7,236,242,87,255,233,8,72,7,223,244,131,243,51,4,102,255,169,242,4,8,110,252,239,252,59,242,201,8,90,251,157,3,66,13,88,2,25,1,163,254,182,13,115,245,217,9,251,254,168,6,69,4,148,254,254,8,64,1,71,246,133,7,242,247,251,13,82,5,122,4,192,13,21,10,32,8,25,252,134,245,25,251,241,247,93,250,27,13,100,1,240,253,161,250,126,4,36,252,226,253,94,8,23,244,164,245,85,250,121,243,181,8,139,2,210,7,90,252,182,4,145,13,194,243,96,250,83,254,74,250,242,254,5,248,86,246,183,254,9,250,192,3,143,245,172,13,175,0,41,252,177,13,227,250,85,10,243,11,139,253,105,0,167,251,159,6,161,252,123,1,72,4,84,3,87,255,10,5,34,11,187,244,104,247,37,251,9,2,0},
  {141,252,24,243,95,12,108,255,107,10,124,250,36,250,228,253,245,251,156,8,136,243,227,4,186,250,134,7,231,0,169,245,167,7,183,9,167,12,127,250,222,242,129,7,36,246,102,3,172,247,58,250,15,254,113,7,28,2,69,242,97,10,96,243,89,9,172,2,126,249,25,11,48,245,11,243,69,247,141,1,76,12,107,243,218,2,86,12,58,1,38,4,150,252,206,8,111,244,255,3,126,246,247,9,247,8,41,248,67,248,128,2,161,6,108,9,53,249,22,250,44,10,44,10,30,5,107,242,91,9,218,6,199,254,141,246,176,8,96,8,24,243,98,252,106,248,113,4,220,254,222,248,13,12,70,11,194,252,244,251,201,245,163,252,67,247,198,6,142,13,238,10,56,244,36,245,180,1,236,248,145,249,114,11,189,0,146,9,145,4,75,243,84,253,66,246,171,255,63,245,94,248,4,14,236,4,73,8,83,248,16,250,112,247,105,243,245,1,95,245,165,253,149,1,23,1,117,11,89,10,208,245,30,11,87,249,24,242,130,245,94,6,112,248,178,1,229,248,141,243,229,13,70,11,235,254,23,4,89,247,52,250,252,12,51,247,141,245,240,247,187,246,21,242,214,244,124,242,187,251,174,255,221,243,27,0,139,0,117,6,77,248,147,1,78,248,28,0,133,246,118,12,231,245,189,246,161,13,162,255,5,6,132,13,191,9,171,11,49,3,5,245,15,9,219,3,21,8,65,255,180,13,212,7,163,245,128,243,7,249,245,5,59,243,145,248,210,247,139,3,217,245,226,254,106,250,251,251,126,13,212,244,69,2,72,254,79,247,121,246,234,251,243,9,157,255,252,252,229,255,49,243,73,6,182,6,32,252,251,255,188,5,242,247,123,249,45,2,20,5,231,12,101,8,85,2,9,5,52,12,91,6,134,2,123,252,116,10,77,245,101,246,151,255,203,12,95,250,107,254,31,0,125,1,212,3,62,254,55,245,174,254,122,0,12,10,177,243,177,5,51,7,244,255,254,251,103,252,158,5,68,2,113,11,238,246,205,3,241,0,189,12,85,5,97,248,133,249,219,10,24,246,94,245,108,245,57,244,92,252,38,10,189,9,185,255,148,6,251,6,12,246,246,254,138,0,147,5,186,0,168,8,3,4,22,2,180,12,190,2,228,6,199,255,98,7,12,6,184,248,253,249,74,244,97,5,136,2,201,3,47,10,73,250,204,5,34,6,56,247,148,249,29,0,134,242,37,244,103,248,70,3,73,249,56,254,228,0,159,12,239,5,77,255,185,11,72,3,201,6,144,2,82,8,3,249,91,249,111,243,215,11,165,4,120,243,69,5,123,0,4,10,233,253,54,8,203,4,2,0,162,1,105,10,172,252,207,251,215,6,194,11,67,243,22,246,245,6,187,246,110,4,30,249,189,1,247,6,112,246,243,250,205,5,42,245,18,242,26,244,201,11,156,7,168,11,10,242,230,9,50,251,183,244,64,2,108,10,10,8,102,248,4,252,92,254,236,5,178,245,228,243,174,7,208,12,89,248,86,244,205,254,64,13,216,3,12,252,60,243,88,6,55,3,62,245,83,4,50,245,64,7,160,253,43,242,105,9,82,1,160,5,237,250,205,5,111,9,172,252,222,252,79,0,11,253,231,254,90,250,48,1,174,245,42,254,211,251,28,245,58,11,143,9,202,0,106,8,26,3,20,6,140,0,212,246,147,251,226,12,102,249,55,248,253,244,189,10,154,242,215,255,1,251,142,2,141,251,169,0,221,246,111,0,49,251,178,253,64,10,159,247,49,247,35,243,160,249,172,246,84,7,53,5,169,244,87,12,174,251,31,4,86,247,217,244,186,246,207,4,144,5,189,251,97,245,123,4,33,251,218,7,4,255,58,247,195,255,44,2,236,253,53,246,73,254,161,11,132,10,232,249,36,6,193,249,193,253,126,250,178,10,244,254,214,11,223,252,7,2,126,253,50,0,212,7,95,243,150,248,58,252,2,249,37,0,187,247,243,253,231,13,246,2,0,12,70,6,118,4,14,245,35,252,28,243,55,243,111,246,251,242,20,2,85,254,87,0,40,249,210,248,15,4,126,5,58,3,111,242,122,3,144,6,194,251,215,255,102,246,188,249,15,247,254,253,226,252,46,247,78,255,97,0,136,243,181,253,138,4,67,0,110,10,172,249,236,251,95,2,243,255,186,254,141,242,211,4,240,248,55,11,202,254,248,4,218,2,80,12,99,1,55,0,48,243,196,247,235,253,136,250,231,245,90,2,55,253,32,0,206,1,208,10,59,7,49,251,155,13,203,4,84,249,135,0,231,1,150,245,209,4,212,2,4,253,8,8,92,247,185,247,57,246,20,255,136,10,179,248,226,2,252,11,243,8,64,253,56,0,73,4,38,253,165,2,161,242,157,5,31,246,253,4,126,5,165,243,49,250,170,254,59,255,175,0,53,252,27,252,46,254,86,7,53,3,110,246,225,3,200,10,93,244,216,248,45,254,172,5,32,13,69,243,234,242,140,252,6,249,248,254,206,11,183,250,43,4,175,246,77,1,164,6,121,7,110,248,255,247,3,1,141,255,40,10,208,252,175,246,239,8,190,10,9,245,225,5,215,254,41,4,169,7,18,245,153,252,172,8,207,244,195,244,102,243,154,255,127,11,252,244,103,3,0,243,120,255,254,3,225,1,67,2,50,244,217,251,163,255,81,246,246,10,35,247,103,5,196,251,180,249,197,247,141,243,107,253,205,12,211,246,53,7,138,11,220,243,96,249,100,246,205,5,3,253,21,8,211,252,110,244,16,244,230,250,111,244,125,252,217,12,137,243,101,255,27,0,25,13,229,13,101,1,80,12,71,13,104,5,56,5,65,12,39,5,189,7,211,244,64,245,222,249,88,6,220,254,59,246,26,10,105,247,253,3,80,253,198,11,144,253,204,247,37,248,219,8,225,7,89,245,160,255,39,249,77,250,116,11,183,252,210,243,179,2,111,5,19,10,18,254,209,252,199,246,209,244,242,3,80,252,183,3,104,251,197,246,115,8,225,243,199,1,59,8,97,0,209,250,95,9,167,250,86,249,166,244,232,250,87,2,232,7,31,7,35,4,138,13,198,244,210,242,94,6,167,247,221,247,101,243,29,8,148,6,255,254,63,4,192,0,97,255,77,251,66,6,94,6,182,255,82,249,44,11,203,250,155,247,21,251,9,253,41,251,207,242,23,248,212,255,189,252,207,0,181,250,113,3,11,8,65,7,88,3,227,242,68,249,81,248,217,5,166,12,0,247,38,6,245,251,152,4,102,252,138,8,16,3,187,9,221,246,2,250,226,244,219,1,121,4,117,5,220,3,105,243,56,11,68,242,163,249,207,244,218,8,44,249,99,2,9,247,211,248,114,246,76,7,16,10,246,10,98,9,219,12,205,245,216,9,181,5,238,1,175,244,208,248,130,254,79,12,240,6,203,254,209,4,17,245,188,4,117,242,65,5,243,5,84,255,159,249,171,249,154,3,252,248,11,2,135,253,23,244,182,0,205,0,194,5,201,244,124,253,200,253,244,246,152,242,252,7,178,13,7,8,251,5,106,12,79,3,248,10,232,249,54,242,242,13,181,248,182,0,20,3,98,245,46,252,252,242,54,9,177,0,15,252,46,7,125,250,105,5,147,3,231,251,5,252,51,249,240,248,227,242,91,4,241,243,27,253,160,252,203,242,160,250,165,0,24,255,130,250,110,1,244,3,245,11,62,254,102,2,63,6,175,249,218,9,105,11,88,12,209,249,245,13,115,242,214,247,63,244,46,253,147,252,55,245,74,252,241,246,141,247,7,244,13,254,216,7,52,11,57,242,46,5,45,10,114,12,162,0,27,249,212,244,195,2,92,11,80,248,65,5,18,6,5,251,27,5,233,244,29,243,236,3,32,248,160,0,202,250,215,244,55,7,117,255,19,253,241,8,209,244,81,11,207,9,117,7,26,245,243,13,161,246,221,246,69,246,75,247,55,2,54,0,126,12,54,11,172,1,21,4,216,252,107,246,181,2,66,3,231,5,106,9,192,13,27,7,51,6,143,252,80,255,211,2,46,1,87,243,173,246,209,9,198,12,50,248,6,10,100,12,87,0,49,243,214,249,77,253,147,246,40,5,107,8,210,6,148,248,107,8,250,253,78,255,191,243,45,6,62,255,164,249,80,243,69,9,210,254,239,242,27,252,204,11,38,255,131,1,84,244,77,0,64,255,91,4,117,4,63,4,234,1,21,5,37,11,38,247,234,244,75,2,161,9,70,252,165,11,52,12,64,242,103,249,200,12,86,246,233,0,155,1,26,11,40,248,157,11,33,249,247,10,44,5,59,10,124,2,88,11,100,253,130,247,61,251,35,255,84,4,234,242,57,6,147,246,251,247,252,5,7,244,211,244,227,246,188,252,165,13,65,252,21,6,28,255,199,245,197,8,33,9,194,7,50,0,71,1,165,3,23,252,108,252,109,251,172,251,254,242,9,5,225,3,153,3,240,249,65,11,117,249,84,242,174,1,156,3,0},
  {221,249,155,255,50,254,153,248,139,245,86,244,217,9,49,249,80,12,107,248,132,251,145,255,249,253,59,1,123,11,233,254,246,1,158,252,3,248,75,0,224,242,79,0,188,250,6,2,40,243,60,2,214,244,178,252,216,9,255,250,100,255,26,7,40,252,98,11,191,10,114,8,29,2,218,249,46,252,23,7,196,250,122,13,60,9,164,247,20,1,224,252,216,245,18,6,194,5,104,3,246,245,26,8,84,13,193,247,132,242,204,244,103,253,140,253,102,248,198,245,86,5,236,249,112,7,214,247,156,5,56,254,191,248,223,250,188,13,180,7,187,3,89,8,114,246,38,246,158,242,160,3,208,2,201,5,99,3,199,247,61,248,162,11,201,251,141,5,140,12,42,252,231,11,180,242,187,12,179,253,161,3,21,3,186,12,2,244,20,4,204,5,60,247,206,255,180,1,236,247,1,248,251,244,187,248,209,250,242,11,100,9,226,8,77,6,78,250,94,3,249,1,48,243,242,243,97,5,69,254,249,253,234,250,116,5,43,246,15,10,94,2,62,252,99,243,83,13,66,5,205,9,11,1,176,6,162,13,181,3,51,253,225,254,69,9,5,13,208,242,31,4,104,251,148,251,242,242,17,1,78,251,111,13,116,248,91,12,107,248,102,254,108,250,23,4,229,244,225,253,26,247,10,250,138,13,58,242,99,7,0,249,57,255,60,10,92,252,42,245,247,254,96,10,212,10,15,13,197,249,150,246,187,2,158,249,192,2,104,12,226,252,126,255,228,7,35,246,55,245,250,247,252,8,109,12,229,0,52,2,137,246,3,13,83,8,118,245,68,7,84,12,28,251,34,250,142,242,110,242,188,8,49,11,13,12,218,247,202,11,169,250,174,10,175,1,158,6,242,0,116,8,249,7,123,2,215,0,136,245,55,6,58,0,215,245,246,8,117,242,130,0,22,248,48,5,4,2,21,252,90,2,27,246,114,9,153,10,147,5,233,2,249,251,63,0,47,8,187,245,174,248,83,247,205,11,224,249,115,247,56,244,185,7,1,243,27,0,127,12,207,11,246,13,176,250,60,245,231,11,59,250,126,246,191,249,89,12,55,253,5,255,247,11,152,244,151,251,88,0,161,6,109,242,251,0,38,244,209,244,117,0,217,247,19,11,130,1,186,252,173,13,175,6,137,3,180,4,116,246,222,8,117,250,167,12,206,0,217,2,250,255,237,12,22,2,28,11,179,2,55,0,85,3,188,1,111,254,140,244,96,248,132,255,84,246,19,243,145,244,55,11,40,4,156,248,186,242,138,249,66,6,98,242,168,251,175,6,143,242,163,250,33,254,158,3,47,254,234,247,23,254,196,8,234,246,111,250,208,8,127,249,244,8,127,3,132,253,85,11,195,246,72,10,69,254,72,254,134,248,142,3,4,0,181,1,255,6,237,12,42,253,84,4,18,254,184,8,50,11,242,13,95,13,136,8,239,12,241,255,224,253,243,6,65,250,93,2,106,254,145,251,226,247,124,248,190,7,197,243,18,244,242,1,38,3,231,246,28,255,185,243,5,12,34,247,69,246,78,244,3,249,196,0,19,5,78,242,194,0,73,0,60,249,220,251,37,1,91,242,176,250,143,246,89,242,183,244,80,245,176,244,42,242,242,250,160,246,242,255,99,252,187,7,43,0,189,255,21,248,59,253,189,250,230,248,103,246,244,0,218,7,185,246,191,244,237,2,168,13,73,2,57,3,190,254,198,255,187,10,226,248,142,1,221,243,132,251,88,246,233,243,21,243,1,5,148,8,102,6,149,246,168,13,192,245,195,9,200,12,95,245,54,243,216,2,92,252,56,13,250,248,143,5,209,252,191,8,63,244,156,254,208,9,155,255,217,246,149,6,140,2,19,11,252,1,130,8,171,1,90,6,80,11,144,5,115,10,150,251,40,248,120,254,202,252,249,13,131,10,132,12,132,13,98,11,32,9,100,252,51,249,121,249,130,3,58,2,213,1,2,250,60,245,18,255,44,251,206,255,200,13,109,254,198,2,34,0,54,254,238,249,4,10,61,2,230,254,155,6,79,8,217,249,38,9,124,244,22,0,95,2,141,242,48,251,119,13,170,246,164,4,226,13,194,4,78,6,103,255,174,5,29,254,39,253,20,9,196,254,240,244,93,5,70,7,115,6,98,5,66,9,174,254,216,243,50,3,50,249,68,247,223,248,126,254,24,243,130,248,215,13,85,250,69,12,113,3,16,9,185,249,60,0,93,13,126,13,136,13,79,249,221,12,136,255,216,0,214,0,209,3,230,11,27,2,30,5,216,0,93,248,41,11,134,3,142,245,114,9,149,248,57,251,74,7,157,242,18,250,136,7,73,4,2,10,6,11,193,8,34,255,143,12,222,253,194,245,12,13,7,0,135,8,209,248,30,249,170,249,201,12,61,8,169,243,55,255,0,254,80,1,216,7,173,7,6,244,101,8,183,253,40,2,66,7,217,13,97,255,12,242,117,251,11,10,128,242,45,245,149,242,96,249,252,9,84,2,152,245,218,12,173,1,219,7,215,1,240,4,136,252,146,4,136,12,179,9,189,243,140,9,84,13,60,7,134,0,233,245,68,249,63,252,57,246,238,246,249,254,60,13,4,244,76,253,151,6,62,13,141,248,50,252,37,243,57,5,215,249,147,249,225,12,224,243,135,247,58,248,96,247,180,2,23,1,24,244,205,5,14,244,196,1,11,254,181,244,131,2,81,251,126,0,3,244,243,246,142,0,143,2,245,246,252,252,76,253,12,253,155,244,166,246,248,253,144,255,3,3,36,4,78,255,44,242,97,249,138,1,164,8,201,242,72,252,29,0,254,241,241,254,70,253,79,255,27,11,239,2,74,3,203,10,123,250,122,1,33,254,205,255,236,252,12,5,197,9,254,0,208,242,63,253,1,248,96,248,108,245,30,9,117,4,82,7,171,248,56,253,212,244,232,252,189,0,220,2,94,4,227,3,35,0,222,246,66,254,12,4,73,247,87,246,222,6,105,244,204,252,68,245,44,243,218,255,167,9,133,249,97,247,192,13,174,11,87,253,72,253,251,251,144,245,29,254,178,7,131,252,39,246,191,244,116,255,145,246,78,251,185,243,31,251,12,248,218,3,67,2,110,246,49,253,76,3,125,255,150,10,91,248,16,8,27,251,182,246,89,248,62,10,30,11,127,13,51,243,15,250,213,10,54,10,245,1,87,252,230,253,207,9,190,1,111,248,210,12,61,0,216,252,51,1,182,250,193,252,62,8,33,242,239,246,169,255,202,13,19,251,250,5,97,252,98,6,175,9,183,7,47,246,252,247,193,11,244,243,207,247,180,242,87,252,138,11,48,253,182,2,102,9,166,9,223,4,203,246,102,248,52,250,73,4,99,8,178,5,9,2,232,252,6,7,181,2,58,8,33,9,97,254,44,253,95,249,57,11,30,7,99,251,31,244,22,8,23,4,220,253,10,249,60,250,24,2,57,9,95,1,224,253,106,244,118,8,78,9,253,3,219,252,68,245,99,252,65,4,70,10,214,245,84,3,158,1,58,8,76,250,216,245,219,9,42,244,149,13,167,5,230,2,254,0,162,254,34,8,173,11,251,244,135,9,182,245,36,249,52,243,80,13,228,3,61,250,23,0,100,245,19,13,222,245,202,4,93,4,147,3,127,254,101,243,192,242,187,0,66,251,178,245,185,250,255,252,150,243,57,5,85,10,20,255,2,242,112,254,51,13,174,252,235,245,69,12,236,252,51,9,203,4,77,244,177,5,58,7,189,247,198,254,21,249,75,248,227,3,123,7,245,3,196,13,244,7,9,255,180,248,84,9,121,10,36,5,34,5,1,5,160,252,89,4,189,13,13,0,143,242,144,251,114,11,110,4,31,244,171,0,100,10,243,8,228,245,113,3,134,242,79,6,168,251,222,0,243,253,107,252,223,247,185,13,65,247,204,1,187,1,251,8,211,244,35,250,32,243,175,249,41,251,15,244,186,244,94,245,36,243,199,9,104,243,50,255,2,10,99,9,48,242,54,4,3,11,138,245,110,242,218,6,10,12,10,253,213,11,76,245,243,252,43,3,187,12,94,244,159,5,221,254,226,12,158,5,48,243,150,12,158,2,81,248,50,12,87,8,81,250,123,2,166,243,71,253,46,245,43,247,165,252,45,8,255,4,220,9,119,252,126,250,111,255,26,254,151,11,38,243,224,5,130,250,223,8,153,246,106,249,138,254,219,245,70,245,71,252,229,250,169,253,190,12,219,247,63,8,146,0,91,252,159,8,227,247,120,253,188,242,185,0,206,250,255,244,231,248,228,249,1,252,50,250,60,7,64,4,19,247,5,255,178,6,70,11,51,248,207,254,165,254,2,14,34,254,154,7,43,248,101,250,177,1,166,248,100,255,199,4,11,2,177,0,231,247,20,245,237,4,246,9,198,254,176,253,32,249,11,248,95,9,174,12,56,242,91,255,154,243,140,7,180,3,92,5,52,6,138,3,245,0,9,9,69,250,230,249,157,1,225,1,56,251,22,246,0},
  {72,253,67,6,184,242,113,11,24,249,230,255,235,1,13,9,145,245,166,9,83,11,201,250,209,11,136,1,168,0,90,244,117,244,245,1,134,247,153,243,158,1,56,2,212,250,58,11,79,8,119,8,89,243,49,2,40,244,18,10,37,6,105,4,119,252,72,7,33,248,99,4,253,0,229,249,19,254,92,255,45,245,122,0,253,7,240,7,112,3,51,247,131,250,96,243,180,243,151,253,219,0,212,5,241,253,60,252,150,6,165,4,11,249,84,2,193,1,61,249,182,12,200,5,87,250,43,255,230,2,140,7,214,243,123,1,239,251,71,4,35,6,127,12,42,242,34,12,97,3,86,250,89,3,24,6,201,254,228,244,31,5,132,10,58,252,97,10,10,247,230,247,78,4,30,255,182,13,178,6,255,13,89,10,70,244,98,11,17,254,188,8,157,251,231,246,11,243,50,244,30,2,76,5,43,245,246,9,106,7,68,1,140,255,188,6,214,249,57,6,202,244,3,3,230,9,21,250,209,12,221,247,188,9,186,254,110,2,110,9,175,245,81,4,201,242,139,243,205,5,71,242,29,255,177,246,205,1,164,255,159,250,6,1,174,11,30,3,216,251,124,247,218,13,42,8,99,11,225,6,164,254,56,0,255,1,86,7,101,8,218,10,4,4,123,0,170,244,13,8,81,245,211,9,123,3,133,248,143,10,119,6,61,12,159,12,194,10,201,2,251,254,227,2,214,246,76,249,91,10,223,245,46,12,186,2,40,254,78,13,51,242,182,12,5,10,141,245,83,242,81,6,3,3,16,247,244,13,135,2,235,249,15,248,165,10,65,255,218,251,152,248,179,254,166,6,11,13,169,251,50,242,171,13,53,252,255,244,187,254,90,2,40,253,60,242,109,254,56,9,118,4,69,12,86,5,146,3,30,4,175,12,216,253,101,8,180,0,197,2,108,3,186,246,246,254,184,7,166,248,103,11,188,1,148,11,101,244,72,13,158,244,204,10,119,251,123,255,8,8,216,6,200,11,180,8,59,247,232,243,227,6,5,5,123,251,52,3,175,13,174,246,109,249,22,4,201,243,51,5,176,8,152,243,123,11,243,5,99,5,160,9,148,13,136,248,113,0,16,1,156,242,146,1,157,243,0,246,55,10,136,6,72,243,185,6,167,1,242,251,241,246,59,5,87,243,176,0,128,2,234,244,92,242,100,254,78,6,170,243,140,10,69,247,192,2,99,4,68,250,72,249,118,2,241,6,205,5,251,245,146,253,1,13,5,251,64,242,16,254,171,244,35,3,213,248,254,10,63,249,105,249,71,1,79,12,150,252,94,242,182,6,104,253,248,12,12,10,4,254,180,2,60,255,165,11,172,255,236,243,53,13,149,1,87,10,20,243,116,251,220,243,136,5,94,249,175,2,47,248,91,1,240,255,38,251,100,0,121,248,234,6,43,246,102,252,237,253,247,244,196,247,14,243,185,10,206,8,126,3,163,250,87,10,201,243,231,249,130,1,154,10,80,4,82,9,39,4,5,8,2,0,116,243,130,250,177,0,25,251,216,242,142,251,172,249,54,247,132,245,63,250,57,244,92,13,209,6,5,7,158,1,8,250,109,4,31,11,186,9,213,247,58,12,255,255,253,12,8,244,223,0,207,1,169,9,121,7,183,251,63,3,44,3,76,248,138,10,136,3,32,7,216,254,181,247,126,11,54,255,114,7,131,245,83,2,110,255,233,245,224,2,34,1,140,13,252,247,238,248,69,248,147,242,122,8,119,249,193,11,132,250,253,252,83,243,25,2,130,12,31,247,97,252,67,248,191,4,218,251,132,246,251,242,147,252,73,1,218,254,244,6,113,242,70,10,47,5,162,2,70,245,128,3,0,243,108,1,132,250,49,254,117,1,128,6,183,248,238,5,138,13,118,13,231,246,191,249,17,4,123,248,169,253,107,11,22,251,111,5,23,251,244,6,68,13,182,248,67,11,44,251,195,250,48,250,217,243,251,8,23,249,24,254,25,254,251,13,127,246,16,244,219,244,57,255,176,247,64,247,224,244,78,243,68,6,1,247,130,242,235,9,131,246,25,253,75,12,179,5,229,5,106,7,76,1,85,248,91,242,54,11,255,249,159,7,43,6,25,254,72,11,128,5,158,246,144,10,93,242,133,250,216,246,36,4,68,12,144,242,147,249,212,249,196,243,201,8,133,5,89,10,107,255,141,250,235,11,60,245,38,7,172,1,121,1,186,2,255,246,237,3,103,250,107,243,211,10,128,251,221,252,119,6,223,255,75,250,132,244,83,4,22,250,65,11,251,253,250,243,235,11,79,246,145,0,240,12,137,9,53,2,223,248,175,242,129,247,26,9,2,9,20,250,75,244,171,13,227,5,110,250,123,9,96,247,219,248,93,252,16,251,228,5,81,0,132,0,239,247,253,241,157,252,244,254,247,252,69,248,140,251,9,2,99,251,112,250,182,252,51,11,56,249,1,8,112,4,53,13,244,12,48,243,25,6,148,2,236,7,136,1,28,0,46,5,87,3,236,2,52,12,218,253,144,254,170,244,56,11,144,243,15,242,208,11,63,1,166,13,98,255,0,7,155,249,156,11,230,12,208,7,117,10,235,246,247,12,29,1,80,243,170,4,60,251,88,4,140,1,153,2,241,251,188,5,185,245,195,4,229,243,39,4,95,2,233,248,25,246,126,13,213,246,20,12,66,246,27,255,184,12,146,253,186,249,108,243,154,3,197,11,132,249,138,254,254,255,97,247,246,0,215,255,152,243,10,255,81,2,239,4,113,249,52,9,18,9,194,10,75,13,141,8,224,1,162,12,249,247,180,12,8,246,56,3,104,1,201,248,175,7,68,244,206,6,146,8,142,8,227,254,229,252,84,8,164,255,187,4,87,247,208,245,88,2,131,10,224,247,88,247,6,8,222,242,44,3,63,255,212,2,152,7,36,6,54,1,16,13,147,3,88,10,153,10,68,7,197,250,201,252,140,255,88,246,13,254,36,255,74,10,130,7,61,12,58,2,200,254,22,7,102,246,167,7,164,250,20,244,11,243,84,13,178,0,210,252,170,10,118,6,205,253,137,249,168,6,207,252,192,6,78,0,186,11,76,3,201,0,95,12,3,255,36,243,176,10,53,10,189,249,108,244,78,248,59,13,129,254,227,1,6,242,208,247,164,248,48,248,178,248,9,252,92,245,231,248,70,252,60,4,251,250,200,249,202,1,80,6,38,246,59,245,240,6,87,9,152,244,64,249,4,12,144,247,35,12,52,244,97,3,221,252,176,242,203,5,110,252,249,246,252,10,40,7,213,9,66,11,93,252,73,255,237,245,63,250,10,1,124,244,144,9,61,252,18,251,135,250,248,13,110,245,220,10,72,248,154,5,64,244,44,9,49,245,100,247,145,4,149,7,159,244,108,8,83,9,226,246,137,4,13,253,156,9,233,4,62,5,105,249,250,1,225,245,11,242,238,248,41,253,136,6,191,255,72,245,138,3,133,251,33,10,169,242,175,4,110,4,126,13,124,255,6,245,25,7,176,251,154,249,19,6,179,244,55,255,68,7,171,253,104,10,46,252,203,245,24,243,228,10,134,10,237,254,126,12,7,248,83,4,183,12,14,13,228,247,128,253,90,10,139,242,10,12,103,254,158,243,54,2,156,9,91,6,18,248,41,7,235,243,45,9,78,250,34,4,9,249,199,11,195,246,67,255,139,12,71,246,109,8,88,4,16,7,140,247,143,249,124,8,220,7,140,10,128,250,109,253,44,242,212,13,58,7,174,4,158,247,70,6,45,0,224,7,21,6,229,10,150,247,220,252,72,4,241,255,254,6,101,2,177,9,65,6,253,248,98,5,2,9,39,13,134,246,69,242,126,248,108,255,211,13,120,7,71,249,196,248,36,0,207,249,129,12,123,248,188,3,150,1,27,7,243,247,74,248,103,4,38,244,139,245,60,255,72,242,201,5,222,13,78,253,27,247,119,6,203,1,253,243,76,245,36,248,54,7,67,3,117,5,75,252,23,12,195,1,175,253,62,3,244,7,159,8,180,8,115,12,195,6,133,7,18,251,144,252,10,252,169,254,68,248,75,3,133,255,224,0,27,244,42,252,170,5,71,13,35,11,66,253,239,11,204,251,171,12,201,254,250,8,152,253,14,253,72,10,39,246,177,250,100,246,25,248,243,253,228,12,217,11,91,7,90,245,161,252,173,6,54,6,140,6,108,245,225,250,169,246,158,9,26,9,32,243,153,10,24,8,191,6,154,0,86,243,12,255,199,247,60,254,28,8,201,13,237,251,78,245,19,253,70,2,219,254,29,251,78,8,168,243,60,254,17,8,54,2,125,244,1,14,109,10,224,8,146,242,64,245,86,245,81,8,49,247,178,9,207,251,50,0,243,250,51,13,188,5,13,6,210,10,196,6,56,254,95,246,120,2,21,7,129,3,174,243,101,248,120,242,9,247,233,1,204,8,173,7,40,9,61,3,37,8,78,0,178,6,81,6,113,255,17,242,135,250,145,246,204,248,98,244,100,8,192,252,0},
} ;

static const unsigned char precomputed_core_invsntrup1013_n[precomputed_core_invsntrup1013_NUM][crypto_core_INPUTBYTES] = {
  {108,114,20,187,202,219,118,144,255,167,28,171,128,150,70,222,212,71,158,210,118,181,162,180,45,205,168,149,110,65,15,204,234,83,186,68,59,120,70,38,119,55,92,116,91,11,152,21,54,160,73,137,140,182,244,108,86,242,48,123,190,96,17,86,247,110,203,241,127,57,45,214,33,23,36,174,1,187,239,110,117,218,126,137,225,238,125,74,204,236,149,201,86,220,77,237,4,75,132,166,179,12,184,125,210,74,222,247,1,142,44,41,93,63,156,177,86,199,84,215,4,161,245,99,61,221,1,128,60,191,123,34,10,214,138,173,215,62,147,194,111,184,88,216,216,33,218,129,145,109,113,169,238,14,145,233,82,212,13,138,133,223,28,125,55,19,232,179,231,36,168,192,47,254,174,95,139,161,176,181,236,91,127,118,165,58,69,188,14,84,132,37,165,213,11,242,204,128,66,37,46,191,4,48,164,142,71,183,63,153,148,224,234,84,208,247,252,136,249,141,167,245,43,162,110,218,59,130,82,55,167,69,23,84,130,94,158,215,207,45,234,69,13,20,187,227,192,79,211,145,247,72,221,186,78,65,143,201,9,167,47,132,184,169,87,205,8,247,31,34,54,1,97,169,136,231,21,152,225,1,203,145,106,223,53,255,219,34,112,66,179,172,104,236,210,176,172,7,45,24,152,72,127,142,189,86,133,3,137,111,90,86,54,92,238,111,154,226,242,184,165,161,3,62,240,203,183,135,102,132,117,140,220,38,46,193,52,201,194,141,170,112,125,158,145,38,193,176,208,44,13,175,47,150,23,84,86,15,111,63,143,225,82,240,41,96,215,72,27,87,136,21,160,126,237,201,179,239,200,178,245,237,144,255,21,227,154,23,70,131,73,168,181,36,190,141,188,234,181,48,219,10,183,70,180,229,88,121,249,18,65,4,15,135,185,0,226,148,167,170,81,67,23,112,211,84,64,193,53,141,77,166,112,254,228,17,203,144,220,125,100,43,82,12,106,193,73,22,222,152,72,66,27,91,76,67,126,193,71,187,209,31,245,168,202,50,153,8,22,246,151,3,176,247,171,164,229,142,202,68,89,28,10,233,106,130,84,251,94,23,134,27,67,13,152,206,174,62,17,242,251,148,138,244,173,51,69,76,141,140,49,255,67,149,202,17,194,14,211,42,114,187,128,163,183,119,208,56,132,148,173,240,52,79,88,207,236,20,7,35,22,113,25,163,4,215,250,241,183,160,206,71,215,62,121,107,238,162,64,83,111,184,10,247,37,207,110,194,55,185,40,70,58,130,142,123,242,166,19,186,67,132,138,16,222,28,63,255,71,212,204,240,19,65,226,128,180,53,125,16,100,36,177,62,149,223,21,12,225,143,205,45,214,245,198,180,206,183,86,35,44,75,133,143,114,185,191,188,148,146,44,72,11,227,46,212,156,0,130,41,148,140,172,120,41,197,255,14,129,137,66,14,34,229,182,78,248,155,69,224,238,115,163,91,78,2,134,212,148,214,12,4,214,103,129,156,37,92,47,130,88,93,21,224,59,190,35,128,237,228,102,155,203,122,195,121,62,233,81,195,184,58,209,35,0,43,150,198,86,241,10,244,65,213,164,72,48,232,89,41,229,237,235,231,108,243,2,97,12,114,104,80,216,122,225,106,138,206,150,255,100,88,230,177,218,16,254,226,255,55,102,142,112,185,207,224,181,26,248,170,163,23,73,53,95,146,169,75,121,192,45,209,190,153,9,129,64,112,172,239,80,89,201,119,179,205,120,67,49,228,181,208,75,54,87,137,28,64,198,40,75,23,158,66,77,84,178,91,145,68,142,113,188,129,2,21,117,0,94,177,101,201,195,133,152,163,6,113,91,38,148,54,37,35,220,69,225,255,97,62,206,78,47,231,24,237,233,198,137,13,123,247,248,132,138,162,96,194,208,13,72,214,182,207,180,111,192,231,10,189,4,142,173,78,111,125,65,129,73,53,160,3,164,119,6,236,98,87,17,124,45,195,28,117,208,91,225,149,51,160,44,225,155,174,137,72,8,111,92,236,209,142,103,142,45,142,95,90,142,197,38,240,254,66,232,48,210,173,103,23,78,13,106,109,161,10,129,134,131,170,241,45,14,67,39,249,108,209,132,1,53,179,204,215,4,53,116,152,205,192,67,165,242,82,131,188,147,154,173,26,172,73,43,17,253,226,23,55,144,114,201,49,215,99,182,187,159,7,39,79,99,78,237,235,195,128,186,39,250,121,198,67,91,60,136,104,43,0,199,157,129,51,75},
  {208,88,175,231,161,20,174,219,182,215,63,140,168,127,184,60,86,24,189,49,70,186,163,115,212,143,197,56,78,41,112,165,220,118,39,144,126,231,224,234,249,139,181,115,79,171,161,195,17,132,207,96,221,120,253,85,42,234,142,12,138,78,199,128,1,15,2,241,141,46,47,249,7,222,148,133,55,76,5,16,229,95,23,71,72,76,74,28,103,34,163,150,173,175,75,101,224,146,133,213,242,50,253,66,247,155,169,41,246,39,5,55,89,65,189,211,251,241,170,67,44,127,25,34,247,134,55,59,117,16,234,50,56,18,54,92,208,22,49,103,57,53,104,248,193,135,161,173,225,244,94,93,213,183,54,219,65,144,8,236,206,162,241,179,55,181,172,195,72,89,228,131,220,36,9,112,113,234,76,60,246,19,64,171,179,28,92,161,14,21,148,138,214,27,232,7,226,105,48,91,186,132,211,161,101,216,135,43,152,147,179,234,162,63,22,138,3,10,121,151,14,7,242,35,117,171,116,135,89,52,184,128,17,142,44,60,18,140,148,82,155,131,88,232,115,3,65,240,47,105,185,184,150,75,129,170,32,188,244,234,163,197,35,158,178,4,18,51,204,2,173,136,118,200,153,192,66,105,189,174,160,98,147,247,111,80,173,88,115,19,161,5,83,206,182,10,48,95,32,41,67,141,182,176,158,90,139,39,51,148,68,157,156,106,184,243,167,167,133,228,73,194,89,29,73,124,202,85,70,60,153,231,64,206,239,92,141,93,23,194,85,128,84,8,161,252,39,1,76,140,132,92,224,216,180,238,37,73,211,64,11,186,211,77,35,127,255,4,19,2,41,83,207,112,129,163,147,17,75,229,183,79,211,144,230,131,98,253,91,143,85,242,3,228,72,78,133,205,111,177,164,243,147,185,19,116,77,162,132,36,88,167,233,99,130,80,225,225,234,162,232,206,46,236,148,196,215,114,112,107,127,111,203,177,224,4,187,46,146,170,68,100,184,234,13,191,155,34,244,198,116,236,138,190,204,90,121,28,74,115,136,34,228,167,35,131,17,98,18,109,228,210,7,96,247,77,4,208,93,250,74,103,91,46,17,214,12,148,4,16,160,213,25,83,116,168,243,213,129,36,183,197,230,150,242,80,95,137,228,60,228,81,133,43,60,171,141,198,43,102,2,209,228,240,160,101,235,111,208,40,61,6,66,140,0,185,216,251,30,201,230,53,12,79,78,27,72,13,234,239,89,131,117,4,44,205,173,190,179,152,4,124,43,15,205,115,102,41,56,22,179,115,51,75,20,153,241,172,103,115,59,182,230,72,52,31,196,25,97,203,28,124,1,170,21,7,106,187,203,29,129,92,11,147,112,211,245,117,50,121,203,147,214,98,230,73,133,216,89,148,138,174,7,150,41,147,122,79,110,247,188,164,72,152,197,139,26,189,116,222,100,66,9,131,233,78,155,193,225,155,170,137,104,19,165,169,1,51,78,83,171,207,254,100,78,137,8,68,61,101,242,161,5,37,0,117,7,79,220,11,226,42,5,99,150,149,133,213,186,37,81,30,55,130,72,32,171,184,53,125,12,5,9,229,243,130,27,16,21,41,29,241,48,57,171,75,29,164,101,7,8,140,239,7,239,192,117,86,219,27,76,185,160,215,86,119,31,198,209,151,56,32,112,158,103,114,117,229,181,13,30,38,214,133,54,253,251,73,42,186,208,54,32,168,120,56,15,228,104,66,231,250,83,65,71,219,84,39,245,49,167,52,251,168,251,119,147,66,135,83,248,236,209,139,200,180,84,224,188,236,61,138,87,65,47,161,174,50,43,1,112,106,116,128,158,88,150,64,29,177,60,204,153,201,174,223,136,184,76,212,211,230,217,202,209,181,21,57,133,185,246,111,154,58,90,82,7,0,57,144,243,228,227,104,164,82,197,51,150,149,163,35,161,238,63,251,104,205,43,232,252,140,68,11,50,250,173,186,247,13,112,170,219,37,220,184,17,7,103,74,222,199,75,173,92,213,127,242,92,173,199,171,234,184,144,64,146,161,247,173,171,58,212,121,26,196,181,10,74,228,105,181,71,198,146,71,49,118,21,245,238,77,8,125,62,166,105,204,234,157,198,240,126,99,249,49,135,251,215,242,0,160,123,42,212,174,176,185,196,245,36,95,110,250,137,246,133,26,183,85,110,40,131,75,14,71,171,100,229,89,48,244,133,24,50,134,47,139,34,216,195,181,172,10,186,88,133,22,49,170,33,247,196,130,200,192,142,128,176,30,100,37,254},
  {151,188,187,37,78,109,93,166,147,77,226,175,181,188,225,153,53,50,99,31,180,174,186,177,111,134,92,201,117,25,110,230,221,127,247,161,213,247,207,136,248,202,139,131,250,252,178,251,244,54,59,1,33,45,98,5,174,29,35,255,107,54,186,131,81,244,220,24,63,253,249,141,69,47,216,106,187,178,181,152,112,1,58,198,91,14,80,130,199,84,84,12,193,72,44,13,15,73,172,208,152,74,159,0,54,198,70,207,173,212,26,235,153,93,216,192,56,245,149,116,148,136,201,65,74,150,78,40,115,73,37,71,136,42,142,158,171,230,223,0,49,182,9,107,3,226,145,30,179,142,14,140,180,21,63,190,229,57,125,87,39,152,187,195,196,209,79,36,173,111,54,191,57,163,69,190,202,161,135,163,192,90,31,224,144,107,172,118,135,213,61,227,112,184,185,68,148,173,230,186,158,99,14,113,135,63,104,204,237,0,161,147,183,59,61,100,25,54,95,210,210,214,194,178,251,43,168,148,155,237,78,117,155,174,37,119,225,57,253,59,122,221,132,113,111,142,154,167,61,39,160,39,235,40,152,50,66,35,209,118,226,160,110,93,40,93,208,123,15,233,181,14,254,41,243,255,53,177,178,55,203,185,117,192,7,8,225,153,24,181,158,94,23,250,166,95,31,244,197,8,126,16,10,87,7,96,73,199,242,214,53,40,53,246,231,62,12,226,114,247,152,85,234,16,166,164,248,85,203,116,27,29,179,144,43,44,159,39,222,167,239,207,220,122,38,239,190,172,240,152,162,19,159,176,111,248,182,233,177,186,40,14,144,67,97,127,153,229,22,103,250,95,171,254,180,133,235,47,41,14,159,63,205,162,31,236,247,67,123,201,105,46,245,203,218,132,30,21,199,81,134,218,249,96,75,166,218,28,2,13,249,185,164,31,82,184,48,208,32,91,111,247,71,65,220,210,229,111,221,92,77,26,237,238,84,146,234,117,99,100,105,0,89,51,119,98,133,1,180,183,155,193,107,169,211,87,153,218,211,31,131,42,177,164,128,183,106,255,97,174,196,95,136,126,207,42,0,153,7,75,36,64,73,150,124,229,14,223,224,26,62,225,149,126,15,250,108,51,115,35,32,214,166,209,237,14,246,45,186,94,158,117,82,185,200,103,188,3,75,137,96,185,162,39,232,112,250,235,201,241,42,4,63,78,207,51,127,77,211,195,13,100,128,155,173,136,58,9,12,200,247,88,95,138,168,215,31,87,101,91,214,19,210,143,240,40,214,87,147,234,65,253,54,146,205,14,141,210,98,247,3,80,196,177,98,173,142,220,29,228,208,29,111,16,44,219,88,16,224,47,143,173,238,253,35,80,151,83,222,126,80,76,165,0,168,108,238,125,46,153,254,202,32,71,142,124,42,106,214,38,78,18,118,180,191,249,224,209,80,190,130,108,101,239,179,89,186,99,18,219,218,154,172,122,110,167,21,72,64,244,122,74,82,110,181,139,194,238,231,64,170,107,107,118,121,186,211,187,180,25,173,130,48,84,199,32,242,248,216,186,130,83,148,15,170,45,26,206,129,165,162,3,226,226,39,150,203,197,11,194,189,30,10,194,196,210,97,162,49,52,38,236,196,4,66,101,202,101,36,173,178,177,92,63,49,81,243,36,126,232,232,38,41,63,103,102,217,168,54,161,190,230,175,132,132,51,155,44,141,25,13,24,119,176,201,193,71,232,254,113,87,59,247,193,251,142,231,149,48,50,36,228,196,63,2,100,125,42,245,172,180,41,64,147,83,199,16,68,91,121,246,93,10,11,100,108,25,84,43,131,75,183,184,161,127,152,109,89,181,240,213,50,186,102,170,179,146,112,111,181,118,235,76,70,80,9,114,141,104,145,48,199,14,214,159,118,25,246,26,68,41,125,246,16,170,40,134,241,202,59,231,68,235,146,88,170,78,121,126,211,213,41,106,246,54,156,232,249,92,187,120,23,213,248,155,125,98,77,213,99,32,187,147,49,22,90,59,109,208,31,229,96,83,232,154,95,216,9,48,143,74,61,199,102,197,53,55,190,136,225,164,110,81,8,69,90,168,211,22,228,18,162,49,135,202,133,231,231,104,46,223,99,200,120,123,12,109,234,39,84,83,166,98,88,106,119,23,164,239,254,2,112,4,251,126,229,9,209,237,66,135,150,46,76,119,185,207,171,146,159,116,118,224,18,188,59,249,58,20,131,105,149,144,90,191,120,157,28,229,242,66,131,66,240,245,124,47,61,187,217,133,245,163},
  {216,56,210,195,158,188,225,37,150,135,51,148,199,218,157,6,62,193,250,186,40,255,46,92,100,169,137,77,81,32,48,58,142,2,230,230,107,178,34,70,73,39,108,172,167,86,145,155,68,75,205,156,0,33,26,68,73,12,65,71,17,54,202,78,110,174,88,62,188,34,49,9,91,180,212,69,165,69,143,228,21,167,60,220,58,63,83,111,204,230,173,5,173,67,109,127,49,232,199,197,183,170,71,31,179,127,101,118,37,111,154,238,207,216,59,40,195,2,246,229,85,12,60,198,101,111,65,9,196,41,32,12,10,165,155,173,194,64,247,166,185,221,244,246,213,116,18,185,31,16,73,83,114,161,68,67,29,99,139,81,26,71,87,165,73,174,165,151,33,38,91,233,60,154,66,213,66,58,3,159,141,220,46,224,55,31,57,107,163,126,134,58,52,215,54,32,35,46,15,217,50,64,231,205,55,86,97,126,39,181,28,85,170,161,6,54,237,94,166,207,3,217,206,85,154,224,113,209,125,211,227,115,222,147,197,115,226,131,11,227,45,238,171,41,14,17,68,186,126,60,152,114,250,83,49,135,232,201,116,2,118,176,231,16,235,56,120,45,42,159,69,193,18,122,244,187,212,255,61,84,206,33,134,151,173,153,102,150,100,178,146,123,216,173,249,252,79,147,252,225,49,222,238,170,47,60,103,167,126,7,183,234,114,88,135,97,18,119,151,139,140,179,245,124,180,65,191,123,191,247,102,247,156,83,59,62,134,248,210,63,27,10,205,42,211,28,209,176,97,33,218,22,161,99,80,55,117,211,168,125,25,190,6,195,102,86,251,92,192,45,165,67,68,224,172,173,150,231,169,109,131,158,31,23,130,237,111,57,151,234,223,213,245,96,96,124,212,130,186,64,189,38,109,55,88,216,104,181,58,35,69,190,154,148,58,16,251,230,209,240,5,38,28,42,192,189,92,220,149,77,236,90,199,93,115,203,160,254,7,75,200,102,11,246,193,214,108,173,182,251,115,135,15,114,44,85,205,244,63,140,6,137,4,71,132,78,65,95,168,144,45,189,57,13,187,104,209,19,64,48,224,130,59,197,40,149,137,204,200,32,91,2,148,6,113,183,31,107,191,34,132,40,121,77,37,134,45,95,53,39,25,251,143,201,17,190,118,254,239,159,102,47,211,143,31,202,183,52,149,74,209,220,97,171,56,166,57,226,115,76,29,63,99,85,134,45,72,168,7,109,185,126,91,219,227,95,201,133,97,77,110,34,109,96,128,228,63,219,41,26,14,29,149,195,184,51,87,231,100,143,72,40,179,109,48,89,161,143,50,224,121,64,74,224,92,69,80,216,112,248,184,121,64,166,90,64,191,239,140,56,80,176,29,185,34,48,26,4,122,202,99,250,27,129,76,242,126,80,151,27,168,193,132,77,61,17,141,203,158,73,81,242,76,88,82,85,235,32,208,78,216,133,15,137,148,97,29,99,129,170,126,246,9,141,20,5,8,7,174,108,190,163,152,49,137,15,23,207,253,205,218,119,94,103,21,21,195,240,198,234,239,171,89,191,52,57,128,36,46,199,19,18,25,192,88,169,12,31,177,18,13,193,239,126,6,152,140,154,239,107,93,169,25,43,205,13,192,25,209,194,72,3,59,192,104,175,41,50,229,224,238,8,14,8,70,1,234,74,74,105,80,147,130,2,70,239,227,106,144,42,220,153,6,20,246,166,142,53,13,78,243,110,78,131,231,46,195,103,64,146,28,10,200,245,166,28,37,27,140,239,230,145,194,117,88,146,91,109,116,227,201,212,120,59,246,97,184,143,255,112,106,128,101,28,158,177,236,215,151,197,165,160,206,39,25,45,145,7,187,139,217,61,196,217,115,149,241,134,92,172,252,61,94,125,230,22,5,178,49,74,145,103,233,17,70,183,115,32,185,133,239,56,96,118,189,152,225,246,248,161,77,151,116,239,231,245,204,238,38,206,34,209,151,7,69,245,236,63,42,22,11,190,24,217,94,30,166,128,236,99,166,16,161,76,168,85,201,77,165,164,120,196,227,201,246,227,108,156,145,176,18,211,162,64,195,90,210,109,64,3,114,158,187,27,115,66,180,82,178,159,216,103,80,37,230,247,214,44,252,120,75,147,17,252,40,130,112,113,146,189,229,18,140,135,20,0,140,44,164,107,99,167,127,25,190,67,95,65,135,149,163,2,34,134,95,79,56,165,187,87,67,212,2,153,41,230,94,32,128,205,197,241,224,179,81,76,188,61,143,4,212,7,119},
} ;

static const unsigned char precomputed_core_invsntrup1013_k[precomputed_core_invsntrup1013_NUM][crypto_core_KEYBYTES] = {
  {},
  {},
  {},
  {},
} ;

static const unsigned char precomputed_core_invsntrup1013_c[precomputed_core_invsntrup1013_NUM][crypto_core_CONSTBYTES] = {
  {},
  {},
  {},
  {},
} ;

static void test_core_invsntrup1013_impl(long long impl)
{
  unsigned char *h = test_core_invsntrup1013_h;
  unsigned char *n = test_core_invsntrup1013_n;
  unsigned char *k = test_core_invsntrup1013_k;
  unsigned char *c = test_core_invsntrup1013_c;
  unsigned char *h2 = test_core_invsntrup1013_h2;
  unsigned char *n2 = test_core_invsntrup1013_n2;
  unsigned char *k2 = test_core_invsntrup1013_k2;
  unsigned char *c2 = test_core_invsntrup1013_c2;
  long long hlen = crypto_core_OUTPUTBYTES;
  long long nlen = crypto_core_INPUTBYTES;
  long long klen = crypto_core_KEYBYTES;
  long long clen = crypto_core_CONSTBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_core_invsntrup1013_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_core = ntruprime_dispatch_core_invsntrup1013(impl);
    printf("core_invsntrup1013 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_invsntrup1013_implementation(impl),ntruprime_dispatch_core_invsntrup1013_compiler(impl));
  } else {
    crypto_core = ntruprime_core_invsntrup1013;
    printf("core_invsntrup1013 selected implementation %s compiler %s\n",ntruprime_core_invsntrup1013_implementation(),ntruprime_core_invsntrup1013_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 512;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(h2,h,hlen);
      input_prepare(n2,n,nlen);
      input_prepare(k2,k,klen);
      input_prepare(c2,c,clen);
      secret(n,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(h,n,k,c);
      public(n,nlen);
      public(k,klen);
      public(c,clen);
      public(h,hlen);
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_core");
      input_compare(n2,n,nlen,"crypto_core");
      input_compare(k2,k,klen,"crypto_core");
      input_compare(c2,c,clen,"crypto_core");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k2,klen);
      secret(c2,clen);
      crypto_core(h2,n2,k2,c2);
      public(n2,nlen);
      public(k2,klen);
      public(c2,clen);
      public(h2,hlen);
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic\n");
    }
    checksum_expected(core_invsntrup1013_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_core_invsntrup1013_NUM;++precomp) {
    output_prepare(h2,h,crypto_core_OUTPUTBYTES);
    input_prepare(n2,n,crypto_core_INPUTBYTES);
    memcpy(n,precomputed_core_invsntrup1013_n[precomp],crypto_core_INPUTBYTES);
    memcpy(n2,precomputed_core_invsntrup1013_n[precomp],crypto_core_INPUTBYTES);
    input_prepare(k2,k,crypto_core_KEYBYTES);
    memcpy(k,precomputed_core_invsntrup1013_k[precomp],crypto_core_KEYBYTES);
    memcpy(k2,precomputed_core_invsntrup1013_k[precomp],crypto_core_KEYBYTES);
    input_prepare(c2,c,crypto_core_CONSTBYTES);
    memcpy(c,precomputed_core_invsntrup1013_c[precomp],crypto_core_CONSTBYTES);
    memcpy(c2,precomputed_core_invsntrup1013_c[precomp],crypto_core_CONSTBYTES);
    crypto_core(h,n,k,c);
    if (memcmp(h,precomputed_core_invsntrup1013_h[precomp],crypto_core_OUTPUTBYTES)) {
      fail("failure: crypto_core fails precomputed test vectors\n");
      printf("expected h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",((unsigned char *) precomputed_core_invsntrup1013_h[precomp])[pos]);
      printf("\n");
      printf("received h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",h[pos]);
      printf("\n");
    }
    output_compare(h2,h,crypto_core_OUTPUTBYTES,"crypto_core");
    input_compare(n2,n,crypto_core_INPUTBYTES,"crypto_core");
    input_compare(k2,k,crypto_core_KEYBYTES,"crypto_core");
    input_compare(c2,c,crypto_core_CONSTBYTES,"crypto_core");
  }
}

void test_core_invsntrup1013(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"invsntrup1013")) return;
  storage_core_invsntrup1013_h = callocplus(crypto_core_OUTPUTBYTES);
  test_core_invsntrup1013_h = aligned(storage_core_invsntrup1013_h,crypto_core_OUTPUTBYTES);
  if (crypto_core_OUTPUTBYTES > maxalloc) maxalloc = crypto_core_OUTPUTBYTES;
  storage_core_invsntrup1013_n = callocplus(crypto_core_INPUTBYTES);
  test_core_invsntrup1013_n = aligned(storage_core_invsntrup1013_n,crypto_core_INPUTBYTES);
  if (crypto_core_INPUTBYTES > maxalloc) maxalloc = crypto_core_INPUTBYTES;
  storage_core_invsntrup1013_k = callocplus(crypto_core_KEYBYTES);
  test_core_invsntrup1013_k = aligned(storage_core_invsntrup1013_k,crypto_core_KEYBYTES);
  if (crypto_core_KEYBYTES > maxalloc) maxalloc = crypto_core_KEYBYTES;
  storage_core_invsntrup1013_c = callocplus(crypto_core_CONSTBYTES);
  test_core_invsntrup1013_c = aligned(storage_core_invsntrup1013_c,crypto_core_CONSTBYTES);
  if (crypto_core_CONSTBYTES > maxalloc) maxalloc = crypto_core_CONSTBYTES;
  storage_core_invsntrup1013_h2 = callocplus(maxalloc);
  test_core_invsntrup1013_h2 = aligned(storage_core_invsntrup1013_h2,crypto_core_OUTPUTBYTES);
  storage_core_invsntrup1013_n2 = callocplus(maxalloc);
  test_core_invsntrup1013_n2 = aligned(storage_core_invsntrup1013_n2,crypto_core_INPUTBYTES);
  storage_core_invsntrup1013_k2 = callocplus(maxalloc);
  test_core_invsntrup1013_k2 = aligned(storage_core_invsntrup1013_k2,crypto_core_KEYBYTES);
  storage_core_invsntrup1013_c2 = callocplus(maxalloc);
  test_core_invsntrup1013_c2 = aligned(storage_core_invsntrup1013_c2,crypto_core_CONSTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("core_invsntrup1013 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_core_invsntrup1013();++impl)
      forked(test_core_invsntrup1013_impl,impl);
    ++test_core_invsntrup1013_h;
    ++test_core_invsntrup1013_n;
    ++test_core_invsntrup1013_k;
    ++test_core_invsntrup1013_c;
    ++test_core_invsntrup1013_h2;
    ++test_core_invsntrup1013_n2;
    ++test_core_invsntrup1013_k2;
    ++test_core_invsntrup1013_c2;
  }
  free(storage_core_invsntrup1013_c2);
  free(storage_core_invsntrup1013_k2);
  free(storage_core_invsntrup1013_n2);
  free(storage_core_invsntrup1013_h2);
  free(storage_core_invsntrup1013_c);
  free(storage_core_invsntrup1013_k);
  free(storage_core_invsntrup1013_n);
  free(storage_core_invsntrup1013_h);
}
#undef crypto_core_OUTPUTBYTES
#undef crypto_core_INPUTBYTES
#undef crypto_core_KEYBYTES
#undef crypto_core_CONSTBYTES

