doc ///
	Key
		"Holonomy Lie algebras and symmetries"
	
	SeeAlso
	         "First Lie algebra tutorial"
		 "Second Lie algebra tutorial"
		 "Differential Lie algebra tutorial"
		 
		 	 
		 
	Description
	     Text
	          The method function @TO holonomy@
		  constructs the holonomy Lie algebra
		  of a hyperplane arrangement or a matroid given by the set of 2-flats. 
		  The input may be any set of 
		  subsets of a finite set $X$, such that all subsets have at most 
		  one element 
		  in common and are of length at least 3 
		  (the 2-flats of size 2 are determined by those). 
		  Indeed, for any such set $A$
		  of subsets there is a unique simple matroid of rank at most 3 with the
		  given set as the set of 2-flats of size at least 3, and {\tt holonomy(A)}
		  represents the holonomy Lie algebra of this matroid. 
		  
	     Example
		  L = holonomy({{a1,a2,a3},{a1,a4,a5},{a2,a4,a6}}) 
		  ideal L
		  		  
	     Text
	          The sum of the generators is a central element. Hence, by dividing out
		  by this element and using @TO "minimalPresentation(ZZ,LieAlgebra)"@ 
		  one obtains a presentation of
		  a Lie algebra with one generator less, 
		  which is isomorphic to the holonomy
		  Lie algebra in degrees $\ge\ 2$. 
		  
	     Example
	          L0 = L/{a1+a2+a3+a4+a5+a6}
		  L0 = minimalPresentation(3,L0)
		  describe L0
		  
	     Text
	          It is possible to get this Lie algebra directly by choosing one of 
		  the variables, picking all 2-flats containing that variable, deleting 
		  the variable, putting $A$ equal to the set of deleted 2-flats and 
		  $B$ equal
		  to the remaining 2-flats, and finally applying {\tt holonomy(A,B)}. 
		  
	     Example
	          L1 = holonomy({{a2,a3},{a4,a5}},{{a2,a4,a6}})
		  L0==L1 
		  
	     Text
	          Choosing another generator to delete gives another presentation
		  (which is still isomorhic to the holonomy 
		      Lie algebra in degrees $\ge\ 2$).
		  
	     Example
	          L6 = holonomy({{a2,a4}},{{a1,a2,a3},{a1,a4,a5}})
		  describe L6
		  dims(1,6,L6)
		  dims(1,6,L1)
		  dims(1,6,L)
		  
		  	     
	     Text
	          The procedure above corresponds to the deconing process of a central 
		  hyperplane arrangement, yielding an affine hyperplane arrangement. 
		  The first input set in {\tt holonomy} should be 
		  all maximal sets of parallel hyperplanes of size at least 2, 
		  and the second input set
		  should be all maximal sets of hyperplanes of size at least 3 that 
		  intersect in an affine 
		  space of codimension 2.
		  
	     Text
	     	  A local Lie algebra of a holonomy Lie algebra, see @TO holonomyLocal@, is
		  the Lie subalgebra generated by the generators in one of the subsets 
		  defined in the input. If this set is of size $k$, then the local Lie
		  algebra is free on $k$ generators if the set belongs to the first input
		  set, and it is free on $k-1$ generators in degrees $\ge\ 2$, if it belongs
		  to the second input set 
		  (observe that the numbering of the sets begins with 0).    
		  
	     Example 
	          describe holonomyLocal(1,L1)
		  describe holonomyLocal(2,L1)
	     Text
	          The kernel of the natural map, in degrees $\ge\ 2$, 
		  from $L$ to the direct sum of the local Lie algebras, 
		  see @TO holonomyLocal@,
		  is obtained by @TO "decompose(LieAlgebra)"@. 
		  This ideal is generated by the basis
		  elements in degree 3 of the form {\tt (a b c)},
		  where not all of {\tt a,b,c} belong
		  to the same local Lie algebra.
		  
		  
	     Example
	          I1=decompose(L1)
		  dim(3,I1)
		  
	     Text
	          It follows from the output displayed above that 
		  $L1$, in degrees $\ge\ 2$, is the direct sum of its local Lie
		  algebras: $L1$ is "decomposable".  This is not true for the
		  "quadrangel", i.e., the graphical
		  arrangement of the complete graph on four vertices, which is also
		  the braid arrangement of dimension 4. 
		  
	     Example
	          Q = holonomy({{a1,a2,a3},{a1,a4,a5},{a2,a4,a6},{a3,a5,a6}})
		  decompose Q
		  basis(3,oo)
		  Q1 = holonomy({{a2,a3},{a4,a5}},{{a2,a4,a6},{a3,a5,a6}})
		  decompose Q1
		  basis(3,oo)		  
	    
	     Text
	          Here is a way to obtain @TO "decompose(LieAlgebra)"@ (which is not used
		  in the program). The direct
		  sum of the local Lie algebras of $Q1$ may be obtained as follows
		  
	     Example
	          L0 = holonomyLocal(0,Q1)
		  L1 = holonomyLocal(1,Q1)
		  L2 = holonomyLocal(2,Q1)
		  L3 = holonomyLocal(3,Q1)
	          M = L0++L1++L2++L3
		  gens M
		  
	     Text
	          and the map from $Q1$ to $M$ is given as
		  
	     Example
	          f = map(M,Q1,{pr_0+pr_4,pr_1+pr_7,pr_2+pr_5,pr_3+pr_8,pr_6+pr_9})
		  describe f
	     Text
	          and  the ideal @TO "decompose(LieAlgebra)"@ 
		  may be obtained as the kernel of $f$:
		  
	     Example
	          kernel f
		  basis(3,oo)
	         		 	    
	     Text
	          The symmetric group S_4 operates on the vertices of K_4,
		  and this induces an action of S_4 on the six edges, which
		  in turn induces an action of S_4 on $Q$ as automorphisms. One
		  such permutation of the edges is (231645) but not (231564).
		  Using @TO "isIsomorphism(LieAlgebraMap)"@, 
		  it is possible to check  
		  if a permutation of the generators, 
		  written as a rearrangement of the generators, 
		  defines an automorphism of the Lie algebra. 
		   		   
	     Example
	          use Q
	          f=map(Q,Q,{a2,a3,a1,a6,a4,a5})
		  g=map(Q,Q,{a2,a3,a1,a5,a6,a4})
		  isIsomorphism f
		  isIsomorphism g
		  describe f		  
		  
	     Text
	          The ideal {\tt decompose(Q)} is invariant under all automorphisms
		  of $Q$. 
		  We may use @TO "trace(ZZ,LieSubSpace,LieAlgebraMap)"@ 
		  and a character table
		  for S_4 to determine its irreducible
		  representation constituents. There are four conjugacy classes 
		  (except $id$). Representatives for them as permutations of the six 
		  generators are, in cycle presentation, 
		  (23)(45), (123)(465), (16)(2354) and (16)(25)  
		  corresponding, in S_4, to one 2-cycle, one 3-cycle, 
		  one 4-cycle and a product
		  of two 2-cycles.
		  
	     Example
	          I=decompose Q
		  use Q
		  f1=map(Q,Q,{a1,a3,a2,a5,a4,a6})
		  f2=map(Q,Q,{a2,a3,a1,a6,a4,a5})
		  f3=map(Q,Q,{a6,a3,a5,a2,a4,a1})
		  f4=map(Q,Q,{a6,a5,a3,a4,a2,a1})
		  trace(4,I,f1)
		  trace(4,I,f2)
		  trace(4,I,f3)
		  trace(4,I,f4)
		  
	     Text
	          Making calculations with the character table for S_4, we see that
		  $I$ in degree 4 is the sum 
		  of the nontrivial irreducible representations. 
		  
		  
		  
		  
	     	  
    	    	  
///
end


