/*
-----------------------------------------------------------------------------
This source file is part of OGRE
(Object-oriented Graphics Rendering Engine)
For the latest info, see http://www.ogre3d.org/

Copyright (c) 2000-2013 Torus Knot Software Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
-----------------------------------------------------------------------------
*/

#include "PlayPenTestPlugin.h"
#include "PlayPenTests.h"
#include "OgreResourceGroupManager.h"

PlaypenTestPlugin::PlaypenTestPlugin()
    :SamplePlugin("PlaypenTestPlugin")
{
    // add the playpen tests
    addSample(new PlayPen_ManualLOD());
    addSample(new PlayPen_ManualLODFromFile());
    addSample(new PlayPen_ManualBlend());
    addSample(new PlayPen_ProjectSphere());
    addSample(new PlayPen_CameraSetDirection());
    addSample(new PlayPen_SceneNodeTracking());
    addSample(new PlayPen_StencilGlow());
    addSample(new PlayPen_TransparencyMipMaps());
    addSample(new PlayPen_BasicPlane());
    addSample(new PlayPen_MultiViewports());
    addSample(new PlayPen_Distortion());
    addSample(new PlayPen_AttachObjectsToBones());
    addSample(new PlayPen_Ortho());
    addSample(new PlayPen_StencilShadows());
    addSample(new PlayPen_2Spotlights());
    addSample(new PlayPen_LotsAndLotsOfEntities());
    addSample(new PlayPen_StaticGeometry());
    addSample(new PlayPen_StaticGeometryWithLOD());
    addSample(new PlayPen_BillboardTextureCoords());
    addSample(new PlayPen_ReflectedBillboards());
    addSample(new PlayPen_ManualObjectNonIndexed());
    addSample(new PlayPen_ManualObjectNonIndexedUpdateSmaller());
    addSample(new PlayPen_ManualObjectNonIndexedUpdateLarger());
    addSample(new PlayPen_ManualObjectIndexed());
    addSample(new PlayPen_ManualObjectIndexedUpdateSmaller());
    addSample(new PlayPen_ManualObjectIndexedUpdateLarger());
    addSample(new PlayPen_BillboardChain());
    addSample(new PlayPen_CubeDDS());
    addSample(new PlayPen_Dxt1());
    addSample(new PlayPen_Dxt1FromMemory());
    addSample(new PlayPen_Dxt1Alpha());
    addSample(new PlayPen_Dxt3());
    addSample(new PlayPen_Dxt3FromMemory());
    addSample(new PlayPen_Dxt5());
    addSample(new PlayPen_RibbonTrail());
    addSample(new PlayPen_BlendDiffuseColour());
    addSample(new PlayPen_CustomProjectionMatrix());
    addSample(new PlayPen_BillboardAccurateFacing());
    addSample(new PlayPen_MultiSceneManagersSimple());
    addSample(new PlayPen_NegativeScale());
    addSample(new PlayPen_SRGBtexture());
    addSample(new PlayPen_LightScissoring());
    addSample(new PlayPen_LightClipPlanes());
    addSample(new PlayPen_LightClipPlanesMoreLights());
    addSample(new PlayPen_MaterialSchemes());
    addSample(new PlayPen_BuildTangentOnAnimatedMesh());
    addSample(new PlayPen_BillboardOrigins());
    addSample(new PlayPen_DepthBias());
    addSample(new PlayPen_FarFromOrigin());
    addSample(new PlayPen_AlphaToCoverage());
    addSample(new PlayPen_ImageCombine());
    addSample(new PlayPen_WindowedViewportMode());
    addSample(new PlayPen_SkeletalAnimation());
    addSample(new PlayPen_SubEntityVisibility());
    addSample(new PlayPen_SkeletonAnimationOptimise());
    addSample(new PlayPen_TextureShadows());
    addSample(new PlayPen_TextureShadowsIntegrated());
    addSample(new PlayPen_TextureShadowsIntegratedPSSM());
    addSample(new PlayPen_ManualObject2D());
    addSample(new PlayPen_LiSPSM());
    addSample(new PlayPen_ClearScene());
    addSample(new PlayPen_StencilShadowsMixedOpSubMeshes());
    addSample(new PlayPen_ManualIlluminationStage());
    addSample(new PlayPen_Projection());
    addSample(new PlayPen_CompositorTextureShadows());
    addSample(new PlayPen_CompositorTechniqueSwitch());
    addSample(new PlayPen_ManualBoneMovement());
    addSample(new PlayPen_IntersectionSceneQuery());
    addSample(new PlayPen_RaySceneQuery());
    addSample(new PlayPen_SuppressedShadows());
    addSample(new PlayPen_DepthShadowMap());
    addSample(new PlayPen_ViewportNoShadows());
    addSample(new PlayPen_SerialisedColour());
    addSample(new PlayPen_ShadowLod());
    addSample(new PlayPen_MaterialSchemesListener());
    addSample(new PlayPen_ReinitialiseEntityAlteredMesh());
    addSample(new PlayPen_GeometryShaders());
    addSample(new PlayPen_VertexTexture());
    addSample(new PlayPen_PointSprites());
    addSample(new PlayPen_BlitSubTextures());
    addSample(new PlayPen_NonUniqueResourceNames());
    addSample(new PlayPen_NormalMapMirroredUVs());
    addSample(new PlayPen_TextureShadowsTransparentCaster());
    addSample(new PlayPen_MorphAnimationWithNormals());
    addSample(new PlayPen_MorphAnimationWithoutNormals());
    addSample(new PlayPen_PoseAnimationWithNormals());
    addSample(new PlayPen_PoseAnimationWithoutNormals());
    addSample(new PlayPen_ReloadResources());

    // GL ES 2 supports a minimum of 8 texture units, most implementations abide by this so we have to disable the test.
#if OGRE_NO_GLES3_SUPPORT == 1
    if (Ogre::Root::getSingletonPtr()->getRenderSystem()->getName().find("OpenGL ES 2") == String::npos)
#endif
        addSample(new PlayPen_16Textures());

    if (Ogre::Root::getSingletonPtr()->getRenderSystem()->getName().find("OpenGL ES 2") == String::npos &&
        Ogre::Root::getSingletonPtr()->getRenderSystem()->getName().find("OpenGL 3+") == String::npos)
    {
        //addSample(new PlayPen_Bsp()); // Disabled until non-RTSS PK3 loading is fixed
        addSample(new PlayPen_InfiniteAAB());
        addSample(new PlayPen_SpotlightViewProj()); // Only Cg at this time
        addSample(new PlayPen_TextureShadowsCustomCasterMat()); // Only Cg at this time
        addSample(new PlayPen_TextureShadowsCustomReceiverMat()); // Only Cg at this time
        addSample(new PlayPen_MaterialSchemesWithLOD());
        addSample(new PlayPen_MaterialSchemesWithMismatchedLOD());
    }

    // these should work, but my hardware doesn't seem to support 'em
    // (and I'm unaware of a way to reliably check capabilities in this area...)

    //addSample(new PlayPen_Float64DDS());
    //addSample(new PlayPen_Float128DDS());
    //addSample(new PlayPen_Float16DDS());
    //addSample(new PlayPen_Float32DDS());
    //addSample(new PlayPen_4bppPVR());
    //addSample(new PlayPen_4bppAlphaPVR());
    //addSample(new PlayPen_2bppPVR());
    //addSample(new PlayPen_2bppAlphaPVR());

    // There was some shader issue (possibly my hardware, but either way I can't verify these two)
    //addSample(new PlayPen_MRT());
    //addSample(new PlayPen_MRTCompositorScript());
}
//---------------------------------------------------------------------

PlaypenTestPlugin::~PlaypenTestPlugin()
{
    for (OgreBites::SampleSet::iterator i = mSamples.begin(); i != mSamples.end(); ++i)
    {
        delete *i;
    }
    mSamples.clear();
}
//---------------------------------------------------------------------

#ifndef OGRE_STATIC_LIB

PlaypenTestPlugin* testPlugin = 0;

extern "C" _OgreSampleExport void dllStartPlugin()
{
    testPlugin = OGRE_NEW PlaypenTestPlugin();
    Ogre::Root::getSingleton().installPlugin(testPlugin);
}

extern "C" _OgreSampleExport void dllStopPlugin()
{
    Ogre::Root::getSingleton().uninstallPlugin(testPlugin);
    OGRE_DELETE testPlugin;
}

#endif
