/*
 * Copyright (c) 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * @test
 * @bug 8012675
 * @library /java/awt/regtesthelpers
 * @build PassFailJFrame
 * @summary Tests if HTML script tags are unsupported
 * @run main/manual HtmlScriptTagParserTest
 */

import java.awt.Dimension;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class HtmlScriptTagParserTest {
    private static final String instructionsText = "Pass if you can see the " +
            "script and foo tags and its contents as text in editable " +
            "JTextFields and JTextAreas in the frame. Fail if this is not shown.";

    private static final String htmlText = "<!DOCTYPE html> <html> <head> " +
            "<title>Title</title> </head> <body> <script>function foo() " +
            "{alert('Alert generated by script tag function!');}</script>" +
            "<foo> Text inside unknown tag.</foo>" + "This is a test.";

    private static JFrame frame;
    private static JEditorPane jep;

    public static void createAndShowGUI() throws InterruptedException,
            InvocationTargetException {
        SwingUtilities.invokeAndWait(() -> {
            jep = new JEditorPane("text/html", htmlText);
            JScrollPane scroll = new JScrollPane(jep);
            Dimension scrollSize = new Dimension(500, 300);
            scroll.setPreferredSize(scrollSize);
            scroll.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);

            frame = new JFrame();
            frame.getContentPane().add(scroll);
            frame.pack();

            PassFailJFrame.addTestWindow(frame);
            PassFailJFrame.positionTestWindow(frame,
                    PassFailJFrame.Position.HORIZONTAL);
            frame.setVisible(true);
        });
    }

    public static void main(String[] args) throws InterruptedException,
            InvocationTargetException, IOException {

        PassFailJFrame pfjFrame = new PassFailJFrame("JScrollPane "
                + "Test Instructions", instructionsText +
                "\n\nHTML Used:\n" + htmlText, 5);

        createAndShowGUI();
        pfjFrame.awaitAndCheck();
    }
}
