with text_io;                           use text_io;
with Standard_Integer_Numbers;          use Standard_Integer_Numbers;
with Standard_Complex_Vectors;
with DoblDobl_Complex_Vectors;
with QuadDobl_Complex_Vectors;
with Standard_Complex_VecVecs;
with Standard_Complex_Poly_Systems;
with Standard_Complex_Solutions;
with DoblDobl_Complex_Solutions;
with QuadDobl_Complex_Solutions;

package Witness_Sets_Formats is

-- DESCRIPTION :
--   This package offers routines to convert the intrinsic representation
--   of witness points into an extrinsic format.  A witness point is a
--   solution of a polynomial system which lies on generic hyperplanes,
--   The number of generic hyperplanes used to cut out the point from
--   a solution component equals the dimension of the solution component.
--   The number of witness points on one component cut out by a same set
--   of generic hyperplanes equals the degree of the solution component.
--   So the witness point set is a very compact and efficient description
--   of a positive dimensional solution component of a polynomial system.
--   The intrinsic format uses the generators of the affine planes,
--   while the extrinsic format uses the explicit linear equations.
--   The intrinsic representation is more efficient as it needs less
--   variables, while the extrinsic representation is closer to the
--   tools of PHCpack to deal with solutions of polynomial systems.

-- FROM INTRINSIC TO EXTRINSIC FORMATS :

  function Embedded_System
              ( n : integer32;
                b,v : Standard_Complex_Vectors.Vector;
                p : Standard_Complex_Poly_Systems.Poly_Sys )
              return Standard_Complex_Poly_Systems.Poly_Sys;

  -- DESCRIPTION :
  --   Returns the embedded polynomial cut by the line b + t*v, with the
  --   defining equations for the line added as last n-1 linear equations
  --   in their embedded form.

  -- WARNING : only designed to work if p is square...

  function Embedded_System
              ( n,k : integer32;
                b : Standard_Complex_Vectors.Vector;
                v : Standard_Complex_VecVecs.VecVec;
                p : Standard_Complex_Poly_Systems.Poly_Sys )
              return Standard_Complex_Poly_Systems.Poly_Sys;

  -- DESCRIPTION :
  --   Returns the polynomial system, embedded with k slack variables,
  --   and the defining equations for the k-dimensional affine plane
  --   generated by offset vector b and directions v appended.

  -- WARNING : only designed to work if p is square...

  function Embedded_Extrinsic_Solutions
              ( n : integer32;
                b,v,sol : Standard_Complex_Vectors.Vector )
              return Standard_Complex_Solutions.Solution_List;
  function Embedded_Extrinsic_Solutions
              ( n : integer32;
                b,v,sol : DoblDobl_Complex_Vectors.Vector )
              return DoblDobl_Complex_Solutions.Solution_List;
  function Embedded_Extrinsic_Solutions
              ( n : integer32;
                b,v,sol : QuadDobl_Complex_Vectors.Vector )
              return QuadDobl_Complex_Solutions.Solution_List;

  -- DESCRIPTION :
  --   Returns the solutions on the line b + t*v in extrinsic format,
  --   embedded with n-1 slack variables with zero value,
  --   in standard double, double double, or quad double precision.

  function Embedded_Extrinsic_Solutions
              ( n,k : integer32;
                b : Standard_Complex_Vectors.Vector;
                v : Standard_Complex_VecVecs.VecVec;
                sols : Standard_Complex_Solutions.Solution_List )
              return Standard_Complex_Solutions.Solution_List;

  -- DESCRIPTION :
  --   Returns the extrinsic format of the solutions on the affine 
  --   k-plane generated by offset b and directions in v,
  --   embedded with k slack variables with zero value.

  procedure Write_Embedding
              ( file : in file_type;
                p : in Standard_Complex_Poly_Systems.Poly_Sys;
                n : in integer32;
                b,v : in Standard_Complex_Vectors.Vector;
                sols : in Standard_Complex_Solutions.Solution_List );

  -- DESCRIPTION :
  --   Writes the embedded polynomial system on file,
  --   along with the solution list in embedded extrinsic format.

  -- WARNING : only designed to work if p is square...

  procedure Write_Embedding
              ( file : in file_type;
                p : in Standard_Complex_Poly_Systems.Poly_Sys;
                n,k : in integer32;
                b : in Standard_Complex_Vectors.Vector;
                v : in Standard_Complex_VecVecs.VecVec;
                sols : in Standard_Complex_Solutions.Solution_List );

  -- DESCRIPTION :
  --   Writes the embedded polynomial system on file,
  --   along with the solution list in embedded extrinsic format.

  -- WARNING : only designed to work if p is square...

end Witness_Sets_Formats;
