/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import com.sixlegs.png.PixelProcessor;
import com.sixlegs.png.PngImage;
import java.awt.image.BufferedImage;

final class ProgressUpdater
extends PixelProcessor {
    private static final int STEP_PERCENT = 5;
    private final PngImage png;
    private final BufferedImage image;
    private final PixelProcessor pp;
    private final int total;
    private final int step;
    private int count;
    private int mod;

    public ProgressUpdater(PngImage png, BufferedImage image, PixelProcessor pp) {
        this.png = png;
        this.image = image;
        this.pp = pp;
        this.total = png.getWidth() * png.getHeight();
        this.step = Math.max(1, this.total * 5 / 100);
    }

    public boolean process(int[] row, int xOffset, int xStep, int yStep, int y, int width) {
        boolean result = this.pp.process(row, xOffset, xStep, yStep, y, width);
        this.mod += width;
        this.count += width;
        if (this.mod > this.step) {
            this.mod %= this.step;
            result = result && this.png.handleProgress(this.image, 100.0f * (float)this.count / (float)this.total);
        }
        return result;
    }
}

