% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/week-year-week-day.R
\name{year-week-day-arithmetic}
\alias{year-week-day-arithmetic}
\alias{add_years.clock_year_week_day}
\title{Arithmetic: year-week-day}
\usage{
\method{add_years}{clock_year_week_day}(x, n, ...)
}
\arguments{
\item{x}{\verb{[clock_year_week_day]}

A year-week-day vector.}

\item{n}{\verb{[integer / clock_duration]}

An integer vector to be converted to a duration, or a duration
corresponding to the arithmetic function being used. This corresponds
to the number of duration units to add. \code{n} may be negative to subtract
units of duration.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
\code{x} after performing the arithmetic.
}
\description{
These are year-week-day methods for the
\link[=clock-arithmetic]{arithmetic generics}.
\itemize{
\item \code{add_years()}
}

You cannot add weeks or days to a year-week-day calendar. Adding
days is much more efficiently done by converting to a time point first
by using \code{\link[=as_naive_time]{as_naive_time()}} or \code{\link[=as_sys_time]{as_sys_time()}}. Adding weeks is equally
as efficient as adding 7 days. Additionally, adding weeks to an invalid
year-week object (i.e. one set to the 53rd week, when that doesn't exist)
would be undefined.
}
\details{
\code{x} and \code{n} are recycled against each other using
\link[vctrs:theory-faq-recycling]{tidyverse recycling rules}.
}
\examples{
x <- year_week_day(2019, 1, 1)
add_years(x, 1:2)
}
