% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_boxplot.R
\name{compute_boxplot}
\alias{compute_boxplot}
\title{Calculate boxplot values}
\usage{
compute_boxplot(x, var = NULL, coef = 1.5)
}
\arguments{
\item{x}{Dataset-like object to compute boxplot values. There are built-in
methods for data frames, grouped data frames, and ggvis visualisations.}

\item{var}{Name of variable for which to compute boxplot values. The variable
must be continuous.}

\item{coef}{The maximum length of the whiskers as multiple of the
inter-quartile range. Default value is 1.5.}
}
\value{
A data frame with columns:
  \item{min_}{Lower whisker = smallest observation greater than or equal to lower hinge - 1.5 * IQR}
  \item{lower_}{Lower hinge (25th percentile)}
  \item{median_}{Median (50th percentile)}
  \item{upper_}{Upper hinge (75th percentile)}
  \item{max_}{Upper whisker = largest observation less than or equal to upper hinge + 1.5 * IQR}
  \item{outliers_}{A vector of values that are outside of the min and max}
}
\description{
Calculate boxplot values
}
\examples{
mtcars \%>\% compute_boxplot(~mpg)
mtcars \%>\% group_by(cyl) \%>\% compute_boxplot(~mpg)
}
\seealso{
\code{\link{layer_boxplots}}
}
