% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{dclass}
\alias{dclass}
\title{Kernel density estimation for classified data}
\usage{
dclass(
  xclass,
  burnin = 2,
  samples = 5,
  boundary = FALSE,
  bw = "nrd0",
  evalpoints = 200,
  adjust = 1,
  dFunc = NULL
)
}
\arguments{
\item{xclass}{classified values; matrix with two columns: lower and upper value}

\item{burnin}{burn-in sample size}

\item{samples}{sampling iteration size}

\item{boundary}{TRUE for positive only data (no positive density for negative values)}

\item{bw}{bandwidth selector method, defaults to "nrd0" see \code{density} for more options}

\item{evalpoints}{number of evaluation grid points}

\item{adjust}{as in \code{density}, the user can multiply the bandwidth by a certain factor such that bw=adjust*bw}

\item{dFunc}{character optional density (with "d", "p" and "q" functions) function name for parametric estimation such as "norm" "gamma" or "lnorm"}
}
\value{
The function returns a list object with the following objects (besides all input objects):
\item{\code{Mestimates}}{kde object containing the corrected density estimate}
\item{\code{gridx}}{Vector Grid on which density is evaluated}
\item{\code{resultDensity}}{Matrix with Estimated Density for each iteration}
\item{\code{resultX}}{Matrix of true latent values X estimates}
}
\description{
Kernel density estimation for classified data
}
\examples{
x=rlnorm(500, meanlog = 8, sdlog = 1)
classes <- c(0,500,1000,1500,2000,2500,3000,4000,5000,6000,8000,10000,15000,Inf)
xclass <- cut(x,breaks=classes)
xclass <- cbind(classes[as.numeric(xclass)], classes[as.numeric(xclass) + 1])
densityEst <- dclass(xclass=xclass, burnin=20, samples=50, evalpoints=1000)
plot(densityEst$Mestimates~densityEst$gridx ,lwd=2, type = "l")
}
