% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sCorrect-summary2.R
\name{summary2}
\alias{summary2}
\alias{summary2.lvmfit}
\alias{summary2.lvmfit2}
\alias{summary.lvmfit2}
\title{Latent Variable Model Summary After Small Sample Correction}
\usage{
summary2(object, robust, cluster, digit, ...)

\method{summary2}{lvmfit}(
  object,
  robust = FALSE,
  cluster = NULL,
  digit = max(5, getOption("digit")),
  ssc = lava.options()$ssc,
  df = lava.options()$df,
  ...
)

\method{summary2}{lvmfit2}(
  object,
  robust = FALSE,
  cluster = NULL,
  digit = max(5, getOption("digit")),
  ...
)

\method{summary}{lvmfit2}(
  object,
  robust = FALSE,
  cluster = NULL,
  digit = max(5, getOption("digit")),
  ...
)
}
\arguments{
\item{object}{a \code{lvmfit} or \code{lvmfit2} object (i.e. output of \code{lava::estimate} or \code{lavaSearch2::estimate2}).}

\item{robust}{[logical] should robust standard errors be used instead of the model based standard errors? Should be \code{TRUE} if argument cluster is not \code{NULL}.}

\item{cluster}{[integer vector] the grouping variable relative to which the observations are iid.}

\item{digit}{[integer > 0] the number of decimal places to use when displaying the summary.}

\item{...}{[logical] arguments passed to lower level methods.}

\item{ssc}{[character] method used to correct the small sample bias of the variance coefficients: no correction (\code{"none"}/\code{FALSE}/\code{NA}),
correct the first order bias in the residual variance (\code{"residual"}), or correct the first order bias in the estimated coefficients \code{"cox"}).
Only relevant when using a \code{lvmfit} object.}

\item{df}{[character] method used to estimate the degree of freedoms of the Wald statistic: Satterthwaite \code{"satterthwaite"}. 
Otherwise (\code{"none"}/\code{FALSE}/\code{NA}) the degree of freedoms are set to \code{Inf}.
Only relevant when using a \code{lvmfit} object.}
}
\description{
Summarize a fitted latent variable model.
Similar to \code{stats::summary} with small sample correction.
}
\details{
\code{summary2} is the same as \code{summary}
except that it first computes the small sample correction (but does not store it).
So if \code{summary2} is to be called several times,
it is more efficient to pre-compute the quantities for the small sample correction
using \code{sCorrect} and then call \code{summary2}.

\code{summary2} returns an object with an element \code{table2} containing the estimates, standard errors, degrees of freedom,
upper and lower limits of the confidence intervals, test statistics, and p-values.
}
\examples{
#### simulate data ####
m <- lvm(Y~X1+X2)
set.seed(10)
d <- lava::sim(m, 2e1)

#### latent variable models ####
e.lvm <- estimate(m, data = d)
summary(e.lvm)$coef

summary2(e.lvm)
summary2(e.lvm, ssc = "none")

}
\seealso{
\code{\link{estimate2}} to obtain \code{lvmfit2} objects.
}
\concept{small sample inference}
