% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progression.R
\name{progression}
\alias{progression}
\title{A Progression Condition}
\usage{
progression(
  message = character(0L),
  amount = 1,
  step = NULL,
  time = progression_time,
  ...,
  type = "update",
  class = NULL,
  progressor_uuid = NULL,
  progression_index = NULL,
  progression_time = Sys.time(),
  call = NULL,
  calls = sys.calls(),
  owner_session_uuid = NULL
)
}
\arguments{
\item{message}{(character vector or a function) If a character vector, then
it is pasted together into a single string using an empty separator.
If a function, then the message is constructed by \code{conditionMessage(p)}
calling this function with the progression condition \code{p} itself as the
first argument.}

\item{amount}{(numeric) The total amount of progress made.}

\item{step}{(numeric) The step completed. If specified, \code{amount} is ignored.
\emph{WARNING: Argument \code{step} should only be used when in full control of the
order when this progression condition is signaled.} For example, it must not
be signaled as one of many parallel progress updates signaled concurrently,
because then we cannot guarantee the order these progressions arrive.}

\item{time}{(POSIXct) A timestamp.}

\item{type}{Type of progression made.}

\item{class}{(character) Zero or more class names to prepend.}

\item{progressor_uuid}{(character string) A character string that is unique
for the current progressor and the current \R session.}

\item{progression_index}{(integer) A non-negative integer that is
incremented by one for each progression condition created.}

\item{progression_time}{(POSIXct or character string) A timestamp specifying
when the progression condition was created.}

\item{call}{(expression) A call expression.}

\item{calls}{(pairlist) The calls that lead up to this progression update.}

\item{owner_session_uuid}{(character string) A character string that is
unique for the \R session where the progressor was created.}

\item{\ldots}{Additional named elements.}
}
\value{
A \link[base:conditions]{base::condition} of class \code{progression}.
}
\description{
A progression condition represents a progress in an \R program.
}
\seealso{
To signal a progression condition, use \code{\link[base:conditions]{base::signalCondition()}}.
}
\keyword{internal}
