% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collectors.R
\name{parse_vector}
\alias{parse_vector}
\title{Parse a character vector.}
\usage{
parse_vector(
  x,
  collector,
  na = c("", "NA"),
  locale = default_locale(),
  trim_ws = TRUE
)
}
\arguments{
\item{x}{Character vector of elements to parse.}

\item{collector}{Column specification.}

\item{na}{Character vector of strings to interpret as missing values. Set this
option to \code{character()} to indicate no missing values.}

\item{locale}{The locale controls defaults that vary from place to place.
The default locale is US-centric (like R), but you can use
\code{\link[=locale]{locale()}} to create your own locale that controls things like
the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{trim_ws}{Should leading and trailing whitespace (ASCII spaces and tabs) be trimmed from
each field before parsing it?}
}
\description{
Parse a character vector.
}
\examples{
x <- c("1", "2", "3", "NA")
parse_vector(x, col_integer())
parse_vector(x, col_double())
}
\seealso{
Other parsers: 
\code{\link{col_skip}()},
\code{\link{cols_condense}()},
\code{\link{cols}()},
\code{\link{parse_datetime}()},
\code{\link{parse_factor}()},
\code{\link{parse_guess}()},
\code{\link{parse_logical}()},
\code{\link{parse_number}()}
}
\concept{parsers}
\keyword{internal}
