\name{get.mser.interpolation}
\alias{get.mser.interpolation}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Interpolate MSER dependency on the tag count }
\description{
  MSER generally decreases with increasing sequencing depth. This
  function interpolates the dependency of MSER on tag counts as a
  log-log linear function. The log-log fit is used to estimate the depth
  of sequencing required to reach desired \code{target.fold.enrichment}.
}
\usage{
get.mser.interpolation(signal.data, 
  control.data, 
  target.fold.enrichment = 5, 
  n.chains = 10, 
  n.steps = 6, 
  step.size = 1e+05, 
  chains = NULL, 
  test.agreement = 0.99, 
  return.chains = F, 
  enrichment.background.scales = c(1), 
  excluded.steps = c(seq(2, n.steps - 2)), ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{signal.data}{ signal chromosome tag vector list }
  \item{control.data}{ control chromosome tag vector list }
  \item{target.fold.enrichment}{ target MSER for which the depth should
    be estimated}
  \item{n.steps}{ number of steps in each subset chain. }
  \item{step.size}{ Either number of tags or fraction of the dataset
    size, see \code{step.size} parameter for \code{\link{get.mser}}. }
  \item{test.agreement}{ Fraction of the detected peaks that should
    agree between the full and subsampled datasets. See \code{test.agreement} parameter for \code{\link{get.mser}}}
  \item{n.chains}{ number of random subset chains }
  \item{chains}{ optional structure of pre-calculated chains
    (e.g. generated by an earlier call with \code{return.chains=T}.}
  
  \item{return.chains}{ whether to return peak predictions calculated on
  random chains. These can be passed back using \code{chains} argument
  to skip subsampling/prediction steps, and just recalculate the depth
  estimate for a different MSER.}
  \item{enrichment.background.scales}{ see \code{enrichment.background.scales} parameter for \code{\link{get.mser}} }
  \item{excluded.steps}{ Intermediate subsampling steps that should be excluded from
  the chains to speed up the calculation. By default, all intermediate
  steps except for first two and last two are skipped. Adding
  intermediate steps improves interpolation at the expense of
  computational time.}
  \item{\dots}{ additional parameters are passed to \code{\link{get.mser}} }
}
\details{
  To simulate sequencing growth, the method calculates peak predictions
  on random chains. Each chain is produced by sequential random
  subsampling of the original data. The number of steps in the chain
  indicates how many times the random subsampling will be performed.
}
\value{
  Normally reurns a list, specifying for each backgroundscale:
  \item{prediction}{estimated sequencing depth required to reach
  specified target MSER}
  \item{log10.fit}{linear fit model, a result of \code{lm()} call}

  If \code{return.chains=T}, the above structure is returned under
  \code{interpolation} field, along with \code{chains} field containing
  results of \code{\link{find.binding.positions}} calls on subsampled chains.
}
