% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{N2finemapping}
\alias{N2finemapping}
\title{Simulated Fine-mapping Data with Two Effect Variables}
\format{
\code{N2finemapping} is a list with the following elements:

\describe{

  \item{X}{Centered and scaled genotype data.}

  \item{chrom}{Chromomsome of the original data, in hg38 coordinates.}

  \item{pos}{Chromomosomal position of the original data, in hg38
    coordinates. The information can be used to compare impact of using
    other genotype references of the same variables in \code{susie_rss}
    application.}

  \item{true_coef}{Simulated effect sizes.}

  \item{residual_variance}{Simulated residual covariance matrix.}

  \item{Y}{Simulated multivariate response.}

  \item{allele_freq}{Allele frequencies based on the original
    genotype data.}

  \item{V}{Suggested prior covariance matrix for effect sizes of
     the two non-zero effect variables.}
}
}
\description{
This data set contains a genotype matrix for 574
  individuals and 1,002 variables. The variables are genotypes after
  centering and scaling, and therefore retain the correlation
  structure of the original genotype data. Two of the variables have
  non-zero effects on the multivariate response. The response data
  are generated under a multivariate linear regression model. See
  Wang \emph{et al} (2020) for details.
}
\examples{
data(N2finemapping)
}
\references{
G. Wang, A. Sarkar, P. Carbonetto and M. Stephens (2020). A simple
  new approach to variable selection in regression, with application
  to genetic fine-mapping. \emph{Journal of the Royal Statistical
  Society, Series B} \doi{10.1101/501114}.
}
\keyword{data}
