#!/usr/bin/perl

use strict;
use warnings;

use Test::More tests => 4;

use CGI;
use CGIParameters qw( read_cgi_parameters );

my $cgi = CGI->new( { c => [ 1, 2 ] } );
my( $param, $changed ) =
    read_cgi_parameters( $cgi,
                         { a => { re => '\d' },
                           b => { re => '\d' },
                           c => { re => '\d', multiple => 1 } },
                         { query_string => 'a=5&b=6&b=7&c=8&c=9' } );

ok( $param->{a} eq '5' );
ok( $param->{b} eq '6' );
ok( $param->{c}[0] eq '1' );
ok( $param->{c}[1] eq '2' );
