### New features

* [#11819](https://github.com/rubocop/rubocop/pull/11819): Add autocorrection for `Lint/AmbiguousBlockAssociation`. ([@r7kamura][])
* [#11597](https://github.com/rubocop/rubocop/issues/11597): Add autocorrection for `Lint/UselessAssignment`. ([@r7kamura][])
* [#11848](https://github.com/rubocop/rubocop/pull/11848): Add autocorrection for `Lint/Void`. ([@r7kamura][])
* [#11851](https://github.com/rubocop/rubocop/pull/11851): Add autocorrection for `Naming/MemoizedInstanceVariableName`. ([@r7kamura][])
* [#11856](https://github.com/rubocop/rubocop/pull/11856): Add autocorrection for `Style/CombinableLoops`. ([@r7kamura][])
* [#11824](https://github.com/rubocop/rubocop/pull/11824): Add autocorrection for `Lint/TopLevelReturnWithArgument`. ([@r7kamura][])
* [#11869](https://github.com/rubocop/rubocop/pull/11869): Add new `Style/ExactRegexpMatch` cop. ([@koic][])
* [#11814](https://github.com/rubocop/rubocop/pull/11814): Make `Style/CollectionCompact` aware of `delete_if`. ([@koic][])
* [#11866](https://github.com/rubocop/rubocop/pull/11866): Make `Style/Semicolon` aware of redundant semicolons in string interpolation braces. ([@koic][])

### Bug fixes

* [#11812](https://github.com/rubocop/rubocop/issues/11812): Fix a false negative for `Style/Attr` when using `attr` and method definitions. ([@koic][])
* [#11861](https://github.com/rubocop/rubocop/issues/11861): Fix a false positive for `Layout/SpaceAfterSemicolon` when no space between a semicolon and a closing brace of string interpolation. ([@koic][])
* [#11830](https://github.com/rubocop/rubocop/pull/11830): Fix a false positive for `Lint/IncompatibleIoSelectWithFiberScheduler`. ([@koic][])
* [#11846](https://github.com/rubocop/rubocop/issues/11846): Fix a false positive for `Lint/RedundantStringCoercion` when using `to_s(argument)` in `puts` argument. ([@koic][])
* [#11865](https://github.com/rubocop/rubocop/pull/11865): Fix an error for `Naming/ConstantName` when assigning a constant from an empty branch of `else`. ([@koic][])
* [#11844](https://github.com/rubocop/rubocop/issues/11844): Fix a false positive for `Style/RedundantLineContinuation` when using line concatenation for assigning a return value and without argument parentheses. ([@koic][])
* [#11808](https://github.com/rubocop/rubocop/pull/11808): Fix a false positive for `Style/RegexpLiteral` when using a regexp starts with equal as a method argument. ([@koic][])
* [#11822](https://github.com/rubocop/rubocop/issues/11822): Fix an error for `Layout/SpaceInsideBlockBraces` when a method call with a multiline block is used as an argument. ([@koic][])
* [#11849](https://github.com/rubocop/rubocop/issues/11849): Fix an error for `Style/ConditionalAssignment` when `EnforcedStyle: assign_inside_condition` and using empty `case` condition. ([@koic][])
* [#11967](https://github.com/rubocop/rubocop/pull/11967): Fix error for `Style/IfInsideElse` when a deep nested multiline `if...then...elsif...else...end`. ([@koic][])
* [#11842](https://github.com/rubocop/rubocop/pull/11842): Fix an error for `Style/IfUnlessModifier` when using multiple `if` modifier in the long one line. ([@koic][])
* [#11835](https://github.com/rubocop/rubocop/pull/11835): Fix an error for `Style/RequireOrder` when multiple `require` are not sorted. ([@koic][])
* [#11809](https://github.com/rubocop/rubocop/issues/11809): Fix an incorrect autocorrect for `Naming/RescuedExceptionsVariableName` when exception variable is referenced after `rescue` statement. ([@koic][])
* [#11852](https://github.com/rubocop/rubocop/issues/11852): Fix an incorrect autocorrect for `Style/EvalWithLocation` when using `eval` without line number and with parenthesized method call. ([@koic][])
* [#11862](https://github.com/rubocop/rubocop/issues/11862): Fix an incorrect autocorrect for `Style/GuardClause` when using `raise` in `else` branch in a one-liner with `then`. ([@koic][])
* [#11868](https://github.com/rubocop/rubocop/issues/11868): Fix a false positive for `Style/HashExcept` when method's receiver/argument is not the same as block key argument. ([@fatkodima][])
* [#11858](https://github.com/rubocop/rubocop/pull/11858): Fix false positives when using source comments in blocks. ([@reitermarkus][])
* [#11510](https://github.com/rubocop/rubocop/pull/11510): Fix `Lint/UselessAssignment` false positive when using numbered block parameters. ([@sambostock][])
* [#11872](https://github.com/rubocop/rubocop/pull/11872): Fix `Gemspec/DevelopmentDependencies` not trigger when add_development_dependency has more then one arguments. ([@Bhacaz][])
* [#11820](https://github.com/rubocop/rubocop/issues/11820): Fix `Lint/EmptyConditionalBody` false-positives for commented empty `elsif` body. ([@r7kamura][])

### Changes

* [#11859](https://github.com/rubocop/rubocop/pull/11859): Add rubocop-factory_bot to suggested extensions. ([@ydah][])
* [#10791](https://github.com/rubocop/rubocop/pull/10791): **(Breaking)** Drop runtime support for Ruby 2.6 and JRuby 9.3 (CRuby 2.6 compatible). ([@koic][])
* [#11826](https://github.com/rubocop/rubocop/pull/11826): Exclude `**/*.jb` from `Lint/TopLevelReturnWithArgument`. ([@r7kamura][])
* [#11871](https://github.com/rubocop/rubocop/pull/11871): Mark `Style/DataInheritance` as unsafe autocorrect, `Style/OpenStructUse` as unsafe, and `Security/CompoundHash` as unsafe. ([@koic][])

[@r7kamura]: https://github.com/r7kamura
[@koic]: https://github.com/koic
[@fatkodima]: https://github.com/fatkodima
[@reitermarkus]: https://github.com/reitermarkus
[@sambostock]: https://github.com/sambostock
[@Bhacaz]: https://github.com/Bhacaz
[@ydah]: https://github.com/ydah
