### New features

* [#14348](https://github.com/rubocop/rubocop/pull/14348): Add new cop `Layout/EmptyLinesAfterModuleInclusion`. ([@lovro-bikic][])
* [#14374](https://github.com/rubocop/rubocop/pull/14374): Enhance `Naming/MethodName` cop to detect offenses within `Data` members. ([@viralpraxis][])

### Bug fixes

* [#14373](https://github.com/rubocop/rubocop/pull/14373): Fix an error for `Style/ParallelAssignment` when a lambda with parallel assignment is used on the RHS. ([@koic][])
* [#14370](https://github.com/rubocop/rubocop/issues/14370): Fix comment duplication bug in `Style/AccessorGrouping` separated autocorrect. ([@r7kamura][])
* [#14377](https://github.com/rubocop/rubocop/pull/14377): Fix a false positive for `Lint/UselessAssignment` when the assignment is inside a loop body. ([@5hun-s][])
* [#14355](https://github.com/rubocop/rubocop/pull/14355): Fix a false negative for `Style/RedundantParentheses` when using parentheses around a `rescue` expression on a one-line. ([@koic][])
* [#14354](https://github.com/rubocop/rubocop/pull/14354): Fix incorrect autocorrect for `Style/AccessModifierDeclarations` when using a grouped access modifier declaration. ([@girasquid][])
* [#14367](https://github.com/rubocop/rubocop/issues/14367): Fix an incorrect autocorrect for `Style/SingleLineMethods` when defining a single-line singleton method. ([@koic][])
* [#14344](https://github.com/rubocop/rubocop/issues/14344): Fix incorrect autocorrect for `Style/SingleLineMethods` when a single-line method definition contains a modifier. ([@koic][])
* [#14350](https://github.com/rubocop/rubocop/issues/14350): Fix `Naming/MethodName` cop false positives with `define_method` and operator names. ([@viralpraxis][])
* [#14333](https://github.com/rubocop/rubocop/issues/14333): Fix `Naming/PredicateMethod` ignoring the implicit `nil` from missing `else` branches. ([@earlopain][])
* [#14356](https://github.com/rubocop/rubocop/pull/14356): Fix `Style/ItBlockParameter` cop error on `always` style and missing block body. ([@viralpraxis][])
* [#14362](https://github.com/rubocop/rubocop/issues/14362): Update `Lint/RequireRangeParentheses` to not register false positives when range elements span multiple lines. ([@dvandersluis][])
* [#14309](https://github.com/rubocop/rubocop/issues/14309): Update `Style/SoleNestedConditional` to properly correct assignments within `and`. ([@dvandersluis][])

### Changes

* [#14358](https://github.com/rubocop/rubocop/pull/14358): Add `tsort` gem to runtime dependency for Ruby 3.5-dev. ([@koic][])
* [#14322](https://github.com/rubocop/rubocop/issues/14322): Expand the scope of `Style/ItAssignment` to consider all local variable and method parameter names. ([@dvandersluis][])
* [#14378](https://github.com/rubocop/rubocop/pull/14378): Change `Layout/SpaceAroundKeyword` to offend for missing whitespace between `return` and opening parenthesis. ([@lovro-bikic][])
* [#14360](https://github.com/rubocop/rubocop/pull/14360): Make `Layout/SpaceAroundOperators` aware of alternative and as pattern matchings. ([@koic][])
* [#14375](https://github.com/rubocop/rubocop/pull/14375): Make `Lint/RedundantSafeNavigation` aware of builtin convert methods `to_s`, `to_i`, `to_f`, `to_a`, and `to_h`. ([@koic][])
* [#13835](https://github.com/rubocop/rubocop/issues/13835): Add `InferNonNilReceiver` config to `Lint/RedundantSafeNavigation` to check previous code paths if the receiver is non-nil. ([@fatkodima][])
* [#14381](https://github.com/rubocop/rubocop/pull/14381): Offend `array1.any? { |elem| array2.member?(elem) }` and `array1.none? { |elem| array2.member?(elem) }` in `Style/ArrayIntersect`. ([@lovro-bikic][])

[@lovro-bikic]: https://github.com/lovro-bikic
[@viralpraxis]: https://github.com/viralpraxis
[@koic]: https://github.com/koic
[@r7kamura]: https://github.com/r7kamura
[@5hun-s]: https://github.com/5hun-s
[@girasquid]: https://github.com/girasquid
[@earlopain]: https://github.com/earlopain
[@dvandersluis]: https://github.com/dvandersluis
[@fatkodima]: https://github.com/fatkodima
