# Bundler Contributor Guidelines

Thank you for your interest in making Bundler better! We welcome contributions from everyone. Dozens of contributors like you have submitted feature improvements, fixed bugs, and written new documentation. [Join the Bundler Slack community](https://slack.bundler.io/) to connect with the Bundler core team and other contributors like you.

Before submitting a contribution, read through the following guidelines:

* [Bundler Code of Conduct](https://github.com/rubygems/rubygems/blob/master/CODE_OF_CONDUCT.md) (By participating in Bundler, you agree to abide by the terms laid out in the CoC.)
* [Issue Reporting Guidelines](https://github.com/rubygems/rubygems/blob/master/bundler/doc/contributing/ISSUES.md)
* [Pull Request Guidelines](https://github.com/rubygems/rubygems/blob/master/bundler/doc/development/PULL_REQUESTS.md)

And be sure to [set up your development environment](https://github.com/rubygems/rubygems/blob/master/bundler/doc/development/SETUP.md).

## Feature Requests

To request substantial changes to Bundler and/or Bundler documentation, please refer to the [README](https://github.com/bundler/rfcs/blob/master/README.md) in the [RFC repository](https://github.com/bundler/rfcs) for instructions.

## Contributing to Bundler

Here are the different ways you can start contributing to the Bundler project:

* [First contribution suggestions](/bundler/doc/contributing/HOW_YOU_CAN_HELP.md)
* [Adding new features](/bundler/doc/development/NEW_FEATURES.md)
* [Triaging bugs](/bundler/doc/contributing/BUG_TRIAGE.md)
* [Writing documentation](/bundler/doc/documentation/WRITING.md)
* [Community engagement](/bundler/doc/contributing/COMMUNITY.md)

## Supporting Bundler

[Ruby Together](https://rubytogether.org/) pays some Bundler maintainers for their work, funded directly by the Ruby community. If you'd like to support Bundler with a financial contribution, [become an individual sponsor](https://rubytogether.org/developers#plans). We also welcome financial [contributions from companies](https://rubytogether.org/companies#plans), too! (You can also support us through [Open Collective](https://opencollective.com/rubytogether).)
