// Copyright 2025 the Fearless_SIMD Authors
// SPDX-License-Identifier: Apache-2.0 OR MIT

// This file is autogenerated by fearless_simd_gen

use crate::{Simd, SimdInto};
use crate::{
    f32x4, f32x8, f32x16, f64x2, f64x4, f64x8, i8x16, i8x32, i8x64, i16x8, i16x16, i16x32, i32x4,
    i32x8, i32x16, mask8x16, mask8x32, mask8x64, mask16x8, mask16x16, mask16x32, mask32x4,
    mask32x8, mask32x16, mask64x2, mask64x4, mask64x8, u8x16, u8x32, u8x64, u16x8, u16x16, u16x32,
    u32x4, u32x8, u32x16,
};
impl<S: Simd> core::ops::Neg for f32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn neg(self) -> Self::Output {
        self.simd.neg_f32x4(self)
    }
}
impl<S: Simd> core::ops::Add for f32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: Self) -> Self::Output {
        self.simd.add_f32x4(self, rhs)
    }
}
impl<S: Simd> core::ops::AddAssign for f32x4<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: Self) {
        *self = self.simd.add_f32x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add<f32> for f32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: f32) -> Self::Output {
        self.simd.add_f32x4(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::AddAssign<f32> for f32x4<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: f32) {
        *self = self.simd.add_f32x4(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Add<f32x4<S>> for f32 {
    type Output = f32x4<S>;
    #[inline(always)]
    fn add(self, rhs: f32x4<S>) -> Self::Output {
        rhs.simd.add_f32x4(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Sub for f32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: Self) -> Self::Output {
        self.simd.sub_f32x4(self, rhs)
    }
}
impl<S: Simd> core::ops::SubAssign for f32x4<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: Self) {
        *self = self.simd.sub_f32x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::Sub<f32> for f32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: f32) -> Self::Output {
        self.simd.sub_f32x4(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::SubAssign<f32> for f32x4<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: f32) {
        *self = self.simd.sub_f32x4(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Sub<f32x4<S>> for f32 {
    type Output = f32x4<S>;
    #[inline(always)]
    fn sub(self, rhs: f32x4<S>) -> Self::Output {
        rhs.simd.sub_f32x4(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Mul for f32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: Self) -> Self::Output {
        self.simd.mul_f32x4(self, rhs)
    }
}
impl<S: Simd> core::ops::MulAssign for f32x4<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: Self) {
        *self = self.simd.mul_f32x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::Mul<f32> for f32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: f32) -> Self::Output {
        self.simd.mul_f32x4(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::MulAssign<f32> for f32x4<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: f32) {
        *self = self.simd.mul_f32x4(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Mul<f32x4<S>> for f32 {
    type Output = f32x4<S>;
    #[inline(always)]
    fn mul(self, rhs: f32x4<S>) -> Self::Output {
        rhs.simd.mul_f32x4(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Div for f32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn div(self, rhs: Self) -> Self::Output {
        self.simd.div_f32x4(self, rhs)
    }
}
impl<S: Simd> core::ops::DivAssign for f32x4<S> {
    #[inline(always)]
    fn div_assign(&mut self, rhs: Self) {
        *self = self.simd.div_f32x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::Div<f32> for f32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn div(self, rhs: f32) -> Self::Output {
        self.simd.div_f32x4(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::DivAssign<f32> for f32x4<S> {
    #[inline(always)]
    fn div_assign(&mut self, rhs: f32) {
        *self = self.simd.div_f32x4(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Div<f32x4<S>> for f32 {
    type Output = f32x4<S>;
    #[inline(always)]
    fn div(self, rhs: f32x4<S>) -> Self::Output {
        rhs.simd.div_f32x4(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Neg for i8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn neg(self) -> Self::Output {
        self.simd.neg_i8x16(self)
    }
}
impl<S: Simd> core::ops::Add for i8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: Self) -> Self::Output {
        self.simd.add_i8x16(self, rhs)
    }
}
impl<S: Simd> core::ops::AddAssign for i8x16<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: Self) {
        *self = self.simd.add_i8x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add<i8> for i8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: i8) -> Self::Output {
        self.simd.add_i8x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::AddAssign<i8> for i8x16<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: i8) {
        *self = self.simd.add_i8x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Add<i8x16<S>> for i8 {
    type Output = i8x16<S>;
    #[inline(always)]
    fn add(self, rhs: i8x16<S>) -> Self::Output {
        rhs.simd.add_i8x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Sub for i8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: Self) -> Self::Output {
        self.simd.sub_i8x16(self, rhs)
    }
}
impl<S: Simd> core::ops::SubAssign for i8x16<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: Self) {
        *self = self.simd.sub_i8x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Sub<i8> for i8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: i8) -> Self::Output {
        self.simd.sub_i8x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::SubAssign<i8> for i8x16<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: i8) {
        *self = self.simd.sub_i8x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Sub<i8x16<S>> for i8 {
    type Output = i8x16<S>;
    #[inline(always)]
    fn sub(self, rhs: i8x16<S>) -> Self::Output {
        rhs.simd.sub_i8x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Mul for i8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: Self) -> Self::Output {
        self.simd.mul_i8x16(self, rhs)
    }
}
impl<S: Simd> core::ops::MulAssign for i8x16<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: Self) {
        *self = self.simd.mul_i8x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Mul<i8> for i8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: i8) -> Self::Output {
        self.simd.mul_i8x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::MulAssign<i8> for i8x16<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: i8) {
        *self = self.simd.mul_i8x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Mul<i8x16<S>> for i8 {
    type Output = i8x16<S>;
    #[inline(always)]
    fn mul(self, rhs: i8x16<S>) -> Self::Output {
        rhs.simd.mul_i8x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitAnd for i8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: Self) -> Self::Output {
        self.simd.and_i8x16(self, rhs)
    }
}
impl<S: Simd> core::ops::BitAndAssign for i8x16<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: Self) {
        *self = self.simd.and_i8x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd<i8> for i8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: i8) -> Self::Output {
        self.simd.and_i8x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitAndAssign<i8> for i8x16<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: i8) {
        *self = self.simd.and_i8x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitAnd<i8x16<S>> for i8 {
    type Output = i8x16<S>;
    #[inline(always)]
    fn bitand(self, rhs: i8x16<S>) -> Self::Output {
        rhs.simd.and_i8x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitOr for i8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: Self) -> Self::Output {
        self.simd.or_i8x16(self, rhs)
    }
}
impl<S: Simd> core::ops::BitOrAssign for i8x16<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: Self) {
        *self = self.simd.or_i8x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitOr<i8> for i8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: i8) -> Self::Output {
        self.simd.or_i8x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitOrAssign<i8> for i8x16<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: i8) {
        *self = self.simd.or_i8x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitOr<i8x16<S>> for i8 {
    type Output = i8x16<S>;
    #[inline(always)]
    fn bitor(self, rhs: i8x16<S>) -> Self::Output {
        rhs.simd.or_i8x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitXor for i8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: Self) -> Self::Output {
        self.simd.xor_i8x16(self, rhs)
    }
}
impl<S: Simd> core::ops::BitXorAssign for i8x16<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: Self) {
        *self = self.simd.xor_i8x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitXor<i8> for i8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: i8) -> Self::Output {
        self.simd.xor_i8x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitXorAssign<i8> for i8x16<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: i8) {
        *self = self.simd.xor_i8x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitXor<i8x16<S>> for i8 {
    type Output = i8x16<S>;
    #[inline(always)]
    fn bitxor(self, rhs: i8x16<S>) -> Self::Output {
        rhs.simd.xor_i8x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Shl<u32> for i8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn shl(self, rhs: u32) -> Self::Output {
        self.simd.shl_i8x16(self, rhs)
    }
}
impl<S: Simd> core::ops::Shr<u32> for i8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: u32) -> Self::Output {
        self.simd.shr_i8x16(self, rhs)
    }
}
impl<S: Simd> core::ops::ShlAssign<u32> for i8x16<S> {
    #[inline(always)]
    fn shl_assign(&mut self, rhs: u32) {
        *self = self.simd.shl_i8x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::ShrAssign<u32> for i8x16<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: u32) {
        *self = self.simd.shr_i8x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Shr for i8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: Self) -> Self::Output {
        self.simd.shrv_i8x16(self, rhs)
    }
}
impl<S: Simd> core::ops::ShrAssign for i8x16<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: Self) {
        *self = self.simd.shrv_i8x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add for u8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: Self) -> Self::Output {
        self.simd.add_u8x16(self, rhs)
    }
}
impl<S: Simd> core::ops::AddAssign for u8x16<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: Self) {
        *self = self.simd.add_u8x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add<u8> for u8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: u8) -> Self::Output {
        self.simd.add_u8x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::AddAssign<u8> for u8x16<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: u8) {
        *self = self.simd.add_u8x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Add<u8x16<S>> for u8 {
    type Output = u8x16<S>;
    #[inline(always)]
    fn add(self, rhs: u8x16<S>) -> Self::Output {
        rhs.simd.add_u8x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Sub for u8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: Self) -> Self::Output {
        self.simd.sub_u8x16(self, rhs)
    }
}
impl<S: Simd> core::ops::SubAssign for u8x16<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: Self) {
        *self = self.simd.sub_u8x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Sub<u8> for u8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: u8) -> Self::Output {
        self.simd.sub_u8x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::SubAssign<u8> for u8x16<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: u8) {
        *self = self.simd.sub_u8x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Sub<u8x16<S>> for u8 {
    type Output = u8x16<S>;
    #[inline(always)]
    fn sub(self, rhs: u8x16<S>) -> Self::Output {
        rhs.simd.sub_u8x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Mul for u8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: Self) -> Self::Output {
        self.simd.mul_u8x16(self, rhs)
    }
}
impl<S: Simd> core::ops::MulAssign for u8x16<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: Self) {
        *self = self.simd.mul_u8x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Mul<u8> for u8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: u8) -> Self::Output {
        self.simd.mul_u8x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::MulAssign<u8> for u8x16<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: u8) {
        *self = self.simd.mul_u8x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Mul<u8x16<S>> for u8 {
    type Output = u8x16<S>;
    #[inline(always)]
    fn mul(self, rhs: u8x16<S>) -> Self::Output {
        rhs.simd.mul_u8x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitAnd for u8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: Self) -> Self::Output {
        self.simd.and_u8x16(self, rhs)
    }
}
impl<S: Simd> core::ops::BitAndAssign for u8x16<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: Self) {
        *self = self.simd.and_u8x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd<u8> for u8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: u8) -> Self::Output {
        self.simd.and_u8x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitAndAssign<u8> for u8x16<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: u8) {
        *self = self.simd.and_u8x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitAnd<u8x16<S>> for u8 {
    type Output = u8x16<S>;
    #[inline(always)]
    fn bitand(self, rhs: u8x16<S>) -> Self::Output {
        rhs.simd.and_u8x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitOr for u8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: Self) -> Self::Output {
        self.simd.or_u8x16(self, rhs)
    }
}
impl<S: Simd> core::ops::BitOrAssign for u8x16<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: Self) {
        *self = self.simd.or_u8x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitOr<u8> for u8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: u8) -> Self::Output {
        self.simd.or_u8x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitOrAssign<u8> for u8x16<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: u8) {
        *self = self.simd.or_u8x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitOr<u8x16<S>> for u8 {
    type Output = u8x16<S>;
    #[inline(always)]
    fn bitor(self, rhs: u8x16<S>) -> Self::Output {
        rhs.simd.or_u8x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitXor for u8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: Self) -> Self::Output {
        self.simd.xor_u8x16(self, rhs)
    }
}
impl<S: Simd> core::ops::BitXorAssign for u8x16<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: Self) {
        *self = self.simd.xor_u8x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitXor<u8> for u8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: u8) -> Self::Output {
        self.simd.xor_u8x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitXorAssign<u8> for u8x16<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: u8) {
        *self = self.simd.xor_u8x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitXor<u8x16<S>> for u8 {
    type Output = u8x16<S>;
    #[inline(always)]
    fn bitxor(self, rhs: u8x16<S>) -> Self::Output {
        rhs.simd.xor_u8x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Shl<u32> for u8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn shl(self, rhs: u32) -> Self::Output {
        self.simd.shl_u8x16(self, rhs)
    }
}
impl<S: Simd> core::ops::Shr<u32> for u8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: u32) -> Self::Output {
        self.simd.shr_u8x16(self, rhs)
    }
}
impl<S: Simd> core::ops::ShlAssign<u32> for u8x16<S> {
    #[inline(always)]
    fn shl_assign(&mut self, rhs: u32) {
        *self = self.simd.shl_u8x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::ShrAssign<u32> for u8x16<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: u32) {
        *self = self.simd.shr_u8x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Shr for u8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: Self) -> Self::Output {
        self.simd.shrv_u8x16(self, rhs)
    }
}
impl<S: Simd> core::ops::ShrAssign for u8x16<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: Self) {
        *self = self.simd.shrv_u8x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd for mask8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: Self) -> Self::Output {
        self.simd.and_mask8x16(self, rhs)
    }
}
impl<S: Simd> core::ops::BitAndAssign for mask8x16<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: Self) {
        *self = self.simd.and_mask8x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd<i8> for mask8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: i8) -> Self::Output {
        self.simd.and_mask8x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitAndAssign<i8> for mask8x16<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: i8) {
        *self = self.simd.and_mask8x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitAnd<mask8x16<S>> for i8 {
    type Output = mask8x16<S>;
    #[inline(always)]
    fn bitand(self, rhs: mask8x16<S>) -> Self::Output {
        rhs.simd.and_mask8x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitOr for mask8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: Self) -> Self::Output {
        self.simd.or_mask8x16(self, rhs)
    }
}
impl<S: Simd> core::ops::BitOrAssign for mask8x16<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: Self) {
        *self = self.simd.or_mask8x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitOr<i8> for mask8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: i8) -> Self::Output {
        self.simd.or_mask8x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitOrAssign<i8> for mask8x16<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: i8) {
        *self = self.simd.or_mask8x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitOr<mask8x16<S>> for i8 {
    type Output = mask8x16<S>;
    #[inline(always)]
    fn bitor(self, rhs: mask8x16<S>) -> Self::Output {
        rhs.simd.or_mask8x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitXor for mask8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: Self) -> Self::Output {
        self.simd.xor_mask8x16(self, rhs)
    }
}
impl<S: Simd> core::ops::BitXorAssign for mask8x16<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: Self) {
        *self = self.simd.xor_mask8x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitXor<i8> for mask8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: i8) -> Self::Output {
        self.simd.xor_mask8x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitXorAssign<i8> for mask8x16<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: i8) {
        *self = self.simd.xor_mask8x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitXor<mask8x16<S>> for i8 {
    type Output = mask8x16<S>;
    #[inline(always)]
    fn bitxor(self, rhs: mask8x16<S>) -> Self::Output {
        rhs.simd.xor_mask8x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Not for mask8x16<S> {
    type Output = Self;
    #[inline(always)]
    fn not(self) -> Self::Output {
        self.simd.not_mask8x16(self)
    }
}
impl<S: Simd> core::ops::Neg for i16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn neg(self) -> Self::Output {
        self.simd.neg_i16x8(self)
    }
}
impl<S: Simd> core::ops::Add for i16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: Self) -> Self::Output {
        self.simd.add_i16x8(self, rhs)
    }
}
impl<S: Simd> core::ops::AddAssign for i16x8<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: Self) {
        *self = self.simd.add_i16x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add<i16> for i16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: i16) -> Self::Output {
        self.simd.add_i16x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::AddAssign<i16> for i16x8<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: i16) {
        *self = self.simd.add_i16x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Add<i16x8<S>> for i16 {
    type Output = i16x8<S>;
    #[inline(always)]
    fn add(self, rhs: i16x8<S>) -> Self::Output {
        rhs.simd.add_i16x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Sub for i16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: Self) -> Self::Output {
        self.simd.sub_i16x8(self, rhs)
    }
}
impl<S: Simd> core::ops::SubAssign for i16x8<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: Self) {
        *self = self.simd.sub_i16x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::Sub<i16> for i16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: i16) -> Self::Output {
        self.simd.sub_i16x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::SubAssign<i16> for i16x8<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: i16) {
        *self = self.simd.sub_i16x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Sub<i16x8<S>> for i16 {
    type Output = i16x8<S>;
    #[inline(always)]
    fn sub(self, rhs: i16x8<S>) -> Self::Output {
        rhs.simd.sub_i16x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Mul for i16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: Self) -> Self::Output {
        self.simd.mul_i16x8(self, rhs)
    }
}
impl<S: Simd> core::ops::MulAssign for i16x8<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: Self) {
        *self = self.simd.mul_i16x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::Mul<i16> for i16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: i16) -> Self::Output {
        self.simd.mul_i16x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::MulAssign<i16> for i16x8<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: i16) {
        *self = self.simd.mul_i16x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Mul<i16x8<S>> for i16 {
    type Output = i16x8<S>;
    #[inline(always)]
    fn mul(self, rhs: i16x8<S>) -> Self::Output {
        rhs.simd.mul_i16x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitAnd for i16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: Self) -> Self::Output {
        self.simd.and_i16x8(self, rhs)
    }
}
impl<S: Simd> core::ops::BitAndAssign for i16x8<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: Self) {
        *self = self.simd.and_i16x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd<i16> for i16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: i16) -> Self::Output {
        self.simd.and_i16x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitAndAssign<i16> for i16x8<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: i16) {
        *self = self.simd.and_i16x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitAnd<i16x8<S>> for i16 {
    type Output = i16x8<S>;
    #[inline(always)]
    fn bitand(self, rhs: i16x8<S>) -> Self::Output {
        rhs.simd.and_i16x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitOr for i16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: Self) -> Self::Output {
        self.simd.or_i16x8(self, rhs)
    }
}
impl<S: Simd> core::ops::BitOrAssign for i16x8<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: Self) {
        *self = self.simd.or_i16x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitOr<i16> for i16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: i16) -> Self::Output {
        self.simd.or_i16x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitOrAssign<i16> for i16x8<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: i16) {
        *self = self.simd.or_i16x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitOr<i16x8<S>> for i16 {
    type Output = i16x8<S>;
    #[inline(always)]
    fn bitor(self, rhs: i16x8<S>) -> Self::Output {
        rhs.simd.or_i16x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitXor for i16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: Self) -> Self::Output {
        self.simd.xor_i16x8(self, rhs)
    }
}
impl<S: Simd> core::ops::BitXorAssign for i16x8<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: Self) {
        *self = self.simd.xor_i16x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitXor<i16> for i16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: i16) -> Self::Output {
        self.simd.xor_i16x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitXorAssign<i16> for i16x8<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: i16) {
        *self = self.simd.xor_i16x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitXor<i16x8<S>> for i16 {
    type Output = i16x8<S>;
    #[inline(always)]
    fn bitxor(self, rhs: i16x8<S>) -> Self::Output {
        rhs.simd.xor_i16x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Shl<u32> for i16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn shl(self, rhs: u32) -> Self::Output {
        self.simd.shl_i16x8(self, rhs)
    }
}
impl<S: Simd> core::ops::Shr<u32> for i16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: u32) -> Self::Output {
        self.simd.shr_i16x8(self, rhs)
    }
}
impl<S: Simd> core::ops::ShlAssign<u32> for i16x8<S> {
    #[inline(always)]
    fn shl_assign(&mut self, rhs: u32) {
        *self = self.simd.shl_i16x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::ShrAssign<u32> for i16x8<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: u32) {
        *self = self.simd.shr_i16x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::Shr for i16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: Self) -> Self::Output {
        self.simd.shrv_i16x8(self, rhs)
    }
}
impl<S: Simd> core::ops::ShrAssign for i16x8<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: Self) {
        *self = self.simd.shrv_i16x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add for u16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: Self) -> Self::Output {
        self.simd.add_u16x8(self, rhs)
    }
}
impl<S: Simd> core::ops::AddAssign for u16x8<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: Self) {
        *self = self.simd.add_u16x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add<u16> for u16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: u16) -> Self::Output {
        self.simd.add_u16x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::AddAssign<u16> for u16x8<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: u16) {
        *self = self.simd.add_u16x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Add<u16x8<S>> for u16 {
    type Output = u16x8<S>;
    #[inline(always)]
    fn add(self, rhs: u16x8<S>) -> Self::Output {
        rhs.simd.add_u16x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Sub for u16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: Self) -> Self::Output {
        self.simd.sub_u16x8(self, rhs)
    }
}
impl<S: Simd> core::ops::SubAssign for u16x8<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: Self) {
        *self = self.simd.sub_u16x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::Sub<u16> for u16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: u16) -> Self::Output {
        self.simd.sub_u16x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::SubAssign<u16> for u16x8<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: u16) {
        *self = self.simd.sub_u16x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Sub<u16x8<S>> for u16 {
    type Output = u16x8<S>;
    #[inline(always)]
    fn sub(self, rhs: u16x8<S>) -> Self::Output {
        rhs.simd.sub_u16x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Mul for u16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: Self) -> Self::Output {
        self.simd.mul_u16x8(self, rhs)
    }
}
impl<S: Simd> core::ops::MulAssign for u16x8<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: Self) {
        *self = self.simd.mul_u16x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::Mul<u16> for u16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: u16) -> Self::Output {
        self.simd.mul_u16x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::MulAssign<u16> for u16x8<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: u16) {
        *self = self.simd.mul_u16x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Mul<u16x8<S>> for u16 {
    type Output = u16x8<S>;
    #[inline(always)]
    fn mul(self, rhs: u16x8<S>) -> Self::Output {
        rhs.simd.mul_u16x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitAnd for u16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: Self) -> Self::Output {
        self.simd.and_u16x8(self, rhs)
    }
}
impl<S: Simd> core::ops::BitAndAssign for u16x8<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: Self) {
        *self = self.simd.and_u16x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd<u16> for u16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: u16) -> Self::Output {
        self.simd.and_u16x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitAndAssign<u16> for u16x8<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: u16) {
        *self = self.simd.and_u16x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitAnd<u16x8<S>> for u16 {
    type Output = u16x8<S>;
    #[inline(always)]
    fn bitand(self, rhs: u16x8<S>) -> Self::Output {
        rhs.simd.and_u16x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitOr for u16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: Self) -> Self::Output {
        self.simd.or_u16x8(self, rhs)
    }
}
impl<S: Simd> core::ops::BitOrAssign for u16x8<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: Self) {
        *self = self.simd.or_u16x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitOr<u16> for u16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: u16) -> Self::Output {
        self.simd.or_u16x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitOrAssign<u16> for u16x8<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: u16) {
        *self = self.simd.or_u16x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitOr<u16x8<S>> for u16 {
    type Output = u16x8<S>;
    #[inline(always)]
    fn bitor(self, rhs: u16x8<S>) -> Self::Output {
        rhs.simd.or_u16x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitXor for u16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: Self) -> Self::Output {
        self.simd.xor_u16x8(self, rhs)
    }
}
impl<S: Simd> core::ops::BitXorAssign for u16x8<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: Self) {
        *self = self.simd.xor_u16x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitXor<u16> for u16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: u16) -> Self::Output {
        self.simd.xor_u16x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitXorAssign<u16> for u16x8<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: u16) {
        *self = self.simd.xor_u16x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitXor<u16x8<S>> for u16 {
    type Output = u16x8<S>;
    #[inline(always)]
    fn bitxor(self, rhs: u16x8<S>) -> Self::Output {
        rhs.simd.xor_u16x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Shl<u32> for u16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn shl(self, rhs: u32) -> Self::Output {
        self.simd.shl_u16x8(self, rhs)
    }
}
impl<S: Simd> core::ops::Shr<u32> for u16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: u32) -> Self::Output {
        self.simd.shr_u16x8(self, rhs)
    }
}
impl<S: Simd> core::ops::ShlAssign<u32> for u16x8<S> {
    #[inline(always)]
    fn shl_assign(&mut self, rhs: u32) {
        *self = self.simd.shl_u16x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::ShrAssign<u32> for u16x8<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: u32) {
        *self = self.simd.shr_u16x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::Shr for u16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: Self) -> Self::Output {
        self.simd.shrv_u16x8(self, rhs)
    }
}
impl<S: Simd> core::ops::ShrAssign for u16x8<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: Self) {
        *self = self.simd.shrv_u16x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd for mask16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: Self) -> Self::Output {
        self.simd.and_mask16x8(self, rhs)
    }
}
impl<S: Simd> core::ops::BitAndAssign for mask16x8<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: Self) {
        *self = self.simd.and_mask16x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd<i16> for mask16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: i16) -> Self::Output {
        self.simd.and_mask16x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitAndAssign<i16> for mask16x8<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: i16) {
        *self = self.simd.and_mask16x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitAnd<mask16x8<S>> for i16 {
    type Output = mask16x8<S>;
    #[inline(always)]
    fn bitand(self, rhs: mask16x8<S>) -> Self::Output {
        rhs.simd.and_mask16x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitOr for mask16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: Self) -> Self::Output {
        self.simd.or_mask16x8(self, rhs)
    }
}
impl<S: Simd> core::ops::BitOrAssign for mask16x8<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: Self) {
        *self = self.simd.or_mask16x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitOr<i16> for mask16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: i16) -> Self::Output {
        self.simd.or_mask16x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitOrAssign<i16> for mask16x8<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: i16) {
        *self = self.simd.or_mask16x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitOr<mask16x8<S>> for i16 {
    type Output = mask16x8<S>;
    #[inline(always)]
    fn bitor(self, rhs: mask16x8<S>) -> Self::Output {
        rhs.simd.or_mask16x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitXor for mask16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: Self) -> Self::Output {
        self.simd.xor_mask16x8(self, rhs)
    }
}
impl<S: Simd> core::ops::BitXorAssign for mask16x8<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: Self) {
        *self = self.simd.xor_mask16x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitXor<i16> for mask16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: i16) -> Self::Output {
        self.simd.xor_mask16x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitXorAssign<i16> for mask16x8<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: i16) {
        *self = self.simd.xor_mask16x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitXor<mask16x8<S>> for i16 {
    type Output = mask16x8<S>;
    #[inline(always)]
    fn bitxor(self, rhs: mask16x8<S>) -> Self::Output {
        rhs.simd.xor_mask16x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Not for mask16x8<S> {
    type Output = Self;
    #[inline(always)]
    fn not(self) -> Self::Output {
        self.simd.not_mask16x8(self)
    }
}
impl<S: Simd> core::ops::Neg for i32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn neg(self) -> Self::Output {
        self.simd.neg_i32x4(self)
    }
}
impl<S: Simd> core::ops::Add for i32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: Self) -> Self::Output {
        self.simd.add_i32x4(self, rhs)
    }
}
impl<S: Simd> core::ops::AddAssign for i32x4<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: Self) {
        *self = self.simd.add_i32x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add<i32> for i32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: i32) -> Self::Output {
        self.simd.add_i32x4(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::AddAssign<i32> for i32x4<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: i32) {
        *self = self.simd.add_i32x4(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Add<i32x4<S>> for i32 {
    type Output = i32x4<S>;
    #[inline(always)]
    fn add(self, rhs: i32x4<S>) -> Self::Output {
        rhs.simd.add_i32x4(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Sub for i32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: Self) -> Self::Output {
        self.simd.sub_i32x4(self, rhs)
    }
}
impl<S: Simd> core::ops::SubAssign for i32x4<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: Self) {
        *self = self.simd.sub_i32x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::Sub<i32> for i32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: i32) -> Self::Output {
        self.simd.sub_i32x4(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::SubAssign<i32> for i32x4<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: i32) {
        *self = self.simd.sub_i32x4(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Sub<i32x4<S>> for i32 {
    type Output = i32x4<S>;
    #[inline(always)]
    fn sub(self, rhs: i32x4<S>) -> Self::Output {
        rhs.simd.sub_i32x4(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Mul for i32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: Self) -> Self::Output {
        self.simd.mul_i32x4(self, rhs)
    }
}
impl<S: Simd> core::ops::MulAssign for i32x4<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: Self) {
        *self = self.simd.mul_i32x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::Mul<i32> for i32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: i32) -> Self::Output {
        self.simd.mul_i32x4(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::MulAssign<i32> for i32x4<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: i32) {
        *self = self.simd.mul_i32x4(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Mul<i32x4<S>> for i32 {
    type Output = i32x4<S>;
    #[inline(always)]
    fn mul(self, rhs: i32x4<S>) -> Self::Output {
        rhs.simd.mul_i32x4(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitAnd for i32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: Self) -> Self::Output {
        self.simd.and_i32x4(self, rhs)
    }
}
impl<S: Simd> core::ops::BitAndAssign for i32x4<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: Self) {
        *self = self.simd.and_i32x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd<i32> for i32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: i32) -> Self::Output {
        self.simd.and_i32x4(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitAndAssign<i32> for i32x4<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: i32) {
        *self = self.simd.and_i32x4(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitAnd<i32x4<S>> for i32 {
    type Output = i32x4<S>;
    #[inline(always)]
    fn bitand(self, rhs: i32x4<S>) -> Self::Output {
        rhs.simd.and_i32x4(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitOr for i32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: Self) -> Self::Output {
        self.simd.or_i32x4(self, rhs)
    }
}
impl<S: Simd> core::ops::BitOrAssign for i32x4<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: Self) {
        *self = self.simd.or_i32x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitOr<i32> for i32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: i32) -> Self::Output {
        self.simd.or_i32x4(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitOrAssign<i32> for i32x4<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: i32) {
        *self = self.simd.or_i32x4(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitOr<i32x4<S>> for i32 {
    type Output = i32x4<S>;
    #[inline(always)]
    fn bitor(self, rhs: i32x4<S>) -> Self::Output {
        rhs.simd.or_i32x4(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitXor for i32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: Self) -> Self::Output {
        self.simd.xor_i32x4(self, rhs)
    }
}
impl<S: Simd> core::ops::BitXorAssign for i32x4<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: Self) {
        *self = self.simd.xor_i32x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitXor<i32> for i32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: i32) -> Self::Output {
        self.simd.xor_i32x4(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitXorAssign<i32> for i32x4<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: i32) {
        *self = self.simd.xor_i32x4(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitXor<i32x4<S>> for i32 {
    type Output = i32x4<S>;
    #[inline(always)]
    fn bitxor(self, rhs: i32x4<S>) -> Self::Output {
        rhs.simd.xor_i32x4(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Shl<u32> for i32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn shl(self, rhs: u32) -> Self::Output {
        self.simd.shl_i32x4(self, rhs)
    }
}
impl<S: Simd> core::ops::Shr<u32> for i32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: u32) -> Self::Output {
        self.simd.shr_i32x4(self, rhs)
    }
}
impl<S: Simd> core::ops::ShlAssign<u32> for i32x4<S> {
    #[inline(always)]
    fn shl_assign(&mut self, rhs: u32) {
        *self = self.simd.shl_i32x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::ShrAssign<u32> for i32x4<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: u32) {
        *self = self.simd.shr_i32x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::Shr for i32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: Self) -> Self::Output {
        self.simd.shrv_i32x4(self, rhs)
    }
}
impl<S: Simd> core::ops::ShrAssign for i32x4<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: Self) {
        *self = self.simd.shrv_i32x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add for u32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: Self) -> Self::Output {
        self.simd.add_u32x4(self, rhs)
    }
}
impl<S: Simd> core::ops::AddAssign for u32x4<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: Self) {
        *self = self.simd.add_u32x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add<u32> for u32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: u32) -> Self::Output {
        self.simd.add_u32x4(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::AddAssign<u32> for u32x4<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: u32) {
        *self = self.simd.add_u32x4(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Add<u32x4<S>> for u32 {
    type Output = u32x4<S>;
    #[inline(always)]
    fn add(self, rhs: u32x4<S>) -> Self::Output {
        rhs.simd.add_u32x4(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Sub for u32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: Self) -> Self::Output {
        self.simd.sub_u32x4(self, rhs)
    }
}
impl<S: Simd> core::ops::SubAssign for u32x4<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: Self) {
        *self = self.simd.sub_u32x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::Sub<u32> for u32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: u32) -> Self::Output {
        self.simd.sub_u32x4(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::SubAssign<u32> for u32x4<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: u32) {
        *self = self.simd.sub_u32x4(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Sub<u32x4<S>> for u32 {
    type Output = u32x4<S>;
    #[inline(always)]
    fn sub(self, rhs: u32x4<S>) -> Self::Output {
        rhs.simd.sub_u32x4(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Mul for u32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: Self) -> Self::Output {
        self.simd.mul_u32x4(self, rhs)
    }
}
impl<S: Simd> core::ops::MulAssign for u32x4<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: Self) {
        *self = self.simd.mul_u32x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::Mul<u32> for u32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: u32) -> Self::Output {
        self.simd.mul_u32x4(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::MulAssign<u32> for u32x4<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: u32) {
        *self = self.simd.mul_u32x4(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Mul<u32x4<S>> for u32 {
    type Output = u32x4<S>;
    #[inline(always)]
    fn mul(self, rhs: u32x4<S>) -> Self::Output {
        rhs.simd.mul_u32x4(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitAnd for u32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: Self) -> Self::Output {
        self.simd.and_u32x4(self, rhs)
    }
}
impl<S: Simd> core::ops::BitAndAssign for u32x4<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: Self) {
        *self = self.simd.and_u32x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd<u32> for u32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: u32) -> Self::Output {
        self.simd.and_u32x4(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitAndAssign<u32> for u32x4<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: u32) {
        *self = self.simd.and_u32x4(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitAnd<u32x4<S>> for u32 {
    type Output = u32x4<S>;
    #[inline(always)]
    fn bitand(self, rhs: u32x4<S>) -> Self::Output {
        rhs.simd.and_u32x4(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitOr for u32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: Self) -> Self::Output {
        self.simd.or_u32x4(self, rhs)
    }
}
impl<S: Simd> core::ops::BitOrAssign for u32x4<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: Self) {
        *self = self.simd.or_u32x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitOr<u32> for u32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: u32) -> Self::Output {
        self.simd.or_u32x4(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitOrAssign<u32> for u32x4<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: u32) {
        *self = self.simd.or_u32x4(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitOr<u32x4<S>> for u32 {
    type Output = u32x4<S>;
    #[inline(always)]
    fn bitor(self, rhs: u32x4<S>) -> Self::Output {
        rhs.simd.or_u32x4(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitXor for u32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: Self) -> Self::Output {
        self.simd.xor_u32x4(self, rhs)
    }
}
impl<S: Simd> core::ops::BitXorAssign for u32x4<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: Self) {
        *self = self.simd.xor_u32x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitXor<u32> for u32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: u32) -> Self::Output {
        self.simd.xor_u32x4(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitXorAssign<u32> for u32x4<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: u32) {
        *self = self.simd.xor_u32x4(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitXor<u32x4<S>> for u32 {
    type Output = u32x4<S>;
    #[inline(always)]
    fn bitxor(self, rhs: u32x4<S>) -> Self::Output {
        rhs.simd.xor_u32x4(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Shl<u32> for u32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn shl(self, rhs: u32) -> Self::Output {
        self.simd.shl_u32x4(self, rhs)
    }
}
impl<S: Simd> core::ops::Shr<u32> for u32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: u32) -> Self::Output {
        self.simd.shr_u32x4(self, rhs)
    }
}
impl<S: Simd> core::ops::ShlAssign<u32> for u32x4<S> {
    #[inline(always)]
    fn shl_assign(&mut self, rhs: u32) {
        *self = self.simd.shl_u32x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::ShrAssign<u32> for u32x4<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: u32) {
        *self = self.simd.shr_u32x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::Shr for u32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: Self) -> Self::Output {
        self.simd.shrv_u32x4(self, rhs)
    }
}
impl<S: Simd> core::ops::ShrAssign for u32x4<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: Self) {
        *self = self.simd.shrv_u32x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd for mask32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: Self) -> Self::Output {
        self.simd.and_mask32x4(self, rhs)
    }
}
impl<S: Simd> core::ops::BitAndAssign for mask32x4<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: Self) {
        *self = self.simd.and_mask32x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd<i32> for mask32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: i32) -> Self::Output {
        self.simd.and_mask32x4(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitAndAssign<i32> for mask32x4<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: i32) {
        *self = self.simd.and_mask32x4(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitAnd<mask32x4<S>> for i32 {
    type Output = mask32x4<S>;
    #[inline(always)]
    fn bitand(self, rhs: mask32x4<S>) -> Self::Output {
        rhs.simd.and_mask32x4(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitOr for mask32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: Self) -> Self::Output {
        self.simd.or_mask32x4(self, rhs)
    }
}
impl<S: Simd> core::ops::BitOrAssign for mask32x4<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: Self) {
        *self = self.simd.or_mask32x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitOr<i32> for mask32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: i32) -> Self::Output {
        self.simd.or_mask32x4(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitOrAssign<i32> for mask32x4<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: i32) {
        *self = self.simd.or_mask32x4(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitOr<mask32x4<S>> for i32 {
    type Output = mask32x4<S>;
    #[inline(always)]
    fn bitor(self, rhs: mask32x4<S>) -> Self::Output {
        rhs.simd.or_mask32x4(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitXor for mask32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: Self) -> Self::Output {
        self.simd.xor_mask32x4(self, rhs)
    }
}
impl<S: Simd> core::ops::BitXorAssign for mask32x4<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: Self) {
        *self = self.simd.xor_mask32x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitXor<i32> for mask32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: i32) -> Self::Output {
        self.simd.xor_mask32x4(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitXorAssign<i32> for mask32x4<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: i32) {
        *self = self.simd.xor_mask32x4(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitXor<mask32x4<S>> for i32 {
    type Output = mask32x4<S>;
    #[inline(always)]
    fn bitxor(self, rhs: mask32x4<S>) -> Self::Output {
        rhs.simd.xor_mask32x4(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Not for mask32x4<S> {
    type Output = Self;
    #[inline(always)]
    fn not(self) -> Self::Output {
        self.simd.not_mask32x4(self)
    }
}
impl<S: Simd> core::ops::Neg for f64x2<S> {
    type Output = Self;
    #[inline(always)]
    fn neg(self) -> Self::Output {
        self.simd.neg_f64x2(self)
    }
}
impl<S: Simd> core::ops::Add for f64x2<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: Self) -> Self::Output {
        self.simd.add_f64x2(self, rhs)
    }
}
impl<S: Simd> core::ops::AddAssign for f64x2<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: Self) {
        *self = self.simd.add_f64x2(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add<f64> for f64x2<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: f64) -> Self::Output {
        self.simd.add_f64x2(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::AddAssign<f64> for f64x2<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: f64) {
        *self = self.simd.add_f64x2(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Add<f64x2<S>> for f64 {
    type Output = f64x2<S>;
    #[inline(always)]
    fn add(self, rhs: f64x2<S>) -> Self::Output {
        rhs.simd.add_f64x2(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Sub for f64x2<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: Self) -> Self::Output {
        self.simd.sub_f64x2(self, rhs)
    }
}
impl<S: Simd> core::ops::SubAssign for f64x2<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: Self) {
        *self = self.simd.sub_f64x2(*self, rhs);
    }
}
impl<S: Simd> core::ops::Sub<f64> for f64x2<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: f64) -> Self::Output {
        self.simd.sub_f64x2(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::SubAssign<f64> for f64x2<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: f64) {
        *self = self.simd.sub_f64x2(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Sub<f64x2<S>> for f64 {
    type Output = f64x2<S>;
    #[inline(always)]
    fn sub(self, rhs: f64x2<S>) -> Self::Output {
        rhs.simd.sub_f64x2(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Mul for f64x2<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: Self) -> Self::Output {
        self.simd.mul_f64x2(self, rhs)
    }
}
impl<S: Simd> core::ops::MulAssign for f64x2<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: Self) {
        *self = self.simd.mul_f64x2(*self, rhs);
    }
}
impl<S: Simd> core::ops::Mul<f64> for f64x2<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: f64) -> Self::Output {
        self.simd.mul_f64x2(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::MulAssign<f64> for f64x2<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: f64) {
        *self = self.simd.mul_f64x2(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Mul<f64x2<S>> for f64 {
    type Output = f64x2<S>;
    #[inline(always)]
    fn mul(self, rhs: f64x2<S>) -> Self::Output {
        rhs.simd.mul_f64x2(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Div for f64x2<S> {
    type Output = Self;
    #[inline(always)]
    fn div(self, rhs: Self) -> Self::Output {
        self.simd.div_f64x2(self, rhs)
    }
}
impl<S: Simd> core::ops::DivAssign for f64x2<S> {
    #[inline(always)]
    fn div_assign(&mut self, rhs: Self) {
        *self = self.simd.div_f64x2(*self, rhs);
    }
}
impl<S: Simd> core::ops::Div<f64> for f64x2<S> {
    type Output = Self;
    #[inline(always)]
    fn div(self, rhs: f64) -> Self::Output {
        self.simd.div_f64x2(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::DivAssign<f64> for f64x2<S> {
    #[inline(always)]
    fn div_assign(&mut self, rhs: f64) {
        *self = self.simd.div_f64x2(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Div<f64x2<S>> for f64 {
    type Output = f64x2<S>;
    #[inline(always)]
    fn div(self, rhs: f64x2<S>) -> Self::Output {
        rhs.simd.div_f64x2(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitAnd for mask64x2<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: Self) -> Self::Output {
        self.simd.and_mask64x2(self, rhs)
    }
}
impl<S: Simd> core::ops::BitAndAssign for mask64x2<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: Self) {
        *self = self.simd.and_mask64x2(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd<i64> for mask64x2<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: i64) -> Self::Output {
        self.simd.and_mask64x2(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitAndAssign<i64> for mask64x2<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: i64) {
        *self = self.simd.and_mask64x2(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitAnd<mask64x2<S>> for i64 {
    type Output = mask64x2<S>;
    #[inline(always)]
    fn bitand(self, rhs: mask64x2<S>) -> Self::Output {
        rhs.simd.and_mask64x2(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitOr for mask64x2<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: Self) -> Self::Output {
        self.simd.or_mask64x2(self, rhs)
    }
}
impl<S: Simd> core::ops::BitOrAssign for mask64x2<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: Self) {
        *self = self.simd.or_mask64x2(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitOr<i64> for mask64x2<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: i64) -> Self::Output {
        self.simd.or_mask64x2(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitOrAssign<i64> for mask64x2<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: i64) {
        *self = self.simd.or_mask64x2(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitOr<mask64x2<S>> for i64 {
    type Output = mask64x2<S>;
    #[inline(always)]
    fn bitor(self, rhs: mask64x2<S>) -> Self::Output {
        rhs.simd.or_mask64x2(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitXor for mask64x2<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: Self) -> Self::Output {
        self.simd.xor_mask64x2(self, rhs)
    }
}
impl<S: Simd> core::ops::BitXorAssign for mask64x2<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: Self) {
        *self = self.simd.xor_mask64x2(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitXor<i64> for mask64x2<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: i64) -> Self::Output {
        self.simd.xor_mask64x2(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitXorAssign<i64> for mask64x2<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: i64) {
        *self = self.simd.xor_mask64x2(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitXor<mask64x2<S>> for i64 {
    type Output = mask64x2<S>;
    #[inline(always)]
    fn bitxor(self, rhs: mask64x2<S>) -> Self::Output {
        rhs.simd.xor_mask64x2(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Not for mask64x2<S> {
    type Output = Self;
    #[inline(always)]
    fn not(self) -> Self::Output {
        self.simd.not_mask64x2(self)
    }
}
impl<S: Simd> core::ops::Neg for f32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn neg(self) -> Self::Output {
        self.simd.neg_f32x8(self)
    }
}
impl<S: Simd> core::ops::Add for f32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: Self) -> Self::Output {
        self.simd.add_f32x8(self, rhs)
    }
}
impl<S: Simd> core::ops::AddAssign for f32x8<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: Self) {
        *self = self.simd.add_f32x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add<f32> for f32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: f32) -> Self::Output {
        self.simd.add_f32x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::AddAssign<f32> for f32x8<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: f32) {
        *self = self.simd.add_f32x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Add<f32x8<S>> for f32 {
    type Output = f32x8<S>;
    #[inline(always)]
    fn add(self, rhs: f32x8<S>) -> Self::Output {
        rhs.simd.add_f32x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Sub for f32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: Self) -> Self::Output {
        self.simd.sub_f32x8(self, rhs)
    }
}
impl<S: Simd> core::ops::SubAssign for f32x8<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: Self) {
        *self = self.simd.sub_f32x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::Sub<f32> for f32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: f32) -> Self::Output {
        self.simd.sub_f32x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::SubAssign<f32> for f32x8<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: f32) {
        *self = self.simd.sub_f32x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Sub<f32x8<S>> for f32 {
    type Output = f32x8<S>;
    #[inline(always)]
    fn sub(self, rhs: f32x8<S>) -> Self::Output {
        rhs.simd.sub_f32x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Mul for f32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: Self) -> Self::Output {
        self.simd.mul_f32x8(self, rhs)
    }
}
impl<S: Simd> core::ops::MulAssign for f32x8<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: Self) {
        *self = self.simd.mul_f32x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::Mul<f32> for f32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: f32) -> Self::Output {
        self.simd.mul_f32x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::MulAssign<f32> for f32x8<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: f32) {
        *self = self.simd.mul_f32x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Mul<f32x8<S>> for f32 {
    type Output = f32x8<S>;
    #[inline(always)]
    fn mul(self, rhs: f32x8<S>) -> Self::Output {
        rhs.simd.mul_f32x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Div for f32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn div(self, rhs: Self) -> Self::Output {
        self.simd.div_f32x8(self, rhs)
    }
}
impl<S: Simd> core::ops::DivAssign for f32x8<S> {
    #[inline(always)]
    fn div_assign(&mut self, rhs: Self) {
        *self = self.simd.div_f32x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::Div<f32> for f32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn div(self, rhs: f32) -> Self::Output {
        self.simd.div_f32x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::DivAssign<f32> for f32x8<S> {
    #[inline(always)]
    fn div_assign(&mut self, rhs: f32) {
        *self = self.simd.div_f32x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Div<f32x8<S>> for f32 {
    type Output = f32x8<S>;
    #[inline(always)]
    fn div(self, rhs: f32x8<S>) -> Self::Output {
        rhs.simd.div_f32x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Neg for i8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn neg(self) -> Self::Output {
        self.simd.neg_i8x32(self)
    }
}
impl<S: Simd> core::ops::Add for i8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: Self) -> Self::Output {
        self.simd.add_i8x32(self, rhs)
    }
}
impl<S: Simd> core::ops::AddAssign for i8x32<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: Self) {
        *self = self.simd.add_i8x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add<i8> for i8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: i8) -> Self::Output {
        self.simd.add_i8x32(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::AddAssign<i8> for i8x32<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: i8) {
        *self = self.simd.add_i8x32(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Add<i8x32<S>> for i8 {
    type Output = i8x32<S>;
    #[inline(always)]
    fn add(self, rhs: i8x32<S>) -> Self::Output {
        rhs.simd.add_i8x32(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Sub for i8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: Self) -> Self::Output {
        self.simd.sub_i8x32(self, rhs)
    }
}
impl<S: Simd> core::ops::SubAssign for i8x32<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: Self) {
        *self = self.simd.sub_i8x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::Sub<i8> for i8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: i8) -> Self::Output {
        self.simd.sub_i8x32(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::SubAssign<i8> for i8x32<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: i8) {
        *self = self.simd.sub_i8x32(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Sub<i8x32<S>> for i8 {
    type Output = i8x32<S>;
    #[inline(always)]
    fn sub(self, rhs: i8x32<S>) -> Self::Output {
        rhs.simd.sub_i8x32(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Mul for i8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: Self) -> Self::Output {
        self.simd.mul_i8x32(self, rhs)
    }
}
impl<S: Simd> core::ops::MulAssign for i8x32<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: Self) {
        *self = self.simd.mul_i8x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::Mul<i8> for i8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: i8) -> Self::Output {
        self.simd.mul_i8x32(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::MulAssign<i8> for i8x32<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: i8) {
        *self = self.simd.mul_i8x32(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Mul<i8x32<S>> for i8 {
    type Output = i8x32<S>;
    #[inline(always)]
    fn mul(self, rhs: i8x32<S>) -> Self::Output {
        rhs.simd.mul_i8x32(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitAnd for i8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: Self) -> Self::Output {
        self.simd.and_i8x32(self, rhs)
    }
}
impl<S: Simd> core::ops::BitAndAssign for i8x32<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: Self) {
        *self = self.simd.and_i8x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd<i8> for i8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: i8) -> Self::Output {
        self.simd.and_i8x32(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitAndAssign<i8> for i8x32<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: i8) {
        *self = self.simd.and_i8x32(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitAnd<i8x32<S>> for i8 {
    type Output = i8x32<S>;
    #[inline(always)]
    fn bitand(self, rhs: i8x32<S>) -> Self::Output {
        rhs.simd.and_i8x32(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitOr for i8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: Self) -> Self::Output {
        self.simd.or_i8x32(self, rhs)
    }
}
impl<S: Simd> core::ops::BitOrAssign for i8x32<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: Self) {
        *self = self.simd.or_i8x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitOr<i8> for i8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: i8) -> Self::Output {
        self.simd.or_i8x32(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitOrAssign<i8> for i8x32<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: i8) {
        *self = self.simd.or_i8x32(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitOr<i8x32<S>> for i8 {
    type Output = i8x32<S>;
    #[inline(always)]
    fn bitor(self, rhs: i8x32<S>) -> Self::Output {
        rhs.simd.or_i8x32(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitXor for i8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: Self) -> Self::Output {
        self.simd.xor_i8x32(self, rhs)
    }
}
impl<S: Simd> core::ops::BitXorAssign for i8x32<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: Self) {
        *self = self.simd.xor_i8x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitXor<i8> for i8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: i8) -> Self::Output {
        self.simd.xor_i8x32(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitXorAssign<i8> for i8x32<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: i8) {
        *self = self.simd.xor_i8x32(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitXor<i8x32<S>> for i8 {
    type Output = i8x32<S>;
    #[inline(always)]
    fn bitxor(self, rhs: i8x32<S>) -> Self::Output {
        rhs.simd.xor_i8x32(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Shl<u32> for i8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn shl(self, rhs: u32) -> Self::Output {
        self.simd.shl_i8x32(self, rhs)
    }
}
impl<S: Simd> core::ops::Shr<u32> for i8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: u32) -> Self::Output {
        self.simd.shr_i8x32(self, rhs)
    }
}
impl<S: Simd> core::ops::ShlAssign<u32> for i8x32<S> {
    #[inline(always)]
    fn shl_assign(&mut self, rhs: u32) {
        *self = self.simd.shl_i8x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::ShrAssign<u32> for i8x32<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: u32) {
        *self = self.simd.shr_i8x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::Shr for i8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: Self) -> Self::Output {
        self.simd.shrv_i8x32(self, rhs)
    }
}
impl<S: Simd> core::ops::ShrAssign for i8x32<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: Self) {
        *self = self.simd.shrv_i8x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add for u8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: Self) -> Self::Output {
        self.simd.add_u8x32(self, rhs)
    }
}
impl<S: Simd> core::ops::AddAssign for u8x32<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: Self) {
        *self = self.simd.add_u8x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add<u8> for u8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: u8) -> Self::Output {
        self.simd.add_u8x32(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::AddAssign<u8> for u8x32<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: u8) {
        *self = self.simd.add_u8x32(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Add<u8x32<S>> for u8 {
    type Output = u8x32<S>;
    #[inline(always)]
    fn add(self, rhs: u8x32<S>) -> Self::Output {
        rhs.simd.add_u8x32(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Sub for u8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: Self) -> Self::Output {
        self.simd.sub_u8x32(self, rhs)
    }
}
impl<S: Simd> core::ops::SubAssign for u8x32<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: Self) {
        *self = self.simd.sub_u8x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::Sub<u8> for u8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: u8) -> Self::Output {
        self.simd.sub_u8x32(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::SubAssign<u8> for u8x32<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: u8) {
        *self = self.simd.sub_u8x32(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Sub<u8x32<S>> for u8 {
    type Output = u8x32<S>;
    #[inline(always)]
    fn sub(self, rhs: u8x32<S>) -> Self::Output {
        rhs.simd.sub_u8x32(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Mul for u8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: Self) -> Self::Output {
        self.simd.mul_u8x32(self, rhs)
    }
}
impl<S: Simd> core::ops::MulAssign for u8x32<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: Self) {
        *self = self.simd.mul_u8x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::Mul<u8> for u8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: u8) -> Self::Output {
        self.simd.mul_u8x32(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::MulAssign<u8> for u8x32<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: u8) {
        *self = self.simd.mul_u8x32(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Mul<u8x32<S>> for u8 {
    type Output = u8x32<S>;
    #[inline(always)]
    fn mul(self, rhs: u8x32<S>) -> Self::Output {
        rhs.simd.mul_u8x32(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitAnd for u8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: Self) -> Self::Output {
        self.simd.and_u8x32(self, rhs)
    }
}
impl<S: Simd> core::ops::BitAndAssign for u8x32<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: Self) {
        *self = self.simd.and_u8x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd<u8> for u8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: u8) -> Self::Output {
        self.simd.and_u8x32(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitAndAssign<u8> for u8x32<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: u8) {
        *self = self.simd.and_u8x32(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitAnd<u8x32<S>> for u8 {
    type Output = u8x32<S>;
    #[inline(always)]
    fn bitand(self, rhs: u8x32<S>) -> Self::Output {
        rhs.simd.and_u8x32(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitOr for u8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: Self) -> Self::Output {
        self.simd.or_u8x32(self, rhs)
    }
}
impl<S: Simd> core::ops::BitOrAssign for u8x32<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: Self) {
        *self = self.simd.or_u8x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitOr<u8> for u8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: u8) -> Self::Output {
        self.simd.or_u8x32(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitOrAssign<u8> for u8x32<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: u8) {
        *self = self.simd.or_u8x32(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitOr<u8x32<S>> for u8 {
    type Output = u8x32<S>;
    #[inline(always)]
    fn bitor(self, rhs: u8x32<S>) -> Self::Output {
        rhs.simd.or_u8x32(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitXor for u8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: Self) -> Self::Output {
        self.simd.xor_u8x32(self, rhs)
    }
}
impl<S: Simd> core::ops::BitXorAssign for u8x32<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: Self) {
        *self = self.simd.xor_u8x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitXor<u8> for u8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: u8) -> Self::Output {
        self.simd.xor_u8x32(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitXorAssign<u8> for u8x32<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: u8) {
        *self = self.simd.xor_u8x32(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitXor<u8x32<S>> for u8 {
    type Output = u8x32<S>;
    #[inline(always)]
    fn bitxor(self, rhs: u8x32<S>) -> Self::Output {
        rhs.simd.xor_u8x32(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Shl<u32> for u8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn shl(self, rhs: u32) -> Self::Output {
        self.simd.shl_u8x32(self, rhs)
    }
}
impl<S: Simd> core::ops::Shr<u32> for u8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: u32) -> Self::Output {
        self.simd.shr_u8x32(self, rhs)
    }
}
impl<S: Simd> core::ops::ShlAssign<u32> for u8x32<S> {
    #[inline(always)]
    fn shl_assign(&mut self, rhs: u32) {
        *self = self.simd.shl_u8x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::ShrAssign<u32> for u8x32<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: u32) {
        *self = self.simd.shr_u8x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::Shr for u8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: Self) -> Self::Output {
        self.simd.shrv_u8x32(self, rhs)
    }
}
impl<S: Simd> core::ops::ShrAssign for u8x32<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: Self) {
        *self = self.simd.shrv_u8x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd for mask8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: Self) -> Self::Output {
        self.simd.and_mask8x32(self, rhs)
    }
}
impl<S: Simd> core::ops::BitAndAssign for mask8x32<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: Self) {
        *self = self.simd.and_mask8x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd<i8> for mask8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: i8) -> Self::Output {
        self.simd.and_mask8x32(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitAndAssign<i8> for mask8x32<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: i8) {
        *self = self.simd.and_mask8x32(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitAnd<mask8x32<S>> for i8 {
    type Output = mask8x32<S>;
    #[inline(always)]
    fn bitand(self, rhs: mask8x32<S>) -> Self::Output {
        rhs.simd.and_mask8x32(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitOr for mask8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: Self) -> Self::Output {
        self.simd.or_mask8x32(self, rhs)
    }
}
impl<S: Simd> core::ops::BitOrAssign for mask8x32<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: Self) {
        *self = self.simd.or_mask8x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitOr<i8> for mask8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: i8) -> Self::Output {
        self.simd.or_mask8x32(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitOrAssign<i8> for mask8x32<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: i8) {
        *self = self.simd.or_mask8x32(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitOr<mask8x32<S>> for i8 {
    type Output = mask8x32<S>;
    #[inline(always)]
    fn bitor(self, rhs: mask8x32<S>) -> Self::Output {
        rhs.simd.or_mask8x32(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitXor for mask8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: Self) -> Self::Output {
        self.simd.xor_mask8x32(self, rhs)
    }
}
impl<S: Simd> core::ops::BitXorAssign for mask8x32<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: Self) {
        *self = self.simd.xor_mask8x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitXor<i8> for mask8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: i8) -> Self::Output {
        self.simd.xor_mask8x32(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitXorAssign<i8> for mask8x32<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: i8) {
        *self = self.simd.xor_mask8x32(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitXor<mask8x32<S>> for i8 {
    type Output = mask8x32<S>;
    #[inline(always)]
    fn bitxor(self, rhs: mask8x32<S>) -> Self::Output {
        rhs.simd.xor_mask8x32(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Not for mask8x32<S> {
    type Output = Self;
    #[inline(always)]
    fn not(self) -> Self::Output {
        self.simd.not_mask8x32(self)
    }
}
impl<S: Simd> core::ops::Neg for i16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn neg(self) -> Self::Output {
        self.simd.neg_i16x16(self)
    }
}
impl<S: Simd> core::ops::Add for i16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: Self) -> Self::Output {
        self.simd.add_i16x16(self, rhs)
    }
}
impl<S: Simd> core::ops::AddAssign for i16x16<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: Self) {
        *self = self.simd.add_i16x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add<i16> for i16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: i16) -> Self::Output {
        self.simd.add_i16x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::AddAssign<i16> for i16x16<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: i16) {
        *self = self.simd.add_i16x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Add<i16x16<S>> for i16 {
    type Output = i16x16<S>;
    #[inline(always)]
    fn add(self, rhs: i16x16<S>) -> Self::Output {
        rhs.simd.add_i16x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Sub for i16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: Self) -> Self::Output {
        self.simd.sub_i16x16(self, rhs)
    }
}
impl<S: Simd> core::ops::SubAssign for i16x16<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: Self) {
        *self = self.simd.sub_i16x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Sub<i16> for i16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: i16) -> Self::Output {
        self.simd.sub_i16x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::SubAssign<i16> for i16x16<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: i16) {
        *self = self.simd.sub_i16x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Sub<i16x16<S>> for i16 {
    type Output = i16x16<S>;
    #[inline(always)]
    fn sub(self, rhs: i16x16<S>) -> Self::Output {
        rhs.simd.sub_i16x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Mul for i16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: Self) -> Self::Output {
        self.simd.mul_i16x16(self, rhs)
    }
}
impl<S: Simd> core::ops::MulAssign for i16x16<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: Self) {
        *self = self.simd.mul_i16x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Mul<i16> for i16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: i16) -> Self::Output {
        self.simd.mul_i16x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::MulAssign<i16> for i16x16<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: i16) {
        *self = self.simd.mul_i16x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Mul<i16x16<S>> for i16 {
    type Output = i16x16<S>;
    #[inline(always)]
    fn mul(self, rhs: i16x16<S>) -> Self::Output {
        rhs.simd.mul_i16x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitAnd for i16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: Self) -> Self::Output {
        self.simd.and_i16x16(self, rhs)
    }
}
impl<S: Simd> core::ops::BitAndAssign for i16x16<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: Self) {
        *self = self.simd.and_i16x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd<i16> for i16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: i16) -> Self::Output {
        self.simd.and_i16x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitAndAssign<i16> for i16x16<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: i16) {
        *self = self.simd.and_i16x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitAnd<i16x16<S>> for i16 {
    type Output = i16x16<S>;
    #[inline(always)]
    fn bitand(self, rhs: i16x16<S>) -> Self::Output {
        rhs.simd.and_i16x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitOr for i16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: Self) -> Self::Output {
        self.simd.or_i16x16(self, rhs)
    }
}
impl<S: Simd> core::ops::BitOrAssign for i16x16<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: Self) {
        *self = self.simd.or_i16x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitOr<i16> for i16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: i16) -> Self::Output {
        self.simd.or_i16x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitOrAssign<i16> for i16x16<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: i16) {
        *self = self.simd.or_i16x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitOr<i16x16<S>> for i16 {
    type Output = i16x16<S>;
    #[inline(always)]
    fn bitor(self, rhs: i16x16<S>) -> Self::Output {
        rhs.simd.or_i16x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitXor for i16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: Self) -> Self::Output {
        self.simd.xor_i16x16(self, rhs)
    }
}
impl<S: Simd> core::ops::BitXorAssign for i16x16<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: Self) {
        *self = self.simd.xor_i16x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitXor<i16> for i16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: i16) -> Self::Output {
        self.simd.xor_i16x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitXorAssign<i16> for i16x16<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: i16) {
        *self = self.simd.xor_i16x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitXor<i16x16<S>> for i16 {
    type Output = i16x16<S>;
    #[inline(always)]
    fn bitxor(self, rhs: i16x16<S>) -> Self::Output {
        rhs.simd.xor_i16x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Shl<u32> for i16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn shl(self, rhs: u32) -> Self::Output {
        self.simd.shl_i16x16(self, rhs)
    }
}
impl<S: Simd> core::ops::Shr<u32> for i16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: u32) -> Self::Output {
        self.simd.shr_i16x16(self, rhs)
    }
}
impl<S: Simd> core::ops::ShlAssign<u32> for i16x16<S> {
    #[inline(always)]
    fn shl_assign(&mut self, rhs: u32) {
        *self = self.simd.shl_i16x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::ShrAssign<u32> for i16x16<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: u32) {
        *self = self.simd.shr_i16x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Shr for i16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: Self) -> Self::Output {
        self.simd.shrv_i16x16(self, rhs)
    }
}
impl<S: Simd> core::ops::ShrAssign for i16x16<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: Self) {
        *self = self.simd.shrv_i16x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add for u16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: Self) -> Self::Output {
        self.simd.add_u16x16(self, rhs)
    }
}
impl<S: Simd> core::ops::AddAssign for u16x16<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: Self) {
        *self = self.simd.add_u16x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add<u16> for u16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: u16) -> Self::Output {
        self.simd.add_u16x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::AddAssign<u16> for u16x16<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: u16) {
        *self = self.simd.add_u16x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Add<u16x16<S>> for u16 {
    type Output = u16x16<S>;
    #[inline(always)]
    fn add(self, rhs: u16x16<S>) -> Self::Output {
        rhs.simd.add_u16x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Sub for u16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: Self) -> Self::Output {
        self.simd.sub_u16x16(self, rhs)
    }
}
impl<S: Simd> core::ops::SubAssign for u16x16<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: Self) {
        *self = self.simd.sub_u16x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Sub<u16> for u16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: u16) -> Self::Output {
        self.simd.sub_u16x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::SubAssign<u16> for u16x16<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: u16) {
        *self = self.simd.sub_u16x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Sub<u16x16<S>> for u16 {
    type Output = u16x16<S>;
    #[inline(always)]
    fn sub(self, rhs: u16x16<S>) -> Self::Output {
        rhs.simd.sub_u16x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Mul for u16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: Self) -> Self::Output {
        self.simd.mul_u16x16(self, rhs)
    }
}
impl<S: Simd> core::ops::MulAssign for u16x16<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: Self) {
        *self = self.simd.mul_u16x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Mul<u16> for u16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: u16) -> Self::Output {
        self.simd.mul_u16x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::MulAssign<u16> for u16x16<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: u16) {
        *self = self.simd.mul_u16x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Mul<u16x16<S>> for u16 {
    type Output = u16x16<S>;
    #[inline(always)]
    fn mul(self, rhs: u16x16<S>) -> Self::Output {
        rhs.simd.mul_u16x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitAnd for u16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: Self) -> Self::Output {
        self.simd.and_u16x16(self, rhs)
    }
}
impl<S: Simd> core::ops::BitAndAssign for u16x16<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: Self) {
        *self = self.simd.and_u16x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd<u16> for u16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: u16) -> Self::Output {
        self.simd.and_u16x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitAndAssign<u16> for u16x16<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: u16) {
        *self = self.simd.and_u16x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitAnd<u16x16<S>> for u16 {
    type Output = u16x16<S>;
    #[inline(always)]
    fn bitand(self, rhs: u16x16<S>) -> Self::Output {
        rhs.simd.and_u16x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitOr for u16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: Self) -> Self::Output {
        self.simd.or_u16x16(self, rhs)
    }
}
impl<S: Simd> core::ops::BitOrAssign for u16x16<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: Self) {
        *self = self.simd.or_u16x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitOr<u16> for u16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: u16) -> Self::Output {
        self.simd.or_u16x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitOrAssign<u16> for u16x16<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: u16) {
        *self = self.simd.or_u16x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitOr<u16x16<S>> for u16 {
    type Output = u16x16<S>;
    #[inline(always)]
    fn bitor(self, rhs: u16x16<S>) -> Self::Output {
        rhs.simd.or_u16x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitXor for u16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: Self) -> Self::Output {
        self.simd.xor_u16x16(self, rhs)
    }
}
impl<S: Simd> core::ops::BitXorAssign for u16x16<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: Self) {
        *self = self.simd.xor_u16x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitXor<u16> for u16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: u16) -> Self::Output {
        self.simd.xor_u16x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitXorAssign<u16> for u16x16<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: u16) {
        *self = self.simd.xor_u16x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitXor<u16x16<S>> for u16 {
    type Output = u16x16<S>;
    #[inline(always)]
    fn bitxor(self, rhs: u16x16<S>) -> Self::Output {
        rhs.simd.xor_u16x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Shl<u32> for u16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn shl(self, rhs: u32) -> Self::Output {
        self.simd.shl_u16x16(self, rhs)
    }
}
impl<S: Simd> core::ops::Shr<u32> for u16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: u32) -> Self::Output {
        self.simd.shr_u16x16(self, rhs)
    }
}
impl<S: Simd> core::ops::ShlAssign<u32> for u16x16<S> {
    #[inline(always)]
    fn shl_assign(&mut self, rhs: u32) {
        *self = self.simd.shl_u16x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::ShrAssign<u32> for u16x16<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: u32) {
        *self = self.simd.shr_u16x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Shr for u16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: Self) -> Self::Output {
        self.simd.shrv_u16x16(self, rhs)
    }
}
impl<S: Simd> core::ops::ShrAssign for u16x16<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: Self) {
        *self = self.simd.shrv_u16x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd for mask16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: Self) -> Self::Output {
        self.simd.and_mask16x16(self, rhs)
    }
}
impl<S: Simd> core::ops::BitAndAssign for mask16x16<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: Self) {
        *self = self.simd.and_mask16x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd<i16> for mask16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: i16) -> Self::Output {
        self.simd.and_mask16x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitAndAssign<i16> for mask16x16<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: i16) {
        *self = self.simd.and_mask16x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitAnd<mask16x16<S>> for i16 {
    type Output = mask16x16<S>;
    #[inline(always)]
    fn bitand(self, rhs: mask16x16<S>) -> Self::Output {
        rhs.simd.and_mask16x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitOr for mask16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: Self) -> Self::Output {
        self.simd.or_mask16x16(self, rhs)
    }
}
impl<S: Simd> core::ops::BitOrAssign for mask16x16<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: Self) {
        *self = self.simd.or_mask16x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitOr<i16> for mask16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: i16) -> Self::Output {
        self.simd.or_mask16x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitOrAssign<i16> for mask16x16<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: i16) {
        *self = self.simd.or_mask16x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitOr<mask16x16<S>> for i16 {
    type Output = mask16x16<S>;
    #[inline(always)]
    fn bitor(self, rhs: mask16x16<S>) -> Self::Output {
        rhs.simd.or_mask16x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitXor for mask16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: Self) -> Self::Output {
        self.simd.xor_mask16x16(self, rhs)
    }
}
impl<S: Simd> core::ops::BitXorAssign for mask16x16<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: Self) {
        *self = self.simd.xor_mask16x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitXor<i16> for mask16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: i16) -> Self::Output {
        self.simd.xor_mask16x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitXorAssign<i16> for mask16x16<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: i16) {
        *self = self.simd.xor_mask16x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitXor<mask16x16<S>> for i16 {
    type Output = mask16x16<S>;
    #[inline(always)]
    fn bitxor(self, rhs: mask16x16<S>) -> Self::Output {
        rhs.simd.xor_mask16x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Not for mask16x16<S> {
    type Output = Self;
    #[inline(always)]
    fn not(self) -> Self::Output {
        self.simd.not_mask16x16(self)
    }
}
impl<S: Simd> core::ops::Neg for i32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn neg(self) -> Self::Output {
        self.simd.neg_i32x8(self)
    }
}
impl<S: Simd> core::ops::Add for i32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: Self) -> Self::Output {
        self.simd.add_i32x8(self, rhs)
    }
}
impl<S: Simd> core::ops::AddAssign for i32x8<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: Self) {
        *self = self.simd.add_i32x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add<i32> for i32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: i32) -> Self::Output {
        self.simd.add_i32x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::AddAssign<i32> for i32x8<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: i32) {
        *self = self.simd.add_i32x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Add<i32x8<S>> for i32 {
    type Output = i32x8<S>;
    #[inline(always)]
    fn add(self, rhs: i32x8<S>) -> Self::Output {
        rhs.simd.add_i32x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Sub for i32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: Self) -> Self::Output {
        self.simd.sub_i32x8(self, rhs)
    }
}
impl<S: Simd> core::ops::SubAssign for i32x8<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: Self) {
        *self = self.simd.sub_i32x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::Sub<i32> for i32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: i32) -> Self::Output {
        self.simd.sub_i32x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::SubAssign<i32> for i32x8<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: i32) {
        *self = self.simd.sub_i32x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Sub<i32x8<S>> for i32 {
    type Output = i32x8<S>;
    #[inline(always)]
    fn sub(self, rhs: i32x8<S>) -> Self::Output {
        rhs.simd.sub_i32x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Mul for i32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: Self) -> Self::Output {
        self.simd.mul_i32x8(self, rhs)
    }
}
impl<S: Simd> core::ops::MulAssign for i32x8<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: Self) {
        *self = self.simd.mul_i32x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::Mul<i32> for i32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: i32) -> Self::Output {
        self.simd.mul_i32x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::MulAssign<i32> for i32x8<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: i32) {
        *self = self.simd.mul_i32x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Mul<i32x8<S>> for i32 {
    type Output = i32x8<S>;
    #[inline(always)]
    fn mul(self, rhs: i32x8<S>) -> Self::Output {
        rhs.simd.mul_i32x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitAnd for i32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: Self) -> Self::Output {
        self.simd.and_i32x8(self, rhs)
    }
}
impl<S: Simd> core::ops::BitAndAssign for i32x8<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: Self) {
        *self = self.simd.and_i32x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd<i32> for i32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: i32) -> Self::Output {
        self.simd.and_i32x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitAndAssign<i32> for i32x8<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: i32) {
        *self = self.simd.and_i32x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitAnd<i32x8<S>> for i32 {
    type Output = i32x8<S>;
    #[inline(always)]
    fn bitand(self, rhs: i32x8<S>) -> Self::Output {
        rhs.simd.and_i32x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitOr for i32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: Self) -> Self::Output {
        self.simd.or_i32x8(self, rhs)
    }
}
impl<S: Simd> core::ops::BitOrAssign for i32x8<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: Self) {
        *self = self.simd.or_i32x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitOr<i32> for i32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: i32) -> Self::Output {
        self.simd.or_i32x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitOrAssign<i32> for i32x8<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: i32) {
        *self = self.simd.or_i32x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitOr<i32x8<S>> for i32 {
    type Output = i32x8<S>;
    #[inline(always)]
    fn bitor(self, rhs: i32x8<S>) -> Self::Output {
        rhs.simd.or_i32x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitXor for i32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: Self) -> Self::Output {
        self.simd.xor_i32x8(self, rhs)
    }
}
impl<S: Simd> core::ops::BitXorAssign for i32x8<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: Self) {
        *self = self.simd.xor_i32x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitXor<i32> for i32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: i32) -> Self::Output {
        self.simd.xor_i32x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitXorAssign<i32> for i32x8<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: i32) {
        *self = self.simd.xor_i32x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitXor<i32x8<S>> for i32 {
    type Output = i32x8<S>;
    #[inline(always)]
    fn bitxor(self, rhs: i32x8<S>) -> Self::Output {
        rhs.simd.xor_i32x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Shl<u32> for i32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn shl(self, rhs: u32) -> Self::Output {
        self.simd.shl_i32x8(self, rhs)
    }
}
impl<S: Simd> core::ops::Shr<u32> for i32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: u32) -> Self::Output {
        self.simd.shr_i32x8(self, rhs)
    }
}
impl<S: Simd> core::ops::ShlAssign<u32> for i32x8<S> {
    #[inline(always)]
    fn shl_assign(&mut self, rhs: u32) {
        *self = self.simd.shl_i32x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::ShrAssign<u32> for i32x8<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: u32) {
        *self = self.simd.shr_i32x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::Shr for i32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: Self) -> Self::Output {
        self.simd.shrv_i32x8(self, rhs)
    }
}
impl<S: Simd> core::ops::ShrAssign for i32x8<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: Self) {
        *self = self.simd.shrv_i32x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add for u32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: Self) -> Self::Output {
        self.simd.add_u32x8(self, rhs)
    }
}
impl<S: Simd> core::ops::AddAssign for u32x8<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: Self) {
        *self = self.simd.add_u32x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add<u32> for u32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: u32) -> Self::Output {
        self.simd.add_u32x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::AddAssign<u32> for u32x8<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: u32) {
        *self = self.simd.add_u32x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Add<u32x8<S>> for u32 {
    type Output = u32x8<S>;
    #[inline(always)]
    fn add(self, rhs: u32x8<S>) -> Self::Output {
        rhs.simd.add_u32x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Sub for u32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: Self) -> Self::Output {
        self.simd.sub_u32x8(self, rhs)
    }
}
impl<S: Simd> core::ops::SubAssign for u32x8<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: Self) {
        *self = self.simd.sub_u32x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::Sub<u32> for u32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: u32) -> Self::Output {
        self.simd.sub_u32x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::SubAssign<u32> for u32x8<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: u32) {
        *self = self.simd.sub_u32x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Sub<u32x8<S>> for u32 {
    type Output = u32x8<S>;
    #[inline(always)]
    fn sub(self, rhs: u32x8<S>) -> Self::Output {
        rhs.simd.sub_u32x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Mul for u32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: Self) -> Self::Output {
        self.simd.mul_u32x8(self, rhs)
    }
}
impl<S: Simd> core::ops::MulAssign for u32x8<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: Self) {
        *self = self.simd.mul_u32x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::Mul<u32> for u32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: u32) -> Self::Output {
        self.simd.mul_u32x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::MulAssign<u32> for u32x8<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: u32) {
        *self = self.simd.mul_u32x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Mul<u32x8<S>> for u32 {
    type Output = u32x8<S>;
    #[inline(always)]
    fn mul(self, rhs: u32x8<S>) -> Self::Output {
        rhs.simd.mul_u32x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitAnd for u32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: Self) -> Self::Output {
        self.simd.and_u32x8(self, rhs)
    }
}
impl<S: Simd> core::ops::BitAndAssign for u32x8<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: Self) {
        *self = self.simd.and_u32x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd<u32> for u32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: u32) -> Self::Output {
        self.simd.and_u32x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitAndAssign<u32> for u32x8<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: u32) {
        *self = self.simd.and_u32x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitAnd<u32x8<S>> for u32 {
    type Output = u32x8<S>;
    #[inline(always)]
    fn bitand(self, rhs: u32x8<S>) -> Self::Output {
        rhs.simd.and_u32x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitOr for u32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: Self) -> Self::Output {
        self.simd.or_u32x8(self, rhs)
    }
}
impl<S: Simd> core::ops::BitOrAssign for u32x8<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: Self) {
        *self = self.simd.or_u32x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitOr<u32> for u32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: u32) -> Self::Output {
        self.simd.or_u32x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitOrAssign<u32> for u32x8<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: u32) {
        *self = self.simd.or_u32x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitOr<u32x8<S>> for u32 {
    type Output = u32x8<S>;
    #[inline(always)]
    fn bitor(self, rhs: u32x8<S>) -> Self::Output {
        rhs.simd.or_u32x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitXor for u32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: Self) -> Self::Output {
        self.simd.xor_u32x8(self, rhs)
    }
}
impl<S: Simd> core::ops::BitXorAssign for u32x8<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: Self) {
        *self = self.simd.xor_u32x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitXor<u32> for u32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: u32) -> Self::Output {
        self.simd.xor_u32x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitXorAssign<u32> for u32x8<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: u32) {
        *self = self.simd.xor_u32x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitXor<u32x8<S>> for u32 {
    type Output = u32x8<S>;
    #[inline(always)]
    fn bitxor(self, rhs: u32x8<S>) -> Self::Output {
        rhs.simd.xor_u32x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Shl<u32> for u32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn shl(self, rhs: u32) -> Self::Output {
        self.simd.shl_u32x8(self, rhs)
    }
}
impl<S: Simd> core::ops::Shr<u32> for u32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: u32) -> Self::Output {
        self.simd.shr_u32x8(self, rhs)
    }
}
impl<S: Simd> core::ops::ShlAssign<u32> for u32x8<S> {
    #[inline(always)]
    fn shl_assign(&mut self, rhs: u32) {
        *self = self.simd.shl_u32x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::ShrAssign<u32> for u32x8<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: u32) {
        *self = self.simd.shr_u32x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::Shr for u32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: Self) -> Self::Output {
        self.simd.shrv_u32x8(self, rhs)
    }
}
impl<S: Simd> core::ops::ShrAssign for u32x8<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: Self) {
        *self = self.simd.shrv_u32x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd for mask32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: Self) -> Self::Output {
        self.simd.and_mask32x8(self, rhs)
    }
}
impl<S: Simd> core::ops::BitAndAssign for mask32x8<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: Self) {
        *self = self.simd.and_mask32x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd<i32> for mask32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: i32) -> Self::Output {
        self.simd.and_mask32x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitAndAssign<i32> for mask32x8<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: i32) {
        *self = self.simd.and_mask32x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitAnd<mask32x8<S>> for i32 {
    type Output = mask32x8<S>;
    #[inline(always)]
    fn bitand(self, rhs: mask32x8<S>) -> Self::Output {
        rhs.simd.and_mask32x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitOr for mask32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: Self) -> Self::Output {
        self.simd.or_mask32x8(self, rhs)
    }
}
impl<S: Simd> core::ops::BitOrAssign for mask32x8<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: Self) {
        *self = self.simd.or_mask32x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitOr<i32> for mask32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: i32) -> Self::Output {
        self.simd.or_mask32x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitOrAssign<i32> for mask32x8<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: i32) {
        *self = self.simd.or_mask32x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitOr<mask32x8<S>> for i32 {
    type Output = mask32x8<S>;
    #[inline(always)]
    fn bitor(self, rhs: mask32x8<S>) -> Self::Output {
        rhs.simd.or_mask32x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitXor for mask32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: Self) -> Self::Output {
        self.simd.xor_mask32x8(self, rhs)
    }
}
impl<S: Simd> core::ops::BitXorAssign for mask32x8<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: Self) {
        *self = self.simd.xor_mask32x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitXor<i32> for mask32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: i32) -> Self::Output {
        self.simd.xor_mask32x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitXorAssign<i32> for mask32x8<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: i32) {
        *self = self.simd.xor_mask32x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitXor<mask32x8<S>> for i32 {
    type Output = mask32x8<S>;
    #[inline(always)]
    fn bitxor(self, rhs: mask32x8<S>) -> Self::Output {
        rhs.simd.xor_mask32x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Not for mask32x8<S> {
    type Output = Self;
    #[inline(always)]
    fn not(self) -> Self::Output {
        self.simd.not_mask32x8(self)
    }
}
impl<S: Simd> core::ops::Neg for f64x4<S> {
    type Output = Self;
    #[inline(always)]
    fn neg(self) -> Self::Output {
        self.simd.neg_f64x4(self)
    }
}
impl<S: Simd> core::ops::Add for f64x4<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: Self) -> Self::Output {
        self.simd.add_f64x4(self, rhs)
    }
}
impl<S: Simd> core::ops::AddAssign for f64x4<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: Self) {
        *self = self.simd.add_f64x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add<f64> for f64x4<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: f64) -> Self::Output {
        self.simd.add_f64x4(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::AddAssign<f64> for f64x4<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: f64) {
        *self = self.simd.add_f64x4(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Add<f64x4<S>> for f64 {
    type Output = f64x4<S>;
    #[inline(always)]
    fn add(self, rhs: f64x4<S>) -> Self::Output {
        rhs.simd.add_f64x4(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Sub for f64x4<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: Self) -> Self::Output {
        self.simd.sub_f64x4(self, rhs)
    }
}
impl<S: Simd> core::ops::SubAssign for f64x4<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: Self) {
        *self = self.simd.sub_f64x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::Sub<f64> for f64x4<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: f64) -> Self::Output {
        self.simd.sub_f64x4(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::SubAssign<f64> for f64x4<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: f64) {
        *self = self.simd.sub_f64x4(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Sub<f64x4<S>> for f64 {
    type Output = f64x4<S>;
    #[inline(always)]
    fn sub(self, rhs: f64x4<S>) -> Self::Output {
        rhs.simd.sub_f64x4(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Mul for f64x4<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: Self) -> Self::Output {
        self.simd.mul_f64x4(self, rhs)
    }
}
impl<S: Simd> core::ops::MulAssign for f64x4<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: Self) {
        *self = self.simd.mul_f64x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::Mul<f64> for f64x4<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: f64) -> Self::Output {
        self.simd.mul_f64x4(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::MulAssign<f64> for f64x4<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: f64) {
        *self = self.simd.mul_f64x4(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Mul<f64x4<S>> for f64 {
    type Output = f64x4<S>;
    #[inline(always)]
    fn mul(self, rhs: f64x4<S>) -> Self::Output {
        rhs.simd.mul_f64x4(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Div for f64x4<S> {
    type Output = Self;
    #[inline(always)]
    fn div(self, rhs: Self) -> Self::Output {
        self.simd.div_f64x4(self, rhs)
    }
}
impl<S: Simd> core::ops::DivAssign for f64x4<S> {
    #[inline(always)]
    fn div_assign(&mut self, rhs: Self) {
        *self = self.simd.div_f64x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::Div<f64> for f64x4<S> {
    type Output = Self;
    #[inline(always)]
    fn div(self, rhs: f64) -> Self::Output {
        self.simd.div_f64x4(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::DivAssign<f64> for f64x4<S> {
    #[inline(always)]
    fn div_assign(&mut self, rhs: f64) {
        *self = self.simd.div_f64x4(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Div<f64x4<S>> for f64 {
    type Output = f64x4<S>;
    #[inline(always)]
    fn div(self, rhs: f64x4<S>) -> Self::Output {
        rhs.simd.div_f64x4(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitAnd for mask64x4<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: Self) -> Self::Output {
        self.simd.and_mask64x4(self, rhs)
    }
}
impl<S: Simd> core::ops::BitAndAssign for mask64x4<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: Self) {
        *self = self.simd.and_mask64x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd<i64> for mask64x4<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: i64) -> Self::Output {
        self.simd.and_mask64x4(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitAndAssign<i64> for mask64x4<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: i64) {
        *self = self.simd.and_mask64x4(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitAnd<mask64x4<S>> for i64 {
    type Output = mask64x4<S>;
    #[inline(always)]
    fn bitand(self, rhs: mask64x4<S>) -> Self::Output {
        rhs.simd.and_mask64x4(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitOr for mask64x4<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: Self) -> Self::Output {
        self.simd.or_mask64x4(self, rhs)
    }
}
impl<S: Simd> core::ops::BitOrAssign for mask64x4<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: Self) {
        *self = self.simd.or_mask64x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitOr<i64> for mask64x4<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: i64) -> Self::Output {
        self.simd.or_mask64x4(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitOrAssign<i64> for mask64x4<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: i64) {
        *self = self.simd.or_mask64x4(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitOr<mask64x4<S>> for i64 {
    type Output = mask64x4<S>;
    #[inline(always)]
    fn bitor(self, rhs: mask64x4<S>) -> Self::Output {
        rhs.simd.or_mask64x4(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitXor for mask64x4<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: Self) -> Self::Output {
        self.simd.xor_mask64x4(self, rhs)
    }
}
impl<S: Simd> core::ops::BitXorAssign for mask64x4<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: Self) {
        *self = self.simd.xor_mask64x4(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitXor<i64> for mask64x4<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: i64) -> Self::Output {
        self.simd.xor_mask64x4(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitXorAssign<i64> for mask64x4<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: i64) {
        *self = self.simd.xor_mask64x4(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitXor<mask64x4<S>> for i64 {
    type Output = mask64x4<S>;
    #[inline(always)]
    fn bitxor(self, rhs: mask64x4<S>) -> Self::Output {
        rhs.simd.xor_mask64x4(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Not for mask64x4<S> {
    type Output = Self;
    #[inline(always)]
    fn not(self) -> Self::Output {
        self.simd.not_mask64x4(self)
    }
}
impl<S: Simd> core::ops::Neg for f32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn neg(self) -> Self::Output {
        self.simd.neg_f32x16(self)
    }
}
impl<S: Simd> core::ops::Add for f32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: Self) -> Self::Output {
        self.simd.add_f32x16(self, rhs)
    }
}
impl<S: Simd> core::ops::AddAssign for f32x16<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: Self) {
        *self = self.simd.add_f32x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add<f32> for f32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: f32) -> Self::Output {
        self.simd.add_f32x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::AddAssign<f32> for f32x16<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: f32) {
        *self = self.simd.add_f32x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Add<f32x16<S>> for f32 {
    type Output = f32x16<S>;
    #[inline(always)]
    fn add(self, rhs: f32x16<S>) -> Self::Output {
        rhs.simd.add_f32x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Sub for f32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: Self) -> Self::Output {
        self.simd.sub_f32x16(self, rhs)
    }
}
impl<S: Simd> core::ops::SubAssign for f32x16<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: Self) {
        *self = self.simd.sub_f32x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Sub<f32> for f32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: f32) -> Self::Output {
        self.simd.sub_f32x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::SubAssign<f32> for f32x16<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: f32) {
        *self = self.simd.sub_f32x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Sub<f32x16<S>> for f32 {
    type Output = f32x16<S>;
    #[inline(always)]
    fn sub(self, rhs: f32x16<S>) -> Self::Output {
        rhs.simd.sub_f32x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Mul for f32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: Self) -> Self::Output {
        self.simd.mul_f32x16(self, rhs)
    }
}
impl<S: Simd> core::ops::MulAssign for f32x16<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: Self) {
        *self = self.simd.mul_f32x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Mul<f32> for f32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: f32) -> Self::Output {
        self.simd.mul_f32x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::MulAssign<f32> for f32x16<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: f32) {
        *self = self.simd.mul_f32x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Mul<f32x16<S>> for f32 {
    type Output = f32x16<S>;
    #[inline(always)]
    fn mul(self, rhs: f32x16<S>) -> Self::Output {
        rhs.simd.mul_f32x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Div for f32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn div(self, rhs: Self) -> Self::Output {
        self.simd.div_f32x16(self, rhs)
    }
}
impl<S: Simd> core::ops::DivAssign for f32x16<S> {
    #[inline(always)]
    fn div_assign(&mut self, rhs: Self) {
        *self = self.simd.div_f32x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Div<f32> for f32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn div(self, rhs: f32) -> Self::Output {
        self.simd.div_f32x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::DivAssign<f32> for f32x16<S> {
    #[inline(always)]
    fn div_assign(&mut self, rhs: f32) {
        *self = self.simd.div_f32x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Div<f32x16<S>> for f32 {
    type Output = f32x16<S>;
    #[inline(always)]
    fn div(self, rhs: f32x16<S>) -> Self::Output {
        rhs.simd.div_f32x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Neg for i8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn neg(self) -> Self::Output {
        self.simd.neg_i8x64(self)
    }
}
impl<S: Simd> core::ops::Add for i8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: Self) -> Self::Output {
        self.simd.add_i8x64(self, rhs)
    }
}
impl<S: Simd> core::ops::AddAssign for i8x64<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: Self) {
        *self = self.simd.add_i8x64(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add<i8> for i8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: i8) -> Self::Output {
        self.simd.add_i8x64(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::AddAssign<i8> for i8x64<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: i8) {
        *self = self.simd.add_i8x64(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Add<i8x64<S>> for i8 {
    type Output = i8x64<S>;
    #[inline(always)]
    fn add(self, rhs: i8x64<S>) -> Self::Output {
        rhs.simd.add_i8x64(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Sub for i8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: Self) -> Self::Output {
        self.simd.sub_i8x64(self, rhs)
    }
}
impl<S: Simd> core::ops::SubAssign for i8x64<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: Self) {
        *self = self.simd.sub_i8x64(*self, rhs);
    }
}
impl<S: Simd> core::ops::Sub<i8> for i8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: i8) -> Self::Output {
        self.simd.sub_i8x64(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::SubAssign<i8> for i8x64<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: i8) {
        *self = self.simd.sub_i8x64(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Sub<i8x64<S>> for i8 {
    type Output = i8x64<S>;
    #[inline(always)]
    fn sub(self, rhs: i8x64<S>) -> Self::Output {
        rhs.simd.sub_i8x64(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Mul for i8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: Self) -> Self::Output {
        self.simd.mul_i8x64(self, rhs)
    }
}
impl<S: Simd> core::ops::MulAssign for i8x64<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: Self) {
        *self = self.simd.mul_i8x64(*self, rhs);
    }
}
impl<S: Simd> core::ops::Mul<i8> for i8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: i8) -> Self::Output {
        self.simd.mul_i8x64(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::MulAssign<i8> for i8x64<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: i8) {
        *self = self.simd.mul_i8x64(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Mul<i8x64<S>> for i8 {
    type Output = i8x64<S>;
    #[inline(always)]
    fn mul(self, rhs: i8x64<S>) -> Self::Output {
        rhs.simd.mul_i8x64(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitAnd for i8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: Self) -> Self::Output {
        self.simd.and_i8x64(self, rhs)
    }
}
impl<S: Simd> core::ops::BitAndAssign for i8x64<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: Self) {
        *self = self.simd.and_i8x64(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd<i8> for i8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: i8) -> Self::Output {
        self.simd.and_i8x64(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitAndAssign<i8> for i8x64<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: i8) {
        *self = self.simd.and_i8x64(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitAnd<i8x64<S>> for i8 {
    type Output = i8x64<S>;
    #[inline(always)]
    fn bitand(self, rhs: i8x64<S>) -> Self::Output {
        rhs.simd.and_i8x64(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitOr for i8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: Self) -> Self::Output {
        self.simd.or_i8x64(self, rhs)
    }
}
impl<S: Simd> core::ops::BitOrAssign for i8x64<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: Self) {
        *self = self.simd.or_i8x64(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitOr<i8> for i8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: i8) -> Self::Output {
        self.simd.or_i8x64(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitOrAssign<i8> for i8x64<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: i8) {
        *self = self.simd.or_i8x64(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitOr<i8x64<S>> for i8 {
    type Output = i8x64<S>;
    #[inline(always)]
    fn bitor(self, rhs: i8x64<S>) -> Self::Output {
        rhs.simd.or_i8x64(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitXor for i8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: Self) -> Self::Output {
        self.simd.xor_i8x64(self, rhs)
    }
}
impl<S: Simd> core::ops::BitXorAssign for i8x64<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: Self) {
        *self = self.simd.xor_i8x64(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitXor<i8> for i8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: i8) -> Self::Output {
        self.simd.xor_i8x64(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitXorAssign<i8> for i8x64<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: i8) {
        *self = self.simd.xor_i8x64(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitXor<i8x64<S>> for i8 {
    type Output = i8x64<S>;
    #[inline(always)]
    fn bitxor(self, rhs: i8x64<S>) -> Self::Output {
        rhs.simd.xor_i8x64(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Shl<u32> for i8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn shl(self, rhs: u32) -> Self::Output {
        self.simd.shl_i8x64(self, rhs)
    }
}
impl<S: Simd> core::ops::Shr<u32> for i8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: u32) -> Self::Output {
        self.simd.shr_i8x64(self, rhs)
    }
}
impl<S: Simd> core::ops::ShlAssign<u32> for i8x64<S> {
    #[inline(always)]
    fn shl_assign(&mut self, rhs: u32) {
        *self = self.simd.shl_i8x64(*self, rhs);
    }
}
impl<S: Simd> core::ops::ShrAssign<u32> for i8x64<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: u32) {
        *self = self.simd.shr_i8x64(*self, rhs);
    }
}
impl<S: Simd> core::ops::Shr for i8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: Self) -> Self::Output {
        self.simd.shrv_i8x64(self, rhs)
    }
}
impl<S: Simd> core::ops::ShrAssign for i8x64<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: Self) {
        *self = self.simd.shrv_i8x64(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add for u8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: Self) -> Self::Output {
        self.simd.add_u8x64(self, rhs)
    }
}
impl<S: Simd> core::ops::AddAssign for u8x64<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: Self) {
        *self = self.simd.add_u8x64(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add<u8> for u8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: u8) -> Self::Output {
        self.simd.add_u8x64(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::AddAssign<u8> for u8x64<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: u8) {
        *self = self.simd.add_u8x64(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Add<u8x64<S>> for u8 {
    type Output = u8x64<S>;
    #[inline(always)]
    fn add(self, rhs: u8x64<S>) -> Self::Output {
        rhs.simd.add_u8x64(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Sub for u8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: Self) -> Self::Output {
        self.simd.sub_u8x64(self, rhs)
    }
}
impl<S: Simd> core::ops::SubAssign for u8x64<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: Self) {
        *self = self.simd.sub_u8x64(*self, rhs);
    }
}
impl<S: Simd> core::ops::Sub<u8> for u8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: u8) -> Self::Output {
        self.simd.sub_u8x64(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::SubAssign<u8> for u8x64<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: u8) {
        *self = self.simd.sub_u8x64(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Sub<u8x64<S>> for u8 {
    type Output = u8x64<S>;
    #[inline(always)]
    fn sub(self, rhs: u8x64<S>) -> Self::Output {
        rhs.simd.sub_u8x64(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Mul for u8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: Self) -> Self::Output {
        self.simd.mul_u8x64(self, rhs)
    }
}
impl<S: Simd> core::ops::MulAssign for u8x64<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: Self) {
        *self = self.simd.mul_u8x64(*self, rhs);
    }
}
impl<S: Simd> core::ops::Mul<u8> for u8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: u8) -> Self::Output {
        self.simd.mul_u8x64(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::MulAssign<u8> for u8x64<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: u8) {
        *self = self.simd.mul_u8x64(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Mul<u8x64<S>> for u8 {
    type Output = u8x64<S>;
    #[inline(always)]
    fn mul(self, rhs: u8x64<S>) -> Self::Output {
        rhs.simd.mul_u8x64(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitAnd for u8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: Self) -> Self::Output {
        self.simd.and_u8x64(self, rhs)
    }
}
impl<S: Simd> core::ops::BitAndAssign for u8x64<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: Self) {
        *self = self.simd.and_u8x64(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd<u8> for u8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: u8) -> Self::Output {
        self.simd.and_u8x64(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitAndAssign<u8> for u8x64<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: u8) {
        *self = self.simd.and_u8x64(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitAnd<u8x64<S>> for u8 {
    type Output = u8x64<S>;
    #[inline(always)]
    fn bitand(self, rhs: u8x64<S>) -> Self::Output {
        rhs.simd.and_u8x64(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitOr for u8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: Self) -> Self::Output {
        self.simd.or_u8x64(self, rhs)
    }
}
impl<S: Simd> core::ops::BitOrAssign for u8x64<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: Self) {
        *self = self.simd.or_u8x64(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitOr<u8> for u8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: u8) -> Self::Output {
        self.simd.or_u8x64(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitOrAssign<u8> for u8x64<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: u8) {
        *self = self.simd.or_u8x64(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitOr<u8x64<S>> for u8 {
    type Output = u8x64<S>;
    #[inline(always)]
    fn bitor(self, rhs: u8x64<S>) -> Self::Output {
        rhs.simd.or_u8x64(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitXor for u8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: Self) -> Self::Output {
        self.simd.xor_u8x64(self, rhs)
    }
}
impl<S: Simd> core::ops::BitXorAssign for u8x64<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: Self) {
        *self = self.simd.xor_u8x64(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitXor<u8> for u8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: u8) -> Self::Output {
        self.simd.xor_u8x64(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitXorAssign<u8> for u8x64<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: u8) {
        *self = self.simd.xor_u8x64(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitXor<u8x64<S>> for u8 {
    type Output = u8x64<S>;
    #[inline(always)]
    fn bitxor(self, rhs: u8x64<S>) -> Self::Output {
        rhs.simd.xor_u8x64(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Shl<u32> for u8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn shl(self, rhs: u32) -> Self::Output {
        self.simd.shl_u8x64(self, rhs)
    }
}
impl<S: Simd> core::ops::Shr<u32> for u8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: u32) -> Self::Output {
        self.simd.shr_u8x64(self, rhs)
    }
}
impl<S: Simd> core::ops::ShlAssign<u32> for u8x64<S> {
    #[inline(always)]
    fn shl_assign(&mut self, rhs: u32) {
        *self = self.simd.shl_u8x64(*self, rhs);
    }
}
impl<S: Simd> core::ops::ShrAssign<u32> for u8x64<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: u32) {
        *self = self.simd.shr_u8x64(*self, rhs);
    }
}
impl<S: Simd> core::ops::Shr for u8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: Self) -> Self::Output {
        self.simd.shrv_u8x64(self, rhs)
    }
}
impl<S: Simd> core::ops::ShrAssign for u8x64<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: Self) {
        *self = self.simd.shrv_u8x64(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd for mask8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: Self) -> Self::Output {
        self.simd.and_mask8x64(self, rhs)
    }
}
impl<S: Simd> core::ops::BitAndAssign for mask8x64<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: Self) {
        *self = self.simd.and_mask8x64(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd<i8> for mask8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: i8) -> Self::Output {
        self.simd.and_mask8x64(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitAndAssign<i8> for mask8x64<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: i8) {
        *self = self.simd.and_mask8x64(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitAnd<mask8x64<S>> for i8 {
    type Output = mask8x64<S>;
    #[inline(always)]
    fn bitand(self, rhs: mask8x64<S>) -> Self::Output {
        rhs.simd.and_mask8x64(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitOr for mask8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: Self) -> Self::Output {
        self.simd.or_mask8x64(self, rhs)
    }
}
impl<S: Simd> core::ops::BitOrAssign for mask8x64<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: Self) {
        *self = self.simd.or_mask8x64(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitOr<i8> for mask8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: i8) -> Self::Output {
        self.simd.or_mask8x64(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitOrAssign<i8> for mask8x64<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: i8) {
        *self = self.simd.or_mask8x64(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitOr<mask8x64<S>> for i8 {
    type Output = mask8x64<S>;
    #[inline(always)]
    fn bitor(self, rhs: mask8x64<S>) -> Self::Output {
        rhs.simd.or_mask8x64(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitXor for mask8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: Self) -> Self::Output {
        self.simd.xor_mask8x64(self, rhs)
    }
}
impl<S: Simd> core::ops::BitXorAssign for mask8x64<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: Self) {
        *self = self.simd.xor_mask8x64(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitXor<i8> for mask8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: i8) -> Self::Output {
        self.simd.xor_mask8x64(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitXorAssign<i8> for mask8x64<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: i8) {
        *self = self.simd.xor_mask8x64(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitXor<mask8x64<S>> for i8 {
    type Output = mask8x64<S>;
    #[inline(always)]
    fn bitxor(self, rhs: mask8x64<S>) -> Self::Output {
        rhs.simd.xor_mask8x64(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Not for mask8x64<S> {
    type Output = Self;
    #[inline(always)]
    fn not(self) -> Self::Output {
        self.simd.not_mask8x64(self)
    }
}
impl<S: Simd> core::ops::Neg for i16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn neg(self) -> Self::Output {
        self.simd.neg_i16x32(self)
    }
}
impl<S: Simd> core::ops::Add for i16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: Self) -> Self::Output {
        self.simd.add_i16x32(self, rhs)
    }
}
impl<S: Simd> core::ops::AddAssign for i16x32<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: Self) {
        *self = self.simd.add_i16x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add<i16> for i16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: i16) -> Self::Output {
        self.simd.add_i16x32(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::AddAssign<i16> for i16x32<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: i16) {
        *self = self.simd.add_i16x32(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Add<i16x32<S>> for i16 {
    type Output = i16x32<S>;
    #[inline(always)]
    fn add(self, rhs: i16x32<S>) -> Self::Output {
        rhs.simd.add_i16x32(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Sub for i16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: Self) -> Self::Output {
        self.simd.sub_i16x32(self, rhs)
    }
}
impl<S: Simd> core::ops::SubAssign for i16x32<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: Self) {
        *self = self.simd.sub_i16x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::Sub<i16> for i16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: i16) -> Self::Output {
        self.simd.sub_i16x32(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::SubAssign<i16> for i16x32<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: i16) {
        *self = self.simd.sub_i16x32(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Sub<i16x32<S>> for i16 {
    type Output = i16x32<S>;
    #[inline(always)]
    fn sub(self, rhs: i16x32<S>) -> Self::Output {
        rhs.simd.sub_i16x32(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Mul for i16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: Self) -> Self::Output {
        self.simd.mul_i16x32(self, rhs)
    }
}
impl<S: Simd> core::ops::MulAssign for i16x32<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: Self) {
        *self = self.simd.mul_i16x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::Mul<i16> for i16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: i16) -> Self::Output {
        self.simd.mul_i16x32(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::MulAssign<i16> for i16x32<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: i16) {
        *self = self.simd.mul_i16x32(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Mul<i16x32<S>> for i16 {
    type Output = i16x32<S>;
    #[inline(always)]
    fn mul(self, rhs: i16x32<S>) -> Self::Output {
        rhs.simd.mul_i16x32(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitAnd for i16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: Self) -> Self::Output {
        self.simd.and_i16x32(self, rhs)
    }
}
impl<S: Simd> core::ops::BitAndAssign for i16x32<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: Self) {
        *self = self.simd.and_i16x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd<i16> for i16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: i16) -> Self::Output {
        self.simd.and_i16x32(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitAndAssign<i16> for i16x32<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: i16) {
        *self = self.simd.and_i16x32(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitAnd<i16x32<S>> for i16 {
    type Output = i16x32<S>;
    #[inline(always)]
    fn bitand(self, rhs: i16x32<S>) -> Self::Output {
        rhs.simd.and_i16x32(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitOr for i16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: Self) -> Self::Output {
        self.simd.or_i16x32(self, rhs)
    }
}
impl<S: Simd> core::ops::BitOrAssign for i16x32<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: Self) {
        *self = self.simd.or_i16x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitOr<i16> for i16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: i16) -> Self::Output {
        self.simd.or_i16x32(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitOrAssign<i16> for i16x32<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: i16) {
        *self = self.simd.or_i16x32(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitOr<i16x32<S>> for i16 {
    type Output = i16x32<S>;
    #[inline(always)]
    fn bitor(self, rhs: i16x32<S>) -> Self::Output {
        rhs.simd.or_i16x32(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitXor for i16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: Self) -> Self::Output {
        self.simd.xor_i16x32(self, rhs)
    }
}
impl<S: Simd> core::ops::BitXorAssign for i16x32<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: Self) {
        *self = self.simd.xor_i16x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitXor<i16> for i16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: i16) -> Self::Output {
        self.simd.xor_i16x32(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitXorAssign<i16> for i16x32<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: i16) {
        *self = self.simd.xor_i16x32(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitXor<i16x32<S>> for i16 {
    type Output = i16x32<S>;
    #[inline(always)]
    fn bitxor(self, rhs: i16x32<S>) -> Self::Output {
        rhs.simd.xor_i16x32(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Shl<u32> for i16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn shl(self, rhs: u32) -> Self::Output {
        self.simd.shl_i16x32(self, rhs)
    }
}
impl<S: Simd> core::ops::Shr<u32> for i16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: u32) -> Self::Output {
        self.simd.shr_i16x32(self, rhs)
    }
}
impl<S: Simd> core::ops::ShlAssign<u32> for i16x32<S> {
    #[inline(always)]
    fn shl_assign(&mut self, rhs: u32) {
        *self = self.simd.shl_i16x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::ShrAssign<u32> for i16x32<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: u32) {
        *self = self.simd.shr_i16x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::Shr for i16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: Self) -> Self::Output {
        self.simd.shrv_i16x32(self, rhs)
    }
}
impl<S: Simd> core::ops::ShrAssign for i16x32<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: Self) {
        *self = self.simd.shrv_i16x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add for u16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: Self) -> Self::Output {
        self.simd.add_u16x32(self, rhs)
    }
}
impl<S: Simd> core::ops::AddAssign for u16x32<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: Self) {
        *self = self.simd.add_u16x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add<u16> for u16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: u16) -> Self::Output {
        self.simd.add_u16x32(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::AddAssign<u16> for u16x32<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: u16) {
        *self = self.simd.add_u16x32(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Add<u16x32<S>> for u16 {
    type Output = u16x32<S>;
    #[inline(always)]
    fn add(self, rhs: u16x32<S>) -> Self::Output {
        rhs.simd.add_u16x32(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Sub for u16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: Self) -> Self::Output {
        self.simd.sub_u16x32(self, rhs)
    }
}
impl<S: Simd> core::ops::SubAssign for u16x32<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: Self) {
        *self = self.simd.sub_u16x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::Sub<u16> for u16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: u16) -> Self::Output {
        self.simd.sub_u16x32(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::SubAssign<u16> for u16x32<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: u16) {
        *self = self.simd.sub_u16x32(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Sub<u16x32<S>> for u16 {
    type Output = u16x32<S>;
    #[inline(always)]
    fn sub(self, rhs: u16x32<S>) -> Self::Output {
        rhs.simd.sub_u16x32(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Mul for u16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: Self) -> Self::Output {
        self.simd.mul_u16x32(self, rhs)
    }
}
impl<S: Simd> core::ops::MulAssign for u16x32<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: Self) {
        *self = self.simd.mul_u16x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::Mul<u16> for u16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: u16) -> Self::Output {
        self.simd.mul_u16x32(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::MulAssign<u16> for u16x32<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: u16) {
        *self = self.simd.mul_u16x32(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Mul<u16x32<S>> for u16 {
    type Output = u16x32<S>;
    #[inline(always)]
    fn mul(self, rhs: u16x32<S>) -> Self::Output {
        rhs.simd.mul_u16x32(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitAnd for u16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: Self) -> Self::Output {
        self.simd.and_u16x32(self, rhs)
    }
}
impl<S: Simd> core::ops::BitAndAssign for u16x32<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: Self) {
        *self = self.simd.and_u16x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd<u16> for u16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: u16) -> Self::Output {
        self.simd.and_u16x32(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitAndAssign<u16> for u16x32<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: u16) {
        *self = self.simd.and_u16x32(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitAnd<u16x32<S>> for u16 {
    type Output = u16x32<S>;
    #[inline(always)]
    fn bitand(self, rhs: u16x32<S>) -> Self::Output {
        rhs.simd.and_u16x32(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitOr for u16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: Self) -> Self::Output {
        self.simd.or_u16x32(self, rhs)
    }
}
impl<S: Simd> core::ops::BitOrAssign for u16x32<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: Self) {
        *self = self.simd.or_u16x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitOr<u16> for u16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: u16) -> Self::Output {
        self.simd.or_u16x32(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitOrAssign<u16> for u16x32<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: u16) {
        *self = self.simd.or_u16x32(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitOr<u16x32<S>> for u16 {
    type Output = u16x32<S>;
    #[inline(always)]
    fn bitor(self, rhs: u16x32<S>) -> Self::Output {
        rhs.simd.or_u16x32(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitXor for u16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: Self) -> Self::Output {
        self.simd.xor_u16x32(self, rhs)
    }
}
impl<S: Simd> core::ops::BitXorAssign for u16x32<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: Self) {
        *self = self.simd.xor_u16x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitXor<u16> for u16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: u16) -> Self::Output {
        self.simd.xor_u16x32(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitXorAssign<u16> for u16x32<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: u16) {
        *self = self.simd.xor_u16x32(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitXor<u16x32<S>> for u16 {
    type Output = u16x32<S>;
    #[inline(always)]
    fn bitxor(self, rhs: u16x32<S>) -> Self::Output {
        rhs.simd.xor_u16x32(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Shl<u32> for u16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn shl(self, rhs: u32) -> Self::Output {
        self.simd.shl_u16x32(self, rhs)
    }
}
impl<S: Simd> core::ops::Shr<u32> for u16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: u32) -> Self::Output {
        self.simd.shr_u16x32(self, rhs)
    }
}
impl<S: Simd> core::ops::ShlAssign<u32> for u16x32<S> {
    #[inline(always)]
    fn shl_assign(&mut self, rhs: u32) {
        *self = self.simd.shl_u16x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::ShrAssign<u32> for u16x32<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: u32) {
        *self = self.simd.shr_u16x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::Shr for u16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: Self) -> Self::Output {
        self.simd.shrv_u16x32(self, rhs)
    }
}
impl<S: Simd> core::ops::ShrAssign for u16x32<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: Self) {
        *self = self.simd.shrv_u16x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd for mask16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: Self) -> Self::Output {
        self.simd.and_mask16x32(self, rhs)
    }
}
impl<S: Simd> core::ops::BitAndAssign for mask16x32<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: Self) {
        *self = self.simd.and_mask16x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd<i16> for mask16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: i16) -> Self::Output {
        self.simd.and_mask16x32(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitAndAssign<i16> for mask16x32<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: i16) {
        *self = self.simd.and_mask16x32(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitAnd<mask16x32<S>> for i16 {
    type Output = mask16x32<S>;
    #[inline(always)]
    fn bitand(self, rhs: mask16x32<S>) -> Self::Output {
        rhs.simd.and_mask16x32(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitOr for mask16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: Self) -> Self::Output {
        self.simd.or_mask16x32(self, rhs)
    }
}
impl<S: Simd> core::ops::BitOrAssign for mask16x32<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: Self) {
        *self = self.simd.or_mask16x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitOr<i16> for mask16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: i16) -> Self::Output {
        self.simd.or_mask16x32(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitOrAssign<i16> for mask16x32<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: i16) {
        *self = self.simd.or_mask16x32(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitOr<mask16x32<S>> for i16 {
    type Output = mask16x32<S>;
    #[inline(always)]
    fn bitor(self, rhs: mask16x32<S>) -> Self::Output {
        rhs.simd.or_mask16x32(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitXor for mask16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: Self) -> Self::Output {
        self.simd.xor_mask16x32(self, rhs)
    }
}
impl<S: Simd> core::ops::BitXorAssign for mask16x32<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: Self) {
        *self = self.simd.xor_mask16x32(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitXor<i16> for mask16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: i16) -> Self::Output {
        self.simd.xor_mask16x32(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitXorAssign<i16> for mask16x32<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: i16) {
        *self = self.simd.xor_mask16x32(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitXor<mask16x32<S>> for i16 {
    type Output = mask16x32<S>;
    #[inline(always)]
    fn bitxor(self, rhs: mask16x32<S>) -> Self::Output {
        rhs.simd.xor_mask16x32(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Not for mask16x32<S> {
    type Output = Self;
    #[inline(always)]
    fn not(self) -> Self::Output {
        self.simd.not_mask16x32(self)
    }
}
impl<S: Simd> core::ops::Neg for i32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn neg(self) -> Self::Output {
        self.simd.neg_i32x16(self)
    }
}
impl<S: Simd> core::ops::Add for i32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: Self) -> Self::Output {
        self.simd.add_i32x16(self, rhs)
    }
}
impl<S: Simd> core::ops::AddAssign for i32x16<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: Self) {
        *self = self.simd.add_i32x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add<i32> for i32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: i32) -> Self::Output {
        self.simd.add_i32x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::AddAssign<i32> for i32x16<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: i32) {
        *self = self.simd.add_i32x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Add<i32x16<S>> for i32 {
    type Output = i32x16<S>;
    #[inline(always)]
    fn add(self, rhs: i32x16<S>) -> Self::Output {
        rhs.simd.add_i32x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Sub for i32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: Self) -> Self::Output {
        self.simd.sub_i32x16(self, rhs)
    }
}
impl<S: Simd> core::ops::SubAssign for i32x16<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: Self) {
        *self = self.simd.sub_i32x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Sub<i32> for i32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: i32) -> Self::Output {
        self.simd.sub_i32x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::SubAssign<i32> for i32x16<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: i32) {
        *self = self.simd.sub_i32x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Sub<i32x16<S>> for i32 {
    type Output = i32x16<S>;
    #[inline(always)]
    fn sub(self, rhs: i32x16<S>) -> Self::Output {
        rhs.simd.sub_i32x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Mul for i32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: Self) -> Self::Output {
        self.simd.mul_i32x16(self, rhs)
    }
}
impl<S: Simd> core::ops::MulAssign for i32x16<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: Self) {
        *self = self.simd.mul_i32x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Mul<i32> for i32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: i32) -> Self::Output {
        self.simd.mul_i32x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::MulAssign<i32> for i32x16<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: i32) {
        *self = self.simd.mul_i32x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Mul<i32x16<S>> for i32 {
    type Output = i32x16<S>;
    #[inline(always)]
    fn mul(self, rhs: i32x16<S>) -> Self::Output {
        rhs.simd.mul_i32x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitAnd for i32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: Self) -> Self::Output {
        self.simd.and_i32x16(self, rhs)
    }
}
impl<S: Simd> core::ops::BitAndAssign for i32x16<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: Self) {
        *self = self.simd.and_i32x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd<i32> for i32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: i32) -> Self::Output {
        self.simd.and_i32x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitAndAssign<i32> for i32x16<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: i32) {
        *self = self.simd.and_i32x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitAnd<i32x16<S>> for i32 {
    type Output = i32x16<S>;
    #[inline(always)]
    fn bitand(self, rhs: i32x16<S>) -> Self::Output {
        rhs.simd.and_i32x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitOr for i32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: Self) -> Self::Output {
        self.simd.or_i32x16(self, rhs)
    }
}
impl<S: Simd> core::ops::BitOrAssign for i32x16<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: Self) {
        *self = self.simd.or_i32x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitOr<i32> for i32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: i32) -> Self::Output {
        self.simd.or_i32x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitOrAssign<i32> for i32x16<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: i32) {
        *self = self.simd.or_i32x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitOr<i32x16<S>> for i32 {
    type Output = i32x16<S>;
    #[inline(always)]
    fn bitor(self, rhs: i32x16<S>) -> Self::Output {
        rhs.simd.or_i32x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitXor for i32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: Self) -> Self::Output {
        self.simd.xor_i32x16(self, rhs)
    }
}
impl<S: Simd> core::ops::BitXorAssign for i32x16<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: Self) {
        *self = self.simd.xor_i32x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitXor<i32> for i32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: i32) -> Self::Output {
        self.simd.xor_i32x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitXorAssign<i32> for i32x16<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: i32) {
        *self = self.simd.xor_i32x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitXor<i32x16<S>> for i32 {
    type Output = i32x16<S>;
    #[inline(always)]
    fn bitxor(self, rhs: i32x16<S>) -> Self::Output {
        rhs.simd.xor_i32x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Shl<u32> for i32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn shl(self, rhs: u32) -> Self::Output {
        self.simd.shl_i32x16(self, rhs)
    }
}
impl<S: Simd> core::ops::Shr<u32> for i32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: u32) -> Self::Output {
        self.simd.shr_i32x16(self, rhs)
    }
}
impl<S: Simd> core::ops::ShlAssign<u32> for i32x16<S> {
    #[inline(always)]
    fn shl_assign(&mut self, rhs: u32) {
        *self = self.simd.shl_i32x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::ShrAssign<u32> for i32x16<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: u32) {
        *self = self.simd.shr_i32x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Shr for i32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: Self) -> Self::Output {
        self.simd.shrv_i32x16(self, rhs)
    }
}
impl<S: Simd> core::ops::ShrAssign for i32x16<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: Self) {
        *self = self.simd.shrv_i32x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add for u32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: Self) -> Self::Output {
        self.simd.add_u32x16(self, rhs)
    }
}
impl<S: Simd> core::ops::AddAssign for u32x16<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: Self) {
        *self = self.simd.add_u32x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add<u32> for u32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: u32) -> Self::Output {
        self.simd.add_u32x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::AddAssign<u32> for u32x16<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: u32) {
        *self = self.simd.add_u32x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Add<u32x16<S>> for u32 {
    type Output = u32x16<S>;
    #[inline(always)]
    fn add(self, rhs: u32x16<S>) -> Self::Output {
        rhs.simd.add_u32x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Sub for u32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: Self) -> Self::Output {
        self.simd.sub_u32x16(self, rhs)
    }
}
impl<S: Simd> core::ops::SubAssign for u32x16<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: Self) {
        *self = self.simd.sub_u32x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Sub<u32> for u32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: u32) -> Self::Output {
        self.simd.sub_u32x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::SubAssign<u32> for u32x16<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: u32) {
        *self = self.simd.sub_u32x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Sub<u32x16<S>> for u32 {
    type Output = u32x16<S>;
    #[inline(always)]
    fn sub(self, rhs: u32x16<S>) -> Self::Output {
        rhs.simd.sub_u32x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Mul for u32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: Self) -> Self::Output {
        self.simd.mul_u32x16(self, rhs)
    }
}
impl<S: Simd> core::ops::MulAssign for u32x16<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: Self) {
        *self = self.simd.mul_u32x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Mul<u32> for u32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: u32) -> Self::Output {
        self.simd.mul_u32x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::MulAssign<u32> for u32x16<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: u32) {
        *self = self.simd.mul_u32x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Mul<u32x16<S>> for u32 {
    type Output = u32x16<S>;
    #[inline(always)]
    fn mul(self, rhs: u32x16<S>) -> Self::Output {
        rhs.simd.mul_u32x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitAnd for u32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: Self) -> Self::Output {
        self.simd.and_u32x16(self, rhs)
    }
}
impl<S: Simd> core::ops::BitAndAssign for u32x16<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: Self) {
        *self = self.simd.and_u32x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd<u32> for u32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: u32) -> Self::Output {
        self.simd.and_u32x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitAndAssign<u32> for u32x16<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: u32) {
        *self = self.simd.and_u32x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitAnd<u32x16<S>> for u32 {
    type Output = u32x16<S>;
    #[inline(always)]
    fn bitand(self, rhs: u32x16<S>) -> Self::Output {
        rhs.simd.and_u32x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitOr for u32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: Self) -> Self::Output {
        self.simd.or_u32x16(self, rhs)
    }
}
impl<S: Simd> core::ops::BitOrAssign for u32x16<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: Self) {
        *self = self.simd.or_u32x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitOr<u32> for u32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: u32) -> Self::Output {
        self.simd.or_u32x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitOrAssign<u32> for u32x16<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: u32) {
        *self = self.simd.or_u32x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitOr<u32x16<S>> for u32 {
    type Output = u32x16<S>;
    #[inline(always)]
    fn bitor(self, rhs: u32x16<S>) -> Self::Output {
        rhs.simd.or_u32x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitXor for u32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: Self) -> Self::Output {
        self.simd.xor_u32x16(self, rhs)
    }
}
impl<S: Simd> core::ops::BitXorAssign for u32x16<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: Self) {
        *self = self.simd.xor_u32x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitXor<u32> for u32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: u32) -> Self::Output {
        self.simd.xor_u32x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitXorAssign<u32> for u32x16<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: u32) {
        *self = self.simd.xor_u32x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitXor<u32x16<S>> for u32 {
    type Output = u32x16<S>;
    #[inline(always)]
    fn bitxor(self, rhs: u32x16<S>) -> Self::Output {
        rhs.simd.xor_u32x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Shl<u32> for u32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn shl(self, rhs: u32) -> Self::Output {
        self.simd.shl_u32x16(self, rhs)
    }
}
impl<S: Simd> core::ops::Shr<u32> for u32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: u32) -> Self::Output {
        self.simd.shr_u32x16(self, rhs)
    }
}
impl<S: Simd> core::ops::ShlAssign<u32> for u32x16<S> {
    #[inline(always)]
    fn shl_assign(&mut self, rhs: u32) {
        *self = self.simd.shl_u32x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::ShrAssign<u32> for u32x16<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: u32) {
        *self = self.simd.shr_u32x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::Shr for u32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn shr(self, rhs: Self) -> Self::Output {
        self.simd.shrv_u32x16(self, rhs)
    }
}
impl<S: Simd> core::ops::ShrAssign for u32x16<S> {
    #[inline(always)]
    fn shr_assign(&mut self, rhs: Self) {
        *self = self.simd.shrv_u32x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd for mask32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: Self) -> Self::Output {
        self.simd.and_mask32x16(self, rhs)
    }
}
impl<S: Simd> core::ops::BitAndAssign for mask32x16<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: Self) {
        *self = self.simd.and_mask32x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd<i32> for mask32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: i32) -> Self::Output {
        self.simd.and_mask32x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitAndAssign<i32> for mask32x16<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: i32) {
        *self = self.simd.and_mask32x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitAnd<mask32x16<S>> for i32 {
    type Output = mask32x16<S>;
    #[inline(always)]
    fn bitand(self, rhs: mask32x16<S>) -> Self::Output {
        rhs.simd.and_mask32x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitOr for mask32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: Self) -> Self::Output {
        self.simd.or_mask32x16(self, rhs)
    }
}
impl<S: Simd> core::ops::BitOrAssign for mask32x16<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: Self) {
        *self = self.simd.or_mask32x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitOr<i32> for mask32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: i32) -> Self::Output {
        self.simd.or_mask32x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitOrAssign<i32> for mask32x16<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: i32) {
        *self = self.simd.or_mask32x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitOr<mask32x16<S>> for i32 {
    type Output = mask32x16<S>;
    #[inline(always)]
    fn bitor(self, rhs: mask32x16<S>) -> Self::Output {
        rhs.simd.or_mask32x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitXor for mask32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: Self) -> Self::Output {
        self.simd.xor_mask32x16(self, rhs)
    }
}
impl<S: Simd> core::ops::BitXorAssign for mask32x16<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: Self) {
        *self = self.simd.xor_mask32x16(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitXor<i32> for mask32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: i32) -> Self::Output {
        self.simd.xor_mask32x16(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitXorAssign<i32> for mask32x16<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: i32) {
        *self = self.simd.xor_mask32x16(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitXor<mask32x16<S>> for i32 {
    type Output = mask32x16<S>;
    #[inline(always)]
    fn bitxor(self, rhs: mask32x16<S>) -> Self::Output {
        rhs.simd.xor_mask32x16(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Not for mask32x16<S> {
    type Output = Self;
    #[inline(always)]
    fn not(self) -> Self::Output {
        self.simd.not_mask32x16(self)
    }
}
impl<S: Simd> core::ops::Neg for f64x8<S> {
    type Output = Self;
    #[inline(always)]
    fn neg(self) -> Self::Output {
        self.simd.neg_f64x8(self)
    }
}
impl<S: Simd> core::ops::Add for f64x8<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: Self) -> Self::Output {
        self.simd.add_f64x8(self, rhs)
    }
}
impl<S: Simd> core::ops::AddAssign for f64x8<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: Self) {
        *self = self.simd.add_f64x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::Add<f64> for f64x8<S> {
    type Output = Self;
    #[inline(always)]
    fn add(self, rhs: f64) -> Self::Output {
        self.simd.add_f64x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::AddAssign<f64> for f64x8<S> {
    #[inline(always)]
    fn add_assign(&mut self, rhs: f64) {
        *self = self.simd.add_f64x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Add<f64x8<S>> for f64 {
    type Output = f64x8<S>;
    #[inline(always)]
    fn add(self, rhs: f64x8<S>) -> Self::Output {
        rhs.simd.add_f64x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Sub for f64x8<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: Self) -> Self::Output {
        self.simd.sub_f64x8(self, rhs)
    }
}
impl<S: Simd> core::ops::SubAssign for f64x8<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: Self) {
        *self = self.simd.sub_f64x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::Sub<f64> for f64x8<S> {
    type Output = Self;
    #[inline(always)]
    fn sub(self, rhs: f64) -> Self::Output {
        self.simd.sub_f64x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::SubAssign<f64> for f64x8<S> {
    #[inline(always)]
    fn sub_assign(&mut self, rhs: f64) {
        *self = self.simd.sub_f64x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Sub<f64x8<S>> for f64 {
    type Output = f64x8<S>;
    #[inline(always)]
    fn sub(self, rhs: f64x8<S>) -> Self::Output {
        rhs.simd.sub_f64x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Mul for f64x8<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: Self) -> Self::Output {
        self.simd.mul_f64x8(self, rhs)
    }
}
impl<S: Simd> core::ops::MulAssign for f64x8<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: Self) {
        *self = self.simd.mul_f64x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::Mul<f64> for f64x8<S> {
    type Output = Self;
    #[inline(always)]
    fn mul(self, rhs: f64) -> Self::Output {
        self.simd.mul_f64x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::MulAssign<f64> for f64x8<S> {
    #[inline(always)]
    fn mul_assign(&mut self, rhs: f64) {
        *self = self.simd.mul_f64x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Mul<f64x8<S>> for f64 {
    type Output = f64x8<S>;
    #[inline(always)]
    fn mul(self, rhs: f64x8<S>) -> Self::Output {
        rhs.simd.mul_f64x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Div for f64x8<S> {
    type Output = Self;
    #[inline(always)]
    fn div(self, rhs: Self) -> Self::Output {
        self.simd.div_f64x8(self, rhs)
    }
}
impl<S: Simd> core::ops::DivAssign for f64x8<S> {
    #[inline(always)]
    fn div_assign(&mut self, rhs: Self) {
        *self = self.simd.div_f64x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::Div<f64> for f64x8<S> {
    type Output = Self;
    #[inline(always)]
    fn div(self, rhs: f64) -> Self::Output {
        self.simd.div_f64x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::DivAssign<f64> for f64x8<S> {
    #[inline(always)]
    fn div_assign(&mut self, rhs: f64) {
        *self = self.simd.div_f64x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::Div<f64x8<S>> for f64 {
    type Output = f64x8<S>;
    #[inline(always)]
    fn div(self, rhs: f64x8<S>) -> Self::Output {
        rhs.simd.div_f64x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitAnd for mask64x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: Self) -> Self::Output {
        self.simd.and_mask64x8(self, rhs)
    }
}
impl<S: Simd> core::ops::BitAndAssign for mask64x8<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: Self) {
        *self = self.simd.and_mask64x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitAnd<i64> for mask64x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitand(self, rhs: i64) -> Self::Output {
        self.simd.and_mask64x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitAndAssign<i64> for mask64x8<S> {
    #[inline(always)]
    fn bitand_assign(&mut self, rhs: i64) {
        *self = self.simd.and_mask64x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitAnd<mask64x8<S>> for i64 {
    type Output = mask64x8<S>;
    #[inline(always)]
    fn bitand(self, rhs: mask64x8<S>) -> Self::Output {
        rhs.simd.and_mask64x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitOr for mask64x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: Self) -> Self::Output {
        self.simd.or_mask64x8(self, rhs)
    }
}
impl<S: Simd> core::ops::BitOrAssign for mask64x8<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: Self) {
        *self = self.simd.or_mask64x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitOr<i64> for mask64x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitor(self, rhs: i64) -> Self::Output {
        self.simd.or_mask64x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitOrAssign<i64> for mask64x8<S> {
    #[inline(always)]
    fn bitor_assign(&mut self, rhs: i64) {
        *self = self.simd.or_mask64x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitOr<mask64x8<S>> for i64 {
    type Output = mask64x8<S>;
    #[inline(always)]
    fn bitor(self, rhs: mask64x8<S>) -> Self::Output {
        rhs.simd.or_mask64x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::BitXor for mask64x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: Self) -> Self::Output {
        self.simd.xor_mask64x8(self, rhs)
    }
}
impl<S: Simd> core::ops::BitXorAssign for mask64x8<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: Self) {
        *self = self.simd.xor_mask64x8(*self, rhs);
    }
}
impl<S: Simd> core::ops::BitXor<i64> for mask64x8<S> {
    type Output = Self;
    #[inline(always)]
    fn bitxor(self, rhs: i64) -> Self::Output {
        self.simd.xor_mask64x8(self, rhs.simd_into(self.simd))
    }
}
impl<S: Simd> core::ops::BitXorAssign<i64> for mask64x8<S> {
    #[inline(always)]
    fn bitxor_assign(&mut self, rhs: i64) {
        *self = self.simd.xor_mask64x8(*self, rhs.simd_into(self.simd));
    }
}
impl<S: Simd> core::ops::BitXor<mask64x8<S>> for i64 {
    type Output = mask64x8<S>;
    #[inline(always)]
    fn bitxor(self, rhs: mask64x8<S>) -> Self::Output {
        rhs.simd.xor_mask64x8(self.simd_into(rhs.simd), rhs)
    }
}
impl<S: Simd> core::ops::Not for mask64x8<S> {
    type Output = Self;
    #[inline(always)]
    fn not(self) -> Self::Output {
        self.simd.not_mask64x8(self)
    }
}
