<?php

use Symfony\Component\DependencyInjection\Argument\RewindableGenerator;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\Container;
use Symfony\Component\DependencyInjection\Exception\LogicException;
use Symfony\Component\DependencyInjection\Exception\ParameterNotFoundException;
use Symfony\Component\DependencyInjection\Exception\RuntimeException;
use Symfony\Component\DependencyInjection\ParameterBag\FrozenParameterBag;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

/**
 * @internal This class has been auto-generated by the Symfony Dependency Injection Component.
 */
class Symfony_DI_PhpDumper_Test_EnvParameters extends Container
{
    protected $parameters = [];

    public function __construct()
    {
        $this->parameters = $this->getDefaultParameters();

        $this->services = $this->privates = [];
        $this->methodMap = [
            'bar' => 'getBarService',
            'test' => 'getTestService',
        ];

        $this->aliases = [];
    }

    public function compile(): void
    {
        throw new LogicException('You cannot compile a dumped container that was already compiled.');
    }

    public function isCompiled(): bool
    {
        return true;
    }

    /**
     * Gets the public 'bar' shared service.
     *
     * @return \Symfony\Component\DependencyInjection\Tests\Fixtures\Bar
     */
    protected static function getBarService($container)
    {
        return $container->services['bar'] = new \Symfony\Component\DependencyInjection\Tests\Fixtures\Bar($container->getEnv('QUZ'));
    }

    /**
     * Gets the public 'test' shared service.
     *
     * @return object A %env(FOO)% instance
     */
    protected static function getTestService($container)
    {
        return $container->services['test'] = new ${($_ = $container->getEnv('FOO')) && false ?: "_"}($container->getEnv('Bar'), 'foo'.$container->getEnv('string:FOO').'baz', $container->getEnv('int:Baz'));
    }

    public function getParameter(string $name): array|bool|string|int|float|\UnitEnum|null
    {
        if (isset($this->loadedDynamicParameters[$name])) {
            $value = $this->loadedDynamicParameters[$name] ? $this->dynamicParameters[$name] : $this->getDynamicParameter($name);
        } elseif (\array_key_exists($name, $this->parameters) && '.' !== ($name[0] ?? '')) {
            $value = $this->parameters[$name];
        } else {
            throw new ParameterNotFoundException($name);
        }

        return $value;
    }

    public function hasParameter(string $name): bool
    {
        return \array_key_exists($name, $this->parameters) || isset($this->loadedDynamicParameters[$name]);
    }

    public function setParameter(string $name, $value): void
    {
        throw new LogicException('Impossible to call set() on a frozen ParameterBag.');
    }

    public function getParameterBag(): ParameterBagInterface
    {
        if (!isset($this->parameterBag)) {
            $parameters = $this->parameters;
            foreach ($this->loadedDynamicParameters as $name => $loaded) {
                $parameters[$name] = $loaded ? $this->dynamicParameters[$name] : $this->getDynamicParameter($name);
            }
            $this->parameterBag = new FrozenParameterBag($parameters, []);
        }

        return $this->parameterBag;
    }

    private $loadedDynamicParameters = [
        'bar' => false,
        'baz' => false,
        'json' => false,
        'db_dsn' => false,
    ];
    private $dynamicParameters = [];

    private function getDynamicParameter(string $name)
    {
        $container = $this;
        $value = match ($name) {
            'bar' => $container->getEnv('FOO'),
            'baz' => $container->getEnv('int:Baz'),
            'json' => $container->getEnv('json:file:json_file'),
            'db_dsn' => $container->getEnv('resolve:DB'),
            default => throw new ParameterNotFoundException($name),
        };
        $this->loadedDynamicParameters[$name] = true;

        return $this->dynamicParameters[$name] = $value;
    }

    protected function getDefaultParameters(): array
    {
        return [
            'project_dir' => '/foo/bar',
            'env(FOO)' => 'foo',
            'env(DB)' => 'sqlite://%project_dir%/var/data.db',
            'env(json_file)' => (\dirname(__DIR__, 1).'/array.json'),
        ];
    }
}
