[comment {-*- tcl -*- tkcon manpage}]
[manpage_begin tkcon 1 2.5]
[copyright {Jeffrey Hobbs (jeff at hobbs.org)}]
[moddesc   {TkCon}]
[titledesc {Tk console replacement}]

[description]
[para]
TkCon is a replacement for the standard console that comes with Tk
(on Windows/Mac, but also works on Unix).
The console itself provides many more features than the standard
console.
TkCon works on all platforms where Tcl/Tk is available.
It is meant primarily to aid one when working with the little
details inside Tcl and Tk, giving Unix users the GUI console
provided by default in the Mac and Windows Tk.

[list_begin definitions]
[call [cmd tkcon] [lb]\{[arg option] [arg value] | [arg tcl_script]\} ...[rb]]
[list_end]

[section OPTIONS]
[para]
Except for [cmd -rcfile], command line arguments are handled after
the TkCon resource file is sourced, but before the slave
interpreter or the TkCon user interface is initialized.

[para]
[cmd -rcfile] is handled right before it would be sourced,
allowing you to specify any alternate file.
Command line arguments are passed to each new console and
will be evaluated by each.
To prevent this from happening, you have to say

[example_begin]
tkcon main set argv {}; tkcon main set argc 0
[example_end]

[para]
For these options, any unique substring is allowed.

[list_begin definitions]
[def "[cmd -argv] (also [cmd --])"]
Causes TkCon to stop evaluating arguments and set the remaining
args to be argv/argc (with [cmd --] prepended).
This carries over for any further consoles.
This is meant only for wrapping TkCon
around programs that require their own arguments.

[def "[cmd -color-<color>] [arg color]"]
Sets the requested color type to the specified color for tkcon.
See [cmd tkconrc](5) for the recognized [cmd <color>] names.

[def "[cmd -eval] [arg tcl_script] (also [cmd -main] or [cmd -e])"]
A Tcl script to eval in each main interpreter.
This is evaluated after the resource file is loaded and the
slave interpreter is created.
Multiple [cmd -eval] switches will be recognized (in order).

[def "[cmd -exec] [arg slavename]"]
Sets the named slave that tkcon operates in.
In general, this is only useful to set to [arg {""}] (empty),
indicating to tkcon to avoid the multi-interpreter model and
operate in the main environment.
When this is empty, any further arguments will be only used
in the first tkcon console and not passed onto further new consoles.
This is useful when using tkcon as a console for extended wish
executables that don't load there commands into slave interpreters.

[def "[cmd -font] [arg font]"]
Sets the font that tkcon uses for its text windows.
If this isn't a fixed width font, tkcon will override it.

[def "[cmd -nontcl] [arg TCL_BOOLEAN]"]
Sets [cmd ::tkcon::OPT(nontcl)] to [arg TCL_BOOLEAN] (see
[cmd tkconrc](5)).
Needed when attaching to non-Tcl interpreters.

[def "[cmd -package] [arg package_name] (also [cmd -load])"]
Packages to automatically load into the slave interpreters (i.e. "Tk").

[def "[cmd -rcfile] [arg filename]"]
Specify an alternate tkcon resource file name.

[def "[cmd -root] [arg widgetname]"]
Makes the named widget the root name of all consoles (i.e. .tkcon).

[def "[cmd -slave] [arg tcl_script]"]
A Tcl script to eval in each slave interpreter.
This will append the one specified in the tkcon resource file, if any.

[list_end]

[section {KEY BINDINGS}]
[para]
Most of the bindings are the same as for the [cmd text] widget.
Some have been modified to make sure that the integrity of the
console is maintained.
Others have been added to enhance the usefulness of the console.
Only the modified or new bindings are listed here.

[list_begin definitions]

[def "[cmd Control-x] or [cmd Cut] (on Sparc5 keyboards)"]
Cut.

[def "[cmd Control-c] or [cmd Copy] (on Sparc5 keyboards)"]
Copy.

[def "[cmd Control-v] or [cmd Paste] (on Sparc5 keyboards)"]
Paste.

[def [cmd Insert]]
Insert (duh).

[def [cmd Up]]
Goes up one level in the commands line history when cursor is on
the prompt line, otherwise it moves through the buffer.

[def [cmd Down]]
Goes down one level in the commands line history when cursor
is on the last line of the buffer, otherwise it moves through the buffer.

[def [cmd Control-p]]
Goes up one level in the commands line history.

[def [cmd Control-n]]
Goes down one level in the commands line history.

[def [cmd Tab]]
Tries to expand file path names, then variable names, then proc names.

[def [cmd Escape]]
Tries to expand file path names.

[def [cmd Control-P]]
Tries to expand procedure names.
The procedure names will be those that are actually in the attached
interpreter (unless nontcl is specified, in which case it always
does the lookup in the default slave interpreter).

[def [cmd Control-V]]
Tries to expand variable names (those returned by [lb]info vars[rb]).
It's search behavior is like that for procedure names.

[def "[cmd Return] or [cmd Enter]"]
Evaluates the current command line if it is a complete command,
otherwise it just goes to a new line.

[def [cmd Control-a]]
Go to the beginning of the current command line.

[def [cmd Control-l]]
Clear the entire console buffer.

[def [cmd Control-r]]
Searches backwards in the history for any command that contains
the string in the current command line.
Repeatable to search farther back.
The matching substring off the found command will blink.

[def [cmd Control-s]]
As above, but searches forward (only useful if you searched too far back).

[def [cmd Control-t]]
Transposes characters.

[def [cmd Control-u]]
Clears the current command line.

[def [cmd Control-z]]
Saves current command line in a buffer that can be retrieved
with another [cmd Control-z].
If the current command line is empty, then any saved command
is retrieved without being overwritten, otherwise the current
contents get swapped with what's in the saved command buffer.

[def [cmd Control-Key-1]]
Attaches console to the console's slave interpreter.

[def [cmd Control-Key-2]]
Attaches console to the console's master interpreter.

[def [cmd Control-Key-3]]
Attaches console to main TkCon interpreter.

[def [cmd Control-A]]
Pops up the "About" dialog.

[def [cmd Control-N]]
Creates a new console. Each console has separate state, including
it's own widget hierarchy (it's a slave interpreter).

[def [cmd Control-q]]
Close the current console OR Quit the program (depends on the
value of [cmd ::tkcon::TKCON(slaveexit)]).

[def [cmd Control-w]]
Closes the current console.
Closing the main console will exit the program (something has
to control all the slaves...).

[list_end]

[para]
TkCon also has electric bracing (similar to that in emacs).
It will highlight matching pairs of {}'s, [lb][rb]'s, ()'s and ""'s.
For the first three, if there is no matching left element for the right,
then it blinks the entire current command line.
For the double quote, if there is no proper match then it just blinks
the current double quote character.
It does properly recognize most escaping (except escaped escapes),
but does not look for commenting (why would you interactively
put comments in?).

[section COMMANDS]
[para]
There are several new procedures introduced in TkCon to improve
productivity and/or account for lost functionality in the Tcl
environment that users are used to in native environments.
There are also some redefined procedures.
Here is a non-comprehensive list:

[list_begin definitions]

[def "[cmd alias] ?[arg sourceCmd] [arg targetCmd] ?[arg arg] [arg arg] ...??"]
Simple alias mechanism.
It will overwrite existing commands.
When called without args, it returns current aliases.
Note that TkCon makes some aliases for you (in slaves).
Don't delete those.

[def "[cmd clear] ?[arg percentage]?"]
Clears the text widget.
Same as the <[cmd Control-l]> binding, except this will accept a
percentage of the buffer to clear (1-100, 100 default).

[def "[cmd dir] ?[arg -all]? ?[arg -full]? ?[arg -long]?\
	  ?[arg pattern] [arg pattern] ...?"]
Cheap way to get directory listings.
Uses glob style pattern matching.

[def "[cmd dump] [arg type] ?[arg -nocomplain]? ?[arg {-filter pattern}]?\
	  ?[cmd --]? [arg pattern] ?[arg pattern] ...?"]
The dump command provides a way for the user to spit out state
information about the interpreter in a Tcl readable (and
human readable) form.
See [cmd dump](n) for details.

[def "[cmd echo] ?[arg arg] [arg arg] ...?"]
Concatenates the args and spits the result to the console (stdout).

[def "[cmd edit] ?[arg {-type type}]? ?[arg {-find str}]?\
	  ?[arg {-attach interp}]? [arg arg]"]
Opens an editor with the data from arg.
The optional type argument can be one of: [arg proc], [arg var] or [arg file].
For proc or var, the arg may be a pattern.

[def "[cmd idebug] [arg command] ?[arg args]?"]
Interactive debugging command.
See [cmd idebug](n) for details.

[def "[cmd lremove] ?[arg -all]? ?[arg -regexp] [arg -glob]?\
	  [arg list] [arg items]"]
Removes one or more items from a list and returns the new list.
If [arg -all] is specified, it removes all instances of each item
in the list.
If [arg -regexp] or [arg -glob] is specified, it interprets each item in
the items list as a regexp or glob pattern to match against.

[def [cmd less]]
Aliased to [cmd edit].

[def [cmd ls]]
Aliased to [cmd dir] [arg -full].

[def [cmd more]]
Aliased to [cmd edit].

[def "[cmd observe] [arg type] ?[arg args]?"]
This command provides passive runtime debugging output for
variables and commands.
See [cmd observe](n) for details.

[def "[cmd puts] (same options as always)"]
Redefined to put the output into TkCon.

[def "[cmd tkcon] [arg method] ?[arg args]?"]
Multi-purpose command.
See [cmd tkcon](n) for details.

[def "[cmd tclindex] [arg {?-extensions patternlist? ?-index TCL_BOOLEAN?\
	  ?-package TCL_BOOLEAN? ?dir1 dir2 ...?}]"]
Convenience proc to update the [file tclIndex] (controlled by [arg -index] switch)
and/or [file pkgIndex.tcl] (controlled by [arg -package] switch) file in the named
directories based on the given pattern for files.
It defaults to creating the [file tclIndex] but not the [file pkgIndex.tcl] file,
with the directory defaulting to [lb]pwd[rb].
The extension defaults to *.tcl, with *.[lb]info sharelibextension[rb]
added when [arg -package] is true.

[def "[cmd unalias] [arg cmd]"]
unaliases command.

[def "[cmd what] [arg string]"]
The what command will identify the word given in string in
the Tcl environment and return a list of types that it was recognized as.
Possible types are: alias, procedure, command, array variable,
scalar variable, directory, file, widget, and executable.
Used by procedures dump and which.

[def "[cmd which] [arg command]"]
Like the [syscmd which] command of Unix shells, this will tell you if a
particular command is known, and if so, whether it is internal or
external to the interpreter.
If it is an internal command and there is a slot in [cmd auto_index] for it,
it tells you the file that [cmd auto_index] would load.
This does not necessarily mean that that is where the file came from,
but if it were not in the interpreter previously, then that
is where the command was found.

[list_end]

[para]
There are several procedures that I use as helpers that some may find
helpful in there coding (i.e. expanding pathnames). Feel free to lift
them from the code (but do assign proper attribution).

[section EXAMLPES]
[para]
Some examples of tkcon command line startup situations:

[example_begin]
[cmd megawish] /usr/bin/tkcon [cmd -exec] "" [cmd -root] .tkcon [arg mainfile.tcl]
[example_end]

Use tkcon as a console for your [cmd megawish] application.
You can avoid starting the line with megawish if that is the
default [cmd wish] that TkCon would use.
The [cmd -root] ensures that tkcon will not conflict with the
application root window.

[example_begin]
[cmd tkcon] [cmd -font] "Courier 12" [cmd -load] Tk
[example_end]

Use the courier font for TkCon and always load Tk in slave
interpreters at startup.

[example_begin]
[cmd tkcon] [cmd -rcfile] ~/.wishrc [cmd -color-bg] white
[example_end]

Use the ~/.wishrc file as the resource file, and a white
background for TkCon's text widgets.

[section FILES]
TkCon will search for a resource file in [file ~/.tkconrc].
TkCon never sources the [file ~/.wishrc] file.
The resource file is sourced by each new instance of the console.
An example resource file is provided in [cmd tkconrc](5).

[see_also [cmd tkconrc](5)]
[see_also [cmd dump](n) [cmd tkcon](n) [cmd idebug](n)]
[see_also [cmd observe](n) [cmd text](n)]
[keywords Tk console]

[manpage_end]

