/*
 * Copyright (C) Research In Motion Limited 2009-2010. All rights reserved.
 * Copyright (C) 2021, 2022, 2023 Igalia S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#pragma once

#include "AffineTransform.h"
#include "RadialGradientAttributes.h"
#include "RenderSVGResourceGradient.h"
#include "SVGGradientElement.h"
#include "SVGUnitTypes.h"

namespace WebCore {

class SVGRadialGradientElement;

class RenderSVGResourceRadialGradient final : public RenderSVGResourceGradient {
    WTF_MAKE_TZONE_OR_ISO_ALLOCATED(RenderSVGResourceRadialGradient);
    WTF_OVERRIDE_DELETE_FOR_CHECKED_PTR(RenderSVGResourceRadialGradient);
public:
    RenderSVGResourceRadialGradient(SVGRadialGradientElement&, RenderStyle&&);
    virtual ~RenderSVGResourceRadialGradient();

    inline SVGRadialGradientElement& radialGradientElement() const;

    SVGUnitTypes::SVGUnitType gradientUnits() const final { return m_attributes ? m_attributes.value().gradientUnits() : SVGUnitTypes::SVG_UNIT_TYPE_UNKNOWN; }
    AffineTransform gradientTransform() const final { return m_attributes ? m_attributes.value().gradientTransform() : identity; }

    void invalidateGradient() final
    {
        m_gradient = nullptr;
        m_attributes = std::nullopt;
        repaintAllClients();
    }

private:
    void collectGradientAttributesIfNeeded() final;
    RefPtr<Gradient> createGradient(const RenderStyle&) final;

    void element() const = delete;
    ASCIILiteral renderName() const final { return "RenderSVGResourceRadialGradient"_s; }

    std::optional<RadialGradientAttributes> m_attributes;
};

}

SPECIALIZE_TYPE_TRAITS_RENDER_OBJECT(RenderSVGResourceRadialGradient, isRenderSVGResourceRadialGradient())
