#!/usr/bin/env python3




##################################################
## DEPENDENCIES
import sys
import os
import os.path
try:
    import builtins as builtin
except ImportError:
    import __builtin__ as builtin
from os.path import getmtime, exists
import time
import types
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import *
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers
from Cheetah.compat import unicode

##################################################
## MODULE CONSTANTS
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '3.2.3'
__CHEETAH_versionTuple__ = (3, 2, 3, 'final', 0)
__CHEETAH_genTime__ = 1558054970.618689
__CHEETAH_genTimestamp__ = 'Fri May 17 11:02:50 2019'
__CHEETAH_src__ = '/home/mattias/xmds-2.2.3/admin/staging/xmds-3.0.0/xpdeint/xsil2graphics2/PythonImport.tmpl'
__CHEETAH_srcLastModified__ = 'Thu Apr  4 16:29:24 2019'
__CHEETAH_docstring__ = 'Autogenerated by Cheetah: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class PythonImport(Template):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        super(PythonImport, self).__init__(*args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def description(self, **KWS):



        ## Generated from @def description: Creates text to import data from XSIL files into PyLab. at line 27, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''Creates text to import data from XSIL files into PyLab.''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def loadXSILFile(self, xsilFile, **KWS):



        ## CHEETAH: generated from @def loadXSILFile($xsilFile) at line 33, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''#!/usr/bin/env python3
from xpdeint.XSILFile import XSILFile

xsilFile = XSILFile("''')
        _v = VFFSL(SL,"xsilFile.filename",True) # '$xsilFile.filename' on line 37, col 22
        if _v is not None: write(_filter(_v, rawExpr='$xsilFile.filename')) # from line 37, col 22.
        write('''")

def firstElementOrNone(enumerable):
  for element in enumerable:
    return element
  return None

''')
        for objectNum, xsilObject in enumerate(xsilFile.xsilObjects): # generated from line 44, col 3
            for var in xsilObject.independentVariables: # generated from line 45, col 5
                varName = ''.join([str(VFFSL(SL,"var.name",True)),'_',str(VFFSL(SL,"objectNum",True)+1)])
                _v = VFFSL(SL,"varName",True) # '$varName' on line 47, col 1
                if _v is not None: write(_filter(_v, rawExpr='$varName')) # from line 47, col 1.
                write(''' = firstElementOrNone(_["array"] for _ in xsilFile.xsilObjects[''')
                _v = VFFSL(SL,"objectNum",True) # '$objectNum' on line 47, col 72
                if _v is not None: write(_filter(_v, rawExpr='$objectNum')) # from line 47, col 72.
                write('''].independentVariables if _["name"] == "''')
                _v = VFFSL(SL,"var.name",True) # '${var.name}' on line 47, col 122
                if _v is not None: write(_filter(_v, rawExpr='${var.name}')) # from line 47, col 122.
                write('''")
''')
            for var in xsilObject.dependentVariables: # generated from line 49, col 5
                varName = ''.join([str(VFFSL(SL,"var.name",True)),'_',str(VFFSL(SL,"objectNum",True)+1)])
                _v = VFFSL(SL,"varName",True) # '$varName' on line 51, col 1
                if _v is not None: write(_filter(_v, rawExpr='$varName')) # from line 51, col 1.
                write(''' = firstElementOrNone(_["array"] for _ in xsilFile.xsilObjects[''')
                _v = VFFSL(SL,"objectNum",True) # '$objectNum' on line 51, col 72
                if _v is not None: write(_filter(_v, rawExpr='$objectNum')) # from line 51, col 72.
                write('''].dependentVariables if _["name"] == "''')
                _v = VFFSL(SL,"var.name",True) # '${var.name}' on line 51, col 120
                if _v is not None: write(_filter(_v, rawExpr='${var.name}')) # from line 51, col 120.
                write('''")
''')
        write('''
# Write your plotting commands here.
# You may want to import pylab (from pylab import *) or matplotlib (from matplotlib import *)

''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def respond(self, trans=None):



        ## CHEETAH: main method generated for this template
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''
''')
        # 
        # PythonImport.tmpl
        # 
        # Created by Thomas Antioch on 2013-05-31.
        # Modified by Thomas Antioch on 2013-07-18.
        # Modified by Graham Dennis on 2013-07-28.
        # 
        # Copyright (c) 2009-2013, Joe Hope and Graham Dennis
        # 
        # This program is free software: you can redistribute it and/or modify
        # it under the terms of the GNU General Public License as published by
        # the Free Software Foundation, either version 2 of the License, or
        # (at your option) any later version.
        # 
        # This program is distributed in the hope that it will be useful,
        # but WITHOUT ANY WARRANTY; without even the implied warranty of
        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        # GNU General Public License for more details.
        # 
        # You should have received a copy of the GNU General Public License
        # along with this program.  If not, see <http://www.gnu.org/licenses/>.
        # 
        write('''



''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    name = 'Python'

    defaultExtension = 'py'

    _mainCheetahMethod_for_PythonImport = 'respond'

## END CLASS DEFINITION

if not hasattr(PythonImport, '_initCheetahAttributes'):
    templateAPIClass = getattr(PythonImport,
                               '_CHEETAH_templateClass',
                               Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(PythonImport)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit https://cheetahtemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=PythonImport()).run()


