/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.lexicoder;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.UUID;
import org.apache.accumulo.core.client.lexicoder.AbstractLexicoder;
import org.apache.accumulo.core.clientImpl.lexicoder.FixedByteArrayOutputStream;

public class UUIDLexicoder
extends AbstractLexicoder<UUID> {
    @Override
    public byte[] encode(UUID uuid) {
        try {
            byte[] ret = new byte[16];
            DataOutputStream out = new DataOutputStream(new FixedByteArrayOutputStream(ret));
            out.writeLong(uuid.getMostSignificantBits() ^ Long.MIN_VALUE);
            out.writeLong(uuid.getLeastSignificantBits() ^ Long.MIN_VALUE);
            out.close();
            return ret;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public UUID decode(byte[] b) {
        return (UUID)super.decode(b);
    }

    @Override
    protected UUID decodeUnchecked(byte[] b, int offset, int len) {
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(b, offset, len));
            return new UUID(in.readLong() ^ Long.MIN_VALUE, in.readLong() ^ Long.MIN_VALUE);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

