/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.spi.common.ServiceEnvironment;
import org.apache.accumulo.core.util.ConfigurationImpl;

public class ClientServiceEnvironmentImpl
implements ServiceEnvironment {
    private final ClientContext context;

    public ClientServiceEnvironmentImpl(ClientContext context) {
        this.context = context;
    }

    @Override
    public ServiceEnvironment.Configuration getConfiguration() {
        try {
            return new ConfigurationImpl(new ConfigurationCopy(this.context.instanceOperations().getSystemConfiguration()));
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw new RuntimeException("Error getting system configuration", e);
        }
    }

    @Override
    public ServiceEnvironment.Configuration getConfiguration(TableId tableId) {
        try {
            return new ConfigurationImpl(new ConfigurationCopy(this.context.tableOperations().getConfiguration(this.getTableName(tableId))));
        }
        catch (AccumuloException | TableNotFoundException e) {
            throw new RuntimeException("Error getting table configuration", e);
        }
    }

    @Override
    public String getTableName(TableId tableId) throws TableNotFoundException {
        return this.context.getTableName(tableId);
    }

    @Override
    public <T> T instantiate(String className, Class<T> base) throws ReflectiveOperationException {
        return ClientServiceEnvironmentImpl.class.getClassLoader().loadClass(className).asSubclass(base).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    @Override
    public <T> T instantiate(TableId tableId, String className, Class<T> base) throws ReflectiveOperationException {
        return this.instantiate(className, base);
    }
}

