/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.PropertyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AccumuloConfiguration
implements Iterable<Map.Entry<String, String>> {
    private volatile EnumMap<Property, PrefixProps> cachedPrefixProps = new EnumMap(Property.class);
    private final Lock prefixCacheUpdateLock = new ReentrantLock();
    private static final Logger log = LoggerFactory.getLogger(AccumuloConfiguration.class);
    private static final String SCAN_EXEC_THREADS = "threads";
    private static final String SCAN_EXEC_PRIORITY = "priority";
    private static final String SCAN_EXEC_PRIORITIZER = "prioritizer";
    private static final String SCAN_EXEC_PRIORITIZER_OPTS = "prioritizer.opts.";

    public String get(String property) {
        Property p = Property.getPropertyByKey(property);
        if (p != null) {
            return this.get(p);
        }
        HashMap<String, String> propMap = new HashMap<String, String>(1);
        this.getProperties(propMap, key -> Objects.equals(property, key));
        return (String)propMap.get(property);
    }

    public abstract String get(Property var1);

    public Property resolve(Property property, Property ... deprecated) {
        if (property.isDeprecated()) {
            throw new IllegalArgumentException("Unexpected deprecated " + property.name());
        }
        for (Property p : deprecated) {
            if (p.isDeprecated()) continue;
            List notDeprecated = Stream.of(deprecated).filter(Predicate.not(Property::isDeprecated)).map(Enum::name).collect(Collectors.toList());
            throw new IllegalArgumentException("Unexpected non-deprecated " + notDeprecated);
        }
        return this.isPropertySet(property) ? property : Stream.of(deprecated).filter(this::isPropertySet).findFirst().orElse(property);
    }

    public abstract void getProperties(Map<String, String> var1, Predicate<String> var2);

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        Predicate<String> all = x -> true;
        TreeMap<String, String> entries = new TreeMap<String, String>();
        this.getProperties(entries, all);
        return entries.entrySet().iterator();
    }

    private static void checkType(Property property, PropertyType type) {
        if (!property.getType().equals((Object)type)) {
            String msg = "Configuration method intended for type " + type + " called with a " + property.getType() + " argument (" + property.getKey() + ")";
            IllegalArgumentException err = new IllegalArgumentException(msg);
            log.error(msg, (Throwable)err);
            throw err;
        }
    }

    public long getUpdateCount() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getAllPropertiesWithPrefix(Property property) {
        AccumuloConfiguration.checkType(property, PropertyType.PREFIX);
        PrefixProps prefixProps = this.cachedPrefixProps.get((Object)property);
        long currentCount = this.getUpdateCount();
        if (prefixProps == null || prefixProps.updateCount != currentCount) {
            this.prefixCacheUpdateLock.lock();
            try {
                long updateCount = this.getUpdateCount();
                prefixProps = this.cachedPrefixProps.get((Object)property);
                if (prefixProps == null || prefixProps.updateCount != updateCount) {
                    Map<String, String> propMap = new HashMap<String, String>();
                    this.getProperties(propMap, key -> key.startsWith(property.getKey()));
                    propMap = Map.copyOf(propMap);
                    EnumMap<Property, PrefixProps> localPrefixes = new EnumMap<Property, PrefixProps>(Property.class);
                    localPrefixes.putAll(this.cachedPrefixProps);
                    prefixProps = new PrefixProps(propMap, updateCount);
                    localPrefixes.put(property, prefixProps);
                    this.cachedPrefixProps = localPrefixes;
                }
            }
            finally {
                this.prefixCacheUpdateLock.unlock();
            }
        }
        return prefixProps.props;
    }

    public Map<String, String> getAllPropertiesWithPrefixStripped(Property prefix) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.getAllPropertiesWithPrefix(prefix).forEach((? super K k, ? super V v) -> {
            String optKey = k.substring(prefix.getKey().length());
            builder.put((Object)optKey, v);
        });
        return builder.build();
    }

    public Map<String, String> getAllCryptoProperties() {
        HashMap<String, String> allProps = new HashMap<String, String>();
        allProps.putAll(this.getAllPropertiesWithPrefix(Property.INSTANCE_CRYPTO_PREFIX));
        allProps.putAll(this.getAllPropertiesWithPrefix(Property.GENERAL_ARBITRARY_PROP_PREFIX));
        allProps.putAll(this.getAllPropertiesWithPrefix(Property.TABLE_CRYPTO_PREFIX));
        return allProps;
    }

    public long getAsBytes(Property property) {
        String memString = this.get(property);
        if (property.getType() == PropertyType.MEMORY) {
            return ConfigurationTypeHelper.getMemoryAsBytes(memString);
        }
        if (property.getType() == PropertyType.BYTES) {
            return ConfigurationTypeHelper.getFixedMemoryAsBytes(memString);
        }
        throw new IllegalArgumentException(property.getKey() + " is not of BYTES or MEMORY type");
    }

    public long getTimeInMillis(Property property) {
        AccumuloConfiguration.checkType(property, PropertyType.TIMEDURATION);
        return ConfigurationTypeHelper.getTimeInMillis(this.get(property));
    }

    public boolean getBoolean(Property property) {
        AccumuloConfiguration.checkType(property, PropertyType.BOOLEAN);
        return Boolean.parseBoolean(this.get(property));
    }

    public double getFraction(Property property) {
        AccumuloConfiguration.checkType(property, PropertyType.FRACTION);
        return ConfigurationTypeHelper.getFraction(this.get(property));
    }

    public int[] getPort(Property property) {
        return this.getPortStream(property).toArray();
    }

    public IntStream getPortStream(Property property) {
        AccumuloConfiguration.checkType(property, PropertyType.PORT);
        String portString = this.get(property);
        try {
            return PropertyType.PortRange.parse(portString);
        }
        catch (IllegalArgumentException e) {
            try {
                int port = Integer.parseInt(portString);
                if (port == 0 || PropertyType.PortRange.VALID_RANGE.contains((Object)port)) {
                    return IntStream.of(port);
                }
                log.error("Invalid port number {}; Using default {}", (Object)port, (Object)property.getDefaultValue());
                return IntStream.of(Integer.parseInt(property.getDefaultValue()));
            }
            catch (NumberFormatException e1) {
                throw new IllegalArgumentException("Invalid port syntax. Must be a single positive integers or a range (M-N) of positive integers");
            }
        }
    }

    public int getCount(Property property) {
        AccumuloConfiguration.checkType(property, PropertyType.COUNT);
        String countString = this.get(property);
        return Integer.parseInt(countString);
    }

    public String getPath(Property property) {
        AccumuloConfiguration.checkType(property, PropertyType.PATH);
        String pathString = this.get(property);
        if (pathString == null) {
            return null;
        }
        if (pathString.contains("$ACCUMULO_")) {
            throw new IllegalArgumentException("Environment variable interpolation not supported here. Consider using '${env:ACCUMULO_HOME}' or similar in your configuration file.");
        }
        return pathString;
    }

    public int getMaxFilesPerTablet() {
        int maxFilesPerTablet = this.getCount(Property.TABLE_FILE_MAX);
        if (maxFilesPerTablet <= 0) {
            maxFilesPerTablet = this.getCount(Property.TSERV_SCAN_MAX_OPENFILES) - 1;
            log.debug("Max files per tablet {}", (Object)maxFilesPerTablet);
        }
        return maxFilesPerTablet;
    }

    public abstract boolean isPropertySet(Property var1);

    public <T> Deriver<T> newDeriver(Function<AccumuloConfiguration, T> converter) {
        return new DeriverImpl<T>(converter);
    }

    public Collection<ScanExecutorConfig> getScanExecutors(boolean isScanServer) {
        Property prefix = isScanServer ? Property.SSERV_SCAN_EXECUTORS_PREFIX : Property.TSERV_SCAN_EXECUTORS_PREFIX;
        HashMap<String, Map> propsByName = new HashMap<String, Map>();
        ArrayList<ScanExecutorConfig> scanResources = new ArrayList<ScanExecutorConfig>();
        for (Map.Entry<String, String> entry : this.getAllPropertiesWithPrefix(prefix).entrySet()) {
            String suffix = entry.getKey().substring(prefix.getKey().length());
            String[] tokens = suffix.split("\\.", 2);
            String name = tokens[0];
            propsByName.computeIfAbsent(name, k -> new HashMap()).put(tokens[1], entry.getValue());
        }
        for (Map.Entry<String, String> entry : propsByName.entrySet()) {
            String name = entry.getKey();
            Integer threads = null;
            Integer prio = null;
            String prioritizerClass = null;
            HashMap<String, String> prioritizerOpts = new HashMap<String, String>();
            for (Map.Entry subEntry : ((Map)((Object)entry.getValue())).entrySet()) {
                String opt = (String)subEntry.getKey();
                String val = (String)subEntry.getValue();
                if (opt.equals(SCAN_EXEC_THREADS)) {
                    threads = Integer.parseInt(val);
                    continue;
                }
                if (opt.equals(SCAN_EXEC_PRIORITY)) {
                    prio = Integer.parseInt(val);
                    continue;
                }
                if (opt.equals(SCAN_EXEC_PRIORITIZER)) {
                    prioritizerClass = val;
                    continue;
                }
                if (opt.startsWith(SCAN_EXEC_PRIORITIZER_OPTS)) {
                    String key = opt.substring(SCAN_EXEC_PRIORITIZER_OPTS.length());
                    if (key.isEmpty()) {
                        throw new IllegalStateException("Invalid scan executor option : " + opt);
                    }
                    prioritizerOpts.put(key, val);
                    continue;
                }
                throw new IllegalStateException("Unknown scan executor option : " + opt);
            }
            Preconditions.checkArgument((threads != null && threads > 0 ? 1 : 0) != 0, (String)"Scan resource %s incorrectly specified threads", (Object)name);
            scanResources.add(new ScanExecutorConfig(name, threads, prio == null ? OptionalInt.empty() : OptionalInt.of(prio), Optional.ofNullable(prioritizerClass), prioritizerOpts, isScanServer));
        }
        return scanResources;
    }

    public void invalidateCache() {
    }

    public AccumuloConfiguration getParent() {
        return null;
    }

    public Stream<Map.Entry<String, String>> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public static interface Deriver<T> {
        public T derive();
    }

    private class DeriverImpl<T>
    implements Deriver<T> {
        private final AtomicReference<RefCount<T>> refref = new AtomicReference();
        private final Function<AccumuloConfiguration, T> converter;

        DeriverImpl(Function<AccumuloConfiguration, T> converter) {
            this.converter = converter;
        }

        @Override
        public T derive() {
            long uc = AccumuloConfiguration.this.getUpdateCount();
            RefCount<T> rc = this.refref.get();
            if (rc == null || rc.count != uc) {
                T newObj = this.converter.apply(AccumuloConfiguration.this);
                RefCount<T> nrc = new RefCount<T>(uc, newObj);
                this.refref.compareAndSet(rc, nrc);
                return nrc.obj;
            }
            return rc.obj;
        }
    }

    private static class RefCount<T> {
        T obj;
        long count;

        RefCount(long c, T r) {
            this.count = c;
            this.obj = r;
        }
    }

    public class ScanExecutorConfig {
        public final String name;
        public final int maxThreads;
        public final OptionalInt priority;
        public final Optional<String> prioritizerClass;
        public final Map<String, String> prioritizerOpts;
        public final boolean isScanServer;

        public ScanExecutorConfig(String name, int maxThreads, OptionalInt priority, Optional<String> comparatorFactory, Map<String, String> comparatorFactoryOpts, boolean isScanServer) {
            this.name = name;
            this.maxThreads = maxThreads;
            this.priority = priority;
            this.prioritizerClass = comparatorFactory;
            this.prioritizerOpts = comparatorFactoryOpts;
            this.isScanServer = isScanServer;
        }

        public int getCurrentMaxThreads() {
            if (this.isScanServer) {
                String prop = Property.SSERV_SCAN_EXECUTORS_PREFIX.getKey() + this.name + ".threads";
                String val = AccumuloConfiguration.this.getAllPropertiesWithPrefix(Property.SSERV_SCAN_EXECUTORS_PREFIX).get(prop);
                return Integer.parseInt(val);
            }
            String prop = Property.TSERV_SCAN_EXECUTORS_PREFIX.getKey() + this.name + ".threads";
            String val = AccumuloConfiguration.this.getAllPropertiesWithPrefix(Property.TSERV_SCAN_EXECUTORS_PREFIX).get(prop);
            return Integer.parseInt(val);
        }
    }

    private static class PrefixProps {
        final long updateCount;
        final Map<String, String> props;

        PrefixProps(Map<String, String> props, long updateCount) {
            this.updateCount = updateCount;
            this.props = props;
        }
    }
}

