/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.fate;

import com.google.common.util.concurrent.Uninterruptibles;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.fate.Fate;
import org.apache.accumulo.core.fate.FateTxId;
import org.apache.accumulo.core.fate.ReadOnlyRepo;
import org.apache.accumulo.core.fate.ReadOnlyTStore;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.fate.StackOverflowException;
import org.apache.accumulo.core.fate.TStore;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.util.FastFormat;
import org.apache.accumulo.core.util.LazySingletons;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooStore<T>
implements TStore<T> {
    private static final Logger log = LoggerFactory.getLogger(ZooStore.class);
    private String path;
    private ZooReaderWriter zk;
    private String lastReserved = "";
    private Set<Long> reserved;
    private Map<Long, Long> defered;
    private long statusChangeEvents = 0L;
    private int reservationsWaiting = 0;
    private static final int RETRIES = 10;

    private byte[] serialize(Object o) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            oos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @SuppressFBWarnings(value={"OBJECT_DESERIALIZATION"}, justification="unsafe to store arbitrary serialized objects like this, but needed for now for backwards compatibility")
    private Object deserialize(byte[] ser) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(ser);
            ObjectInputStream ois = new ObjectInputStream(bais);
            return ois.readObject();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    private String getTXPath(long tid) {
        return FastFormat.toHexString(this.path + "/tx_", tid, "");
    }

    private long parseTid(String txdir) {
        return Long.parseLong(txdir.split("_")[1], 16);
    }

    public ZooStore(String path, ZooReaderWriter zk) throws KeeperException, InterruptedException {
        this.path = path;
        this.zk = zk;
        this.reserved = new HashSet<Long>();
        this.defered = new HashMap<Long, Long>();
        zk.putPersistentData(path, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
    }

    ZooStore() {
    }

    /*
     * Loose catch block
     */
    @Override
    public long create() {
        while (true) {
            try {
                long tid = LazySingletons.RANDOM.get().nextLong() & Long.MAX_VALUE;
                this.zk.putPersistentData(this.getTXPath(tid), ReadOnlyTStore.TStatus.NEW.name().getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.FAIL);
                return tid;
            }
            catch (KeeperException.NodeExistsException tid) {
                continue;
            }
            break;
        }
        catch (InterruptedException | KeeperException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long reserve() {
        try {
            while (true) {
                long events;
                ZooStore zooStore = this;
                synchronized (zooStore) {
                    events = this.statusChangeEvents;
                }
                ArrayList<String> txdirs = new ArrayList<String>(this.zk.getChildren(this.path));
                Collections.sort(txdirs);
                Object object = this;
                synchronized (object) {
                    if (!txdirs.isEmpty() && ((String)txdirs.get(txdirs.size() - 1)).compareTo(this.lastReserved) <= 0) {
                        this.lastReserved = "";
                    }
                }
                for (String txdir : txdirs) {
                    long tid = this.parseTid(txdir);
                    ZooStore zooStore2 = this;
                    synchronized (zooStore2) {
                        if (txdir.compareTo(this.lastReserved) <= 0) {
                            continue;
                        }
                        if (this.defered.containsKey(tid)) {
                            if (this.defered.get(tid) < System.currentTimeMillis()) {
                                this.defered.remove(tid);
                            } else {
                                continue;
                            }
                        }
                        if (this.reserved.contains(tid)) {
                            continue;
                        }
                        this.reserved.add(tid);
                        this.lastReserved = txdir;
                    }
                    try {
                        ReadOnlyTStore.TStatus status = ReadOnlyTStore.TStatus.valueOf(new String(this.zk.getData(this.path + "/" + txdir), StandardCharsets.UTF_8));
                        if (status == ReadOnlyTStore.TStatus.SUBMITTED || status == ReadOnlyTStore.TStatus.IN_PROGRESS || status == ReadOnlyTStore.TStatus.FAILED_IN_PROGRESS) {
                            return tid;
                        }
                        this.unreserve(tid);
                    }
                    catch (KeeperException.NoNodeException nne) {
                        this.unreserve(tid);
                    }
                    catch (InterruptedException | RuntimeException | KeeperException e) {
                        this.unreserve(tid);
                        throw e;
                    }
                }
                object = this;
                synchronized (object) {
                    if (events == this.statusChangeEvents) {
                        if (this.defered.isEmpty()) {
                            this.wait(5000L);
                        } else {
                            Long minTime = Collections.min(this.defered.values());
                            long waitTime = minTime - System.currentTimeMillis();
                            if (waitTime > 0L) {
                                this.wait(Math.min(waitTime, 5000L));
                            }
                        }
                    }
                }
            }
        }
        catch (InterruptedException | KeeperException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reserve(long tid) {
        ZooStore zooStore = this;
        synchronized (zooStore) {
            ++this.reservationsWaiting;
            try {
                while (this.reserved.contains(tid)) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new IllegalStateException(e);
                    }
                }
                this.reserved.add(tid);
            }
            finally {
                --this.reservationsWaiting;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryReserve(long tid) {
        ZooStore zooStore = this;
        synchronized (zooStore) {
            if (!this.reserved.contains(tid)) {
                this.reserve(tid);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unreserve(long tid) {
        ZooStore zooStore = this;
        synchronized (zooStore) {
            if (!this.reserved.remove(tid)) {
                throw new IllegalStateException("Tried to unreserve id that was not reserved " + FateTxId.formatTid(tid));
            }
            if (this.reservationsWaiting > 0) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unreserve(long tid, long deferTime) {
        if (deferTime < 0L) {
            throw new IllegalArgumentException("deferTime < 0 : " + deferTime);
        }
        ZooStore zooStore = this;
        synchronized (zooStore) {
            if (!this.reserved.remove(tid)) {
                throw new IllegalStateException("Tried to unreserve id that was not reserved " + FateTxId.formatTid(tid));
            }
            if (deferTime > 0L) {
                this.defered.put(tid, System.currentTimeMillis() + deferTime);
            }
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyReserved(long tid) {
        ZooStore zooStore = this;
        synchronized (zooStore) {
            if (!this.reserved.contains(tid)) {
                throw new IllegalStateException("Tried to operate on unreserved transaction " + FateTxId.formatTid(tid));
            }
        }
    }

    @Override
    public Repo<T> top(long tid) {
        this.verifyReserved(tid);
        for (int i = 0; i < 10; ++i) {
            String txpath = this.getTXPath(tid);
            try {
                String top;
                try {
                    top = this.findTop(txpath);
                    if (top == null) {
                        return null;
                    }
                }
                catch (KeeperException.NoNodeException ex) {
                    throw new IllegalStateException(ex);
                }
                byte[] ser = this.zk.getData(txpath + "/" + top);
                Repo deserialized = (Repo)this.deserialize(ser);
                return deserialized;
            }
            catch (KeeperException.NoNodeException ex) {
                log.debug("zookeeper error reading " + txpath + ": " + ex, (Throwable)ex);
                Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                continue;
            }
            catch (InterruptedException | KeeperException e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    private String findTop(String txpath) throws KeeperException, InterruptedException {
        List<String> ops = this.zk.getChildren(txpath);
        ops = new ArrayList<String>(ops);
        String max = "";
        for (String child : ops) {
            if (!child.startsWith("repo_") || child.compareTo(max) <= 0) continue;
            max = child;
        }
        if (max.equals("")) {
            return null;
        }
        return max;
    }

    @Override
    public void push(long tid, Repo<T> repo) throws StackOverflowException {
        this.verifyReserved(tid);
        String txpath = this.getTXPath(tid);
        try {
            String top = this.findTop(txpath);
            if (top != null && Long.parseLong(top.split("_")[1]) > 100L) {
                throw new StackOverflowException("Repo stack size too large");
            }
            this.zk.putPersistentSequential(txpath + "/repo_", this.serialize(repo));
        }
        catch (StackOverflowException soe) {
            throw soe;
        }
        catch (InterruptedException | KeeperException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void pop(long tid) {
        this.verifyReserved(tid);
        try {
            String txpath = this.getTXPath(tid);
            String top = this.findTop(txpath);
            if (top == null) {
                throw new IllegalStateException("Tried to pop when empty " + FateTxId.formatTid(tid));
            }
            this.zk.recursiveDelete(txpath + "/" + top, ZooUtil.NodeMissingPolicy.SKIP);
        }
        catch (InterruptedException | KeeperException e) {
            throw new IllegalStateException(e);
        }
    }

    private ReadOnlyTStore.TStatus _getStatus(long tid) {
        try {
            return ReadOnlyTStore.TStatus.valueOf(new String(this.zk.getData(this.getTXPath(tid)), StandardCharsets.UTF_8));
        }
        catch (KeeperException.NoNodeException nne) {
            return ReadOnlyTStore.TStatus.UNKNOWN;
        }
        catch (InterruptedException | KeeperException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public ReadOnlyTStore.TStatus getStatus(long tid) {
        this.verifyReserved(tid);
        return this._getStatus(tid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadOnlyTStore.TStatus waitForStatusChange(long tid, EnumSet<ReadOnlyTStore.TStatus> expected) {
        while (true) {
            long events;
            ZooStore zooStore = this;
            synchronized (zooStore) {
                events = this.statusChangeEvents;
            }
            ReadOnlyTStore.TStatus status = this._getStatus(tid);
            if (expected.contains((Object)status)) {
                return status;
            }
            ZooStore zooStore2 = this;
            synchronized (zooStore2) {
                if (events == this.statusChangeEvents) {
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException e) {
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatus(long tid, ReadOnlyTStore.TStatus status) {
        this.verifyReserved(tid);
        try {
            this.zk.putPersistentData(this.getTXPath(tid), status.name().getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.OVERWRITE);
        }
        catch (InterruptedException | KeeperException e) {
            throw new IllegalStateException(e);
        }
        ZooStore zooStore = this;
        synchronized (zooStore) {
            ++this.statusChangeEvents;
        }
    }

    @Override
    public void delete(long tid) {
        this.verifyReserved(tid);
        try {
            this.zk.recursiveDelete(this.getTXPath(tid), ZooUtil.NodeMissingPolicy.SKIP);
        }
        catch (InterruptedException | KeeperException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void setTransactionInfo(long tid, Fate.TxInfo txInfo, Serializable so) {
        this.verifyReserved(tid);
        try {
            if (so instanceof String) {
                this.zk.putPersistentData(this.getTXPath(tid) + "/" + txInfo, ("S " + so).getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.OVERWRITE);
            } else {
                byte[] sera = this.serialize(so);
                byte[] data = new byte[sera.length + 2];
                System.arraycopy(sera, 0, data, 2, sera.length);
                data[0] = 79;
                data[1] = 32;
                this.zk.putPersistentData(this.getTXPath(tid) + "/" + txInfo, data, ZooUtil.NodeExistsPolicy.OVERWRITE);
            }
        }
        catch (InterruptedException | KeeperException e2) {
            throw new IllegalStateException(e2);
        }
    }

    @Override
    public Serializable getTransactionInfo(long tid, Fate.TxInfo txInfo) {
        this.verifyReserved(tid);
        try {
            byte[] data = this.zk.getData(this.getTXPath(tid) + "/" + txInfo);
            if (data[0] == 79) {
                byte[] sera = new byte[data.length - 2];
                System.arraycopy(data, 2, sera, 0, sera.length);
                return (Serializable)this.deserialize(sera);
            }
            if (data[0] == 83) {
                return new String(data, 2, data.length - 2, StandardCharsets.UTF_8);
            }
            throw new IllegalStateException("Bad node data " + txInfo);
        }
        catch (KeeperException.NoNodeException nne) {
            return null;
        }
        catch (InterruptedException | KeeperException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<Long> list() {
        try {
            ArrayList<Long> l = new ArrayList<Long>();
            List<String> transactions = this.zk.getChildren(this.path);
            for (String txid : transactions) {
                l.add(this.parseTid(txid));
            }
            return l;
        }
        catch (InterruptedException | KeeperException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public long timeCreated(long tid) {
        this.verifyReserved(tid);
        try {
            Stat stat = this.zk.getZooKeeper().exists(this.getTXPath(tid), false);
            return stat.getCtime();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    @Override
    public List<ReadOnlyRepo<T>> getStack(long tid) {
        ArrayList<ReadOnlyRepo<T>> dops;
        String txpath = this.getTXPath(tid);
        block6: while (true) {
            List<String> ops;
            try {
                ops = this.zk.getChildren(txpath);
            }
            catch (KeeperException.NoNodeException e) {
                return Collections.emptyList();
            }
            catch (InterruptedException | KeeperException e1) {
                throw new IllegalStateException(e1);
            }
            ops = new ArrayList<String>(ops);
            ops.sort(Collections.reverseOrder());
            dops = new ArrayList<ReadOnlyRepo<T>>();
            for (String child : ops) {
                if (!child.startsWith("repo_")) continue;
                try {
                    byte[] ser = this.zk.getData(txpath + "/" + child);
                    ReadOnlyRepo repo = (ReadOnlyRepo)this.deserialize(ser);
                    dops.add(repo);
                }
                catch (KeeperException.NoNodeException e) {
                    continue block6;
                }
                catch (InterruptedException | KeeperException e) {
                    throw new IllegalStateException(e);
                }
            }
            break;
        }
        return dops;
    }
}

