/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iteratorsImpl.system;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.ServerFilter;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;

public class ColumnQualifierFilter
extends ServerFilter {
    private HashSet<ByteSequence> columnFamilies;
    private HashMap<ByteSequence, HashSet<ByteSequence>> columnsQualifiers;

    private ColumnQualifierFilter(SortedKeyValueIterator<Key, Value> iterator, Set<Column> columns) {
        super(iterator);
        this.columnFamilies = new HashSet();
        this.columnsQualifiers = new HashMap();
        columns.forEach(col -> {
            if (col.columnQualifier != null) {
                this.columnsQualifiers.computeIfAbsent(new ArrayByteSequence(col.columnQualifier), k -> new HashSet()).add(new ArrayByteSequence(col.columnFamily));
            } else {
                this.columnFamilies.add(new ArrayByteSequence(col.columnFamily));
            }
        });
    }

    private ColumnQualifierFilter(SortedKeyValueIterator<Key, Value> iterator, HashSet<ByteSequence> columnFamilies, HashMap<ByteSequence, HashSet<ByteSequence>> columnsQualifiers) {
        super(iterator);
        this.columnFamilies = columnFamilies;
        this.columnsQualifiers = columnsQualifiers;
    }

    @Override
    public boolean accept(Key key, Value v) {
        if (this.columnFamilies.contains(key.getColumnFamilyData())) {
            return true;
        }
        HashSet<ByteSequence> cfset = this.columnsQualifiers.get(key.getColumnQualifierData());
        return cfset != null && cfset.contains(key.getColumnFamilyData());
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        return new ColumnQualifierFilter(this.source.deepCopy(env), this.columnFamilies, this.columnsQualifiers);
    }

    public static SortedKeyValueIterator<Key, Value> wrap(SortedKeyValueIterator<Key, Value> source, Set<Column> cols) {
        boolean sawNonNullQual = false;
        for (Column col : cols) {
            if (col.getColumnQualifier() == null) continue;
            sawNonNullQual = true;
            break;
        }
        if (sawNonNullQual) {
            return new ColumnQualifierFilter(source, cols);
        }
        return source;
    }
}

