/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.spi.fs;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.spi.fs.VolumeChooser;
import org.apache.accumulo.core.spi.fs.VolumeChooserEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingChooser
implements VolumeChooser {
    private static final Logger log = LoggerFactory.getLogger(DelegatingChooser.class);
    private final ConcurrentHashMap<TableId, VolumeChooser> tableSpecificChooserCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<VolumeChooserEnvironment.Scope, VolumeChooser> scopeSpecificChooserCache = new ConcurrentHashMap();
    private static final String TABLE_CUSTOM_SUFFIX = "volume.chooser";
    private static final String DEFAULT_SCOPED_VOLUME_CHOOSER = DelegatingChooser.getCustomPropertySuffix(VolumeChooserEnvironment.Scope.DEFAULT);

    private static final String getCustomPropertySuffix(VolumeChooserEnvironment.Scope scope) {
        return "volume.chooser." + scope.name().toLowerCase();
    }

    @Override
    public String choose(VolumeChooserEnvironment env, Set<String> options) {
        log.trace("{}.choose", (Object)this.getClass().getSimpleName());
        return this.getDelegateChooser(env).choose(env, options);
    }

    @Override
    public Set<String> choosable(VolumeChooserEnvironment env, Set<String> options) {
        return this.getDelegateChooser(env).choosable(env, options);
    }

    VolumeChooser getDelegateChooser(VolumeChooserEnvironment env) {
        if (env.getChooserScope() == VolumeChooserEnvironment.Scope.TABLE) {
            return this.getVolumeChooserForTable(env);
        }
        return this.getVolumeChooserForScope(env);
    }

    private VolumeChooser getVolumeChooserForTable(VolumeChooserEnvironment env) {
        log.trace("Looking up property {} for table id: {}", (Object)TABLE_CUSTOM_SUFFIX, env.getTable());
        String clazz = env.getServiceEnv().getConfiguration(env.getTable().orElseThrow()).getTableCustom(TABLE_CUSTOM_SUFFIX);
        if (clazz == null || clazz.isEmpty()) {
            clazz = env.getServiceEnv().getConfiguration().getCustom(DEFAULT_SCOPED_VOLUME_CHOOSER);
        }
        if (clazz == null || clazz.isEmpty()) {
            String msg = "Property " + Property.TABLE_ARBITRARY_PROP_PREFIX + "volume.chooser or " + Property.GENERAL_ARBITRARY_PROP_PREFIX + DEFAULT_SCOPED_VOLUME_CHOOSER + " must be a valid " + VolumeChooser.class.getSimpleName() + " to use the " + this.getClass().getSimpleName();
            throw new IllegalStateException(msg);
        }
        return this.createVolumeChooser(env, clazz, TABLE_CUSTOM_SUFFIX, env.getTable().orElseThrow(), this.tableSpecificChooserCache);
    }

    private VolumeChooser getVolumeChooserForScope(VolumeChooserEnvironment env) {
        VolumeChooserEnvironment.Scope scope = env.getChooserScope();
        String property = DelegatingChooser.getCustomPropertySuffix(scope);
        log.trace("Looking up property {} for scope: {}", (Object)property, (Object)scope);
        String clazz = env.getServiceEnv().getConfiguration().getCustom(property);
        if ((clazz == null || clazz.isEmpty()) && scope != VolumeChooserEnvironment.Scope.DEFAULT) {
            log.debug("{} not found; using {}", (Object)(Property.TABLE_ARBITRARY_PROP_PREFIX + property), (Object)(Property.GENERAL_ARBITRARY_PROP_PREFIX + DEFAULT_SCOPED_VOLUME_CHOOSER));
            clazz = env.getServiceEnv().getConfiguration().getCustom(DEFAULT_SCOPED_VOLUME_CHOOSER);
            if (clazz == null || clazz.isEmpty()) {
                String msg = "Property " + Property.TABLE_ARBITRARY_PROP_PREFIX + property + " or " + Property.GENERAL_ARBITRARY_PROP_PREFIX + DEFAULT_SCOPED_VOLUME_CHOOSER + " must be a valid " + VolumeChooser.class.getSimpleName() + " to use the " + this.getClass().getSimpleName();
                throw new IllegalStateException(msg);
            }
            property = DEFAULT_SCOPED_VOLUME_CHOOSER;
        }
        return this.createVolumeChooser(env, clazz, property, scope, this.scopeSpecificChooserCache);
    }

    private <T> VolumeChooser createVolumeChooser(VolumeChooserEnvironment env, String clazz, String property, T key, ConcurrentHashMap<T, VolumeChooser> cache) {
        String className = clazz.trim();
        return cache.compute(key, (k, previousChooser) -> {
            if (previousChooser != null && previousChooser.getClass().getName().equals(className)) {
                return previousChooser;
            }
            if (previousChooser == null) {
                log.trace("Change detected for {} for {}", (Object)property, key);
            }
            try {
                if (key instanceof TableId) {
                    TableId tableId = (TableId)key;
                    return env.getServiceEnv().instantiate(tableId, className, VolumeChooser.class);
                }
                return env.getServiceEnv().instantiate(className, VolumeChooser.class);
            }
            catch (ReflectiveOperationException e) {
                String msg = "Failed to create instance for " + key + " configured to use " + className + " via " + property;
                throw new IllegalStateException(msg, e);
            }
        });
    }
}

