/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.tabletserver.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.dataImpl.thrift.TKeyExtent;
import org.apache.accumulo.core.tabletserver.thrift.InputFile;
import org.apache.accumulo.core.tabletserver.thrift.IteratorConfig;
import org.apache.accumulo.core.tabletserver.thrift.TCompactionKind;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TExternalCompactionJob
implements TBase<TExternalCompactionJob, _Fields>,
Serializable,
Cloneable,
Comparable<TExternalCompactionJob> {
    private static final TStruct STRUCT_DESC = new TStruct("TExternalCompactionJob");
    private static final TField EXTERNAL_COMPACTION_ID_FIELD_DESC = new TField("externalCompactionId", 11, 1);
    private static final TField EXTENT_FIELD_DESC = new TField("extent", 12, 2);
    private static final TField FILES_FIELD_DESC = new TField("files", 15, 3);
    private static final TField ITERATOR_SETTINGS_FIELD_DESC = new TField("iteratorSettings", 12, 4);
    private static final TField OUTPUT_FILE_FIELD_DESC = new TField("outputFile", 11, 5);
    private static final TField PROPAGATE_DELETES_FIELD_DESC = new TField("propagateDeletes", 2, 6);
    private static final TField KIND_FIELD_DESC = new TField("kind", 8, 7);
    private static final TField USER_COMPACTION_ID_FIELD_DESC = new TField("userCompactionId", 10, 8);
    private static final TField OVERRIDES_FIELD_DESC = new TField("overrides", 13, 9);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TExternalCompactionJobStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TExternalCompactionJobTupleSchemeFactory();
    @Nullable
    public String externalCompactionId;
    @Nullable
    public TKeyExtent extent;
    @Nullable
    public List<InputFile> files;
    @Nullable
    public IteratorConfig iteratorSettings;
    @Nullable
    public String outputFile;
    public boolean propagateDeletes;
    @Nullable
    public TCompactionKind kind;
    public long userCompactionId;
    @Nullable
    public Map<String, String> overrides;
    private static final int __PROPAGATEDELETES_ISSET_ID = 0;
    private static final int __USERCOMPACTIONID_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TExternalCompactionJob() {
    }

    public TExternalCompactionJob(String externalCompactionId, TKeyExtent extent, List<InputFile> files, IteratorConfig iteratorSettings, String outputFile, boolean propagateDeletes, TCompactionKind kind, long userCompactionId, Map<String, String> overrides) {
        this();
        this.externalCompactionId = externalCompactionId;
        this.extent = extent;
        this.files = files;
        this.iteratorSettings = iteratorSettings;
        this.outputFile = outputFile;
        this.propagateDeletes = propagateDeletes;
        this.setPropagateDeletesIsSet(true);
        this.kind = kind;
        this.userCompactionId = userCompactionId;
        this.setUserCompactionIdIsSet(true);
        this.overrides = overrides;
    }

    public TExternalCompactionJob(TExternalCompactionJob other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetExternalCompactionId()) {
            this.externalCompactionId = other.externalCompactionId;
        }
        if (other.isSetExtent()) {
            this.extent = new TKeyExtent(other.extent);
        }
        if (other.isSetFiles()) {
            ArrayList<InputFile> __this__files = new ArrayList<InputFile>(other.files.size());
            for (InputFile other_element : other.files) {
                __this__files.add(new InputFile(other_element));
            }
            this.files = __this__files;
        }
        if (other.isSetIteratorSettings()) {
            this.iteratorSettings = new IteratorConfig(other.iteratorSettings);
        }
        if (other.isSetOutputFile()) {
            this.outputFile = other.outputFile;
        }
        this.propagateDeletes = other.propagateDeletes;
        if (other.isSetKind()) {
            this.kind = other.kind;
        }
        this.userCompactionId = other.userCompactionId;
        if (other.isSetOverrides()) {
            HashMap<String, String> __this__overrides = new HashMap<String, String>(other.overrides);
            this.overrides = __this__overrides;
        }
    }

    public TExternalCompactionJob deepCopy() {
        return new TExternalCompactionJob(this);
    }

    public void clear() {
        this.externalCompactionId = null;
        this.extent = null;
        this.files = null;
        this.iteratorSettings = null;
        this.outputFile = null;
        this.setPropagateDeletesIsSet(false);
        this.propagateDeletes = false;
        this.kind = null;
        this.setUserCompactionIdIsSet(false);
        this.userCompactionId = 0L;
        this.overrides = null;
    }

    @Nullable
    public String getExternalCompactionId() {
        return this.externalCompactionId;
    }

    public TExternalCompactionJob setExternalCompactionId(@Nullable String externalCompactionId) {
        this.externalCompactionId = externalCompactionId;
        return this;
    }

    public void unsetExternalCompactionId() {
        this.externalCompactionId = null;
    }

    public boolean isSetExternalCompactionId() {
        return this.externalCompactionId != null;
    }

    public void setExternalCompactionIdIsSet(boolean value) {
        if (!value) {
            this.externalCompactionId = null;
        }
    }

    @Nullable
    public TKeyExtent getExtent() {
        return this.extent;
    }

    public TExternalCompactionJob setExtent(@Nullable TKeyExtent extent) {
        this.extent = extent;
        return this;
    }

    public void unsetExtent() {
        this.extent = null;
    }

    public boolean isSetExtent() {
        return this.extent != null;
    }

    public void setExtentIsSet(boolean value) {
        if (!value) {
            this.extent = null;
        }
    }

    public int getFilesSize() {
        return this.files == null ? 0 : this.files.size();
    }

    @Nullable
    public Iterator<InputFile> getFilesIterator() {
        return this.files == null ? null : this.files.iterator();
    }

    public void addToFiles(InputFile elem) {
        if (this.files == null) {
            this.files = new ArrayList<InputFile>();
        }
        this.files.add(elem);
    }

    @Nullable
    public List<InputFile> getFiles() {
        return this.files;
    }

    public TExternalCompactionJob setFiles(@Nullable List<InputFile> files) {
        this.files = files;
        return this;
    }

    public void unsetFiles() {
        this.files = null;
    }

    public boolean isSetFiles() {
        return this.files != null;
    }

    public void setFilesIsSet(boolean value) {
        if (!value) {
            this.files = null;
        }
    }

    @Nullable
    public IteratorConfig getIteratorSettings() {
        return this.iteratorSettings;
    }

    public TExternalCompactionJob setIteratorSettings(@Nullable IteratorConfig iteratorSettings) {
        this.iteratorSettings = iteratorSettings;
        return this;
    }

    public void unsetIteratorSettings() {
        this.iteratorSettings = null;
    }

    public boolean isSetIteratorSettings() {
        return this.iteratorSettings != null;
    }

    public void setIteratorSettingsIsSet(boolean value) {
        if (!value) {
            this.iteratorSettings = null;
        }
    }

    @Nullable
    public String getOutputFile() {
        return this.outputFile;
    }

    public TExternalCompactionJob setOutputFile(@Nullable String outputFile) {
        this.outputFile = outputFile;
        return this;
    }

    public void unsetOutputFile() {
        this.outputFile = null;
    }

    public boolean isSetOutputFile() {
        return this.outputFile != null;
    }

    public void setOutputFileIsSet(boolean value) {
        if (!value) {
            this.outputFile = null;
        }
    }

    public boolean isPropagateDeletes() {
        return this.propagateDeletes;
    }

    public TExternalCompactionJob setPropagateDeletes(boolean propagateDeletes) {
        this.propagateDeletes = propagateDeletes;
        this.setPropagateDeletesIsSet(true);
        return this;
    }

    public void unsetPropagateDeletes() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetPropagateDeletes() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setPropagateDeletesIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    @Nullable
    public TCompactionKind getKind() {
        return this.kind;
    }

    public TExternalCompactionJob setKind(@Nullable TCompactionKind kind) {
        this.kind = kind;
        return this;
    }

    public void unsetKind() {
        this.kind = null;
    }

    public boolean isSetKind() {
        return this.kind != null;
    }

    public void setKindIsSet(boolean value) {
        if (!value) {
            this.kind = null;
        }
    }

    public long getUserCompactionId() {
        return this.userCompactionId;
    }

    public TExternalCompactionJob setUserCompactionId(long userCompactionId) {
        this.userCompactionId = userCompactionId;
        this.setUserCompactionIdIsSet(true);
        return this;
    }

    public void unsetUserCompactionId() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetUserCompactionId() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setUserCompactionIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public int getOverridesSize() {
        return this.overrides == null ? 0 : this.overrides.size();
    }

    public void putToOverrides(String key, String val) {
        if (this.overrides == null) {
            this.overrides = new HashMap<String, String>();
        }
        this.overrides.put(key, val);
    }

    @Nullable
    public Map<String, String> getOverrides() {
        return this.overrides;
    }

    public TExternalCompactionJob setOverrides(@Nullable Map<String, String> overrides) {
        this.overrides = overrides;
        return this;
    }

    public void unsetOverrides() {
        this.overrides = null;
    }

    public boolean isSetOverrides() {
        return this.overrides != null;
    }

    public void setOverridesIsSet(boolean value) {
        if (!value) {
            this.overrides = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case EXTERNAL_COMPACTION_ID: {
                if (value == null) {
                    this.unsetExternalCompactionId();
                    break;
                }
                this.setExternalCompactionId((String)value);
                break;
            }
            case EXTENT: {
                if (value == null) {
                    this.unsetExtent();
                    break;
                }
                this.setExtent((TKeyExtent)value);
                break;
            }
            case FILES: {
                if (value == null) {
                    this.unsetFiles();
                    break;
                }
                this.setFiles((List)value);
                break;
            }
            case ITERATOR_SETTINGS: {
                if (value == null) {
                    this.unsetIteratorSettings();
                    break;
                }
                this.setIteratorSettings((IteratorConfig)value);
                break;
            }
            case OUTPUT_FILE: {
                if (value == null) {
                    this.unsetOutputFile();
                    break;
                }
                this.setOutputFile((String)value);
                break;
            }
            case PROPAGATE_DELETES: {
                if (value == null) {
                    this.unsetPropagateDeletes();
                    break;
                }
                this.setPropagateDeletes((Boolean)value);
                break;
            }
            case KIND: {
                if (value == null) {
                    this.unsetKind();
                    break;
                }
                this.setKind((TCompactionKind)((Object)value));
                break;
            }
            case USER_COMPACTION_ID: {
                if (value == null) {
                    this.unsetUserCompactionId();
                    break;
                }
                this.setUserCompactionId((Long)value);
                break;
            }
            case OVERRIDES: {
                if (value == null) {
                    this.unsetOverrides();
                    break;
                }
                this.setOverrides((Map)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case EXTERNAL_COMPACTION_ID: {
                return this.getExternalCompactionId();
            }
            case EXTENT: {
                return this.getExtent();
            }
            case FILES: {
                return this.getFiles();
            }
            case ITERATOR_SETTINGS: {
                return this.getIteratorSettings();
            }
            case OUTPUT_FILE: {
                return this.getOutputFile();
            }
            case PROPAGATE_DELETES: {
                return this.isPropagateDeletes();
            }
            case KIND: {
                return this.getKind();
            }
            case USER_COMPACTION_ID: {
                return this.getUserCompactionId();
            }
            case OVERRIDES: {
                return this.getOverrides();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case EXTERNAL_COMPACTION_ID: {
                return this.isSetExternalCompactionId();
            }
            case EXTENT: {
                return this.isSetExtent();
            }
            case FILES: {
                return this.isSetFiles();
            }
            case ITERATOR_SETTINGS: {
                return this.isSetIteratorSettings();
            }
            case OUTPUT_FILE: {
                return this.isSetOutputFile();
            }
            case PROPAGATE_DELETES: {
                return this.isSetPropagateDeletes();
            }
            case KIND: {
                return this.isSetKind();
            }
            case USER_COMPACTION_ID: {
                return this.isSetUserCompactionId();
            }
            case OVERRIDES: {
                return this.isSetOverrides();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof TExternalCompactionJob) {
            return this.equals((TExternalCompactionJob)that);
        }
        return false;
    }

    public boolean equals(TExternalCompactionJob that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_externalCompactionId = this.isSetExternalCompactionId();
        boolean that_present_externalCompactionId = that.isSetExternalCompactionId();
        if (this_present_externalCompactionId || that_present_externalCompactionId) {
            if (!this_present_externalCompactionId || !that_present_externalCompactionId) {
                return false;
            }
            if (!this.externalCompactionId.equals(that.externalCompactionId)) {
                return false;
            }
        }
        boolean this_present_extent = this.isSetExtent();
        boolean that_present_extent = that.isSetExtent();
        if (this_present_extent || that_present_extent) {
            if (!this_present_extent || !that_present_extent) {
                return false;
            }
            if (!this.extent.equals(that.extent)) {
                return false;
            }
        }
        boolean this_present_files = this.isSetFiles();
        boolean that_present_files = that.isSetFiles();
        if (this_present_files || that_present_files) {
            if (!this_present_files || !that_present_files) {
                return false;
            }
            if (!this.files.equals(that.files)) {
                return false;
            }
        }
        boolean this_present_iteratorSettings = this.isSetIteratorSettings();
        boolean that_present_iteratorSettings = that.isSetIteratorSettings();
        if (this_present_iteratorSettings || that_present_iteratorSettings) {
            if (!this_present_iteratorSettings || !that_present_iteratorSettings) {
                return false;
            }
            if (!this.iteratorSettings.equals(that.iteratorSettings)) {
                return false;
            }
        }
        boolean this_present_outputFile = this.isSetOutputFile();
        boolean that_present_outputFile = that.isSetOutputFile();
        if (this_present_outputFile || that_present_outputFile) {
            if (!this_present_outputFile || !that_present_outputFile) {
                return false;
            }
            if (!this.outputFile.equals(that.outputFile)) {
                return false;
            }
        }
        boolean this_present_propagateDeletes = true;
        boolean that_present_propagateDeletes = true;
        if (this_present_propagateDeletes || that_present_propagateDeletes) {
            if (!this_present_propagateDeletes || !that_present_propagateDeletes) {
                return false;
            }
            if (this.propagateDeletes != that.propagateDeletes) {
                return false;
            }
        }
        boolean this_present_kind = this.isSetKind();
        boolean that_present_kind = that.isSetKind();
        if (this_present_kind || that_present_kind) {
            if (!this_present_kind || !that_present_kind) {
                return false;
            }
            if (!this.kind.equals((Object)that.kind)) {
                return false;
            }
        }
        boolean this_present_userCompactionId = true;
        boolean that_present_userCompactionId = true;
        if (this_present_userCompactionId || that_present_userCompactionId) {
            if (!this_present_userCompactionId || !that_present_userCompactionId) {
                return false;
            }
            if (this.userCompactionId != that.userCompactionId) {
                return false;
            }
        }
        boolean this_present_overrides = this.isSetOverrides();
        boolean that_present_overrides = that.isSetOverrides();
        if (this_present_overrides || that_present_overrides) {
            if (!this_present_overrides || !that_present_overrides) {
                return false;
            }
            if (!this.overrides.equals(that.overrides)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetExternalCompactionId() ? 131071 : 524287);
        if (this.isSetExternalCompactionId()) {
            hashCode = hashCode * 8191 + this.externalCompactionId.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetExtent() ? 131071 : 524287);
        if (this.isSetExtent()) {
            hashCode = hashCode * 8191 + this.extent.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetFiles() ? 131071 : 524287);
        if (this.isSetFiles()) {
            hashCode = hashCode * 8191 + this.files.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetIteratorSettings() ? 131071 : 524287);
        if (this.isSetIteratorSettings()) {
            hashCode = hashCode * 8191 + this.iteratorSettings.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetOutputFile() ? 131071 : 524287);
        if (this.isSetOutputFile()) {
            hashCode = hashCode * 8191 + this.outputFile.hashCode();
        }
        hashCode = hashCode * 8191 + (this.propagateDeletes ? 131071 : 524287);
        hashCode = hashCode * 8191 + (this.isSetKind() ? 131071 : 524287);
        if (this.isSetKind()) {
            hashCode = hashCode * 8191 + this.kind.getValue();
        }
        hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.userCompactionId);
        hashCode = hashCode * 8191 + (this.isSetOverrides() ? 131071 : 524287);
        if (this.isSetOverrides()) {
            hashCode = hashCode * 8191 + this.overrides.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(TExternalCompactionJob other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetExternalCompactionId(), other.isSetExternalCompactionId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetExternalCompactionId() && (lastComparison = TBaseHelper.compareTo((String)this.externalCompactionId, (String)other.externalCompactionId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetExtent(), other.isSetExtent());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetExtent() && (lastComparison = TBaseHelper.compareTo((Comparable)this.extent, (Comparable)other.extent)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetFiles(), other.isSetFiles());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFiles() && (lastComparison = TBaseHelper.compareTo(this.files, other.files)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetIteratorSettings(), other.isSetIteratorSettings());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIteratorSettings() && (lastComparison = TBaseHelper.compareTo((Comparable)this.iteratorSettings, (Comparable)other.iteratorSettings)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetOutputFile(), other.isSetOutputFile());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOutputFile() && (lastComparison = TBaseHelper.compareTo((String)this.outputFile, (String)other.outputFile)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPropagateDeletes(), other.isSetPropagateDeletes());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPropagateDeletes() && (lastComparison = TBaseHelper.compareTo((boolean)this.propagateDeletes, (boolean)other.propagateDeletes)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetKind(), other.isSetKind());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetKind() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.kind), (Comparable)((Object)other.kind))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetUserCompactionId(), other.isSetUserCompactionId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetUserCompactionId() && (lastComparison = TBaseHelper.compareTo((long)this.userCompactionId, (long)other.userCompactionId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetOverrides(), other.isSetOverrides());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOverrides() && (lastComparison = TBaseHelper.compareTo(this.overrides, other.overrides)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        TExternalCompactionJob.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        TExternalCompactionJob.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TExternalCompactionJob(");
        boolean first = true;
        sb.append("externalCompactionId:");
        if (this.externalCompactionId == null) {
            sb.append("null");
        } else {
            sb.append(this.externalCompactionId);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("extent:");
        if (this.extent == null) {
            sb.append("null");
        } else {
            sb.append(this.extent);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("files:");
        if (this.files == null) {
            sb.append("null");
        } else {
            sb.append(this.files);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("iteratorSettings:");
        if (this.iteratorSettings == null) {
            sb.append("null");
        } else {
            sb.append(this.iteratorSettings);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("outputFile:");
        if (this.outputFile == null) {
            sb.append("null");
        } else {
            sb.append(this.outputFile);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("propagateDeletes:");
        sb.append(this.propagateDeletes);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("kind:");
        if (this.kind == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.kind);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("userCompactionId:");
        sb.append(this.userCompactionId);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("overrides:");
        if (this.overrides == null) {
            sb.append("null");
        } else {
            sb.append(this.overrides);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.extent != null) {
            this.extent.validate();
        }
        if (this.iteratorSettings != null) {
            this.iteratorSettings.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    private static void unusedMethod() {
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.EXTERNAL_COMPACTION_ID, new FieldMetaData("externalCompactionId", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.EXTENT, new FieldMetaData("extent", 3, (FieldValueMetaData)new StructMetaData(12, TKeyExtent.class)));
        tmpMap.put(_Fields.FILES, new FieldMetaData("files", 3, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, InputFile.class))));
        tmpMap.put(_Fields.ITERATOR_SETTINGS, new FieldMetaData("iteratorSettings", 3, (FieldValueMetaData)new StructMetaData(12, IteratorConfig.class)));
        tmpMap.put(_Fields.OUTPUT_FILE, new FieldMetaData("outputFile", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PROPAGATE_DELETES, new FieldMetaData("propagateDeletes", 3, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.KIND, new FieldMetaData("kind", 3, new FieldValueMetaData(16, "TCompactionKind")));
        tmpMap.put(_Fields.USER_COMPACTION_ID, new FieldMetaData("userCompactionId", 3, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.OVERRIDES, new FieldMetaData("overrides", 3, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TExternalCompactionJob.class, metaDataMap);
    }

    private static class TExternalCompactionJobTupleScheme
    extends TupleScheme<TExternalCompactionJob> {
        private TExternalCompactionJobTupleScheme() {
        }

        public void write(TProtocol prot, TExternalCompactionJob struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetExternalCompactionId()) {
                optionals.set(0);
            }
            if (struct.isSetExtent()) {
                optionals.set(1);
            }
            if (struct.isSetFiles()) {
                optionals.set(2);
            }
            if (struct.isSetIteratorSettings()) {
                optionals.set(3);
            }
            if (struct.isSetOutputFile()) {
                optionals.set(4);
            }
            if (struct.isSetPropagateDeletes()) {
                optionals.set(5);
            }
            if (struct.isSetKind()) {
                optionals.set(6);
            }
            if (struct.isSetUserCompactionId()) {
                optionals.set(7);
            }
            if (struct.isSetOverrides()) {
                optionals.set(8);
            }
            oprot.writeBitSet(optionals, 9);
            if (struct.isSetExternalCompactionId()) {
                oprot.writeString(struct.externalCompactionId);
            }
            if (struct.isSetExtent()) {
                struct.extent.write((TProtocol)oprot);
            }
            if (struct.isSetFiles()) {
                oprot.writeI32(struct.files.size());
                for (InputFile inputFile : struct.files) {
                    inputFile.write((TProtocol)oprot);
                }
            }
            if (struct.isSetIteratorSettings()) {
                struct.iteratorSettings.write((TProtocol)oprot);
            }
            if (struct.isSetOutputFile()) {
                oprot.writeString(struct.outputFile);
            }
            if (struct.isSetPropagateDeletes()) {
                oprot.writeBool(struct.propagateDeletes);
            }
            if (struct.isSetKind()) {
                oprot.writeI32(struct.kind.getValue());
            }
            if (struct.isSetUserCompactionId()) {
                oprot.writeI64(struct.userCompactionId);
            }
            if (struct.isSetOverrides()) {
                oprot.writeI32(struct.overrides.size());
                for (Map.Entry entry : struct.overrides.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    oprot.writeString((String)entry.getValue());
                }
            }
        }

        public void read(TProtocol prot, TExternalCompactionJob struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(9);
            if (incoming.get(0)) {
                struct.externalCompactionId = iprot.readString();
                struct.setExternalCompactionIdIsSet(true);
            }
            if (incoming.get(1)) {
                struct.extent = new TKeyExtent();
                struct.extent.read((TProtocol)iprot);
                struct.setExtentIsSet(true);
            }
            if (incoming.get(2)) {
                TList _list65 = iprot.readListBegin((byte)12);
                struct.files = new ArrayList<InputFile>(_list65.size);
                for (int _i67 = 0; _i67 < _list65.size; ++_i67) {
                    InputFile _elem66 = new InputFile();
                    _elem66.read((TProtocol)iprot);
                    struct.files.add(_elem66);
                }
                struct.setFilesIsSet(true);
            }
            if (incoming.get(3)) {
                struct.iteratorSettings = new IteratorConfig();
                struct.iteratorSettings.read((TProtocol)iprot);
                struct.setIteratorSettingsIsSet(true);
            }
            if (incoming.get(4)) {
                struct.outputFile = iprot.readString();
                struct.setOutputFileIsSet(true);
            }
            if (incoming.get(5)) {
                struct.propagateDeletes = iprot.readBool();
                struct.setPropagateDeletesIsSet(true);
            }
            if (incoming.get(6)) {
                struct.kind = TCompactionKind.findByValue(iprot.readI32());
                struct.setKindIsSet(true);
            }
            if (incoming.get(7)) {
                struct.userCompactionId = iprot.readI64();
                struct.setUserCompactionIdIsSet(true);
            }
            if (incoming.get(8)) {
                TMap _map68 = iprot.readMapBegin((byte)11, (byte)11);
                struct.overrides = new HashMap<String, String>(2 * _map68.size);
                for (int _i71 = 0; _i71 < _map68.size; ++_i71) {
                    String _key69 = iprot.readString();
                    String _val70 = iprot.readString();
                    struct.overrides.put(_key69, _val70);
                }
                struct.setOverridesIsSet(true);
            }
        }
    }

    private static class TExternalCompactionJobTupleSchemeFactory
    implements SchemeFactory {
        private TExternalCompactionJobTupleSchemeFactory() {
        }

        public TExternalCompactionJobTupleScheme getScheme() {
            return new TExternalCompactionJobTupleScheme();
        }
    }

    private static class TExternalCompactionJobStandardScheme
    extends StandardScheme<TExternalCompactionJob> {
        private TExternalCompactionJobStandardScheme() {
        }

        public void read(TProtocol iprot, TExternalCompactionJob struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.externalCompactionId = iprot.readString();
                            struct.setExternalCompactionIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 12) {
                            struct.extent = new TKeyExtent();
                            struct.extent.read(iprot);
                            struct.setExtentIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 15) {
                            TList _list54 = iprot.readListBegin();
                            struct.files = new ArrayList<InputFile>(_list54.size);
                            for (int _i56 = 0; _i56 < _list54.size; ++_i56) {
                                InputFile _elem55 = new InputFile();
                                _elem55.read(iprot);
                                struct.files.add(_elem55);
                            }
                            iprot.readListEnd();
                            struct.setFilesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 12) {
                            struct.iteratorSettings = new IteratorConfig();
                            struct.iteratorSettings.read(iprot);
                            struct.setIteratorSettingsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 11) {
                            struct.outputFile = iprot.readString();
                            struct.setOutputFileIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 2) {
                            struct.propagateDeletes = iprot.readBool();
                            struct.setPropagateDeletesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 8) {
                            struct.kind = TCompactionKind.findByValue(iprot.readI32());
                            struct.setKindIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 10) {
                            struct.userCompactionId = iprot.readI64();
                            struct.setUserCompactionIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 13) {
                            TMap _map57 = iprot.readMapBegin();
                            struct.overrides = new HashMap<String, String>(2 * _map57.size);
                            for (int _i60 = 0; _i60 < _map57.size; ++_i60) {
                                String _key58 = iprot.readString();
                                String _val59 = iprot.readString();
                                struct.overrides.put(_key58, _val59);
                            }
                            iprot.readMapEnd();
                            struct.setOverridesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TExternalCompactionJob struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.externalCompactionId != null) {
                oprot.writeFieldBegin(EXTERNAL_COMPACTION_ID_FIELD_DESC);
                oprot.writeString(struct.externalCompactionId);
                oprot.writeFieldEnd();
            }
            if (struct.extent != null) {
                oprot.writeFieldBegin(EXTENT_FIELD_DESC);
                struct.extent.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.files != null) {
                oprot.writeFieldBegin(FILES_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.files.size()));
                for (InputFile inputFile : struct.files) {
                    inputFile.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.iteratorSettings != null) {
                oprot.writeFieldBegin(ITERATOR_SETTINGS_FIELD_DESC);
                struct.iteratorSettings.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.outputFile != null) {
                oprot.writeFieldBegin(OUTPUT_FILE_FIELD_DESC);
                oprot.writeString(struct.outputFile);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(PROPAGATE_DELETES_FIELD_DESC);
            oprot.writeBool(struct.propagateDeletes);
            oprot.writeFieldEnd();
            if (struct.kind != null) {
                oprot.writeFieldBegin(KIND_FIELD_DESC);
                oprot.writeI32(struct.kind.getValue());
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(USER_COMPACTION_ID_FIELD_DESC);
            oprot.writeI64(struct.userCompactionId);
            oprot.writeFieldEnd();
            if (struct.overrides != null) {
                oprot.writeFieldBegin(OVERRIDES_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 11, struct.overrides.size()));
                for (Map.Entry entry : struct.overrides.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    oprot.writeString((String)entry.getValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TExternalCompactionJobStandardSchemeFactory
    implements SchemeFactory {
        private TExternalCompactionJobStandardSchemeFactory() {
        }

        public TExternalCompactionJobStandardScheme getScheme() {
            return new TExternalCompactionJobStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        EXTERNAL_COMPACTION_ID(1, "externalCompactionId"),
        EXTENT(2, "extent"),
        FILES(3, "files"),
        ITERATOR_SETTINGS(4, "iteratorSettings"),
        OUTPUT_FILE(5, "outputFile"),
        PROPAGATE_DELETES(6, "propagateDeletes"),
        KIND(7, "kind"),
        USER_COMPACTION_ID(8, "userCompactionId"),
        OVERRIDES(9, "overrides");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return EXTERNAL_COMPACTION_ID;
                }
                case 2: {
                    return EXTENT;
                }
                case 3: {
                    return FILES;
                }
                case 4: {
                    return ITERATOR_SETTINGS;
                }
                case 5: {
                    return OUTPUT_FILE;
                }
                case 6: {
                    return PROPAGATE_DELETES;
                }
                case 7: {
                    return KIND;
                }
                case 8: {
                    return USER_COMPACTION_ID;
                }
                case 9: {
                    return OVERRIDES;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

