/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.compaction;

import java.util.Comparator;
import org.apache.accumulo.core.spi.compaction.CompactionJob;
import org.apache.accumulo.core.spi.compaction.CompactionKind;

public class CompactionJobPrioritizer {
    public static final Comparator<CompactionJob> JOB_COMPARATOR = Comparator.comparingInt(CompactionJob::getPriority).thenComparingInt(job -> job.getFiles().size()).reversed();

    public static short createPriority(CompactionKind kind, int totalFiles, int compactingFiles) {
        int prio = totalFiles + compactingFiles;
        switch (kind) {
            case USER: 
            case CHOP: {
                if (prio > Short.MAX_VALUE) {
                    return Short.MAX_VALUE;
                }
                return (short)prio;
            }
            case SELECTOR: 
            case SYSTEM: {
                if (prio > Short.MAX_VALUE) {
                    return -1;
                }
                return (short)(Short.MIN_VALUE + prio);
            }
        }
        throw new AssertionError((Object)("Unknown kind " + kind));
    }
}

